var Tage_pro_Monat = new Array (31,28,31,30,31,30,31,31,30,31,30,31);
var WochenTage     = new Array ("Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag","Sonntag");
var Meldungstext   = "Keine Datumsberechnungen vor Christi.";

function Melden(Meldetext) {
     if (Meldetext != "") alert(" Problem: "+Meldetext);
}

function ist_Schaltjahr(jahr) {
   if (jahr % 4 == 0)
      if (jahr < 1582)
         return 1;
      else if (!(jahr % 100 == 0))
              return 1;
           else if (jahr % 400 == 0)
                   return 1;
   return 0;
}

function Tage_pro_Jahr(jahr) {
   if (jahr == 1582)
      return 355;
   else
      return 365 + ist_Schaltjahr(jahr);
}

function Tag_des_Jahres(tag,monat,jahr) {
   var Tage = 0;

   /* Februar hat im Schaltjahr 29 Tage      */
   Tage_pro_Monat[1] = 28 + ist_Schaltjahr(jahr);
   if (tag <= Tage_pro_Monat[monat-1]) {
      for (var i=0; i<monat-1; i++)
          Tage = Tage + Tage_pro_Monat[i];
      Tage = Tage + tag;
   }

   /* Bei Kalenderreform 10 Tage weggefallen */
   if ((jahr==1582) && (monat >= 10) && (tag>=15))
      Tage = Tage - 10;
   return Tage;
}

function CurrentDoomDay(jahr) {
   var CenturyDoomDay = new Array (5,4,2,0);
   var CC             = Math.floor(jahr/100);
   var YY             = jahr%100;
   var CCDoomDay      = CenturyDoomDay[CC%4];
   var YYDoomDay      = 0;

   if (YY == 0)
         YYDoomDay = CCDoomDay;
   else if (YY%12 == 0)
        YYDoomDay = (CCDoomDay + YY/12 - 1) % 7;
   else YYDoomDay = ( CCDoomDay
                     +(Math.floor(YY/12)
                     + (YY%12)
                     + Math.floor(((YY-1)%12)/4))
                    ) % 7;
   if  ((YY != 0)&&(CC%4 == 0))
         YYDoomDay = (YYDoomDay + 1)%7;

   return YYDoomDay;
}

function Wochentag(tag,monat,jahr) {
   var Wochentag1Jan = CurrentDoomDay(jahr);
   var Tage          = Tag_des_Jahres(tag,monat,jahr)-1;

   /* Die fehlenden 10 Tage in 1582 werden zur Wochentagberechnung gebraucht */
   if ((jahr==1582) && (monat >= 10) && (tag>=15))
      Tage = Tage + 10;

   return WochenTage[(Wochentag1Jan+(Tage%7))%7];
}

function Kalenderwoche(tag,monat,jahr) {
   var Woche         = 0;
   var Wochentag1Jan = CurrentDoomDay(jahr);
   var Tage          = Tag_des_Jahres(tag,monat,jahr)-1;

   if (Wochentag1Jan > 3)
      Tage = Tage - (7 - Wochentag1Jan);
   else Tage = Tage + Wochentag1Jan;

   if (Tage < 0)
      if ((Wochentag1Jan == 4) || (CurrentDoomDay(jahr-1) == 3))
         Woche = 53;
      else Woche = 52;
   else Woche = Math.floor(Tage/7) + 1;

   if ((Tage > 360) && (Woche > 52)) {
      if (Wochentag1Jan == 3)
          Woche = 53;
      else if (CurrentDoomDay(jahr+1) == 4)
              Woche = 53;
           else Woche = 1;
   }

   return Woche;
}

function Ostersonntag(jahr) {
  var K  = Math.floor(jahr/100);
   if (jahr > 1582) {
      var h = Math.floor((3*K+3)/4);
      var M = 15 + h - Math.floor((8*K+13)/25);
      var S = 2 - h;
   } else {
      var M = 15;
      var S =  0;
   }
  var A  = jahr % 19;
  var B  = Math.floor(jahr/4);
  var D  = (19*A+M) % 30;
  var R  = Math.floor((D + A/11)/29);
/* Alte Version von R:
  var R  = Math.floor(D/29) + (Math.floor(D/28)-Math.floor(D/29)) * Math.floor(A/11);
*/
  var OG = 21 + D - R;
  var SZ = 7 - ((jahr+B+S)%7);
  var OE = 7 - ((OG-SZ)%7);

  return (OG+OE);
}

function Feiertage(jahr) {
  var i = 0;
  var l_day   = 0;
  var l_month = 0;
  var tdj     = 0;
  var OS      = Ostersonntag(jahr);

  l_tdj = Tag_des_Jahres(1,3,jahr)-1 + OS;
  while (l_tdj > 0) {
        l_tdj = l_tdj - Tage_pro_Monat[i];
        i++;
  }
  l_month = i;
  l_day   = Tage_pro_Monat[i-1] + l_tdj;
  if (l_tdj > 0)
     l_day = l_day + 1;

  document.calc.Ostern.value = l_day+". "+l_month+".";
  return;
}

function is_greg_Date(dd,mm,jjjj) {
   if (jjjj > 1582)
      return 1;
   else if (jjjj == 1582)
           if (mm > 10)
              return 1;
           else if (mm == 10)
                   if (dd >= 15)
                      return 1;
                   else return 0;
                else return 0;
         else return 0;
}

function JulianDayNumber(tag,monat,jahr) {
   var MJDN = 0; /* Modified Julian Day Number */
   var B    = 0;

   if (is_greg_Date(tag,monat,jahr))
      B = Math.floor(jahr/400) - Math.floor(jahr/100) + Math.floor(jahr/4);
   else
      B = Math.floor((jahr+4716)/4) - 1181;

   if (monat <= 2) {
      B = B - ist_Schaltjahr(jahr);
      jahr  = jahr - 1;
      monat = monat + 13;
   }
   else monat = monat + 1;

   MJDN = (365*jahr) - 679004 + B + Math.floor(30.6*monat) + tag;

   return (MJDN + 2400001);
}

function date2days() {
  var l_dd   = parseInt(document.calc.dd.value);
  var l_mm   = parseInt(document.calc.mm.value);
  var l_jahr = parseInt(document.calc.jahr1.value);
  var l_ddd  = 0;

  if (l_jahr > 0) {
     Melden("");
     Tage_pro_Monat[1] = 28 + ist_Schaltjahr(l_jahr);

     if ((l_mm > 0) && (l_mm < 13))
        if ((l_dd > 0) && (l_dd <=Tage_pro_Monat[l_mm-1])) {
           self.status = "";
           l_ddd = Tag_des_Jahres(l_dd,l_mm,l_jahr);
           document.calc.ddd.value   = l_ddd;
           document.calc.jahr1.value = l_jahr;
           if (is_greg_Date(l_dd,l_mm,l_jahr))
              document.calc.wochentag.value = Wochentag(l_dd,l_mm,l_jahr);
           else
              document.calc.wochentag.value = WochenTage[JulianDayNumber(l_dd,l_mm,l_jahr)%7];
           document.calc.woche.value    = Kalenderwoche(l_dd,l_mm,l_jahr);
           document.calc.DayNumber.value = JulianDayNumber(l_dd,l_mm,l_jahr);
           Feiertage(l_jahr);
        } else Melden("Tage bitte nur zwischen 1 und "+Tage_pro_Monat[l_mm-1]+".");
     else Melden("Monate bitte nur zwischen 1 und 12.");
  } else Melden(Meldungstext);
}

function days2date() {
  var i      = 0;
  var l_dd   = 0;
  var jul_dd = 0;
  var l_mm   = 0;
  var l_ddd  = parseInt(document.calc.ddd.value);
  var l_jahr = parseInt(document.calc.jahr1.value);

  if ((l_ddd > 0) && (l_ddd <= (365+ist_Schaltjahr(l_jahr)))) {
     if (l_jahr > 0) {
        Melden("");
        Tage_pro_Monat[1] = 28 + ist_Schaltjahr(l_jahr);
        /* In 1582 die fehlenden 10 Tage unterdruecken. */
        if (l_jahr == 1582)
           if (l_ddd > 277)
              l_ddd = l_ddd + 10;

        if (l_ddd < (366+ist_Schaltjahr(l_jahr))) {
          self.status = "";
          while (l_ddd > 0) {
                l_ddd = l_ddd - Tage_pro_Monat[i];
                i++;
          }
          l_mm = i;
          l_dd = Tage_pro_Monat[i-1] + l_ddd;
          if (l_ddd > 0)
             l_dd = l_dd + 1;

          jul_dd = JulianDayNumber(l_dd,l_mm,l_jahr);

          document.calc.dd.value    = l_dd;
          document.calc.mm.value    = l_mm;
          if (is_greg_Date(l_dd,l_mm,l_jahr))
             document.calc.wochentag.value = Wochentag(l_dd,l_mm,l_jahr);
          else
             document.calc.wochentag.value = WochenTage[jul_dd % 7];
          document.calc.woche.value = Kalenderwoche(l_dd,l_mm,l_jahr);
          Feiertage(l_jahr);
        } else self.status = "In "+l_jahr+" gibt es nur "+(365+ist_Schaltjahr(l_jahr))+" Tage.";

        document.calc.jahr1.value     = l_jahr;
        document.calc.DayNumber.value = jul_dd;
     } else Melden(Meldungstext);
  } else date2days();
}/* days2date */

function changeDD(wert) {
  var TgAnno = 365;
  var l_ddd  = parseInt(document.calc.ddd.value);
  var l_jahr = parseInt(document.calc.jahr1.value);

  if (l_jahr == 1582)
     TgAnno = 355;

  l_ddd = l_ddd + wert;

  if (l_ddd < 1) {
     l_jahr = l_jahr - 1;
     if (l_jahr == 1582)
        TgAnno = 355;
     l_ddd = TgAnno + ist_Schaltjahr(l_jahr);
  }
  if (l_ddd > (TgAnno + ist_Schaltjahr(l_jahr))) {
     l_jahr = l_jahr + 1;
     l_ddd = 1;
  }

  if (l_jahr > 0) {
     document.calc.ddd.value   = l_ddd;
     document.calc.jahr1.value = l_jahr;

     days2date()
  } else Melden(Meldungstext);
}

function changeMM(wert) {
  var l_dd   = parseInt(document.calc.dd.value);
  var l_mm   = parseInt(document.calc.mm.value);
  var l_jahr = parseInt(document.calc.jahr1.value);

  l_mm = l_mm + wert;
  if (l_mm < 1) {
     l_mm   = 12;
     l_jahr = l_jahr - 1;
  } else if (l_mm > 12) {
            l_mm   = 1;
            l_jahr = l_jahr + 1;
         }
  Tage_pro_Monat[1] = 28 + ist_Schaltjahr(l_jahr);
  if (l_dd > Tage_pro_Monat[l_mm-1])
     l_dd = Tage_pro_Monat[l_mm-1];

  if (l_jahr > 0) {
     /* In 1582 die fehlende 10 Tage unterdruecken. */
     if ((l_jahr == 1582) && (l_mm == 10))
        if ((l_dd < 15) && (l_dd > 4))
           if (wert > 0)
              l_dd = 15;
           else
              l_dd = 4;
     document.calc.dd.value    = l_dd;
     document.calc.mm.value    = l_mm;
     document.calc.jahr1.value = l_jahr;

     date2days()
  } else Melden(Meldungstext);
}

function changeYY(wert) {
  var l_dd   = parseInt(document.calc.dd.value);
  var l_mm   = parseInt(document.calc.mm.value);
  var l_jahr = parseInt(document.calc.jahr1.value);

  l_jahr = l_jahr + wert;

  if (l_jahr > 0) {
     /* In 1582 die fehlende 10 Tage unterdruecken. */
     if ((l_jahr == 1582) && (l_mm == 10))
        if ((l_dd < 15) && (l_dd > 4)) {
           if (wert > 0)
              l_dd = 15;
           else
              l_dd = 4;
           document.calc.dd.value = l_dd;
        }
     /* Im Gemeinjahr gibt es keinen 29 Februar */
     if ((l_mm == 2) && !ist_Schaltjahr(l_jahr))
        if (l_dd == 29)
           document.calc.dd.value = 28;
     document.calc.jahr1.value = l_jahr;
     date2days()
  } else Melden(Meldungstext);
}

function current_year(year) {
  if (year < 1900)
     year = year + 1900;
  return year;
}

function DateInit() {
  var dat = new Date();

  document.calc.dd.value = dat.getDate();
  document.calc.mm.value = dat.getMonth()+1;
  document.calc.jahr1.value = current_year(dat.getYear());
  date2days();
}