{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 94

 Inhalt:
  Die Unit BfDat stellt das Objekt "TBahnhofsArray" zur Verwaltung einer
  Datenbank zur Speicherung von Bahnhoefen zur Verfuegung.
  Ein Datensatz der benutzten Textdatei hat folgende Syntax
  ("kleingeschriebenes" ist symbolisch, "GROSSGESCHRIEBENES" woertlich
  gemeint, nach ";" folgen Kommentare, in eckigen Klammern erscheinen
  optionale Angaben):

BAHNHOF nummer name [kurzname]    ; "nummer" wird fuer die interne Speicherung des
                                  ; Bahnhofs in Anwenderprogrammen benutzt
                                  ; Nummer muss eindeutig sein!!!! 0<nr<8192
                                  ; "kurzname" darf bis zu 5 Zeichen lang sein
STRECKEN anzahl                   ; "anzahl" ist ein numerischer Wert, der die
                                  ; Zahl der in den Bahnhof muendenden
                                  ; Streckengleise bezeichnet
GLEIS name [nutzlaenge]           ; "name" kann die Gleisnummer oder die
                                  ; Bezeichnung eines Gleisanschlusses sein
                                  ; "nutzlaenge" wird in cm angegeben
EIGNER name des Eigners
INFO infos zum bahnhof            ; Die Zeilen "GLEIS"  und "INFO" duerfen bei
                                  ; einem Bahnhof mehrfach auftauchen

Ein Datensatz muss mit der "BAHNHOF"-Zeile Anfangen. Alle anderen Zeilen koennen
innerhalb des Datensatzes in beliebiger Reihenfolge auftauchen und sind optional.
Es muss mindestens eine GLEIS-Zeile vorhanden sein.

Beispiel fuer einen Bahnhof:

BAHNHOF 42 Muehlenrade Mrd
EIGNER Martin Meiburg
INFO Selbstgebaute Weichen
INFO Extendet Version gebaut
STRECKEN 2
GLEIS 1 200
GLEIS 2 160
GLEIS 3 120
GLEIS Outbus a
GLEIS Kohlenhandlung a
GLEIS Freiladegleis a
GLEIS Schuppen a
}

UNIT BfArray;

{$A+,B-,G+,I+,V-,X+}
{$D+,L+,R+,S+,Q+}

{$C moveable preload permanent}

INTERFACE
USES BfDef, Heap, Win_Allg;


TYPE PBahnhofsArray=^TBahnhofsArray;
     TBahnhofsArray=OBJECT
       CONSTRUCTOR Init(dn:pchar);            {initialisiert Datenfelder und Arr}
       FUNCTION Load:boolean;                 {Datei in Array laden}
       FUNCTION Save:boolean;                 {Datei speichern}
       DESTRUCTOR done;                       {evtl. Speichern / free aufrufen}
       FUNCTION BahnhofDazu:hBahnhof;
       FUNCTION LoeschBahnhof(nr:hBahnhof):boolean;
       PROCEDURE SetzGeaendert;
       FUNCTION GetGeaendert:boolean;
       FUNCTION GetAnzahl:word;
       FUNCTION GetFilename:pchar;
       FUNCTION Name2handle(Name:string):hBahnhof;

       FUNCTION GetBahnhofsDaten(nr:hBahnhof):PBahnhofsDaten;
       FUNCTION GetInfo(nr:hBahnhof):pchar;
       FUNCTION SetInfo(nr:hBahnhof; p:pchar):boolean;

       FUNCTION GetGleisAnzahl(nr:hBahnhof):word;
       FUNCTION GetGleisDaten(nr:hBahnhof; gl:hGleis):PGleisDaten;
       FUNCTION GleisDazu(nr:hBahnhof; gldat:PGleisDaten):hGleis;
       FUNCTION GleiseLoeschen(nr:hBahnhof):boolean;
     PRIVATE
       Arr:TDynArray;
       geaendert:boolean;                     {muss bei DLL-Beendigung gesichert werden?}
       dateiname:pchar;                       {Dateiname der Datenbank}
       PROCEDURE Free;                        {Gibt alle dynamische Daten frei}

       FUNCTION LadenSub(VAR ZeilenPuffer:TPCharArray):boolean;
       PROCEDURE SyntaxFehlerGefunden(s:string);
       PROCEDURE DateiFehlerGefunden(s:string);
     END;


IMPLEMENTATION
USES BfObj, grund, Strings, WinTypes, WinProcs;

CONSTRUCTOR TBahnhofsArray.Init(dn:pchar);
VAR ok:boolean;
BEGIN
  Arr.init;
  Geaendert:=false;
  DateiName:=StrNew(dn);
END;

DESTRUCTOR TbahnhofsArray.done;
BEGIN
  if geaendert then Save;
  Free;
  StrDispose(Dateiname);
  Arr.done;
END;

PROCEDURE TbahnhofsArray.Free;
VAR w:word;
    Bahnhof:PBahnhof;
BEGIN
  for w:=1 to Arr.anzahl do begin
    Bahnhof:=Arr.p^[w];
    if Bahnhof<>nil then Dispose(Bahnhof,done);
  end;
  Arr.Free;
END;

FUNCTION TBahnhofsArray.BahnhofDazu:hBahnhof;
VAR Bahnhof:PBahnhof;
    nr:word;
BEGIN
  new(Bahnhof,init);
  nr:=Arr.Position(nil);
  if nr=0 then begin     {in Loch stopfen}
    Arr.Append(Bahnhof);
    nr:=Arr.Anzahl;
  end else begin         {anfuegen}
    Arr.p^[nr]:=Bahnhof;
  end;
  BahnhofDazu:=nr;
END;

FUNCTION TBahnhofsArray.LoeschBahnhof(nr:hBahnhof):boolean;
VAR Bahnhof:PBahnhof;
BEGIN
  LoeschBahnhof:=false;
  if (nr<1) or (nr>Arr.anzahl) then exit;
  Bahnhof:=Arr.p^[nr];
  if Bahnhof=nil then exit;
  Dispose(Bahnhof,done);
  Arr.p^[nr]:=nil;
  LoeschBahnhof:=true;
END;

PROCEDURE TBahnhofsArray.SetzGeaendert;
BEGIN
  Geaendert:=true;
END;

FUNCTION TBahnhofsArray.GetGeaendert:boolean;
BEGIN
  GetGeaendert:=Geaendert;
END;

FUNCTION TBahnhofsArray.GetAnzahl;
BEGIN
  GetAnzahl:=Arr.anzahl;
END;

FUNCTION TBahnhofsArray.GetBahnhofsDaten(nr:hBahnhof):PBahnhofsDaten;
VAR bf:PBahnhof;
BEGIN
  if (nr<1) or (nr>Arr.anzahl) then begin
    GetBahnhofsDaten:=nil;
    exit;
  end;
  bf:=Arr.p^[nr];
  if bf=nil then GetBahnhofsDaten:=nil
            else GetBahnhofsDaten:=@bf^.Daten;
END;

FUNCTION TBahnhofsArray.GetInfo(nr:hBahnhof):pchar;
VAR bf:PBahnhof;
BEGIN
  if (nr<1) or (nr>Arr.anzahl) then begin
    GetInfo:=nil;
    exit;
  end;
  bf:=Arr.p^[nr];
  if bf=nil then GetInfo:=nil
            else GetInfo:=bf^.GetInfo;
END;

FUNCTION TBahnhofsArray.SetInfo(nr:hBahnhof; p:pchar):boolean;
VAR bf:PBahnhof;
BEGIN
  SetInfo:=false;
  if (nr<1) or (nr>Arr.anzahl) then exit;
  bf:=Arr.p^[nr];
  if bf<>nil then begin
    SetInfo:=true;
    bf^.SetzInfo(p);
  end;
END;

FUNCTION TBahnhofsArray.GetGleisAnzahl(nr:hBahnhof):word;
VAR bf:PBahnhof;
BEGIN
  GetGleisAnzahl:=0;
  if (nr<1) or (nr>Arr.anzahl) then exit;
  bf:=Arr.p^[nr];
  if bf<>nil then GetGleisAnzahl:=bf^.AnzahlGleise;
END;

FUNCTION TBahnhofsArray.GetGleisDaten(nr:hBahnhof; gl:hGleis):PGleisDaten;
VAR bf:PBahnhof;
BEGIN
  GetGleisDaten:=nil;
  if (nr<1) or (nr>Arr.anzahl) then exit;
  bf:=Arr.p^[nr];
  if bf<>nil then GetGleisDaten:=bf^.GetGleis(gl);
END;

FUNCTION TBahnhofsArray.GleisDazu(nr:hBahnhof; gldat:PGleisDaten):hGleis;
VAR bf:PBahnhof;
BEGIN
  GleisDazu:=0;
  if (nr<1) or (nr>Arr.anzahl) then exit;
  bf:=Arr.p^[nr];
  if bf<>nil then GleisDazu:=bf^.GleisDazu(gldat^.Bezeichnung, gldat^.NutzLaenge);
END;

FUNCTION TBahnhofsArray.GleiseLoeschen(nr:hBahnhof):boolean;
VAR bf:PBahnhof;
BEGIN
  GleiseLoeschen:=false;
  if (nr<1) or (nr>Arr.anzahl) then exit;
  bf:=Arr.p^[nr];
  if bf<>nil then GleiseLoeschen:=bf^.GleiseLoeschen;
END;

FUNCTION TBahnhofsArray.GetFilename:pchar;
BEGIN
  GetFilename:=Dateiname;
END;

FUNCTION TBahnhofsArray.Name2handle(Name:string):hBahnhof;
VAR w:hBahnhof;
    bp:PBahnhofsDaten;
BEGIN
  name:=GrossStr(name);
  for w:=1 to GetAnzahl do begin
    bp:=GetBahnhofsDaten(w);
    if (bp<>nil) and (GrossStr(bp^.Name)=name) then begin
      Name2Handle:=w;
      exit;
    end;
  end;
  Name2Handle:=0;
END;

{************************************* interner Kram ******************************}

FUNCTION TBahnhofsArray.LadenSub(VAR ZeilenPuffer:TPCharArray):boolean;
VAR datei:text;
    Eins,Zwei,Drei:string;  {Zum Zerlegen der Zeilen}
    Bahnhof:Pbahnhof;  {Zeiger auf den momentan gelesenen Datensatz}
    w:word;       {Allzweckvariable}
    c:char;       {"}
    k:integer;    {wird fuers Entschluesseln der GLEIS-Zeile beoetigt}
BEGIN
  LadenSub:=false;
  Bahnhof:=nil;     {Indikator dafuer, dass noch kein Datensatz angefangen hat}
{Datei aufmachen}
  assign(datei,pchar2string(dateiname));
  {$I-}
  reset(datei);
  if InOutRes<>0 then begin
    DateiFehlerGefunden('ffnen der Datei; Fehlercode='+zahlstr(IOresult,1));
    exit;
  end;
  {$I+}
{Datei einlesen}
  while not eof(datei) do begin
    {$I-}
    readln(datei, Eins);
    if InOutRes<>0 then begin
      k:=IOresult;
      close(datei);
      DateiFehlerGefunden('Datei lesen; Fehlercode='+zahlstr(k,1));
      exit;
    end;
    {$I+}
    w:=pos(';', Eins);                   {Kommentar suchen}
    if w<>0 then Eins:=copy(Eins,1,w-1); {ggf. Kommentar abschneiden}
    Eins:=spaceweg(Eins);                {fuehrende oder nachlaufenden Freizeichen killen}
    if Eins<>'' then begin               {Lehrzeilen werden uebersprungen}
      if (not SplitString(Eins, ' ', Eins,Zwei)) and
         (Eins<>'INFO')
      then begin SyntaxFehlerGefunden('Zeile ohne Parameter: '+Eins); exit; end
      else begin
        Eins:=GrossStr(Eins);            {Schluesselwort fuer Vergleiche vorbereiten}
        Zwei:=Spaceweg(Zwei);
        IF Eins='BAHNHOF'   THEN BEGIN
          if (Bahnhof<>nil) and (ZeilenPuffer.anzahl>0) then begin
            Bahnhof^.SetzInfo(ZeilenPuffer.ExportToMultiLine);
            ZeilenPuffer.Free;
          end;
          Bahnhof:=Arr.p^[BahnhofDazu];   {Record erstellen}
          if not SplitString(zwei, ' ', eins, zwei) then begin  {ein String}
            Bahnhof^.Daten.Name:=eins;
            Bahnhof^.Daten.Kurzname:=CreateKurzname(eins);
          end else begin                                        {mehrere Strings}
            val(eins,w,k);
            if k=0 then begin  {index verwerfen, weil er nicht mehr benutzt wird}
              if SplitString(zwei, ' ', eins, zwei) then begin  {1.:Zahl; 2.:Name; 3.:KurzName}
                Bahnhof^.Daten.Name:=eins;
                Bahnhof^.Daten.KurzName:=zwei;
              end else begin                                    {1.:Zahl; 2.:Name}
                Bahnhof^.Daten.Name:=eins;
                Bahnhof^.Daten.Kurzname:=CreateKurzname(eins);
              end;
            end else begin                                      {1.:Name; 2.:KurzName}
              Bahnhof^.Daten.Name:=eins;
              Bahnhof^.Daten.KurzName:=zwei;
            end;
          end;
          Ersetzen('_',' ',Bahnhof^.Daten.Name);
          Ersetzen('_',' ',Bahnhof^.Daten.KurzName);
        END ELSE IF Bahnhof=nil     THEN begin SyntaxFehlerGefunden('Erste Zeile muss "BAHNHOF"-Zeile sein!'); exit; end
        ELSE IF Eins='EIGNER'       THEN Bahnhof^.Daten.Eigner:=Zwei
        ELSE IF Eins='INFO'         THEN ZeilenPuffer.Append(String2NewPChar(Zwei))
        ELSE IF Eins='REGLERFARBEN' THEN BEGIN
          val(Zwei, w, k);
          if (k<>0) then begin SyntaxFehlerGefunden('Numerisches Format der Reglerfarbenanzahl falsch!'); exit; end;
          if (w<low(TReglerFarbenAnzahl)) or (w>high(TReglerFarbenAnzahl)) then begin
            SyntaxFehlerGefunden('Reglerfarbenanzahl ist nicht zwischen '+
                                 zahlstr(low(TReglerFarbenAnzahl),1)+' und '+
                                 zahlstr(high(TReglerFarbenAnzahl),1)+'!');
            exit;
          end;
          Bahnhof^.Daten.ReglerFarben:=w;
        END ELSE IF Eins='STRECKEN' THEN BEGIN
          val(Zwei,w,k);
          if k<>0 then begin SyntaxFehlerGefunden('Streckenanzahl fehlerhaft'); exit; end
                  else Bahnhof^.Daten.Strecken:=w;
        END ELSE IF Eins='GLEIS' THEN BEGIN
          w:=0;
          if SplitString(Zwei, ' ', Eins, Zwei) then begin
            val(zwei,w,k);
            if (k<>0) then begin
              if SplitString(Zwei, ' ', Zwei, Drei) then begin
                val(Drei,w,k);
                if k<>0 then begin SyntaxFehlerGefunden('Fehlerhafte  Nutzlnge'); exit; end;
              end else w:=0;    {nur flags, keine Nutzlaenge in der Zeile}
            end;
          end;
          Ersetzen('_',' ',eins);
          Bahnhof^.GleisDazu(Eins,w);
        END ELSE begin SyntaxFehlerGefunden('Unbekanntes Schlsselwort: "'+Eins+'"'); exit; end;
      end;
    end;
  end;
  if (Bahnhof<>nil) and (ZeilenPuffer.anzahl>0) then begin
    Bahnhof^.SetzInfo(ZeilenPuffer.ExportToMultiLine);
    ZeilenPuffer.Free;  {eigentlich ueberfluessig, aber was solls...}
  end;
  close(datei);
  LadenSub:=true;
END;

FUNCTION TBahnhofsArray.Load:boolean;
VAR ok:boolean;
    ZeilenPuffer:TPCharArray; {wird fuer die Zeilenaufteilung in INFO-Bloecken benoetigt}
BEGIN
  ZeilenPuffer.init;
  ok:=LadenSub(ZeilenPuffer);
  if not ok then Free;
  Load:=ok;
  ZeilenPuffer.done;
END;

FUNCTION TBahnhofsArray.Save:boolean;
VAR datei:text;
    Eins,Zwei:string;
    cp:pchar;
    w,i,Scheisse:word;
    ZeilenPuffer:TPCharArray;              {wird fuer die Zeilenaufteilung in INFO-Bloecken benoetigt}
 Function Anhaengen(was:string):string;
 Begin
   if was='' then Anhaengen:=''
             else Anhaengen:=' '+was;
 End;
BEGIN
  Save:=false;
  assign(datei,pchar2String(dateiname));
{$I-}
  rewrite(datei);
  if InOutRes<>0 then begin
    DateiFehlerGefunden('Erzeugen einer neuen Datei zum schreiben; Fehlercode='+zahlstr(IOresult,1));
    exit;
  end;
{$I+}
  for w:=1 to Arr.anzahl do if Arr.p^[w]<>nil then with PBahnhof(Arr.p^[w])^ do begin
{$I-}
    Eins:=Daten.name;
    Ersetzen(' ','_',Eins);
    Zwei:=Daten.KurzName;
    Ersetzen(' ','_',Zwei);
    writeln(datei,'BAHNHOF '+zahlstr(w,1)+' '+Eins+Anhaengen(Zwei));
    if Daten.Eigner<>'' then writeln(datei,'EIGNER '+Daten.Eigner);
    if Daten.Strecken<>0 then writeln(datei,'STRECKEN ',Daten.Strecken);
    ZeilenPuffer.init;
    ZeilenPuffer.ImportFromMultiline(GetInfo);
    for i:=1 to ZeilenPuffer.anzahl do begin
      cp:=ZeilenPuffer.GetPChar(i);
      if cp=nil then writeln(datei, 'INFO')
      else begin
        Scheisse:=StrLen(cp);
        Scheisse:=min(255,Scheisse);
        Eins[0]:=char(lo(Scheisse));
        move(cp^, Eins[1], Scheisse);
        writeln(datei,'INFO '+Eins);
      end;
    end;
    ZeilenPuffer.Done;
    for i:=1 to AnzahlGleise do with GetGleis(i)^ do begin
      Eins:=Bezeichnung;
      Ersetzen(' ','_',Eins);
      if NutzLaenge<>0 then Eins:=Eins+' '+zahlstr(NutzLaenge,1);
      writeln(datei,'GLEIS '+Eins);
    end;
    if InOutRes<>0 then begin
      DateiFehlerGefunden('Schreiben eines Bahnhofsblocks; Fehlercode='+zahlstr(IOresult,1));
      exit;
    end;
{$I+}
  end;
{$I-}
  close(datei);
  if InOutRes<>0 then begin
    DateiFehlerGefunden('Datei nach dem Schreiben schlieen; Fehlercode='+zahlstr(IOresult,1));
    exit;
  end;
{$I+}
  Save:=true;
  Geaendert:=false;
END;

PROCEDURE TbahnhofsArray.SyntaxFehlerGefunden(s:string);
VAR Puffer:array [0..high(s)] of char;
BEGIN
  String2CharArray(s,Puffer);
  MessageBox(0, Puffer, 'Syntaxfehler in Bahnhofsdatei', mb_OK);
END;

PROCEDURE TbahnhofsArray.DateiFehlerGefunden(s:string);
VAR Puffer:array [0..high(s)] of char;
BEGIN
  String2CharArray(s,Puffer);
  MessageBox(0, Puffer, 'Dateizugriffsfehler bei Bahnhofsdatei',mb_OK);
END;

END.
