{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 95

 Inhalt: TBahnhof ist ein Objekt, dass einen Bahnhof mit mehreren Gleisen und
         einem Infotext speichert.
}

{$A+,B-,D+,F-,G+,I+,L+,N+,P+,V+,W-,X+,Y+,K-}
{$Q+,R+,S+,T+}


UNIT BfObj;

{$C moveable preload permanent}

INTERFACE
USES BfDef, Heap;


TYPE Pbahnhof=^Tbahnhof;
     Tbahnhof=OBJECT
                Daten:RBahnhofsDaten;
                CONSTRUCTOR init;
                DESTRUCTOR done;
                PROCEDURE SetzInfo(cp:pchar);
                FUNCTION GetInfo:pchar;
                FUNCTION GleisDazu(Name:string; Laenge:word):hGleis;
                FUNCTION GetGleis(nr:hGleis):PGleisDaten;
                FUNCTION GleiseLoeschen:boolean;
                FUNCTION AnzahlGleise:word;
              PRIVATE
                Gleise:TRecordArray;
                Info:pchar;
              END;


IMPLEMENTATION
USES Strings;


CONSTRUCTOR TBahnhof.init;
BEGIN
  fillchar(Daten, sizeof(Daten), 0);
  Daten.Reglerfarben:=5;
  Daten.Strecken:=2;
  Gleise.init(sizeof(RGleisDaten));
  Info:=nil;
END;

DESTRUCTOR TBahnhof.done;
BEGIN
  Gleise.done;
  SetzInfo(nil);
END;

PROCEDURE TBahnhof.SetzInfo(cp:pchar);
BEGIN
  if Info<>nil then StrDispose(Info);
  Info:=cp;
END;

FUNCTION TBahnhof.GetInfo:pchar;
BEGIN
  GetInfo:=Info;
END;

FUNCTION TBahnhof.GleisDazu(Name:string; Laenge:word):hGleis;
VAR gp:PGleisDaten;
BEGIN
  new(gp);
  gp^.Bezeichnung:=Name;
  gp^.NutzLaenge:=Laenge;
  Gleise.append(gp);
  GleisDazu:=Gleise.anzahl;
END;

FUNCTION TBahnhof.GetGleis(nr:hGleis):PGleisDaten;
BEGIN
  if (nr>0) and (nr<=Gleise.anzahl) then GetGleis:=Gleise.p^[nr]
                                    else GetGleis:=nil;
END;

FUNCTION TBahnhof.GleiseLoeschen:boolean;
VAR gp:PGleisDaten;
    ok:boolean;
BEGIN
  Gleise.Free;
END;

FUNCTION TBahnhof.AnzahlGleise:word;
BEGIN
  AnzahlGleise:=Gleise.Anzahl;
END;


END.
