{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 95

 Inhalt: Objekttyp, der ein Array ueber alle vergebenen Handles auf Datenbanken und
         die Verbindung zu den Datenbanken beherbergt.
         Im Interfaceteil wird das HandleArray instanziiert, im Implementationteil
         wird das DatenbankArray aus bm_DatAr instanziiert.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT bm_Array;

{$C moveable preload permanent}

INTERFACE
USES BfDef, heap, BfArray;

TYPE THandleArray=OBJECT
                    CONSTRUCTOR init;
                    DESTRUCTOR done;
                    FUNCTION Open(dn:pchar):hDatenbank;
                    FUNCTION Create(dn:pchar):hDatenbank;
                    FUNCTION Handle2Pointer(h:hDatenbank):PBahnhofsArray;
                    FUNCTION Close(h:hDatenbank):boolean;
                    FUNCTION GetAnzahl:word;
                  PRIVATE
                    Arr:TDynArray;  {wird als dynamisches Array of word benutzt}
                    PROCEDURE Prepare(quell,ziel:pchar);
                    FUNCTION Append(w:word):hDatenbank;
                  END;

VAR HandleArray:THandleArray;


IMPLEMENTATION
USES bm_DatAr, WinDos, Strings, ProgExit;

VAR DatenbankArray:TDatenbankArray;


CONSTRUCTOR THandleArray.init;
BEGIN
  Arr.init;
END;

DESTRUCTOR ThandleArray.done;
VAR w:word;
BEGIN
  Arr.done;
END;

FUNCTION ThandleArray.Open(dn:pchar):hDatenbank;
VAR Puffer:Array [0..1000] of char;
    i:word;
BEGIN
{Defaultausgabe}
  Open:=0;
{Standardisierte Dateinamen erzeugen, die sich vergleichen lassen}
  Prepare(dn,puffer);
{Schauen, ob die Datei schon geoeffnet ist}
  i:=DatenbankArray.SearchFilename(Puffer);
  if i=0 then begin                          {noch nicht geoeffnet -> selber oeffnen}
    i:=DatenbankArray.AppendLoad(Puffer);
    if i=0 then exit;
    Open:=Append(i);
  end else begin                             {schon geoeffnet -> Verweis speichern}
    Open:=Append(i);
  end;
END;

FUNCTION ThandleArray.Create(dn:pchar):hDatenbank;
VAR Puffer:Array [0..1000] of char;
    i:word;
BEGIN
{Defaultausgabe}
  Create:=0;
{Standardisierte Dateinamen erzeugen, die sich vergleichen lassen}
  Prepare(dn,puffer);
{Schauen, ob die Datei schon geoeffnet ist, wenn ja, kann sie nicht erzeugt werden}
  i:=DatenbankArray.SearchFilename(Puffer);
  if i<>0 then exit;
{Erzeugen}
  i:=DatenbankArray.AppendCreate(Puffer);
  if i=0 then exit;
{Erfolg}
  Create:=Append(i);
END;

FUNCTION THandleArray.Handle2Pointer(h:hDatenbank):PBahnhofsArray;
VAR w:word;
BEGIN
  if (h<1) or (h>Arr.anzahl) then begin
    Handle2Pointer:=nil;
    exit;
  end;
  w:=word(Arr.p^[h]);
  if w=0 then Handle2Pointer:=nil
         else Handle2Pointer:=DatenbankArray.GetBahnhofsArray(w);
END;

FUNCTION THandleArray.Close(h:hDatenbank):boolean;
VAR w:word;
BEGIN
  if (h<1) or (h>Arr.anzahl) then begin
    Close:=false;
    exit;
  end;
  w:=word(Arr.p^[h]);
  Arr.p^[h]:=pointer(0);
  if Arr.Position(pointer(w))=0 then begin {war einziger User einer Datenbank}
    DatenbankArray.Close(w);
    Close:=true;
  end else begin                       {es gabe noch andere User}
    Close:=DatenbankArray.GetBahnhofsArray(w)^.Save;
  end;
END;

FUNCTION THandleArray.GetAnzahl:word;
BEGIN
  GetAnzahl:=Arr.Anzahl;
END;

{****************************************************************************}

PROCEDURE THandleArray.Prepare(quell,ziel:pchar);
BEGIN
  FileExpand(ziel,quell);
  if StrLen(ziel)>999 then runerror;
END;

FUNCTION THandleArray.Append(w:word):hDatenbank;
BEGIN
  Arr.Append(pointer(w));
  Append:=Arr.Anzahl;
END;


PROCEDURE bm_array_exitproc; FAR;
BEGIN
  DatenbankArray.done;
END;

BEGIN
  DatenbankArray.init;
  RegisterExitProc(bm_array_exitproc);
END.
