{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 94

 Inhalt:Dieses Modul enthaelt Deklarationen, die von anderen "bm_*"-Modulen
        importiert werden.
}

UNIT bm_base;

{$A+,B-,G+,I+,V-,X+,P+,T+}

{$C moveable preload permanent}

INTERFACE
USES bfarray, heap, BfDef, WinTypes;

FUNCTION Bf_GetVersion:pchar;                        export;


IMPLEMENTATION
USES WinProcs, Win_Allg, grund;

{$I version.inc}

FUNCTION Bf_GetVersion:pchar;
BEGIN
  Bf_GetVersion:=VersionString;
END;

{******************************** Bahnhofs-Array *********************************}
(*
CONST FehlerAnzeigen:boolean=true;

PROCEDURE TArray.SyntaxFehlerGefunden(s:string);
BEGIN
  TBahnhofsArray.SyntaxFehlerGefunden(s);
  if not FehlerAnzeigen then exit;
  if MessageBox(0, String2Pchar(s), 'Syntaxfehler in Bahnhofsdatei', mb_OKCancel)=idCancel then Fehleranzeigen:=false;
END;

PROCEDURE TArray.DateiFehlerGefunden(s:string);
BEGIN
  TBahnhofsArray.DateiFehlerGefunden(s);
  MessageBox(0,String2Pchar(s),'Dateizugriffsfehler bei Bahnhofsdatei',mb_OK);
END;

FUNCTION GetBf(nr:word):Pbahnhof;
BEGIN
  if (nr=0) then runerror;
  if (nr>Arr.anzahl) then GetBf:=nil
                     else GetBf:=Arr.p^[nr];
END;

{*************************************** Schnittstelle *******************************}

PROCEDURE Bf_Aenderung(nr:word; Existenz:boolean);
VAR w:word;
    proc:pointer;
BEGIN
  for w:=1 to User.anzahl do PostMessage(SuperPointer(User.p^[w]).o, WM_NeueDaten, nr, word(existenz));
  Arr.geaendert:=true;
END;


FUNCTION Bf_GetWM:word;
BEGIN
  Bf_GetWM:=WM_NeueDaten;
END;


FUNCTION Bf_GetDaten(nr:word):PBahnhofsDaten;
VAR Bahnhof:PBahnhof;
BEGIN
  Bahnhof:=GetBf(nr);
  if Bahnhof=nil then Bf_GetDaten:=nil
                 else Bf_GetDaten:=@Bahnhof^.Daten;
END;

FUNCTION Bf_Anzahl:word;
BEGIN
  Bf_Anzahl:=Arr.anzahl;
END;

FUNCTION Bf_GetNotNilCount:word;
VAR anz,w:word;
BEGIN
  anz:=0;
  for w:=1 to Bf_Anzahl do if GetBf(w)<>nil then inc(anz);
  Bf_GetNotNilCount:=anz;
END;

FUNCTION Bf_Neu:word;
VAR wo:word;
BEGIN
  wo:=Arr.Position(nil);
  if wo=0 then begin
    wo:=1;
    while (wo<=Arr.Anzahl) and ((Arr.p^[wo]=nil) or (GetBf(wo)^.Daten.Name<>'<noname>')) do inc(wo);
    if wo=Arr.anzahl+1 then begin
      Arr.append(CreateBahnhof('<noname> n.n.'));
      wo:=Arr.anzahl;
      Arr.geaendert:=true;
      Bf_Aenderung(wo,true);
    end;
  end else begin
    Arr.p^[wo]:=CreateBahnhof('<noname> n.n.');
    Arr.geaendert:=true;
    Bf_Aenderung(wo,true);
  end;
  Bf_Neu:=wo;
END;

PROCEDURE Bf_Loeschen(bnr:word);
VAR bp:PBahnhof;
BEGIN
  if GetBf(bnr)=nil then runerror;
  DisposeBahnhof(PBahnhof(Arr.p^[bnr]));
{$IFDEF Mindestens_Einen}
  if Bf_GetNotNilCount=0 then begin
    Arr.free;
    Bf_Neu;
  end;
{$ENDIF}
  Arr.geaendert:=true;
  Bf_Aenderung(bnr,true);   {Achtung! Das muss richtig ausgewertet werden}
END;


BEGIN
  WM_NeueDaten:=RegisterWindowMessage('Neue_Daten');*)
END.
