{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 95

 Inhalt: Zugriffsroutinen auf die Daten und den Infotext eines bestimmten Bahnhofs in
         einer bestimmten Datenbank.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT bm_Data;

{$C moveable permanent preload}

INTERFACE
USES BfDef, WinTypes;

FUNCTION Bf_GetData(Datenbank:hDatenbank; Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError; export;
FUNCTION Bf_SetData(Datenbank:hDatenbank; Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError; export;

FUNCTION Bf_GetInfo(Datenbank:hDatenbank; Bahnhof:hBahnhof; InfoPuffer:pchar; MaxChars:word):word; export;
FUNCTION Bf_SetInfo(Datenbank:hDatenbank; Bahnhof:hBahnhof; InfoPuffer:pchar):TBfError; export;

FUNCTION Bf_Info2Window(Datenbank:hDatenbank; Bahnhof:hBahnhof; Window:hWnd):TBfError; export;
FUNCTION Bf_Window2Info(Datenbank:hDatenbank; Bahnhof:hBahnhof; Window:hWnd):TBfError; export;


IMPLEMENTATION
USES bm_Array, BfArray, Strings, WinProcs;

FUNCTION Bf_GetData(Datenbank:hDatenbank; Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
    BahnhofsDaten:PBahnhofsDaten;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_GetData:=DatenbankUngueltig;
    exit;
  end;
  BahnhofsDaten:=BahnhofsArray^.GetBahnhofsDaten(Bahnhof);
  if BahnhofsDaten=nil then begin
    Bf_GetData:=BahnhofUngueltig;
    exit;
  end;
  DatenPuffer^:=BahnhofsDaten^;
  Bf_GetData:=keinFehler;
END;

FUNCTION Bf_SetData(Datenbank:hDatenbank; Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
    BahnhofsDaten:PBahnhofsDaten;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_SetData:=DatenbankUngueltig;
    exit;
  end;
  BahnhofsDaten:=BahnhofsArray^.GetBahnhofsDaten(Bahnhof);
  if BahnhofsDaten=nil then begin
    Bf_SetData:=BahnhofUngueltig;
  end else begin
    BahnhofsDaten^:=DatenPuffer^;
    Bf_SetData:=keinFehler;
    BahnhofsArray^.SetzGeaendert;
  end;
END;


FUNCTION Bf_GetInfo(Datenbank:hDatenbank; Bahnhof:hBahnhof; InfoPuffer:pchar; MaxChars:word):word;
VAR BahnhofsArray:PBahnhofsArray;
    Info:pchar;
    Len:word;
BEGIN
  Bf_GetInfo:=0;
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then exit;
  Info:=BahnhofsArray^.GetInfo(Bahnhof);
  if Info=nil then exit;
  Len:=StrLen(Info);
  Bf_GetInfo:=Len;
  if (InfoPuffer<>nil) and (MaxChars>=Len) then StrCopy(InfoPuffer, Info);
END;

FUNCTION Bf_SetInfo(Datenbank:hDatenbank; Bahnhof:hBahnhof; InfoPuffer:pchar):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
    Info:pchar;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_SetInfo:=Datenbankungueltig;
    exit;
  end;
  Info:=strnew(InfoPuffer);
  if BahnhofsArray^.SetInfo(Bahnhof,Info) then begin
    Bf_SetInfo:=keinFehler;
    BahnhofsArray^.SetzGeaendert;
  end else begin
    Bf_SetInfo:=BahnhofUngueltig;
    StrDispose(Info);
  end;
END;

FUNCTION Bf_Info2Window(Datenbank:hDatenbank; Bahnhof:hBahnhof; Window:hWnd):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_Info2Window:=DatenbankUngueltig;
    exit;
  end;
  Bf_Info2Window:=keinFehler;
  SetWindowText(Window, BahnhofsArray^.GetInfo(Bahnhof));
END;

FUNCTION Bf_Window2Info(Datenbank:hDatenbank; Bahnhof:hBahnhof; Window:hWnd):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
    Info:pchar;
    Len:word;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_Window2Info:=Datenbankungueltig;
    exit;
  end;
  Len:=GetWindowTextLength(Window);
  if Len=0 then begin
    if BahnhofsArray^.SetInfo(Bahnhof,nil) then begin
      Bf_Window2Info:=keinFehler;
    end else begin
      Bf_Window2Info:=BahnhofUngueltig;
    end;
  end else begin
    GetMem(Info, Len+1);
    GetWindowText(Window, Info, Len);
    if BahnhofsArray^.SetInfo(Bahnhof,Info) then begin
      Bf_Window2Info:=keinFehler;
      BahnhofsArray^.SetzGeaendert;
    end else begin
      Bf_Window2Info:=BahnhofUngueltig;
      StrDispose(Info);
    end;
  end;
END;


END.
