{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 95

 Inhalt: Objekttyp, der ein dynamisches Array ueber BahnhofsArray beherbergt.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT bm_DatAr;

{$C moveable permanent preload}

INTERFACE
USES BfArray, heap;

TYPE TDatenbankArray=OBJECT
                       CONSTRUCTOR init;
                       DESTRUCTOR done;
                       FUNCTION SearchFilename(dn:pchar):word;
                       FUNCTION GetBahnhofsArray(w:word):PBahnhofsArray;
                       FUNCTION AppendLoad(dn:pchar):word;
                       FUNCTION AppendCreate(dn:pchar):word;
                       PROCEDURE Close(w:word);
                     PRIVATE
                       Arr:TDynArray;
                     END;


IMPLEMENTATION
USES Strings;

CONSTRUCTOR TDatenbankArray.init;
BEGIN
  Arr.init;
END;

DESTRUCTOR TDatenbankArray.done;
VAR w:word;
    Datenbank:PBahnhofsArray;
BEGIN
  for w:=1 to Arr.anzahl do begin
    Datenbank:=GetBahnhofsArray(w);
    if Datenbank<>nil then dispose(Datenbank,done)
  end;
  Arr.done;
END;

FUNCTION TDatenbankArray.SearchFilename(dn:pchar):word;
VAR w:word;
    bap:PBahnhofsArray;
BEGIN
  for w:=1 to Arr.anzahl do begin
    bap:=GetBahnhofsArray(w);
    if (bap<>nil) and (StrComp(bap^.GetFilename,dn)=0) then begin
      SearchFilename:=w;
      exit;
    end;
  end;
  SearchFilename:=0;
END;

FUNCTION TDatenbankArray.GetBahnhofsArray(w:word):PBahnhofsArray;
BEGIN
  if (w<1) or (w>Arr.anzahl) then runerror;
  GetBahnhofsArray:=Arr.p^[w];
END;

FUNCTION TDatenbankArray.AppendLoad(dn:pchar):word;
VAR bap:PBahnhofsArray;
BEGIN
  new(bap,init(dn));
  if bap^.Load then begin
    Arr.Append(bap);
    AppendLoad:=Arr.anzahl;
  end else begin
    dispose(bap,done);
    AppendLoad:=0;
  end;
END;

FUNCTION TDatenbankArray.AppendCreate(dn:pchar):word;
VAR bap:PBahnhofsArray;
BEGIN
  new(bap,init(dn));
  if bap^.Save then begin
    Arr.Append(bap);
    AppendCreate:=Arr.anzahl;
  end else begin
    dispose(bap,done);
    AppendCreate:=0;
  end;
END;

PROCEDURE TDatenbankArray.Close(w:word);
VAR bap:PBahnhofsArray;
BEGIN
  if (w<1) or (w>Arr.anzahl) then runerror;
  bap:=Arr.p^[w];
  if bap=nil then runerror;
  dispose(bap,done);
  Arr.p^[w]:=nil;
END;


END.
