{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 95

 Inhalt: Datensatz-Funktionen
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT bm_DSet;

{$C moveable preload permanent}

INTERFACE
USES BfDef;

FUNCTION Bf_Aufzaehlung(Datenbank:hDatenbank; AufzaehlProc:TAufzaehlProc):TBfError; export;
FUNCTION Bf_BahnhofDazu(Datenbank:hDatenbank):hBahnhof; export;
FUNCTION Bf_BahnhofLoeschen(Datenbank:hDatenbank; Bahnhof:hBahnhof):TBfError; export;


IMPLEMENTATION
USES BfArray, bm_array;

FUNCTION Bf_Aufzaehlung(Datenbank:hDatenbank; AufzaehlProc:TAufzaehlProc):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
    Bahnhof:hBahnhof;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_Aufzaehlung:=DatenbankUngueltig;
    exit;
  end;
  for Bahnhof:=1 to BahnhofsArray^.GetAnzahl do begin
    if BahnhofsArray^.GetBahnhofsDaten(Bahnhof)<>nil then AufzaehlProc(Bahnhof);
  end;
  Bf_Aufzaehlung:=keinFehler;
END;

FUNCTION Bf_BahnhofDazu(Datenbank:hDatenbank):hBahnhof;
VAR BahnhofsArray:PBahnhofsArray;
    Bahnhof:hBahnhof;
BEGIN
  Bf_BahnhofDazu:=0;
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then exit;
  Bf_BahnhofDazu:=BahnhofsArray^.BahnhofDazu;
  BahnhofsArray^.SetzGeaendert;
END;

FUNCTION Bf_BahnhofLoeschen(Datenbank:hDatenbank; Bahnhof:hBahnhof):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_BahnhofLoeschen:=DatenbankUngueltig;
    exit;
  end;
  if BahnhofsArray^.LoeschBahnhof(Bahnhof) then begin
    Bf_BahnhofLoeschen:=keinFehler;
    BahnhofsArray^.SetzGeaendert;
  end else Bf_BahnhofLoeschen:=BahnhofUngueltig;
END;


END.
