{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann

 Inhalt:Dieses Modul enthaelt zwei Prozeduren, die je ein Dialogfenster
        ausfuehren.
}

UNIT bm_fenst;

{$A+,B-,G+,I+,V-,X+,W+}
{$D+,L+,R+,S+}

{$C moveable demandload discardable}

INTERFACE
USES Wintypes, Win_Allg, BfDef;

FUNCTION Bf_BahnhofsAuswahlDialog(parent:hWnd; Datenbank:hDatenbank; Titel:pchar):hBahnhof; export;
PROCEDURE Bf_ExecuteStatusDialog(parent:hWnd); export;


IMPLEMENTATION
USES bm_array, bm_base, bfarray, bm_handl, WinProcs, heap, Strings;

{********************************** Auswahlfenster ***********************************}

VAR DialogDaten:record
                  edit:word;
                  hilfe:pchar;
                  BahnhofsArray:PBahnhofsArray;
                end;
FUNCTION AuswahlfensterProc(Dialog: HWnd; Message, wParam: Word; lParam: Longint): Bool; export;

 Procedure GotIt(h:Hwnd);
 Var i:integer;
     arr:array [0..30] of char;
 Begin
   i:=SendDlgItemMessage(h, 42, lb_GetCurSel, 0,0);
   if i=lb_err then EndDialog(h,id_cancel) else begin
     if SendDlgItemMessage(h, 42, lb_GetText, i, longint(@arr))>30 then runerror;
     DialogDaten.edit:=DialogDaten.BahnhofsArray^.name2handle(Pchar2string(arr));
     EndDialog(h,id_ok);
   end;
 End;

VAR w:word;
    dp:PBahnhofsDaten;
    ca:array [0..maxBahnhofsName] of char;
BEGIN
  AuswahlfensterProc := True;
  case Message of
    wm_InitDialog:begin
                    SetWindowText(Dialog,pchar(lParam));
                    with DialogDaten.BahnhofsArray^ do for w:=1 to GetAnzahl do begin
                      dp:=GetBahnhofsDaten(w);
                      String2CharArray(dp^.name, ca);
                      if dp<>nil then SendDlgItemMessage
                          (Dialog, 42, lb_AddString, 0, longint(@ca[0]));
                    end;
                    AuswahlfensterProc:=false;
                  end;
    wm_Command   :case wParam of
                    id_Ok:GotIt(Dialog);
                id_Cancel:EndDialog(Dialog,id_cancel);
                       42:if hiword(lParam)=lbn_DblClk then GotIt(Dialog);
                       35:begin
                            if DialogDaten.Hilfe=nil
                              then MessageBox(Dialog,'Der Programmierer war zu faul!','Keine Hilfe',mb_OK)
                              else MessageBox(Dialog, DialogDaten.Hilfe, 'Hilfe', mb_OK);
                          end;
                     else AuswahlfensterProc := False;
                  end;
             else AuswahlfensterProc := False;
  end;
END;

CONST InAuswahlDialog:boolean=false;
FUNCTION Bf_BahnhofsAuswahlDialog(parent:hWnd; Datenbank:hDatenbank; Titel:pchar):hBahnhof;
VAR DlgProc: TFarProc;
    bap:PBahnhofsArray;
BEGIN
  Bf_BahnhofsAuswahlDialog:=0;
  bap:=HandleArray.Handle2Pointer(Datenbank);
  if (bap=nil) or InAuswahlDialog then exit;

  InAuswahlDialog:=true;
  DialogDaten.edit:=0;
  DialogDaten.hilfe:='Hilf dir selbst!';
  DialogDaten.BahnhofsArray:=bap;

  DlgProc := MakeProcInstance(@AuswahlfensterProc, HInstance);
  if DialogBoxParam(HInstance, 'bahnhofsauswahl', parent, DlgProc, longint(titel))=id_ok
    then Bf_BahnhofsAuswahlDialog:=DialogDaten.edit;
  FreeProcInstance(DlgProc);
  InAuswahlDialog:=false;
END;

{********************************** Statusfenster ************************************}

CONST id_Version=101;
      id_Listbox=103;
      id_Anzahl=100;
      id_Geaendert=101;
      id_User=102;

TYPE PEntry=^REntry;
     REntry=RECORD
              Dat:PBahnhofsArray;
              Anzahl:word;
            END;

FUNCTION DatabaseProc(Dialog:hWnd; Message, wparam:word; lParam:longint):Bool; export;
VAR ca:array [0..42] of char;
    anz:word;
    h:hBahnhof;
BEGIN
  DatabaseProc:=True;
  case Message of
    wm_InitDialog:begin
                    SetWindowText(Dialog, PEntry(lParam)^.Dat^.GetFileName);
                    with PEntry(lParam)^ do begin
                      anz:=0;
                      for h:=1 to dat^.GetAnzahl
                        do if dat^.GetBahnhofsDaten(h)<>nil then inc(anz);
                      str(anz, ca);
                      SetWindowText(GetDlgItem(Dialog, 100), ca);
                      if dat^.GetGeaendert then StrCopy(ca, 'ja')
                                           else StrCopy(ca, 'nein');
                      SetWindowText(GetDlgItem(Dialog, 101), ca);
                      str(Anzahl, ca);
                      SetWindowText(GetDlgItem(Dialog, 102), ca);
                    end;
                  end;
    wm_Command   :case wParam of
                        id_Ok:EndDialog(Dialog,id_ok);
                    id_Cancel:EndDialog(Dialog,id_cancel);
                  end;
    else DatabaseProc:=false;
  end;
END;

VAR EntryArray:TRecordArray;

FUNCTION StatusBoxProc(Dialog:hWnd; Message, wParam:Word; lParam:Longint): Bool; export;
VAR Puffer:string[50];
    w:word;
    l:longint;
    DlgProc:TFarProc;
BEGIN
  StatusBoxProc:=True;
  case Message of
    wm_InitDialog:begin
                    SetWindowText(GetDlgItem(Dialog,id_Version), Bf_GetVersion);
                    for w:=1 to EntryArray.anzahl do with PEntry(EntryArray.p^[w])^ do begin
                      SendDlgItemMessage(Dialog, id_ListBox, lb_AddString, 0, longint(dat^.GetFilename));
                    end;
                  end;
    wm_Command   :case wParam of
                        id_Ok:EndDialog(Dialog,id_ok);
                    id_Cancel:EndDialog(Dialog,id_cancel);
                   id_ListBox:if hiword(lParam)=lbn_DblClk then begin
                                l:=SendDlgItemMessage(Dialog, id_ListBox, lb_GetCurSel, 0, 0);
                                if (l>=0) and (l<EntryArray.anzahl) then begin
                                  DlgProc:=MakeProcInstance(@DatabaseProc, HInstance);
                                  DialogBoxParam(HInstance, 'DatabaseInfo', Dialog, DlgProc,
                                                 longint(EntryArray.p^[l+1]));
                                  FreeProcInstance(DlgProc);
                                end;
                              end;
                  end;
    else StatusBoxProc:=false;
  end;
END;

CONST InStatusBox:boolean=false;
PROCEDURE Bf_ExecuteStatusDialog(parent:Hwnd);
 Function Gefunden(BahnhofsArray:PBahnhofsArray):word;
 Var w:word;
 Begin
   for w:=1 to EntryArray.anzahl
   do if (PEntry(EntryArray.p^[w])^.Dat=BahnhofsArray)
   then begin
     Gefunden:=w;
     exit;
   end;
   Gefunden:=0;
 End;
VAR DlgProc:TFarProc;
    h:hDatenbank;
    wo:word;
    BahnhofsArray:PBahnhofsArray;
    ep:PEntry;
BEGIN
{nur einmal gleichzeitig}
  if InStatusBox then exit;
  InStatusBox:=true;
{EntryArray mit allen offenen BahnhofsArrays fuellen}
  EntryArray.init(sizeof(REntry));
  for h:=1 to HandleArray.GetAnzahl do begin
    BahnhofsArray:=HandleArray.Handle2Pointer(h);
    if (BahnhofsArray<>nil) then begin
      wo:=Gefunden(BahnhofsArray);
      if wo=0 then begin
        new(ep);
        with ep^ do begin
          Dat:=BahnhofsArray;
          Anzahl:=1;
        end;
        EntryArray.Append(ep);
      end else begin
        inc(PEntry(EntryArray.p^[wo])^.Anzahl);
      end;
    end;
  end;
{Dialog ausfuehren}
  DlgProc:=MakeProcInstance(@StatusBoxProc, HInstance);
  DialogBox(HInstance, 'StatusBox', parent, DlgProc);
  FreeProcInstance(DlgProc);
  EntryArray.done;
  InStatusBox:=false;
END;


END.
