{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 94

 Inhalt:Dieses Modul enthlt die Prozeduren, die auf das Gleisarray eines
        speziellen Bahnhofs in der Datenbank zugreifen.
}

UNIT bm_Gleis;

{$A+,B-,G+,I+,V-,X+,W+}
{$D+,L+,R+,S+}

{$C moveable permanent preload}

INTERFACE
USES BfDef;

FUNCTION Bf_GetGleisAnzahl(Datenbank:hDatenbank; Bahnhof:hBahnhof):word; export;
FUNCTION Bf_GetGleis(Datenbank:hDatenbank; Bahnhof:hBahnhof; Gleis:hGleis; GleisPuffer:PGleisDaten):TBfError; export;
FUNCTION Bf_GleisDazu(Datenbank:hDatenbank; Bahnhof:hBahnhof; GleisPuffer:PGleisDaten):hGleis; export;
FUNCTION Bf_GleiseLoeschen(Datenbank:hDatenbank; Bahnhof:hBahnhof):TBfError; export;


IMPLEMENTATION
USES bfarray, bm_array;

FUNCTION Bf_GetGleisAnzahl(Datenbank:hDatenbank; Bahnhof:hBahnhof):word;
VAR BahnhofsArray:PBahnhofsArray;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_GetGleisAnzahl:=0;
    exit;
  end;
  Bf_GetGleisAnzahl:=BahnhofsArray^.GetGleisAnzahl(Bahnhof);
END;

FUNCTION Bf_GetGleis(Datenbank:hDatenbank; Bahnhof:hBahnhof; Gleis:hGleis; GleisPuffer:PGleisDaten):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
    GleisDaten:PGleisDaten;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_GetGleis:=DatenbankUngueltig;
    exit;
  end;
  GleisDaten:=BahnhofsArray^.GetGleisDaten(Bahnhof, Gleis);
  if GleisDaten=nil then Bf_GetGleis:=BahnhofUngueltig
                    else Bf_GetGleis:=keinFehler;
  if GleisDaten<>nil then GleisPuffer^:=GleisDaten^;
END;

FUNCTION Bf_GleisDazu(Datenbank:hDatenbank; Bahnhof:hBahnhof; GleisPuffer:PGleisDaten):hGleis;
VAR BahnhofsArray:PBahnhofsArray;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_GleisDazu:=0;
    exit;
  end;
  Bf_GleisDazu:=BahnhofsArray^.GleisDazu(Bahnhof, GleisPuffer);
  BahnhofsArray^.SetzGeaendert;
END;

FUNCTION Bf_GleiseLoeschen(Datenbank:hDatenbank; Bahnhof:hBahnhof):TBfError;
VAR BahnhofsArray:PBahnhofsArray;
BEGIN
  BahnhofsArray:=HandleArray.Handle2Pointer(Datenbank);
  if BahnhofsArray=nil then begin
    Bf_GleiseLoeschen:=DatenbankUngueltig;
    exit;
  end;
  if BahnhofsArray^.GleiseLoeschen(Bahnhof) then begin
    Bf_GleiseLoeschen:=keinFehler;
    BahnhofsArray^.SetzGeaendert;
  end else Bf_GleiseLoeschen:=BahnhofUngueltig;
END;


END.