{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 95

 Inhalt: Funktionen zum oeffnen/schliessen von Datenbanken
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT bm_Handl;

{$C moveable preload permanent}

INTERFACE
USES bm_array, BfDef, WinTypes;

FUNCTION Bf_OpenDirect(parent:hWnd; Dateiname:pchar):hDatenbank; export;
FUNCTION Bf_OpenDialog(parent:hWnd):hDatenbank; export;
FUNCTION Bf_CreateDialog(parent:hWnd):hDatenbank; export;
FUNCTION Bf_Close(Datenbank:hDatenbank):boolean; export;
FUNCTION Bf_GetFileName(Datenbank:hDatenbank; Puffer:pchar; MaxChars:word):word; export;
FUNCTION Bf_GetStatus(Datenbank:hDatenbank):TDatenbankStatus; export;


IMPLEMENTATION
USES bfarray, ProgExit, MyComDlg, WinDos, Strings, CommDlg;

CONST FormatListe='Bahnhofsdatenbanken'+#0+'*.bf'+#0+'alte Bahnhofsliste'+#0+'bahnhof.lst'+#0+'alle Dateien'+#0+'*.*'+#0;

FUNCTION Bf_OpenDirect(parent:hWnd; Dateiname:pchar):hDatenbank;
BEGIN
  Bf_OpenDirect:=HandleArray.Open(Dateiname);
END;

FUNCTION Bf_OpenDialog(parent:hWnd):hDatenbank;
VAR dlg:TLoadCommDlg;
    dateiname:string;
BEGIN
  Bf_OpenDialog:=0;
  dlg.init(parent, 'Bahnhofsdatenbank laden');
  with dlg.Daten do begin
    lpstrDefExt   := 'bf';
    lpstrFilter   := FormatListe;
  end;
  dateiname:='';
  if dlg.execute(dateiname) and (length(dateiname)<>255) then begin
    dateiname[length(dateiname)+1]:=#0;
    Bf_OpenDialog:=HandleArray.Open(@Dateiname[1]);
  end;
  dlg.done;
END;

FUNCTION Bf_CreateDialog(parent:hWnd):hDatenbank;
VAR dlg:TSaveCommDlg;
    dateiname:string;
BEGIN
  Bf_CreateDialog:=0;
  dlg.init(parent, 'Bahnhofsdatenbank erzeugen');
  with dlg.Daten do begin
    lpstrDefExt   := 'bf';
    lpstrFilter   := FormatListe;
    Flags         := Flags or ofn_OverwritePrompt;
  end;
  dateiname:='';
  if dlg.execute(dateiname) and (length(dateiname)<>255) then begin
    dateiname[length(dateiname)+1]:=#0;
    Bf_CreateDialog:=HandleArray.Create(@Dateiname[1]);
  end;
  dlg.done;
END;

FUNCTION Bf_Close(Datenbank:hDatenbank):boolean;
BEGIN
  Bf_Close:=HandleArray.Close(Datenbank);
END;

FUNCTION Bf_GetFileName(Datenbank:hDatenbank; Puffer:pchar; MaxChars:word):word;
VAR bap:PBahnhofsArray;
    FileName:pchar;
    len:word;
BEGIN
{Default}
  Bf_GetFileName:=0;
{Datenbank holen, check ob ueberhaupt vorhanden}
  bap:=HandleArray.Handle2Pointer(Datenbank);
  if bap=nil then exit;
{Zeiger auf Dateiname holen}
  FileName:=bap^.GetFilename;
  len:=StrLen(FileName);
{Rueckgabewert ist immer die eigentliche Laenge}
  Bf_GetFilename:=len;
{Wenn Puffer existiert und gross genug ist, wird Dateiname kopiert}
  if (Puffer<>nil) and (MaxChars>=len) then StrCopy(Puffer,FileName);
END;

FUNCTION Bf_GetStatus(Datenbank:hDatenbank):TDatenbankStatus;
BEGIN
  if HandleArray.Handle2Pointer(Datenbank)=nil then Bf_GetStatus:=Ungueltig
                                               else Bf_GetStatus:=ok;
END;


PROCEDURE bm_handl_exitproc; FAR;
BEGIN
  HandleArray.done;
END;

BEGIN
  HandleArray.init;
  RegisterExitProc(bm_handl_exitproc);
END.
