{Datei: allgemeinbrauchbare Toolbox fuer DOS und Windows
        mit Objekten, die die dynamische Speicherverwaltung
        vereinfachen sollen

 Autor: Stefan Bormann 94

 Inhalt: PointerObj       verwaltet einen simplen Speicherbereich
         ZweiDimArrayObj  wie PointerObj aber mit der Moeglichkeit,
                          den Speicherbereich als zweidimensionales
                          Array zu benutzten
         DynArrayObj      ein SEHR universelles Array of pointer,
                          dessen Groesse sich zur Laufzeit
                          veraendern laesst.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

{$ifdef windows}
{$C moveable preload permanent}
{$endif}

UNIT Heap;

INTERFACE

TYPE PointerObj=OBJECT
                  p:pointer;
                  reserviert:word;
                  PROCEDURE Get(anz:word);
                  PROCEDURE Free;
                END;

TYPE ZweiDimArrayObj=OBJECT(PointerObj)  {[0..Ygr-1,0..Xgr-1]}
                       Xgr,Ygr,RECgr:word;
                       CONSTRUCTOR init(x,y,rec:word);
                       FUNCTION Index(x,y:word):word;
                       FUNCTION Zeiger(x,y:word):pointer;
                       DESTRUCTOR done;  virtual;
                     END;

TYPE ADynPointerArray=Array [1..$3FFF] of pointer;
     PDynPointerArray=^ADynPointerArray;
     PdynArrayObj=^DynArrayObj;
     SignTyp = -1..1;
     VergleichsFunktion=FUNCTION(eins,zwei:pointer):SignTyp;
     FilterFunction    =FUNCTION(d:pointer):boolean;
     {SignTyp: -1 fuer eins<zwei
                0 fuer eins=zwei
                1 fuer eins>zwei}
     DynArrayObj=OBJECT
                   Anzahl:word;
                   p:PDynPointerArray;
                   CONSTRUCTOR Init;
                   PROCEDURE Insert(nr:word; daten:pointer);
                   PROCEDURE Delete(nr:word);
                   FUNCTION Position(daten:pointer):word;
                   FUNCTION SuchPosition(VAR was; gr:word):word;
                   {FUNCTION HalbSchrittSuche(VAR was; AkleinerB:VergleichsFunktion);}
                   PROCEDURE Append(daten:pointer);
                   PROCEDURE Erweiterung(anz:word);
                   PROCEDURE Sortieren   (AkleinerB:VergleichsFunktion);
                   PROCEDURE Trivial_Sort(AkleinerB:VergleichsFunktion);
                   PROCEDURE Merge_Sort  (AkleinerB:VergleichsFunktion);
                   PROCEDURE QSort(AkleinerB:VergleichsFunktion);
                   PROCEDURE Filter(ff:FilterFunction);
                   PROCEDURE FilterCopy(von:DynArrayObj; ff:FilterFunction);
                   PROCEDURE Free;  virtual;
                   DESTRUCTOR Done; virtual;
                   PROCEDURE CheckIndex(i:word);  {neu 20.3.95}
                 PRIVATE
                   qsort_vergleich:VergleichsFunktion;
                   qsort_pivotindex:integer;
                   PROCEDURE qsort_FindPivot(i2,j2:word);
                   PROCEDURE qsort_rekursiv(i,j:word);
                   FUNCTION qsort_partition(i,j:word; pivot:pointer):word;
                 END;

FUNCTION StringVergleich(VAR eins,zwei:string):SignTyp;
FUNCTION LongIntVergleich(l1,l2:longint):SignTyp;
TYPE pstring=^string;
PROCEDURE DisposeStr(VAR p:pstring);
FUNCTION NewStr(s:string):pstring;


TYPE StringArrayObj=OBJECT(DynArrayObj)
                      CONSTRUCTOR Init;
                      PROCEDURE Free; virtual;
                    END;

     RecordArrayObj=OBJECT(DynArrayObj)
                      RecSize:word;
                      CONSTRUCTOR Init(rs:word);
                      PROCEDURE Free; virtual;
                    END;

     ArrayArrayObj =OBJECT(DynArrayObj)
                      PROCEDURE Free; virtual;
                    END;

     TDynArray=DynArrayObj;
     PDynArray=^TDynArray;
     TStringArray=StringArrayObj;
     PStringArray=^TStringArray;
     TRecordArray=RecordArrayObj;
     PArrayArray=^TArrayArray;
     TArrayArray=ArrayArrayObj;


IMPLEMENTATION

{$ifdef windows}
USES strings;
{$endif}

FUNCTION StringVergleich(VAR eins,zwei:string):SignTyp; assembler;
ASM
  push ds
  lds si,eins
  les di,zwei
  cld          {Aufsteigende Reihenfolge}
  lodsb
  mov cl,al
  cmp cl,es:[di]
  jbe @@1
  mov cl,es:[di]
@@1:
  inc di
  xor ch,ch
  repe cmpsb
  jb @@2
  ja @@3
  mov al,0
  jmp @@4
@@2:
  mov al,-1
  jmp @@4
@@3:
  mov al,1
  jmp @@4
@@4:
  pop ds
END;

FUNCTION LongIntVergleich(l1,l2:longint):SignTyp;
BEGIN
  if l1<l2 then LongIntVergleich:=-1
           else if l1=l2 then LongIntVergleich:=0
                         else LongIntVergleich:=1;
END;

FUNCTION newstr(s:string):Pstring;
VAR p:pstring;
BEGIN
  if length(s)=255 then runerror;
  s[length(s)+1]:=#0;
  if length(s)=0 then newstr:=nil else begin
    getmem(p,length(s)+2);
    move(s,p^,length(s)+2);
    newstr:=p;
  end;
END;

PROCEDURE disposestr(var p:pstring);
TYPE pstring=^string;
BEGIN
  freemem(p,length(pstring(p)^)+2);
  p:=nil;
END;


PROCEDURE PointerObj.Get(anz:word);
BEGIN
  if (anz=0) then p:=nil
             else GetMem(p,anz);
  reserviert:=anz;
END;

PROCEDURE PointerObj.Free;
BEGIN
  if reserviert<>0 then begin
    FreeMem(p,reserviert);
    reserviert:=0;
  end;
  p:=nil;
END;


{*********************** 2-dimensionales Array ****************************}

CONSTRUCTOR ZweiDimArrayObj.init(x,y,rec:word);
BEGIN
  Xgr:=X;  Ygr:=Y;  RECgr:=rec;
  get(x*y*rec);
END;

FUNCTION ZweiDimArrayObj.Index(x,y:word):word;
BEGIN
  if (x>=Xgr) or (y>=Ygr)
   then runerror;
  Index:=y*Xgr +x;
END;

FUNCTION ZweiDimArrayObj.Zeiger(x,y:word):pointer;
TYPE arr=array [0..$FFFE] of byte;
BEGIN
  Zeiger:=@arr(p^)[Index(x,y)*RECgr];
END;

DESTRUCTOR ZweiDimArrayObj.done;
BEGIN
  Xgr:=0;  Ygr:=0;
  free;
END;


{************************** Dynamisches Array ****************************}

CONSTRUCTOR DynArrayObj.Init;
BEGIN
  Anzahl:=0;
  p:=nil;
END;

PROCEDURE DynArrayObj.Insert(nr:word; daten:pointer);
VAR Neu : PDynPointerArray;
    a : word;
BEGIN
  if (nr>anzahl+1) or (nr=0) then runerror;
  getmem(Neu,sizeof(Pointer)*(Anzahl+1));
  Neu^[nr]:=daten;
  if not (Anzahl=0) then begin
    for a:=1 to nr-1 do Neu^[a]:=P^[a];
    for a:=nr to Anzahl do Neu^[a+1]:=P^[a];
    freemem(P,sizeof(Pointer)*Anzahl);
  end;
  P:=Neu;
  inc(anzahl);
END;

PROCEDURE DynArrayObj.Delete(nr:word);
VAR Neu : PDynPointerArray;
    a : word;
BEGIN
  if (nr>anzahl) or (nr=0) then runerror;
  if (Anzahl>1) then begin
    getmem(Neu,sizeof(Pointer)*(Anzahl-1));
    for a:=1 to nr-1 do Neu^[a]:=P^[a];
    for a:=nr+1 to Anzahl do Neu^[a-1]:=P^[a];
  end else Neu:=nil;
  freemem(P,sizeof(Pointer)*Anzahl);
  P:=Neu;
  dec(anzahl);
END;

FUNCTION DynArrayObj.Position(daten:pointer):word;
VAR w:word;
BEGIN
  for w:=1 to Anzahl do if p^[w]=daten then begin
    Position:=w;
    exit;
  end;
  Position:=0;
END;

FUNCTION DynArrayObj.SuchPosition(VAR was; gr:word):word;
TYPE ta=Array [1..$FFFE] of byte;
VAR w,i:word;
    ap:^ta;
BEGIN
  for w:=1 to Anzahl do begin
    i:=1;
    ap:=p^[w];
    while (ap^[i]=ta(was)[i]) and (i<=gr) do inc(i);
    if i=gr+1 then begin
      SuchPosition:=w;
      exit;
    end;
  end;
  SuchPosition:=0;
END;

PROCEDURE DynArrayObj.Append(daten:pointer);
BEGIN
  Insert(anzahl+1,daten);
END;

PROCEDURE DynArrayObj.Erweiterung(anz:word);
VAR Neu : PDynPointerArray;
    a : word;
BEGIN
  if anz=0 then exit;
  getmem(Neu,sizeof(Pointer)*(Anzahl+anz));
  if not (Anzahl=0) then begin
    move(p^,Neu^,anzahl*sizeof(pointer));
    freemem(P,sizeof(Pointer)*Anzahl);
  end;
  P:=Neu;
  fillchar(p^[anzahl+1], anz*sizeof(pointer), 0);
  inc(anzahl,anz);
END;

PROCEDURE DynArrayObj.Sortieren(AkleinerB:VergleichsFunktion);
BEGIN
  Trivial_Sort(AkleinerB);
END;

PROCEDURE DynArrayObj.Trivial_Sort(AkleinerB:VergleichsFunktion);
VAR Loch,such:word;
    temp:pointer;
BEGIN
  for Loch:=2 to anzahl do begin
    temp:=p^[Loch];
    such:=1;
    while (such<Loch) and (AkleinerB(temp,p^[such])=1) do inc(such);
    if Loch<>such then begin
      move(p^[such],p^[such+1],sizeof(pointer)*(Loch-such));
      p^[such]:=temp;
    end;
  end;
END;

PROCEDURE DynArrayObj.Merge_Sort(AkleinerB:VergleichsFunktion);

 FUNCTION Merge(VAR run1,run2:DynArrayObj):PDynArrayObj;
 VAR w:word;
     ende:boolean;
     dap:PDynArrayObj;
     welcher:boolean;
     arr:array[boolean] of record
                             pos:word;
                             dp:pointer;
                             ap:PDynArrayObj;
                           end;
  Function AddPos:word;
  begin AddPos:=arr[true].pos+arr[false].pos; end;
 BEGIN
   new(dap);
   arr[true] .ap:=@run1;
   arr[false].ap:=@run2;
   for welcher:=false to true do with arr[welcher] do begin
     pos:=ap^.anzahl;
     dp:=ap^.p^[pos];
   end;
   dap^.Init;
   dap^.Erweiterung(AddPos);
   repeat
     ende:=(arr[true].pos=0) or (arr[false].pos=0);
     if not ende then with arr[(AkleinerB(arr[true].dp,arr[false].dp)=-1)] do begin
       dap^.p^[AddPos]:=dp;
       dec(pos);
       if pos<>0 then dp:=p^[pos];
     end;
   until ende;
   run1.done;
   run2.done;
   Merge:=dap;
 END;

TYPE boolarrtyp=Array [1..16000] of boolean;
VAR bap:^boolarrtyp;
    b:boolean;
    anz,v,w:word;
    temp:DynArrayObj;
    dap:^DynArrayObj;
    altanzahl:word;
CONST minmergesort=10000;
BEGIN
  if anzahl<minmergesort then Trivial_Sort(AkleinerB) else begin
    altanzahl:=anzahl;
    getmem(bap,anzahl);
    anz:=1;
    for w:=1 to anzahl-1 do begin
      b:=(AkleinerB(p^[w],p^[w+1])=-1);
      bap^[w]:=b;
      if not b then inc(anz);
    end;
    if anz=1 then exit;
    temp.init;
    temp.Erweiterung(anz);
    w:=1;
    v:=1;
    for anz:=1 to anz do begin
      while (bap^[v]) and (v<anzahl) do inc(v);
      new(dap);
      dap^.Init;
      dap^.Erweiterung(v-w+1);
      move(p^[w],dap^.p^[1],dap^.anzahl);
      temp.p^[anz]:=dap;
      inc(v);
      w:=v;
    end;
    repeat
      Init;
      Erweiterung((temp.anzahl+1) div 2);
      for w:=1 to (temp.anzahl div 2) do begin
        v:=w*2;
        p^[w]:=Merge(Pdynarrayobj(temp.p^[v-1])^,Pdynarrayobj(temp.p^[v])^);
      end;
      if w*2<temp.anzahl then p^[anzahl]:=temp.p^[w*2+1];
      temp.done;
      temp.p:=p;           p:=nil;
      temp.anzahl:=anzahl; anzahl:=0;
    until temp.anzahl=1;
    dap:=temp.p^[1];
    p:=dap^.p;
    anzahl:=dap^.anzahl;
    dispose(dap);
    if altanzahl<>anzahl then runerror;
  end;
END;

{************************************* QSort *****************************}

Function DynArrayObj.Qsort_Partition(i,j:word; pivot:pointer):word;
var r,l:integer;
    tausch:pointer;
begin
    l:=i;
    r:=j;
    while l<=r do begin
      if QSort_Vergleich(p^[l],pivot)=1
        then inc(l)
        else if QSort_Vergleich(pivot,p^[r])=1
          then dec(r)
          else begin
            tausch:=p^[l];
            p^[l]:=p^[r];
            p^[r]:=tausch;
            inc(l);
            dec(r);
          end;
    end;
    Qsort_partition:=l;
end;

Procedure DynArrayObj.qsort_findpivot(i2,j2:word);
var k:integer;
begin
    qsort_pivotindex:=-1;
    k:=i2;
    while (k<=j2) and (qsort_pivotindex=-1) do case QSort_Vergleich(p^[k],p^[i2]) of
       1:qsort_pivotindex:=k;
      -1:qsort_pivotindex:=i2;
       0:inc(k);
    end;
end;

Procedure DynArrayObj.qsort_rekursiv(i,j:word);
var k:integer;
begin
    qsort_findpivot(i,j);
    if qsort_pivotindex<>-1 then begin
       k:=qsort_partition(i,j,p^[qsort_pivotindex]);
       qsort_rekursiv(i,k-1);
       qsort_rekursiv(k,j);
    end;
end;

PROCEDURE DynArrayObj.QSort(AkleinerB:VergleichsFunktion);
BEGIN
  QSort_Vergleich:=AkleinerB;
  qsort_rekursiv(1,anzahl);
END;

TYPE ABoolean=Array [1..$3FFF] of boolean;

PROCEDURE DynArrayObj.Filter(ff:FilterFunction);
VAR bap:^ABoolean;
    b:boolean;
    w,neuanzahl,i:word;
    neup:PdynPointerArray;
BEGIN
  if anzahl=0 then exit;
  getmem(bap,anzahl);
  neuanzahl:=0;
  for w:=1 to anzahl do begin
    b:=ff(p^[w]);
    if b then inc(neuanzahl);
    bap^[w]:=b;
  end;
  if NeuAnzahl=0 then free else if anzahl<>neuanzahl then begin
    getmem(neup,neuanzahl*sizeof(pointer));
    i:=0;
    for w:=1 to anzahl do if bap^[w] then begin
      inc(i);
      neup^[i]:=p^[w];
    end;
    if i<>neuanzahl then runerror;
    freemem(p,anzahl*sizeof(pointer));
    p:=neup;
  end;
  freemem(bap,anzahl);
  anzahl:=neuanzahl;
END;

PROCEDURE DynArrayObj.FilterCopy(von:DynArrayObj; ff:FilterFunction);
VAR bap:^ABoolean;
    b:boolean;
    w,neuanzahl,i:word;
    neup:PdynPointerArray;
    LastOld:word;
BEGIN
  if von.anzahl=0 then exit;
  getmem(bap,von.anzahl);
  neuanzahl:=0;
  for w:=1 to von.anzahl do begin
    b:=ff(von.p^[w]);
    if b then inc(neuanzahl);
    bap^[w]:=b;
  end;
  if NeuAnzahl<>0 then begin
    i:=self.anzahl;
    self.Erweiterung(neuanzahl);
    for w:=1 to von.anzahl do if bap^[w] then begin
      inc(i);
      self.p^[i]:=von.p^[w];
    end;
  end;
  freemem(bap,von.anzahl);
END;

PROCEDURE DynArrayObj.Free;
BEGIN
  if Anzahl<>0 then freemem(p,sizeof(pointer)*Anzahl);
  p:=nil;
  Anzahl:=0;
END;

DESTRUCTOR DynArrayObj.Done;
BEGIN
  Free;
END;

PROCEDURE DynArrayObj.CheckIndex(i:word);
BEGIN
  if (i<1) or (i>anzahl)
    then runerror;
END;

{********************* Typisierte dynamische Arrays *********************}

CONSTRUCTOR RecordArrayObj.init(rs:word);
BEGIN
  RecSize:=rs;
  DynArrayObj.init;
END;

PROCEDURE RecordArrayObj.Free;
VAR w:word;
BEGIN
  for w:=1 to anzahl do if p^[w]<>nil then freemem(p^[w],RecSize);
  DynArrayObj.Free
END;


CONSTRUCTOR StringArrayObj.init;
BEGIN
  DynArrayObj.init;
END;

PROCEDURE StringArrayObj.Free;
VAR w:word;
BEGIN
  for w:=1 to anzahl do if p^[w]<>nil then disposestr(pstring(p^[w]));
  DynArrayObj.Free
END;


PROCEDURE ArrayArrayObj.Free;
VAR w:word;
BEGIN
  for w:=1 to anzahl do if p^[w]<>nil then dispose(PDynArrayObj(p^[w]),done);
  DynArrayObj.Free;
END;



END.
