UNIT Win_Allg;

{$A+,B-,G+,I+,V-,X+,N+}
{$D+,L+,R+,S+}

{$C moveable preload permanent}

INTERFACE
USES strings, WinTypes, heap;

PROCEDURE InfoFenster(s:string);
PROCEDURE StopFenster(s:string);
PROCEDURE StringHexFenster(s:string);

FUNCTION String2NewPChar(const s:string):pchar;
FUNCTION String2Pchar(VAR s:string):Pchar;
FUNCTION Pchar2String(p:pchar):string;
FUNCTION String2CharArray(const s:string; var ca:array of char):word;

PROCEDURE NeuerFensterCursor(wh:Hwnd; ch:Hcursor);

FUNCTION rgb2GrayScale(rgb:TColorRef):single;

TYPE SuperString=OBJECT(PointerObj)
                   CONSTRUCTOR init(max:word);
                   DESTRUCTOR done;
                   PROCEDURE StringRein(s:string);
                   PROCEDURE PcharRein(pc:pchar);
                   FUNCTION StringRaus:string;
                   FUNCTION PcharRaus:pchar;
                 END;

CONST KeineHilfe=0;
TYPE THilfeThema=word;
PROCEDURE Hilfe(thema:THilfeThema);

TYPE TRechteck=OBJECT
                 Rechteck:TRect;
                 PROCEDURE init(start:TPoint);
                 PROCEDURE AddPoint(Punkt:TPoint);
                 PROCEDURE Vergroessern(dx,dy:integer);
               END;

TYPE PBlinkCursor=^TBlinkCursor;  {nur dynamisch erzeugen, weil dispose in exitproc}
     TBlinkCursor=OBJECT
                    CONSTRUCTOR init;
                    DESTRUCTOR done; virtual;
                    PROCEDURE CursorDazu(c:hCursor);
                    PROCEDURE LoadCursorDazu(name:pchar);
                    PROCEDURE Start;
                    PROCEDURE Stop;
                    PROCEDURE Blink;
                  PRIVATE
                    Alt:hCursor;
                    Arr:TDynArray;
                    Index:word;
                    next:PBlinkCursor;
                    FUNCTION DoSetCursor:hCursor;
                  END;

TYPE TPCharArray=OBJECT(DynArrayObj)
                   PROCEDURE Free; virtual;
                   PROCEDURE AppendString(const s:string);
                   PROCEDURE KillElement(w:word);  virtual;
                   PROCEDURE ImportFromMultiLine(cp:pchar);
                   FUNCTION ExportToMultiLine:pchar;
                   FUNCTION GetPChar(w:word):pchar;
                 END;

FUNCTION GetWinExecFehlerString(fehler:word):pchar;


IMPLEMENTATION
USES WinProcs, grund, ProgExit;

PROCEDURE StopFenster(s:string);
BEGIN
  if MessageBox(0, String2Pchar(s),'so geht''s nicht',mb_OKcancel+mb_IconStop+mb_SystemModal)=id_cancel then halt;;
END;

PROCEDURE InfoFenster(s:string);
BEGIN
  if MessageBox(0, String2Pchar(s),'Info',mb_OKcancel+mb_IconInformation+mb_SystemModal)=id_cancel then halt;
END;

PROCEDURE StringHexFenster(s:string);
VAR arr:Array [0..800] of char;
    w:word;
    temp:string[2];
BEGIN
  fillchar(arr,sizeof(arr),' ');
  for w:=1 to length(s) do  begin
    temp:=byte2hex(byte(s[w]));
    if length(temp)<>2 then runerror;
    arr[w*3]:=temp[1];
    arr[w*3+1]:=temp[2];
  end;
  arr[w*3+2]:=#0;
  messagebox(0,arr,string2pchar(s),mb_ok);
END;


{Achtung: String mu berlnge haben!!!}
FUNCTION String2Pchar(VAR s:string):Pchar;
BEGIN
  if length(s)>=high(s)
  then runerror; {manueller range-check bei open array}
  s[length(s)+1]:=#0;
  String2Pchar:=@s[1];
END;

FUNCTION String2newPChar(const s:string):pchar;
VAR p:pchar;
BEGIN
  getmem(p, length(s)+1);
  StrLCopy(p, @s[1], length(s));
  String2NewPChar:=p;
END;

FUNCTION Pchar2String(p:pchar):string;
VAR s:string;
    laenge:word;
BEGIN
  if p=nil then Pchar2String:='' else begin
    laenge:=StrLen(p);
    if laenge>255 then runerror;
    s[0]:=char(laenge);
    move(p^,s[1],laenge);
    Pchar2String:=s;
  end;
END;

FUNCTION String2CharArray(const s:string; var ca:array of char):word;
VAR anz:word;
BEGIN
  if low(ca)<>0 then runerror;
  fillchar(ca,high(ca)+1,#0);
  anz:=high(ca);
  if length(s)<anz then anz:=length(s);
  move(s[1],ca,anz);
  String2CharArray:=anz;
END;

PROCEDURE NeuerFensterCursor(wh:Hwnd; ch:Hcursor);
VAR Punkt:TPoint;
BEGIN
  SetClassWord(wh, gcw_hCursor, ch);
  GetCursorPos(Punkt);
  SetCursorPos(Punkt.X, Punkt.Y);
END;



CONSTRUCTOR SuperString.init(max:word);
BEGIN
  if max>254 then runerror;
  get(max+1);
  StringRein('');
END;

DESTRUCTOR SuperString.done;
BEGIN
  free;
END;

PROCEDURE SuperString.StringRein(s:string);
BEGIN
  if length(s)+1>reserviert then runerror;
  pstring(p)^:=s;
  pstring(p)^[length(s)+1]:=#0;
END;

PROCEDURE SuperString.PcharRein(pc:pchar);
BEGIN
  if StrLen(pc)>254 then runerror;;
  StringRein(pchar2string(pc));
END;

FUNCTION SuperString.StringRaus:string;
BEGIN
  StringRaus:=pstring(p)^;
END;

FUNCTION SuperString.pcharRaus:pchar;
BEGIN
  PcharRaus:=@pstring(p)^[1];
END;


FUNCTION rgb2GrayScale(rgb:TColorRef):single;
TYPE rrgb=record r,g,b,dummy:byte; end;
VAR value:single;
BEGIN
  with rrgb(rgb) do begin
    value:=(r*3 + g*5 + b*2)
           /(3+5+2)
           /$FF;
  end;
  if (value<0) or (value>1) then runerror;
  rgb2GrayScale:=value;
END;

PROCEDURE Hilfe(thema:THilfeThema);
BEGIN
  if not (thema=KeineHilfe) then runerror;  {bis ich weiss, wie es funktionuckelt}
  if thema=KeineHilfe then Messagebox(0, 'Hier gibt es noch keine Hilfe, '+
                                         'schreib doch selber ''ne Hilfedatei!'+cr+cr+
                                         'Das ist ernst gemeint, ich suche Leute, die eine Hilfedatei schreiben, '+
                                         'weil ich selber in nchster Zeit nicht dazu kommen werde, '+
                                         'eine zu schreiben (mu noch viele wichtige features einbauen...)!',
                                         'Hilfe? Hihihi...', mb_ok+mb_TaskModal);
END;

{************************************* Rechteck ****************************************}

PROCEDURE TRechteck.init(start:TPoint);
BEGIN
  with Rechteck do begin
    top:=start.y;
    bottom:=start.y;
    left:=start.x;
    right:=start.x;
  end;
END;

PROCEDURE TRechteck.AddPoint(Punkt:TPoint);

 Procedure Streck(soll:integer; VAR ist_min,ist_max:integer);
 Begin
   if soll>ist_max then ist_max:=soll
   else if soll<ist_min then ist_min:=soll;
 End;

BEGIN
  Streck(Punkt.x, Rechteck.left, Rechteck.right);
  Streck(Punkt.y, Rechteck.top,  Rechteck.bottom);
END;

PROCEDURE TRechteck.Vergroessern(dx,dy:integer);
BEGIN
  with Rechteck do begin
    dec(top,dy);
    inc(bottom,dy);
    dec(left,dx);
    inc(right,dx);
  end;
END;

{********************************** BlinkCursor ******************************************}

CONST BlinkCursorRoot:PBlinkCursor=nil;

CONSTRUCTOR TBlinkCursor.init;
BEGIN
  next:=BlinkCursorRoot;
  BlinkCursorRoot:=@self;
  Arr.init;
END;

DESTRUCTOR TBlinkCursor.done;
VAR w:word;
BEGIN
  for w:=1 to arr.anzahl do DestroyCursor(longint(arr.p^[w]));
  arr.done;
END;

PROCEDURE TBlinkCursor.CursorDazu(c:hCursor);
BEGIN
  arr.append(pointer(c));
END;

PROCEDURE TBlinkCursor.LoadCursorDazu(name:pchar);
BEGIN
  CursorDazu(LoadCursor(hinstance,name));
END;

PROCEDURE TBlinkCursor.Start;
BEGIN
  if Arr.anzahl<2 then runerror;
  Index:=1;
  alt:=DoSetCursor;
END;

PROCEDURE TBlinkCursor.Stop;
BEGIN
  SetCursor(alt);
END;

PROCEDURE TBlinkCursor.Blink;
BEGIN
  inc(Index);
  if Index>Arr.Anzahl then Index:=1;
  DoSetCursor;
END;

FUNCTION TBlinkCursor.DoSetCursor:hCursor;
BEGIN
  DoSetCursor:=SetCursor(longint(Arr.p^[Index]));
END;

{********************************* pchar-array *****************************}

PROCEDURE TPCharArray.Free;
VAR w:word;
BEGIN
  for w:=1 to Anzahl do KillElement(w);
  inherited Free;
END;

PROCEDURE TPCharArray.KillElement(w:word);
VAR cpp:^pointer;
BEGIN
  cpp:=@(p^[w]);
  Strings.StrDispose(cpp^);
  cpp^:=nil;
END;

PROCEDURE TPCharArray.AppendString(const s:string);
VAR temp:array [0..255] of char;
BEGIN
  string2chararray(s,temp);
  append(strings.strnew(temp));
END;

CONST ZeilenEnde:array [0..2] of char = (cr,lf,#0);
PROCEDURE TPCharArray.ImportFromMultiLine(cp:pchar);
VAR w:word;
    lauf:pchar;
    ende:pchar;

{    s:string; }
BEGIN
  Free;
  if cp=nil then exit;
{  s:=zahlstr(strlen(cp),1)+#0;
  messagebox(0, cp, @s[1], mb_OK or mb_taskmodal); }
  lauf:=cp;
  w:=1;
  repeat
    ende:=StrPos(lauf,ZeilenEnde);
    if ende<>nil then begin
      inc(w);
      lauf:=ende+2;
    end;
  until ende=nil;
  Erweiterung(w);
  lauf:=cp;
  w:=1;
  repeat
    ende:=StrPos(lauf,ZeilenEnde);
    if ende<>nil then ende^:=#0;
    p^[w]:=strnew(lauf);
    if ende<>nil then begin
      ende^:=cr;
      inc(w);
      lauf:=ende+2;
    end;
  until ende=nil;
  if w<>anzahl then runerror;
END;

FUNCTION TPCharArray.ExportToMultiLine:pchar;
VAR w,anz:word;
    cp:pchar;
    merk:pchar;
BEGIN
  anz:=0;
  for w:=1 to anzahl do if (p^[w]<>nil) then inc(anz,strlen(p^[w]));
  inc(anz, (anzahl-1)*2);

  GetMem(cp, anz+1);
  merk:=cp;
  ExportToMultiLine:=cp;
  for w:=1 to anzahl do begin
    if p^[w]<>nil then cp:=StrECopy(cp, p^[w]);
    if w=anzahl then cp^:=#0
                else cp:=StrECopy(cp, ZeilenEnde);
  end;
  if cp<>merk+anz then runerror;
END;

FUNCTION TPCharArray.GetPChar(w:word):pchar;
BEGIN
  if (w<1) or (w>anzahl) then runerror;
  GetPChar:=p^[w];
END;

FUNCTION GetWinExecFehlerString(fehler:word):pchar;
VAR Buffer:string;
    p:pchar;
BEGIN
  case fehler of
     0:p:='Zu wenig freier Speicher, ausfhrbare Datei beschdigt, oder ungltige Relokationen';
     2:p:='Datei nicht gefunden';
     3:p:='Pfand nicht gefunden';
     5:p:='Versuch, eine Task dynamisch einzubinden, oder ein Share- oder Netzwerk-Fehler';
     6:p:='Bibliothek bentigt getrennte Dtensegmente fr jede Task';
     8:p:='Zu wenig Speicher, um die Anwendung zu starten';
    10:p:='Falsche Windows-Version.';
    11:p:='Ungltige EXE-Datei';
    12:p:='Anwendung ist fr ein anderes Betriebssystem';
    13:p:='DOS 4.0 Anwendung';
    14:p:='Unbekannter EXE-Typ';
    15:p:='Anwendung ist fr eine frhere Windows-Version';
    16:p:='Versuch, eine EXE-Datei zu laden, die mehrere beschreibbare Datensegmente enthlt.';
    19:p:='Versuch, eine komprimierte EXE-Datei zu laden.';
    20:p:='Eine der fr diese Anwendung bentigten DLLs ist defenkt';
    21:p:='Anwendung bentigt 32-Bit-Erweiterungen';
    else begin
         Buffer:='Undokumentierter Fehler #'+zahlstr(fehler,1)+#0;
         p:=@Buffer[1];
       end;
  end;
  GetWinExecFehlerString:=p;
END;

{*********************************** exitproc ******************************}

PROCEDURE Win_Allg_Done; FAR;
VAR l:PBlinkCursor;
BEGIN
  l:=BlinkCursorRoot;
  while l<>nil do begin
    BlinkCursorRoot:=l^.next;
    dispose(l,done);
    l:=BlinkCursorRoot;
  end;
END;

BEGIN
  RegisterExitProc(Win_Allg_Done);
END.
