{Projekt: FAHRPLAN

 Autor: Stefan Bormann 94

 Inhalt: Der Objekttyp TBahnhof enthlt alle Daten, die einen Datensatz in der
         Datenbank ausmachen.
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT AbsBfDat;

INTERFACE
USES BfDef, heap;

TYPE PBahnhof=^TBahnhof;
     TBahnhof=OBJECT
       Daten:RBahnhofsDaten;
       CONSTRUCTOR init;
       DESTRUCTOR done; virtual;
       PROCEDURE Free;  virtual;

       FUNCTION AppendGleis(const bez:string; nl:word):PGleisDaten;
       FUNCTION GetGleis(Gleis:hGleis):PGleisDaten;
       FUNCTION AnzahlGleise:word;
       PROCEDURE KillGleise;

       PROCEDURE SetInfo(p:pchar);
       FUNCTION GetInfo:pchar;

       PROCEDURE KurznameSicherstellen;
     PRIVATE
       Info:pchar;
       Gleise:TRecordArray;
       PROCEDURE FreeInfo;
     END;


IMPLEMENTATION
USES Strings;

PROCEDURE TBahnhof.KurznameSicherstellen;
BEGIN
  with Daten do if KurzName='' then KurzName:=CreateKurzname(Name);
END;


CONSTRUCTOR TBahnhof.init;
BEGIN
  Info:=nil;
  Gleise.init(sizeof(RGleisDaten));
  with Daten do begin
    Name:='';
    KurzName:='';
    Eigner:='';
    Strecken:=2;
    ReglerFarben:=5;
  end;
END;

DESTRUCTOR TBahnhof.done;
BEGIN
  Free;
  Gleise.done;
END;

PROCEDURE TBahnhof.Free;
BEGIN
  FreeInfo;
  Gleise.Free;
END;

FUNCTION TBahnhof.GetGleis(Gleis:hGleis):PGleisDaten;
BEGIN
  if (Gleis<1) or (Gleis>Gleise.anzahl) then runerror;
  GetGleis:=Gleise.p^[Gleis];
END;

FUNCTION TBahnhof.AppendGleis(const bez:string; nl:word):PGleisDaten;
VAR glp:PGleisDaten;
BEGIN
  new(glp);
  with glp^ do begin
    Bezeichnung:=bez;
    NutzLaenge:=nl;
  end;
  Gleise.append(glp);
  AppendGleis:=glp;
END;

FUNCTION TBahnhof.AnzahlGleise:word;
BEGIN
  AnzahlGleise:=Gleise.anzahl;
END;

PROCEDURE TBahnhof.KillGleise;
BEGIN
  Gleise.Free;
END;


PROCEDURE TBahnhof.SetInfo(p:pchar);
BEGIN
  FreeInfo;
  Info:=p;
END;

FUNCTION TBahnhof.GetInfo:pchar;
BEGIN
  GetInfo:=Info;
END;

PROCEDURE TBahnhof.FreeInfo;
BEGIN
  if Info<>nil then StrDispose(Info);
  Info:=nil;
END;


END.
