{Modulzweck: allgemein verwendbares Modul

 Autor: Stefan Bormann 94

 Inhalt: Mehrere abstrakte Fensterobjekte
         bzw. spezialisierte Kontrollfensterobjekte
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Base_Wnd;

INTERFACE
USES oWindows, oDialogs, WinTypes;

TYPE PNumericEdit=^TNumericEdit;
     TNumericEdit=OBJECT(TEdit)
                    constructor Init(AParent: PWindowsObject; AnId, X, Y, W, H: Integer;
                                     AMin, AMax: Integer; Digits: Integer);
                    constructor InitResource(AParent: PWindowsObject; Id: Integer;
                                             AMin, AMax: Integer; Digits: Integer);
                    function CanClose: Boolean;           virtual;
                    function GetValue(var Value: Integer): Boolean;
                    procedure SetRange(AMin, AMax: Integer);
                    procedure SetValue(Value: Integer);
                    procedure WMChar(var Msg: TMessage);  virtual wm_First + wm_Char;
                  PRIVATE
                    Min, Max: LongInt;
                  END;

FUNCTION ZahlEingabe(parent:PWindowsObject; caption,prompt:pchar; VAR edit:longint; min,max:longint):word;

TYPE TSetupProc=PROCEDURE(h:Hwnd);
FUNCTION ExecuteSetupDialog(parent:PwindowsObject; resource:pchar; MachSetup:TSetupProc):word;


IMPLEMENTATION
USES WinProcs, oStdDlgs, win_allg, grund;

{********************************* NumericEdit *****************************}

constructor TNumericEdit.Init(AParent:PWindowsObject; AnId, X, Y, W, H: Integer;
                              AMin, AMax: Integer; Digits: Integer);
begin
  inherited Init(AParent, AnId, '', X, Y, W, H, Digits + 1, False);
  Min := AMin;
  Max := AMax;
end;

constructor TNumericEdit.InitResource(AParent: PWindowsObject; Id: Integer;
                                      AMin, AMax: Integer; Digits: Integer);
begin
  inherited InitResource(AParent, Id, Digits + 1);
  Min := AMin;
  Max := AMax;
end;

function TNumericEdit.CanClose: Boolean;
var Value: Integer;
    Valid: Boolean;
    Text: array[0..255] of Char;
    P: array[0..1] of LongInt;
begin
  Valid:=not IsWindowEnabled(HWindow) or
         (GetValue(Value) and (Value >= Min) and (Value <= Max));
  if not Valid then begin
    P[0] := Min;
    P[1] := Max;
    WVSPrintF(Text, 'Wert ist nicht im gltigen Wertebereich (%ld..%ld).', P);
    MessageBox(HWindow, Text, 'Ungltiger numerischer Wert', mb_IconStop or mb_Ok);
    SetSelection(0, MaxInt);
    SetFocus(HWindow);
  end;
  CanClose := Valid;
end;

function TNumericEdit.GetValue(var Value: Integer): Boolean;
var Text: array[0..255] of Char;
    Code: Integer;
    l:longint;
    ok:boolean;
begin
  GetText(Text, high(Text));
  Val(Text, l, Code);
  ok:= (Code=0) and (l>=$FFFF8000) and (l<=$7FFF);
  if ok then value:=l;
  GetValue:=ok;
end;

procedure TNumericEdit.SetRange(AMin, AMax: Integer);
begin
  Min := AMin;
  Max := AMax;
end;

procedure TNumericEdit.SetValue(Value: Integer);
var Text: array[0..20] of Char;
begin
  Str(Value, Text);
  SetText(Text);
end;

procedure TNumericEdit.WMChar(var Msg: TMessage);  {???????}
begin
  if not (Char(Msg.wParamLo) in ['A'..'Z','a'..'z',',','.','<','>',
    '/','?','~','`','!','@','#','$','%','^','&','*','(',')','_','=',
    '{','}','[',']','|','\',';',':','"']) then
    DefWndProc(Msg)
  else MessageBeep(0);
end;


TYPE TZahlEingabe=OBJECT(TInputDialog)
                    zahl:longint;
                    min,max:longint;
                    FUNCTION CanClose:boolean; virtual;
                  END;

FUNCTION TZahlEingabe.CanClose:boolean;
VAR k:integer;
    temp:boolean;
BEGIN
  temp:=TInputDialog.canclose;
  val(Pchar2String(Buffer), zahl, k);
  CanClose:=false;
  if k<>0 then StopFenster('Eingabe mu ein ganzzahliger numerischer Wert sein!!!')
    else if (zahl>max) or (zahl<min) then StopFenster('Eingabe mu zwischen '+zahlstr(min,1)+' und '+zahlstr(max,1)+' liegen!')
      else CanClose:=true;
END;

FUNCTION ZahlEingabe(parent:PWindowsObject; caption,prompt:pchar; VAR edit:longint; min,max:longint):word;
VAR dlg:TZahlEingabe;
    Buffer:array [0..12] of char;
    erg:word;
BEGIN
  str(edit,Buffer);
  dlg.init(parent,caption,prompt,Buffer,11);
  dlg.min:=min;
  dlg.max:=max;
  erg:=dlg.execute;
  if erg=id_ok then edit:=dlg.zahl;
  dlg.done;
  ZahlEingabe:=erg;
END;

TYPE TSetupDialog=OBJECT(TDialog)
                    proc:TSetupProc;
                    PROCEDURE SetupWindow; virtual;
                  END;

PROCEDURE TSetupDialog.SetupWindow;
BEGIN
  inherited SetupWindow;
  proc(hwindow);
END;

FUNCTION ExecuteSetupDialog(parent:PwindowsObject; resource:pchar; MachSetup:TSetupProc):word;
VAR dlg:TSetupDialog;
BEGIN
  dlg.proc:=MachSetup;
  dlg.init(parent,resource);
  ExecuteSetupDialog:=dlg.execute;
  dlg.done;
END;

END.
