{Projekt: BfBrowse

 Autor: Stefan Bormann 95

 Inhalt: Hauptmodul von BFBROWSE.EXE
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


PROGRAM BfBrowse;
USES WinTypes, WinProcs, oWindows, oDialogs, SDI, xdiTools, heap, Strings, WinDOS, Win_Allg,
     BfDef, uBahnhof, Group, Bf_Allg, BrBfDat;

{$R BfBrowse.RES}
{$I Version.INC}

CONST cm_neu =101;
      cm_open=102;
      cm_refresh=103;
      cm_add=201;
      cm_del=202;
      cm_edit=203;
      cm_about=301;
      cm_statusbahnhof=302;
      cm_HelpBfBrowse=401;
      cm_HelpIndex=402;
      cm_Up=501;
      cm_Down=502;
      id_listbox=42;
      wm_UserAddBf=wm_user+1;

      LoeschenBestaetigen=true;

TYPE PFenster=^TFenster;
     TFenster=OBJECT(TNewSDIWindow)
                ListBox:PListBox;
                InfoGroup:PInfoGroup;
                FilenameStatic:PStatic;
                BahnhofsArray:TDynArray;
                CONSTRUCTOR init;
                DESTRUCTOR done;                                  virtual;
                FUNCTION GetClassName:pchar;                      virtual;
                PROCEDURE GetWindowClass(VAR TheClass:TWndClass); virtual;
                PROCEDURE SetupWindow;                            virtual;
                FUNCTION CanClose:boolean;                        virtual;
                FUNCTION GetMenueBeschreibung(cm:word):pchar;     virtual;
                PROCEDURE SizeClient(x,y,w,h:integer);            virtual;
                PROCEDURE IDListbox(VAR Msg:TMessage);            virtual id_first+id_Listbox;
                PROCEDURE CMNeu    (VAR Msg:TMessage);            virtual cm_first+cm_neu;
                PROCEDURE CMOpen   (VAR Msg:TMessage);            virtual cm_first+cm_open;
                PROCEDURE CMRefresh(VAR Msg:TMessage);            virtual cm_first+cm_refresh;
                PROCEDURE CMAbout  (VAR Msg:TMessage);            virtual cm_first+cm_about;
                PROCEDURE CMAdd    (VAR Msg:TMessage);            virtual cm_first+cm_add;
                PROCEDURE CMDel    (VAR Msg:TMessage);            virtual cm_first+cm_del;
                PROCEDURE CMEdit   (VAR Msg:Tmessage);            virtual cm_first+cm_edit;
                PROCEDURE CMStatusBahnhof(VAR Msg:TMessage);      virtual cm_first+cm_statusbahnhof;
                PROCEDURE CMHelpBfBrowse (VAR Msg:TMessage);      virtual cm_first+cm_HelpBfBrowse;
                PROCEDURE CMHelpIndex    (VAR Msg:TMessage);      virtual cm_first+cm_HelpIndex;
                PROCEDURE CMUp           (VAR Msg:TMessage);      virtual cm_first+cm_Up;
                PROCEDURE CMDown         (VAR Msg:TMessage);      virtual cm_first+cm_Down;
                PROCEDURE Schliessen;
                PROCEDURE WMUserAddBf    (VAR Msg:TMessage);      virtual wm_first+wm_UserAddBf;
                PROCEDURE Aufbauen(anwaehlen:hBahnhof);
                FUNCTION ListboxPos:word;
              END;

CONSTRUCTOR TFenster.init;
CONST MaxRec=5;
      ButtArr:Array [1..maxrec] of RZeilenButtonDef=(
          (resource_n:'but_open_n';     resource_g:'but_open_g';   cm:cm_open),
          (resource_n:nil;              resource_g:nil;            cm:0),
          (resource_n:'but_plus_n';     resource_g:'but_plus_g';   cm:cm_add),
          (resource_n:'but_minus_n';    resource_g:'but_minus_g';  cm:cm_del),
          (resource_n:'but_edit_n';     resource_g:'but_edit_g';   cm:cm_edit)
      );
      ButtonZeileDef:RButtonZeileDef=(ArrPtr:pointer(@ButtArr); Anzahl:high(ButtArr));
VAR s:string;
BEGIN
  inherited init('Bahnhofs-Browser', LoadMenu(hInstance, 'BfBrowse'), ButtonZeileDef);
  with attr do begin
    w:=450;
    h:=400;
  end;
  s:='Bahnhofs-Browser '+VersionString+'  von Stefan Bormann `95'+#0;
  StatusZeile^.SetDefaultText(@s[1]);
  StatusZeile^.SetHelpText(nil);
  new(ListBox, init(@self, id_listbox, 0,0,0,0));
  with ListBox^.attr do style:=(style or lbs_NoIntegralHeight) and (not lbs_sort);
  new(InfoGroup, init(@self));
  new(FilenameStatic, init(@self, -1, nil, 0,0,0,0, fsPathname+10));
  with FilenameStatic^.attr do style:=style or ws_border;
  BahnhofsArray.init;
END;

DESTRUCTOR TFenster.done;
BEGIN
  inherited done;
  BahnhofsArray.done;
END;

FUNCTION TFenster.GetClassName:pchar;
BEGIN
  GetClassName:='BfBrowse';
END;

PROCEDURE TFenster.GetWindowClass(VAR TheClass:TWndClass);
BEGIN
  inherited GetWindowClass(TheClass);
  with TheClass do begin
    hIcon:=LoadIcon(hInstance, 'BfBrowse');
  end;
END;

PROCEDURE TFenster.SetupWindow;
VAR s:string;
BEGIN
  inherited SetupWindow;
  case paramcount of
    0:;
    1:begin
        s:=paramstr(1)+#0;
        Datenbank.OpenDirect(hWindow, @s[1]);
        if not Datenbank.IsOpen then begin
          MessageBox(hWindow, 'Die Datei, die als Kommandozeilenparameter angegeben war, '+
                              'konnte nicht geffnet werden.', 'Kommandozeilenparameter', mb_ok);
          PostQuitMessage(0);
        end;
      end;
    else begin
        MessageBox(hWindow, 'Sie haben BfBrowse mit mehr als einem Parameter aufgerufen, '+
                            'das ist nicht erlaubt!', 'Kommandozeilenparameter', mb_ok);
        PostQuitMessage(0);
      end;
  end;
  Aufbauen(0);
END;

FUNCTION TFenster.CanClose:boolean;
BEGIN
  CanClose:=true;
  Schliessen;
END;

FUNCTION TFenster.GetMenueBeschreibung(cm:word):pchar;
VAR p:pchar;
BEGIN
  case cm of
    cm_neu          :p:='Erzeugen einer neuen Bahnhofsdatenbank';
    cm_open         :p:='ffnen einer bestehenden Bahnhofsdatenbank';
    cm_refresh      :p:='Neuanzeige der Datenstze';
    cm_add          :p:='Hinzufgen eines Datensatzes (=Bahnhofs)';
    cm_del          :p:='angewhlten Datensatz (=Bahnhof) lschen';
    cm_edit         :p:='angewhlten Datensatz (=Bahnhof) bearbeiten';
    cm_about        :p:='Informationen ber Bahnhofs-Browser anzeigen';
    cm_statusbahnhof:p:='Informationen ber internen Zustand von BAHNHOF.DLL anzeigen';
    24340  :p:='Und tschss..';
    else p:=inherited GetMenueBeschreibung(cm);
  end;
  GetMenueBeschreibung:=p;
END;

PROCEDURE TFenster.SizeClient(x,y,w,h:integer);
VAR Haelfte:integer;
CONST Hoehe=25;
BEGIN
  Haelfte:=w div 2;
  movewindow(FilenameStatic^.hwindow, x+5,         y+5,       w-10,      Hoehe-5,    true);
  movewindow(listbox^.hwindow,        x+5,         y+5+Hoehe, Haelfte-8, h-10-Hoehe, true);
  movewindow(infogroup^.hwindow,      x+Haelfte+3, y+Hoehe,   Haelfte-8, h-5-Hoehe,  true);
END;

{************************************Men ************************************}

PROCEDURE TFenster.IDListBox(VAR Msg:TMessage);
VAR l:longint;
    Bahnhof:hBahnhof;
BEGIN
  l:=ListBox^.GetSelIndex;
  if (l<0) or
   (l>=BahnhofsArray.Anzahl) then exit;
  Bahnhof:=word(BahnhofsArray.p^[l+1]);
  case msg.lParamHi of
    lbn_dblclk   :begin
                    CMEdit(msg);
                  end;
    lbn_selchange:begin
                    InfoGroup^.DisplayData(Bahnhof);
                  end;
  end;
END;

PROCEDURE TFenster.CMNeu(VAR Msg:TMessage);
BEGIN
  Schliessen;
  Datenbank.CreateDialog(hWindow);
  Aufbauen(0);
END;

PROCEDURE TFenster.CMOpen(VAR Msg:TMessage);
BEGIN
  Schliessen;
  Datenbank.OpenDialog(hWindow);
  Aufbauen(0);
END;

PROCEDURE TFenster.CMRefresh(VAR Msg:TMessage);
BEGIN
  Aufbauen(0);
END;


PROCEDURE TFenster.CMAdd(VAR Msg:TMessage);
BEGIN
  Aufbauen(BfNeu(@self));
END;

PROCEDURE TFenster.CMDel(VAR Msg:TMessage);
VAR s:string;
    nr:word;
    h:hBahnhof;
    Daten:RBahnhofsDaten;
BEGIN
  nr:=ListboxPos;
  if nr<>0 then begin
    h:=word(BahnhofsArray.p^[nr]);
    if Datenbank.GetData(h,@Daten)=keinFehler then begin
      s:='Bahnhof "'+Daten.Name+'" wirklich lschen???'+#0;
      if not LoeschenBestaetigen or (Messagebox(hWindow, @s[1], 'Echt jetzt?', mb_YesNo or mb_IconQuestion)=id_Yes)
      then begin
        if (Datenbank.BahnhofLoeschen(h)<>keinFehler) then InternerFehler('Loeschen fehlgeschlagen in CMDel');
        Aufbauen(0);
      end;
    end else InternerFehler('Datensatz verschwunden in CMDel');
  end;
END;

PROCEDURE TFenster.CMEdit(VAR Msg:TMessage);
VAR nr:word;
    h:hBahnhof;
BEGIN
  nr:=ListboxPos;
  if nr<>0 then begin
    h:=word(BahnhofsArray.p^[nr]);
    BfEdit(@self, h);
    Aufbauen(h);
  end;
END;


TYPE TAboutDlg=OBJECT(TDialog)
                 PROCEDURE SetupWindow; virtual;
               END;

PROCEDURE TAboutDlg.SetupWindow;
BEGIN
  inherited SetupWindow;
  SetWindowText(GetDlgItem(hWindow, 101), VersionString);
END;

PROCEDURE TFenster.CMAbout(VAR Msg:TMessage);
VAR dlg:TAboutDlg;
BEGIN
  dlg.init(@self, 'InfoBfBrowse');
  dlg.execute;
  dlg.done;
END;

PROCEDURE TFenster.CMStatusBahnhof(VAR Msg:TMessage);
BEGIN
  Bf_ExecuteStatusDialog(hWindow);
END;


PROCEDURE TFenster.CMHelpBfBrowse(VAR Msg:TMessage);
BEGIN
  Hilfe(keineHilfe);
END;

PROCEDURE TFenster.CMHelpIndex(VAR Msg:TMessage);
BEGIN
  Hilfe(keineHilfe);
END;


PROCEDURE TFenster.CMUp(VAR Msg:TMessage);
VAR w:word;
BEGIN
  w:=ListboxPos;
  if w=0
    then w:=1
    else if w=1
           then exit {oberer Rand}
           else dec(w);
  Listbox^.SetSelIndex(w-1);
  InfoGroup^.DisplayData(word(BahnhofsArray.p^[w]));
END;

PROCEDURE TFenster.CMDown(VAR Msg:TMessage);
VAR w:word;
BEGIN
  w:=ListboxPos;
  if (w=0)
    then w:=1
    else if w=BahnhofsArray.Anzahl
           then exit  {unterer Rand}
           else inc(w);
  Listbox^.SetSelIndex(w-1);
  InfoGroup^.DisplayData(word(BahnhofsArray.p^[w]));
END;

{********************************** Tools ************************************}

PROCEDURE TFenster.Schliessen;
BEGIN
  if not Datenbank.IsOpen then exit;
  if not Datenbank.Close then InternerFehler('Schliessen');
  Aufbauen(0);
END;


 FUNCTION Alphabetisch(a,b:pointer):SignTyp; FAR;
 VAR ha,hb:hBahnhof;
     da,db:RBahnhofsDaten;
 BEGIN
   ha:=word(a);
   hb:=word(b);
   Datenbank.GetData(ha,@da);
   Datenbank.GetData(hb,@db);
   Alphabetisch:=StringVergleich(da.Name, db.Name);
 END;

 PROCEDURE AufbauProc(Bahnhof:hBahnhof); FAR;
 BEGIN
   SendMessage(Application^.MainWindow^.hWindow, wm_UserAddBf, Bahnhof, 0);
 END;

 PROCEDURE TFenster.WMUserAddBf(VAR Msg:TMessage);
 BEGIN
   BahnhofsArray.Append(pointer(Msg.wParam));
 END;

PROCEDURE TFenster.Aufbauen(anwaehlen:hBahnhof);
VAR puffer:array [0..fsPathName+7] of char;
    w:word;
    ItIsOpen:boolean;
    ShowWhat:word;
    EnableWhat:word;
    m:hMenu;
    Daten:RBahnhofsDaten;
    ca:array [0..high(Daten.Name)+1] of char;
    MerkPos:word;  {anzuwaehlende Position}
    Bahnhof:hBahnhof;
BEGIN
{Aufraeumen}
  BahnhofsArray.free;
  Listbox^.ClearList;
  ItIsOpen:=Datenbank.IsOpen;
  if ItIsOpen then begin
  {Array fuellen}
    if (Datenbank.Aufzaehlung(AufbauProc)<>keinFehler) then InternerFehler('Aufbauen');
    StrCopy(puffer, 'Datei: ');
    Datenbank.GetFilename(StrEnd(Puffer), fsPathName);
    BahnhofsArray.Sortieren(Alphabetisch);
  {Listbox fuellen}
    MerkPos:=0;
    for w:=1 to BahnhofsArray.anzahl do begin
      Bahnhof:=word(BahnhofsArray.p^[w]);
      if Datenbank.GetData(Bahnhof, @Daten)<>keinFehler then runerror;
      StrPCopy(ca,Daten.name);
      ListBox^.AddString(ca);
      if Bahnhof=anwaehlen then MerkPos:=w;
    end;
    if MerkPos<>0 then ListBox^.SetSelIndex(MerkPos-1);
  end else StrCopy(puffer, '     ---- keine Datei geffnet ----');
{static vollmalen}
  FilenameStatic^.SetText(puffer);
  InfoGroup^.DisplayData(anwaehlen);
{Buttons hiden/zeigen}
  if ItIsOpen then ShowWhat:=sw_show
              else ShowWhat:=sw_hide;
  ButtonZeile^.cm2button(cm_add)^ .Show(ShowWhat);
  ButtonZeile^.cm2button(cm_del)^ .Show(ShowWhat);
  ButtonZeile^.cm2button(cm_edit)^.Show(ShowWhat);
{Menueeintraege gray/nich gray}
  m:=GetMenu(hwindow);
  if itisopen then EnableWhat:=mf_enabled
              else EnableWhat:=mf_grayed;
  EnableMenuItem(m, cm_add, EnableWhat);
  EnableMenuItem(m, cm_del, EnableWhat);
  EnableMenuItem(m, cm_edit,EnableWhat);
END;

FUNCTION TFenster.ListboxPos:word;
VAR l:longint;
BEGIN
  l:=ListBox^.GetSelIndex;
  if (l>=0) and (l<BahnhofsArray.anzahl) then ListboxPos:=l+1
                                         else ListboxPos:=0;
END;

{******************************** Applicaiton ********************************}

TYPE TApp=OBJECT(TApplication)
            PROCEDURE InitMainWindow; virtual;
            PROCEDURE InitInstance;   virtual;
          END;

PROCEDURE TApp.InitMainWindow;
BEGIN
  MainWindow:=new(PFenster, init);
END;

PROCEDURE TApp.InitInstance;
BEGIN
  inherited InitInstance;
  HAccTable:=LoadAccelerators(HInstance, 'BfBrowse');
END;

VAR App:TApp;

BEGIN
  App.init('BahnhofsBrowser');
  App.run;
  App.done;
END.
