{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 94

 Inhalt: Datenstrukturen, die von BAHNHOF.DLL exportiert werden.
}

{$A+,B-,G+,I+,V-,X-}

UNIT BfDef;

{$C moveable preload permanent}

INTERFACE

CONST maxGleisBezeichnung=37;

TYPE PGleisDaten=^RGleisDaten;
     RGleisDaten=RECORD
                   Nutzlaenge:word;         {cm}
                   Bezeichnung:string[maxGleisBezeichnung];  {normalerweise die Nummer}
                 END;

CONST maxBahnhofsName=30;
      maxKurzName=6;

TYPE TReglerFarbenAnzahl=3..5;

TYPE PBahnhofsDaten=^RBahnhofsDaten;
     RBahnhofsDaten=RECORD
                      Name:string[maxBahnhofsName];
                      KurzName:string[maxKurzName];
                      Eigner:string[30];
                      Strecken:word;
                      ReglerFarben:TReglerFarbenAnzahl;
                    END;

TYPE hDatenbank=word;
     hBahnhof=word;
     hGleis=word;
     TBfError=(KeinFehler, DatenbankUngueltig, BahnhofUngueltig);
     TDatenbankStatus=(Ungueltig, ok);
     TAufzaehlProc=PROCEDURE(Bahnhof:hBahnhof);

FUNCTION CreateKurzname(Name:string):string;


IMPLEMENTATION


FUNCTION CreateKurzname(Name:string):string;
VAR w:word;
    kn:string[20];
BEGIN
  kn:=Name[1];
  w:=1;
  while (w<length(Name)) and (length(KN)<maxKurzName) do begin
    inc(w);
    if not (upcase(Name[w]) in ['A','E','I','O','U','','',''])
      then Kn:=Kn+Name[w];
  end;
  CreateKurzName:=kn;
END;


END.
