{Projekt: BFBROWSE

 Autor: Stefan Bormann 95

 Inhalt: Abgeleiteter Typ des Bahnhofsobjekts
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT BrBfDat;

INTERFACE
USES BfDef, oWindows;

FUNCTION BfNeu(parent:PWindowsObject):hBahnhof;
PROCEDURE BfEdit(parent:PWindowsObject; Bahnhof:hBahnhof);


IMPLEMENTATION
USES AbsBfDat, db_obj, Bf_Allg, BfEdDlg;

TYPE TBfBrowseBahnhof=OBJECT(TBahnhof)
                        FUNCTION CopyFromDatabase(VAR Datenbank:TBahnhofsDatenbank; Bahnhof:hBahnhof):boolean;
                        FUNCTION CopyToDatabase(VAR Datenbank:TBahnhofsDatenbank; Bahnhof:hBahnhof):hBahnhof;
                      END;

FUNCTION TBfBrowseBahnhof.CopyFromDatabase(VAR Datenbank:TBahnhofsDatenbank; Bahnhof:hBahnhof):boolean;
VAR w:word;
    Gleis:RGleisDaten;
    NeuInfo:pchar;
BEGIN
  CopyFromDatabase:=false;

  Free;

  if (Datenbank.GetData(Bahnhof, @Daten)<>keinFehler) then exit;

  w:=Datenbank.GetInfoLength(Bahnhof);
  if w<>0 then begin
    GetMem(NeuInfo, w+1);
    Datenbank.GetInfo(Bahnhof, NeuInfo, w);
    SetInfo(NeuInfo);
  end;

  w:=Datenbank.GetGleisAnzahl(Bahnhof);
  if w=0 then exit;

  for w:=1 to w do begin
    if (Datenbank.GetGleis(Bahnhof, w, @Gleis)<>keinFehler) then exit;
    AppendGleis(Gleis.Bezeichnung, Gleis.NutzLaenge);
  end;

  CopyFromDatabase:=true;
END;

FUNCTION TBfBrowseBahnhof.CopyToDatabase(VAR Datenbank:TBahnhofsDatenbank;
                                         Bahnhof:hBahnhof):hBahnhof;  {0=neuen Datensatz machen}
VAR w:word;
BEGIN
  CopyToDatabase:=0;
  if not Datenbank.IsOpen then exit;
  if Bahnhof=0 then Bahnhof:=Datenbank.BahnhofDazu;
  if Bahnhof=0 then exit;
  if (Datenbank.SetData(Bahnhof, @Daten)<>keinFehler) then exit;
  if (Datenbank.SetInfo(Bahnhof, GetInfo)<>keinFehler) then exit;
  if (Datenbank.GleiseLoeschen(Bahnhof)<>keinFehler) then exit;
  for w:=1 to AnzahlGleise do  if (Datenbank.GleisDazu(Bahnhof, GetGleis(w))=0) then exit;
  CopyToDatabase:=Bahnhof;
END;


FUNCTION BfNeu(parent:PWindowsObject):hBahnhof;
VAR bf:TBfBrowseBahnhof;
    h:hBahnhof;
BEGIN
  BfNeu:=0;
  bf.init;
  if ExecuteBahnhofsEditor(parent, bf, 0) then begin
    h:=bf.CopyToDatabase(Datenbank, 0);
    BfNeu:=h;
    if h=0 then InternerFehler('CopyToDatabase in BfNeu');
  end;
  bf.done;
END;

PROCEDURE BfEdit(parent:PWindowsObject; Bahnhof:hBahnhof);
VAR bf:TBfBrowseBahnhof;
BEGIN
  bf.init;
  if bf.CopyFromDatabase(Datenbank, Bahnhof) then begin
    if ExecuteBahnhofsEditor(parent, bf, 0) then begin
      if not (bf.CopyToDatabase(Datenbank, Bahnhof)=Bahnhof) then InternerFehler('CopyToDatabase in BfEdit');
    end;
  end else InternerFehler('CopyFromDatabase in BfEdit');
  bf.done;
end;


END.
