{Projekt: BfBrowse

 Autor: Stefan Bormann 95

 Inhalt: Fenstertyp fuer den rechten Infokasten
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Group;

INTERFACE
USES WinTypes, oDialogs, oWindows, BfDef, Bf_Allg;

TYPE PInfoGroup=^TInfoGroup;
     TInfoGroup=OBJECT(TGroupBox)
                  Daten:PStatic;
                  Info:PStatic;
                  CONSTRUCTOR init(aparent:PWindow);
                  PROCEDURE DisplayData(Bahnhof:hBahnhof);
                  PROCEDURE WMSize(VAR Msg:TMessage); virtual wm_first+wm_size;
                END;


IMPLEMENTATION
USES WinProcs, grund;

CONSTRUCTOR TInfoGroup.init(aparent:PWindow);
BEGIN
  inherited init(aparent, -1, 'angewhlter Datensatz', 0,0,0,0);
  new(Daten, init(@self, -1, '', 0,0,0,0, 200));
  {with Daten^.attr do style:=style or ws_border;}
  new(Info, init(@self, -1, '', 0,0,0,0, 2000));
  {with Info^.attr do style:=style or ws_border;}
END;

PROCEDURE TInfoGroup.DisplayData(Bahnhof:hBahnhof);

 Function PluralChar(c:char; b:boolean):string;
 Begin
   if b then PluralChar:=c
        else PluralChar:='';
 End;

VAR Puffer:RBahnhofsDaten;
    s:string;
    s_anz,g_anz:word;
BEGIN
  if Bahnhof=0 then begin
    Daten^.SetText('');
    Info^.SetText('');
  end else begin
    if Datenbank.GetData(Bahnhof, @Puffer)=keinFehler then begin
      s_anz:=puffer.strecken;
      g_anz:=Datenbank.GetGleisAnzahl(Bahnhof);
      s:=puffer.name+' ('+puffer.kurzname+')'+cr+
         'von '+puffer.eigner+cr+
         zahlstr(s_anz,1)+' Strecke'+PluralChar('n', s_anz>1)+'; '+
         zahlstr(g_anz,1)+' Gleis'+PluralChar('e', g_anz>1)+'; '+
         zahlstr(puffer.ReglerFarben,1)+' Farben'+
         #0;
      Daten^.SetText(@s[1]);
      Datenbank.Info2Window(Bahnhof, Info^.hWindow);
    end else InternerFehler('InfoGroup.DisplayData')
  end;
END;

PROCEDURE TInfoGroup.WMSize(VAR Msg:TMessage);
VAR w,h:integer;
CONST Hoehe=105;
BEGIN
  w:=msg.lParamLo;
  h:=msg.lParamHi;
  MoveWindow(Daten^.hWindow, 5, 20,    w-10, hoehe-20,  true);
  MoveWindow(Info ^.hWindow, 5, Hoehe+5, w-10, h-Hoehe-10, true);
END;


END.
