UNIT GRUND;

{Datei: allgemeinbrauchbare Toolbox
        fuer DOS und Windows

 Autor: Stefan Bormann 94

 Inhalt: Character-Konstanten und Stringmanipulationsroutinen}

{$A+,B-,F-,G-,N-,I+,V-,X-}
{$D+,L+,R+,S+}

{$ifdef windows}
{$C moveable preload permanent}
{$endif}


INTERFACE

TYPE ProcTyp = PROCEDURE;
     SuperPointer=record case integer of
                   0:(p:pointer);
                   1:(o,s:word);
                  end;

  CONST F1=#59;  alt_F1=#104;  ctrl_F1=#94;   shift_F1=#84;
        F2=#60;  alt_F2=#105;  ctrl_F2=#95;   shift_F2=#85;
        F3=#61;  alt_F3=#106;  ctrl_F3=#96;   shift_F3=#86;
        F4=#62;  alt_F4=#107;  ctrl_F4=#97;   shift_F4=#87;
        F5=#63;  alt_F5=#108;  ctrl_F5=#98;   shift_F5=#88;
        F6=#64;  alt_F6=#109;  ctrl_F6=#99;   shift_F6=#89;
        F7=#65;  alt_F7=#110;  ctrl_F7=#100;  shift_F7=#90;
        F8=#66;  alt_F8=#111;  ctrl_F8=#101;  shift_F8=#91;
        F9=#67;  alt_F9=#112;  ctrl_F9=#102;  shift_F9=#92;
        F10=#68; alt_F10=#113; ctrl_F10=#103; shift_F10=#93;

  CONST CR  = #$0D;          hochC   = #72;
        BS  = #$08;          runterC = #80;
        DC1 = #$11;          rechtsC = #77;
        DC2 = #$12;          linksC  = #75;
        DC3 = #$13;
        DC4 = #$14;
        ESC = #$1B;          homeC   = #71;
        FF  = #$0C;          endC    = #79;
        FS  = #$1C;
        TAB = #$09;
        LF  = #$0A;
        SI  = #$0F;
        SO  = #$0E;          insertC = #82;
        VT  = #$0B;          delC    = #83;
        XON = DC1;
        XOFF= DC3;

  CONST ASCIIkleinbuchstaben=['a'..'z','','',''];
        ASCIIgrossbuchstaben=['A'..'Z','','',''];
        OEMkleinbuchstaben=['a'..'z','','',''];
        OEMgrossbuchstaben=['A'..'Z','','',''];


 CONST ExitCode_NoError=0;
       ExitCode_OK=0;
       ExitCode_Ctrl_C=1;
       ExitCode_CtrlC=1;
       ExitCode_Error=2;
       ExitCode_Resident=3;

FUNCTION DownCase(c : char) : char;
FUNCTION KleinStr(s : string) : string;
FUNCTION grossStr(s : string) : string;
FUNCTION space(a : integer) : string;
FUNCTION SpaceWeg(S : string) : string;
FUNCTION StrGleich(s1,s2 : string) : boolean;
FUNCTION StringAufLaenge(quell : string; laenge : byte) : string;
FUNCTION StringVielfach(str : string; anz : integer) : string;
FUNCTION SplitString(rein:string; pivot:char; VAR raus1,raus2:string):boolean;
PROCEDURE Ersetzen(was,wodurch:char; VAR worin:string);

FUNCTION dreistellig(nr : word) : string;
FUNCTION zweistellig(nr : word) : string;
FUNCTION Byte2Hex(a : byte) : string;
FUNCTION Word2Hex(w : word) : string;
FUNCTION ZahlStr(z : longint;l : byte) : string;
FUNCTION RealStr(r:real; v,n:byte) : string;
FUNCTION Byte2Bin(z : Byte) : string;
FUNCTION NeuValOK(s : string; VAR zahl : longint) : boolean;
FUNCTION BitGesetzt(l : longint; nr : byte) : boolean;
PROCEDURE SetzBit(VAR l; nr:byte; bit:boolean);
FUNCTION min(a,b : longint) : longint;
FUNCTION max(a,b : longint) : longint;
FUNCTION Wochentag(nr : word) : string;
FUNCTION ZentrierStr(s:string; laenge:byte):string;
FUNCTION PointerStr(Zeiger : pointer) : string;


IMPLEMENTATION


FUNCTION DownCase(c : char) : char;
BEGIN
  if c in ['A'..'Z'] then Downcase:=chr(ord(c)+32) else DownCase:=c;
END;

FUNCTION grossStr(s : string) : string;
VAR a : byte;
BEGIN
  grossStr[0]:=s[0];
  for a:=1 to length(s) do grossStr[a]:=upcase(s[a]);
END;

FUNCTION KleinStr(s : string) : string;
VAR a : byte;
BEGIN
  KleinStr[0]:=s[0];
  for a:=1 to length(s) do KleinStr[a]:=downcase(s[a]);
END;

FUNCTION Wochentag(nr : word) : string;
BEGIN
  CASE nr of
    0,7 : Wochentag:='Sonntag';
    1	: Wochentag:='Montag';
    2	: Wochentag:='Dienstag';
    3	: Wochentag:='Mittwoch';
    4	: Wochentag:='Donnerstag';
    5	: Wochentag:='Freitag';
    6	: Wochentag:='Samstag';
    else runerror;
  END;
END;

FUNCTION ZentrierStr(s:string; laenge:byte):string;
var a:byte;
BEGIN
  if laenge<length(s) then runerror;
  a:=(laenge-length(s)) div 2;
  ZentrierStr:=space(laenge-length(s)-a)+s+space(a);
END;

FUNCTION Byte2Hex(a : byte) : string;
CONST s:array [0..15] of char='0123456789ABCDEF';
BEGIN
  Byte2Hex:=s[(a shr 4) and $0F]+s[a and $0F];
END;

FUNCTION Word2Hex(w : word) : string;
BEGIN
  Word2Hex:=Byte2Hex(hi(w))+Byte2Hex(lo(w));
END;

FUNCTION space(a : integer) : string;
BEGIN   space:=StringVielfach(' ',a);  END;

FUNCTION StringVielfach(str : string; anz : integer) : string;
VAR a : byte;
    s : string;
    i : byte;
BEGIN
  if (anz<=0) or (length(str)=0) then StringVielfach:=''
  else begin
    i:=1;
    s[0]:=char(lo(length(str)*anz));
    for a:=1 to anz do begin
      move(str[1],s[i],length(str));
      inc(i,length(str));
    end;
    StringVielfach:=s;
  end;
END;

FUNCTION SplitString(rein:string; pivot:char; VAR raus1,raus2:string):boolean;
VAR Trennung:byte;
BEGIN
  Trennung:=pos(pivot,rein);
  SplitString:=Trennung<>0;
  if Trennung=0 then begin
    raus1:=rein;  {war mal mit spaceweg, waere aber nich guuut}
    raus2:='';
  end else begin
    raus1:=spaceweg(copy(rein,1,Trennung-1));
    raus2:=spaceweg(copy(rein,Trennung+1,length(rein)-Trennung));
  end;
END;

PROCEDURE Ersetzen(was,wodurch:char; VAR worin:string);
VAR w:word;
BEGIN
  for w:=1 to length(worin) do if worin[w]=was then worin[w]:=wodurch;
END;


FUNCTION dreistellig(nr : word) : string;
VAR s : string[3];
BEGIN
  str(nr:3,s);
  if length(s)>3 then runerror;
  if s[1]=' ' then s[1]:='0';
  if s[2]=' ' then s[2]:='0';
  dreistellig:=s;
END;

FUNCTION zweistellig(nr : word) : string;
VAR s : string[10];
BEGIN
  str(nr:2,s);
  if length(s)>2 then runerror;
  if s[1]=' ' then s[1]:='0';
  zweistellig:=s;
END;

FUNCTION ZahlStr(z : longint;l : byte) : string;
VAR s : string[11];
BEGIN
  str(z:l,s);
  ZahlStr:=s;
END;

FUNCTION RealStr(r:real; v,n:byte) : string;
VAR s:string[45];
BEGIN
  str(r:v:n,s);
  RealStr:=s;
END;

FUNCTION Byte2Bin(z : Byte) : string;
VAR s : string[8];
    a : Byte;
BEGIN
  s:='        ';
  for a:=0 to 7 do  if (z and ($80 shr a))=0 then s[a+1]:='0'
                                             else s[a+1]:='1';
  Byte2Bin:=s;
END;

FUNCTION NeuValOK(s : string; VAR zahl : longint) : boolean;
VAR negativ : boolean;
    k : integer;
Var a : longint;
    b,wert : byte;

Procedure Hex;
var b : byte;
Begin
  if length(s)=0 then NeuValOK:=false;
  a:=0;
  for b:=length(s) downto 1 do begin
    case s[b] of
     '0'..'9' : wert:=byte(s[b])-48;
     'A'..'F' : wert:=byte(s[b])-55;
     else NeuValOK:=false;
    end;
    zahl:=zahl or (wert shl a);
    a:=a+4;
  end;
End;

BEGIN
  NeuValOK:=true;
  zahl:=0;
  s:=spaceweg(s);
  negativ:=s[1]='-';
  if negativ then s:=copy(s,2,length(s)-1);
  s:=grossStr(spaceweg(s));
  if length(s)=0 then NeuValOK:=false;
  if s[1]='$' then begin
    s:=copy(s,2,length(s)-1);
    hex;
  end else  case s[length(s)] of
    'H' : begin
            s:=copy(s,1,length(s)-1);
            hex;
          end;
    'B' : begin
            s:=copy(s,1,length(s)-1);
            if length(s)=0 then NeuValOK:=false;
            a:=1;
            for b:=length(s) downto 1 do begin
              case s[b] of
               '1','H' : zahl:=zahl or a;
               '0','L' : begin end;
               else NeuValOK:=false;
              end;
              a:=a shl 1;
            end;
          end;
    else begin
      val(s,zahl,k);
      NeuValOK:= k=0;
    end;
  end;
  if negativ then zahl:=-zahl;
END;

FUNCTION StrGleich(s1,s2 : string) : boolean;
VAR a : byte;
BEGIN
  StrGleich:=false;
  if length(s1)<>length(s2) then exit;
  for a:=1 to length(s1) do  if upcase(s1[a])<>upcase(s2[a]) then exit;
  StrGleich:=true;
END;

FUNCTION SpaceWeg(S : string) : string;
VAR a,b : byte;
BEGIN
  if length(s)=0 then SpaceWeg:=''
  else begin
    a:=1;
    while (a<=length(s)) and (s[a]=' ') do inc(a);
    if a>length(s) then SpaceWeg:=''
    else begin
      b:=length(s);
      while s[b]=' ' do dec(b);
      SpaceWeg:=copy(s,a,b-a+1);
    end;
  end;
{  a:=1;
  while (a-1<>length(s)) and (s[a]=' ') do inc(a);
  s:=copy(s,a,length(s)-a+1);
  a:=length(s);
  while (a<>0) and (s[a]=' ') do dec(a);
  SpaceWeg:=copy(s,1,a);}
END;

FUNCTION StringAufLaenge(quell : string; laenge : byte) : string;
BEGIN
  StringAufLaenge:=quell+space(laenge-length(quell));
END;

FUNCTION BitGesetzt(l : longint; nr : byte) : boolean;
VAR key : longint;
BEGIN
  key:=1;
  key:=key shl nr;
  BitGesetzt:=(key and l) <> 0;
END;

PROCEDURE SetzBit(VAR l; nr:byte; bit:boolean);
VAR key : longint;
BEGIN
  key:=1;
  key:=key shl nr;
  if bit then longint(l):=longint(l) or key
         else longint(l):=longint(l) and ($FFFFFFFF-key);
END;

FUNCTION min(a,b : longint) : longint;
BEGIN
  if a<b then min:=a else min:=b;
END;

FUNCTION max(a,b : longint) : longint;
BEGIN
  if a>b then max:=a else max:=b;
END;

FUNCTION ShiftState : byte;
BEGIN
  ShiftState:=mem[0:$0417];
END;

FUNCTION InsertAktiv : boolean;
BEGIN
  InsertAktiv:=(ShiftState and $80) <> 0;
END;

FUNCTION PointerStr(Zeiger : pointer) : string;
BEGIN
  PointerStr:=Word2Hex(SuperPointer(Zeiger).s)+':'+Word2Hex(SuperPointer(Zeiger).o);
END;


END.
