{Projekt: Allgemeinverwendbares Modul

 Autor: Stefan Bormann 95

 Inhalt: Standardisierte Buttonzeile/Statuszeile fuer SDI
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT SDI;

INTERFACE
USES oWindows, xdiTools, WinProcs, WinTypes;

TYPE PNewSDIWindow=^TNewSDIWindow;
     PButtonZeile=^TButtonZeile;
     PStatusZeile=^TStatusZeile;

     TStatusZeile=OBJECT(TAbstractStatusZeile)
                    CONSTRUCTOR Init(AParent: PNewSDIWindow);
                  END;

     TButtonZeile=OBJECT(TAbstractButtonZeile)
                    CONSTRUCTOR init(AParent: PNewSDIWindow; VAR ButtonZeileDef:RButtonZeileDef);
                    PROCEDURE WMCommand(var Msg:TMessage);  virtual wm_first+wm_command;
                  END;

     TNewSDIWindow=OBJECT(TWindow)
                     StatusZeile:PStatusZeile;
                     ButtonZeile:PButtonZeile;
                     CONSTRUCTOR init(Atitle:Pchar; Amenu:Hmenu; VAR ButtonZeileDef:RButtonZeileDef);
                     PROCEDURE SetupWindow;  virtual;
                     PROCEDURE InitStatusZeile;                                      virtual;
                     PROCEDURE InitButtonZeile(VAR ButtonZeileDef:RButtonZeileDef);  virtual;
                     PROCEDURE WMSize(VAR msg:TMessage);            virtual wm_first+wm_size;
                     PROCEDURE SizeClient(x,y,w,h:integer);         virtual;
                     PROCEDURE WMMenueSelect(VAR msg:TMessage);     virtual wm_first+wm_menuselect;
                     PROCEDURE WMGetMinMaxInfo(VAR Msg:TMessage);   virtual wm_First+wm_GetMinMaxInfo;
                     FUNCTION GetMenueBeschreibung(cm:word):pchar;  virtual;
                   END;


IMPLEMENTATION
USES Win31, grund;

CONSTRUCTOR TStatusZeile.Init(AParent: PNewSDIWindow);
BEGIN
  inherited init(aParent);
END;

CONSTRUCTOR TButtonZeile.init(AParent: PNewSDIWindow; VAR ButtonZeileDef:RButtonZeileDef);
BEGIN
  inherited init(aParent, ButtonZeileDef);
END;

PROCEDURE TButtonZeile.WMCommand(VAR Msg: TMessage);
BEGIN
  SendMessage(Application^.MainWindow^.hWindow, WM_COMMAND, Msg.wParam, 0);
END;

{************************** abstraktes MDI-Rahmen-Fenster***************************}

CONSTRUCTOR TNewSDIWindow.init(Atitle:Pchar; Amenu:Hmenu; VAR ButtonZeileDef:RButtonZeileDef);
BEGIN
  inherited init(nil, atitle);
  attr.Menu:=aMenu;
  InitStatusZeile;
  InitButtonZeile(ButtonZeileDef);
END;

PROCEDURE TnewSDIWindow.SetupWindow;
BEGIN
  inherited SetupWindow;
  ButtonZeile^.SetPosition(oben);
  StatusZeile^.SetSichtbar(true);
END;

PROCEDURE TNewSDIWindow.InitStatusZeile;
BEGIN
  new(StatusZeile,init(@self));
END;

PROCEDURE TNewSDIWindow.InitButtonZeile(VAR ButtonZeileDef:RButtonZeileDef);
BEGIN
  new(ButtonZeile,init(@self, ButtonZeileDef));
END;

PROCEDURE TNewSDIWindow.WMSize(VAR Msg:TMessage);
VAR rect:TRect;
    HoeheStatusZeile,HoeheButtonZeile,BreiteButtonZeile:word;
    HoeheClient:word;
    StartXClient:word;
BEGIN
  if msg.wParam=SizeIconic then exit;
  HoeheStatusZeile:=StatusZeile^.Height+1;
  HoeheButtonZeile:=ButtonZeile^.Hoehe;
  BreiteButtonZeile:=ButtonZeile^.Breite;
  inherited wmsize(msg);
  GetClientRect(hwindow, rect);
  if StatusZeile^.Sichtbar then begin
    HoeheClient:=rect.bottom-HoeheStatusZeile;
    movewindow(StatusZeile^.hwindow, 0,rect.bottom-HoeheStatusZeile, rect.right, HoeheStatusZeile,true);
  end else begin
    HoeheClient:=rect.bottom;
    movewindow(StatusZeile^.hwindow, 0,0,0,0, false);
  end;
  StartXClient:=0;
  case ButtonZeile^.Position of
    keine :begin
             movewindow(ButtonZeile^.hwindow, 0,0,0,0, false);
             SizeClient(0,0 ,rect.right, HoeheClient);
           end;
    links :begin
             movewindow(ButtonZeile^.hwindow, 0,0, BreiteButtonZeile, HoeheClient, true);
             SizeClient(BreiteButtonZeile,0 ,rect.right-BreiteButtonZeile, HoeheClient);
           end;
    rechts:begin
             movewindow(ButtonZeile^.hwindow, rect.right-BreiteButtonZeile,0, BreiteButtonZeile, HoeheClient, true);
             SizeClient(0,0, rect.right-BreiteButtonZeile,HoeheClient);
           end;
    oben  :begin
             movewindow(ButtonZeile^.hwindow, 0,0, rect.right, HoeheButtonZeile,true);
             SizeClient(0,HoeheButtonZeile ,rect.right, HoeheClient-HoeheButtonZeile);
           end;
  end;
END;

PROCEDURE TNewSDIWindow.SizeClient(x,y,w,h:integer);
BEGIN END;

PROCEDURE TNewSDIWindow.WMMenueSelect(VAR msg:TMessage);
VAR wIDitem,fwMenu,hMenu:word;
    p:pchar;
BEGIN
  wIDItem:=msg.wParam;
  fwMenu :=msg.lParamLo;
  hMenu  :=msg.lParamHi;
  if (fwMenu=-1) then p:=nil
  else if (fwMenu and mf_separator)<>0 then p:=''
  else if (fwMenu and mf_sysmenu)<>0 then p:='System-Men'
  else if (fwMenu and mf_popup)<>0 then p:='Popup-Men'
  else p:=GetMenueBeschreibung(widitem);
  StatusZeile^.SetHelpText(p);
END;

VAR temp:string[20];
FUNCTION TNewSDIWindow.GetMenueBeschreibung(cm:word):pchar;
BEGIN
  temp:='cm='+zahlstr(cm,1)+'d='+word2hex(cm)+'h'+#0;
  GetMenueBeschreibung:=@temp[1];
END;

PROCEDURE TNewSDIWindow.WMGetMinMaxInfo(VAR Msg:TMessage);
BEGIN
  with TMinMaxInfo(pointer(msg.lParam)^) do begin
    ptMinTrackSize.x:=200;
    ptMinTrackSize.y:=200;
  end;
END;


END.
