{Projekt: Allgemeinverwendbares Modul

 Autor: Stefan Bormann 95

 Inhalt: Abstrakte Statuszeile/Buttonzeile fuer SDI oder MDI
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT xdiTools;

INTERFACE
USES WinTypes, oWindows, heap, oDialogs;

CONST MaxStatusZeile=200;

TYPE PAbstractButtonZeile=^TAbstractButtonZeile;
     PAbstractStatusZeile=^TAbstractStatusZeile;
{StatusZeile=RibbonWindow aus HeapSpy geklaut}
     TAbstractStatusZeile=object(TWindow)
                     Height: Integer;
                     Sichtbar:boolean;
                     constructor Init(AParent: PWindowsObject);
                     procedure SetHelpText(Txt: PChar);
                     PROCEDURE SetDefaultText(txt:pchar);
                     PROCEDURE SetSichtbar(flag:boolean);
                     DESTRUCTOR Done; virtual;
                     FUNCTION GetClassName: PChar; virtual;
                     PROCEDURE GetWindowClass(var WndClass: TWndClass); virtual;
                     PROCEDURE Paint(PaintDC: hDC; var PS: TPaintStruct); virtual;
                     PROCEDURE WMSetText(var Msg: TMessage);  virtual wm_First + wm_SetText;
                     PROCEDURE WMTimer(VAR Msg:TMessage);     virtual wm_First + wm_Timer;
                   PRIVATE
                     GrayBrush: HBrush;
                     GrayPen, WhitePen: HPen;
                     HintText,DefaultText: array[0..MaxStatusZeile] of Char;
                     Font: HFont;
                     DefaultTimer:THandle;
                   end;
{ButtonZeile=SpeedBar aus HeapSpy geklaut}
     RZeilenButtonDef=RECORD
                        resource_n,resource_g:pchar;
                        cm:word;
                      END;
     AZeilenButtonDef=Array [1..100] of RZeilenButtonDef;
     RButtonZeileDef=RECORD
                       arrptr:^AZeilenButtonDef;
                       anzahl:word;
                     END;

     TButtonArray=OBJECT(DynArrayObj)
                    PROCEDURE InitButtons(Parent:PAbstractButtonZeile; def:RButtonZeileDef);
                    PROCEDURE Free; virtual;
                    FUNCTION cm2button(cm:word):PButton;
                  END;

     TAusrichtung=(horizontal,vertikal);
     TButtonZeilePosition=(oben,links,rechts,keine);
     TAbstractButtonZeile=OBJECT(TWindow)
                    Hoehe,Breite:Integer;       {Maximalwert aller Bitmaps}
                    Position:TButtonZeilePosition;
                    CONSTRUCTOR init(AParent: PWindowsObject; VAR ButtonZeileDef:RButtonZeileDef);
                    PROCEDURE SetPosition(pos:TButtonZeilePosition);
                    PROCEDURE SetupWindow; virtual;
                    PROCEDURE MoveButtons(Ausrichtung:TAusrichtung);
                    FUNCTION GetClassName: PChar; virtual;
                    PROCEDURE GetWindowClass(var WndClass: TWndClass); virtual;
                    FUNCTION cm2button(cm:word):PButton;
                    PROCEDURE WMDrawItem(var Msg: TMessage);  virtual wm_First+wm_DrawItem;
                    PROCEDURE WMSetFocus(var Msg: TMessage);  virtual wm_First+wm_SetFocus;
                  PRIVATE
                    Definition:RButtonZeileDef; {Initialisiertungparameter}
                    ButtonArray:TButtonArray;   {Array ueber alle Speedbuttons oder NILs (Luecken)}
                  END;


IMPLEMENTATION
USES Strings, WinProcs, grund;

{*********************************** StatusZeile **********************************}

constructor TAbstractStatusZeile.Init(AParent: PWindowsObject);
var
  DC: hDC;
  OldFont: HFont;
  TM: TTExtMetric;
  LogFont: TLogFont;
begin
  Inherited Init(AParent, '');      { create the window normally }
  HintText[0]:=#0;
  DefaultText[0]:=#0;
  Attr.Style := ws_Border or ws_Child or ws_Visible;

  { establish Font for use in this window }
  Font := GetStockObject(ANSI_VAR_FONT);
  GetObject(Font,Sizeof(TLogFont), @LogFont);
  LogFont.lfWeight := 600;
  Font :=CreateFontIndirect(LogFont);

  { Determine the height of this window }
  DC := GetDC(0);
  OldFont := SelectObject(DC, Font);
  GetTextMetrics(DC, TM);
  Height := TM.tmHeight + 8;
  SelectObject(DC, OldFont);
  ReleaseDC(0, DC);

  { Make the pens and brushes used to draw the status line }
  GrayPen := CreatePen(PS_SOLID,1,$00808080);
  WhitePen := GetStockObject(White_Pen);
  GrayBrush := GetStockObject(ltGray_Brush);

  Sichtbar:=false;
end;

destructor TAbstractStatusZeile.Done;
begin
  DeleteObject(GrayPen);
  DeleteObject(Font);
  inherited Done;
end;

PROCEDURE TAbstractStatusZeile.SetSichtbar(flag:boolean);
BEGIN
  Sichtbar:=flag;
  SendMessage(parent^.hwindow, wm_size, 0,0);
END;

function TAbstractStatusZeile.GetClassName;
begin
  GetClassName := 'StatusZeile';
end;

procedure TAbstractStatusZeile.GetWindowClass(var WndClass: TWndClass);
begin
  inherited GetWindowClass(WndClass);
  WndClass.hbrBackGround := GrayBrush;
end;

procedure TAbstractStatusZeile.Paint;
var
  OldFont: HFont;
  OldPen : hPen;
  R: TRect;
begin
  GetClientRect(hWindow,R);
  with R do
  begin
    Inc(Left,4); Inc(top,2); Dec(Right,4);
    Dec(Bottom,3);
    SetBKMode(PaintDC, Transparent);
    OldPen := SelectObject(PaintDC, GrayPen);
    MoveTo(PaintDC, left,bottom);
    LineTo(PaintDC, left,top);
    LineTo(PaintDC, right,top);
    SelectObject(PaintDC, WhitePen);
    LineTo(PaintDC, right,bottom);
    LineTo(PaintDC, left,bottom);
  end;
  SelectObject(PaintDC, OldPen);
  SetTextColor(PaintDC, 0);
  OldFont := SelectObject(PaintDC, Font);
  with R do
    IntersectClipRect(PaintDC, left, top, right-2, bottom);
  if HintText[0] <> #0 then
    TextOut(PaintDC, 8, 3, HintText, StrLen(HintText));
  SelectObject(PaintDC,OldFont);
end;

PROCEDURE TAbstractStatusZeile.SetDefaultText(txt:pchar);
BEGIN
  StrLCopy(DefaultText, txt, MaxStatusZeile);
END;

CONST id_DefaultTimer=420;

procedure TAbstractStatusZeile.SetHelpText(txt:pchar);
VAR NimmDefault:boolean;
begin
  NimmDefault:=txt=nil;
  if NimmDefault then txt:=DefaultText;
  if (Txt=nil) then txt:='';
  if StrComp(txt,hinttext)=0 then exit;

  StrLCopy(HintText, Txt, MaxStatusZeile);
  if (hWindow<>0) then InvalidateRect(hWindow, nil, True);
  if NimmDefault then exit;

  if DefaultTimer<>0 then KillTimer(DefaultTimer, id_DefaultTimer);
  DefaultTimer:=SetTimer(hWindow, id_DefaultTimer, 1000*60, nil);
end;

PROCEDURE TAbstractStatusZeile.WMTimer(VAR Msg:TMessage);
BEGIN
  KillTimer(DefaultTimer, id_DefaultTimer);
  SetHelpText(nil);
END;

procedure TAbstractStatusZeile.WMSetText(VAR Msg:TMessage);
begin
  SetHelpText(PChar(Msg.lPAram));
end;

{********************************* ButtonZeile *************************************}

TYPE PSpeedButton=^TSpeedButton;
     TSpeedButton=object(TButton)
                    BMP_n, BMP_g: hBitmap;
                    Width,Height: word;
                    constructor Init(AParent:PAbstractButtonZeile; AnID:Integer; Bitmap_n,Bitmap_g:PChar);
                    destructor Done; virtual;
                    function GetClassName: PChar; virtual;
                    procedure GetWindowClass(var WndClass: TWndClass); virtual;
                    procedure WMLButtonDown(var Msg: TMessage);  virtual wm_First + wm_LButtonDown;
                    procedure WMLButtonUp(var Msg: TMessage);    virtual wm_First + wm_LButtonUp;
                  end;

PROCEDURE TButtonArray.InitButtons(parent:PAbstractButtonZeile; def:RButtonZeileDef);
VAR w:word;
    data:^RZeilenButtonDef;
BEGIN
  free;
  erweiterung(def.anzahl);
  for w:=1 to def.anzahl do with def.arrptr^[w] do
    if (resource_n<>nil) then p^[w]:=new(PSpeedButton,init(parent, cm, resource_n, resource_g))
                         else p^[w]:=nil;
END;

PROCEDURE TButtonArray.Free;
VAR w:word;
BEGIN                      {Luecken!!!}
  for w:=1 to anzahl do if (p^[w]<>nil) then dispose(PSpeedButton(p^[w]),done);
  inherited free;
END;

FUNCTION TButtonArray.cm2button(cm:word):PButton;
VAR w:word;
    sbp:PSpeedButton;
BEGIN
  for w:=1 to anzahl do begin
    sbp:=p^[w];
    if (sbp<>nil) and (sbp^.attr.id=cm) then begin
      cm2button:=sbp;
      exit;
    end;
  end;
  cm2button:=nil;
END;


constructor TSpeedButton.Init(AParent:PAbstractButtonZeile; AnID:Integer; BitMap_n,Bitmap_g:PChar);
var B: TBitMap;
begin
  BMP_n:=LoadBitMap(hInstance,Bitmap_n);
  BMP_g:=LoadBitmap(hInstance,Bitmap_g);
  if (BMP_g=0) or (BMP_n=0) then runerror;
  GetObject(BMP_n,Sizeof(B), @B);
  Width := B.bmWidth+2;   {+2 wegen Rahmens}
  Height := B.bmHeight+2;
  inherited Init(AParent, AnID, '', 0,0, Width,Height, False);
  Attr.Style := Attr.Style or bs_OwnerDraw or ws_Border;
end;

destructor TSpeedButton.Done;
begin
  inherited Done;
  DeleteObject(BMP_g);
  DeleteObject(BMP_g);
end;

function TSpeedButton.GetClassName: PChar;
begin
  GetClassName := 'Button';
end;

procedure TSpeedButton.GetWindowClass(var WndClass: TWndClass);
begin
  inherited GetWindowClass(WndClass);
end;

procedure TSpeedButton.WMLButtonDown;
var
  HelpText: array[0..MaxStatusZeile] of Char;
begin
  SendMessage(parent^.parent^.hwindow, WM_MenuSelect, attr.id, 0);
  DefWndProc(Msg);
end;

procedure TSpeedButton.WMLButtonUp;
begin
  SendMessage(parent^.parent^.hwindow, WM_MenuSelect, 0, mf_separator);
  DefWndProc(Msg);
end;

{ ButtonZeile Methods }

constructor TAbstractButtonZeile.Init(AParent: PWindowsObject; VAR ButtonZeileDef:RButtonZeileDef);
var i: Integer;
begin
  inherited Init(AParent,'');
  Attr.X := 0;
  Attr.Y := 0;
  Attr.W := 2;
  Attr.H := 0;
  Attr.Style := ws_Visible or ws_Child or ws_border;
  Definition:=ButtonZeileDef;
  ButtonArray.init;
  ButtonArray.InitButtons(@self, ButtonZeileDef);
  Position:=keine;
end;

PROCEDURE TAbstractButtonZeile.SetPosition(Pos:TButtonZeilePosition);
BEGIN
  Position:=pos;
  case pos of
    keine:;
    links,rechts:MoveButtons(vertikal);
    oben:MoveButtons(horizontal);
  end;
  SendMessage(parent^.hwindow, wm_size, 0,0);
END;

PROCEDURE TAbstractButtonZeile.SetupWindow;
BEGIN
  inherited SetupWindow;
END;

PROCEDURE TAbstractButtonZeile.MoveButtons(Ausrichtung:TAusrichtung);
VAR w:word;
    button:PSpeedButton;
    Xpixel,Ypixel:integer;
    Veraendern:^integer;
CONST RandPixel=1;
      LueckePixel=20;
      AbstandPixel=2;
BEGIN
  Hoehe:=0;
  Breite:=0;
  case Ausrichtung of
    horizontal:Veraendern:=@Xpixel;
    vertikal  :Veraendern:=@Ypixel;
    else runerror;
  end;
  Xpixel:=RandPixel;
  Ypixel:=RandPixel;
  inc(Veraendern^,AbstandPixel);
  for w:=1 to ButtonArray.Anzahl do begin
    button:=ButtonArray.p^[w];
    if button=nil then inc(Veraendern^,LueckePixel) else begin
      MoveWindow(Button^.hwindow, Xpixel,Ypixel, button^.height, button^.width, true);
      if Ausrichtung=vertikal then begin
        inc(Veraendern^, Button^.height+AbstandPixel);
        Breite:=max(Breite,Button^.width);
      end else begin
        inc(Veraendern^, Button^.width +AbstandPixel);
        Hoehe:=max(Hoehe,Button^.height);
      end;
    end;
  end;
  dec(Veraendern^,RandPixel);
  if Ausrichtung=vertikal then Hoehe:=Ypixel
                          else Breite:=Xpixel;
  inc(Hoehe,2*RandPixel+2);  {+2 wegen border}
  inc(Breite,2*RandPixel+2);
END;

function TAbstractButtonZeile.GetClassName: PChar;
begin
  GetClassName := 'ButtonZeile';
end;

procedure TAbstractButtonZeile.GetWindowClass(var WndClass: TWndClass);
begin
  inherited GetWindowClass(WndClass);
  with WndClass do
    hbrBackGround := GetStockObject(LtGray_Brush);
end;

FUNCTION TAbstractButtonZeile.cm2button(cm:word):PButton;
BEGIN
  cm2button:=ButtonArray.cm2button(cm);
END;

procedure TAbstractButtonZeile.WMDrawItem(var Msg: TMessage);
var
  Tool: PSpeedButton;
  MemDC: hDC;
  OldBMP: hBitmap;
  x,y: Integer;
begin
  with PDrawItemStruct(Msg.lParam)^ do
  begin
    Tool := PSpeedButton(ChildWithID(CtlID));
    MemDC := CreateCompatibleDC(hDC);
    if (ItemState and ODS_Selected) <> 0
      then OldBMP := SelectObject(MemDC,Tool^.BMP_g)
      else OldBMP := SelectObject(MemDC,Tool^.BMP_n);
    BitBlt(hDC, 0, 0, Tool^.Width, Tool^.Height, MemDC, 0, 0, SrcCopy);
    SelectObject(MemDC,OldBMP);
    DeleteDC(MemDC);
  end;
end;

procedure TAbstractButtonZeile.WMSetFocus(var Msg: TMessage);
begin
  SetFocus(Msg.wParam);
end;


END.
