{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 95

 Inhalt: TFehlerArray ist eine Datenstruktur, in der mehrere
         Fehler-Beschreibungs-Texte gespeichert werden knnen.

 Referenzen: Dieses Modul wird von allen Modulen, die die
             Datenkonsistenz der PLN-Datenstrukturen prfen,
             importiert.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT AbsCheck;

INTERFACE
USES heap;

TYPE TFehlerSchwere=(warning,error,fatal);
     {TFehlerSchwere klassifiziert Fehler.
      warning: ein Fehler, der beim Eingeben auftauchen darf und
               die Programmstabilitt nicht beeinflut;
               Beispiel: Kreuzung auf freier Strecke
      error:   ein schwehrer Fehler, der eigentlich nicht vom
               Programm erzeugt werden werden duerften,
               aber auch nicht zum Abstrurz fueren sollten,
               wenn alle Algorithmen fehlertolerant wren;
               Beispiel: Rckwrtsfahrt
      fatal:   fehler, die nie auftreten drfen, weil sie das
               Programm z.B. via Range-Check zum Abstrurz
               brchten.
               Beispiel: Linienfarbe=42}

TYPE PDatenFehler=^RDatenFehler;
     RDatenFehler=RECORD
                    Schwere:TFehlerSchwere;
                    Beschreibung:string[255];
                  END;
     {RDatenFehler beschreibt genau einen Fehler}

TYPE TFehlerArray=OBJECT(TRecordArray)
                    CONSTRUCTOR init;
                    PROCEDURE Dazu(schwere:TFehlerSchwere; s:string);
                    FUNCTION GetRec(w:word):PDatenFehler;
                  END;
     {TFehlerArray ist ein dynamisches Array ueber RDatenFehler}


IMPLEMENTATION

{Konstruktoraufruf muss vor dem Aufruf des eigentlichen Check-
 Algorithmus geschehen}
CONSTRUCTOR TFehlerArray.init;
BEGIN
  inherited init(sizeof(RDatenFehler));
END;

{Fuegt einen Fehler an das Array an}
PROCEDURE TFehlerArray.Dazu(schwere:TFehlerSchwere; s:string);
VAR rp:^RDatenFehler;
BEGIN
  new(rp);
  rp^.Schwere:=Schwere;
  rp^.beschreibung:=s;
  Append(rp);
END;

{Liefert einen Zeiger auf das w-te Fehlerrecord}
FUNCTION TFehlerArray.GetRec(w:word):PDatenFehler;
BEGIN
  GetRec:=p^[w];
END;


END.
