{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: "TSimpleLineArray" ist ein dynamisches Array ueber
         Objekte "TSimpleLine", die im wesentlichen Records
         "RLineData" beinhalten, in denen sich z.B. das
         Objekt vom Typ TStreckenArray befindet.
         Der Aufwand ist vergleichsweise gross, weil im
         Fahrplaneditor eine erweiterte Version von "TSimpleLine"
         benutzt wird, die einen Zeiger auf das Editorfenster
         mitverwaltet.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT AbsLinAr;

INTERFACE
USES heap, nodeedge, Strecke;


TYPE PLineData=^RLineData;
     RLineData=RECORD
                 name:string[80];     {Name der Linie}
                 Farbe:TGraphenFarbe; {Faerbung der Linie im Netzfenster}
                 anfang,ende:Pnode;   {Anfangs-/Endbahnhof der Linie}
                 StreckenArray:TStreckenArray; {Array ber alle Bahnhfe in der Linie}
               END;

TYPE PSimpleLine=^TSimpleLine;
     TSimpleLine=OBJECT
                   LineData:RLineData;
                   CONSTRUCTOR init(aAnfang,aEnde:Pnode; const aName:string; aFarbe:TGraphenFarbe);
                   DESTRUCTOR done; virtual;
                 END;

{Array ueber Linien}
TYPE PSimpleLineArray=^TSimpleLineArray;
     TSimpleLineArray=OBJECT
                        TheArray:TDynArray;
                        CONSTRUCTOR init;
                        DESTRUCTOR done; virtual;
                        PROCEDURE LinieDazu(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe);
                        PROCEDURE LinieLoeschen(nr:word);
                        FUNCTION InitLine(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe):PSimpleLine; virtual;
                        FUNCTION GetLineData(nr:word):PLineData;
                        FUNCTION GetAnzahl:word;
                      private
                        FUNCTION GetSimpleLine(nr:word):PSimpleLine;
                      END;


IMPLEMENTATION

{**************************************** SimpleLine *********************************}

CONSTRUCTOR TSimpleLine.init(aAnfang,aEnde:Pnode; const aName:string; aFarbe:TGraphenFarbe);
VAR s:string;
    w,fuck:word;
TYPE aRGB=array [0..3] of byte;
BEGIN
  with LineData do begin
{Felder vollmachen}
    name:=aName;
    Farbe:=aFarbe;
    anfang:=aAnfang;
    ende:=aEnde;
{Unterobjekte initialisieren}
    StreckenArray.init;
    StreckenArray.Aufbauen(aAnfang,aEnde,aFarbe);
  end;
END;

DESTRUCTOR TSimpleLine.done;
BEGIN
  LineData.StreckenArray.done;
END;

{******************************** LinienArray ********************************}

CONSTRUCTOR TSimpleLineArray.init;
BEGIN
  TheArray.init;
END;

DESTRUCTOR TSimpleLineArray.done;
VAR w:word;
BEGIN
  for w:=1 to TheArray.anzahl do dispose(PSimpleLine(TheArray.p^[w]),done);
  TheArray.done;
END;

FUNCTION TSimpleLineArray.InitLine(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe):PSimpleLine;
BEGIN
  InitLine:=new(PSimpleLine,init(anfang,ende,Name,Farbe));
END;

PROCEDURE TSimpleLineArray.LinieDazu(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe);
BEGIN
  TheArray.append(InitLine(anfang,ende, name, Farbe));
END;

PROCEDURE TSimpleLineArray.LinieLoeschen(nr:word);
VAR Line:PSimpleLine;
BEGIN
  Line:=GetSimpleLine(nr);
  dispose(Line,done);
  TheArray.delete(nr);
END;

FUNCTION TSimpleLineArray.GetSimpleLine(nr:word):PSimpleLine;
BEGIN
  if (nr=0) or (nr>TheArray.anzahl) then runerror;
  GetSimpleLine:=TheArray.p^[nr]
END;

FUNCTION TSimpleLineArray.GetLineData(nr:word):PLineData;
BEGIN
  GetLineData:=@GetSimpleLine(nr)^.LineData;
END;

FUNCTION TSimpleLineArray.GetAnzahl:word;
BEGIN
  GetAnzahl:=TheArray.Anzahl;
END;


END.
