{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: Abstrakter Objekttyp fuer Optionen-Dialogfenster
         Objekttypen fuer INI-Dateien-Daten
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT AbstOpt;

INTERFACE
USES WinTypes, heap, Base_Wnd, oDialogs, oWindows, win_allg;

TYPE TAbstractOption=OBJECT
                       CONSTRUCTOR init(app,key:pchar);
                       FUNCTION GetPrivateProfileString
                                (Default: PChar; ReturnedString: PChar; Size:Integer):integer;
                       FUNCTION WritePrivateProfileString(s:PChar): Bool;
                     PRIVATE
                       ApplicationName, KeyName:pchar;
                     END;

TYPE AOptionenTabelle=array [byte] of pchar;
     PEnumOption=^TEnumOption;
     TEnumOption=OBJECT(TAbstractOption)
                   CONSTRUCTOR init(app,key:pchar; Default:byte; VAR Tabelle:array of pchar);
                   PROCEDURE SetValue(v:byte);
                   FUNCTION GetValue:byte;
                 PRIVATE
                   Value:byte;
                   TabPtr:^AOptionenTabelle;
                   MaxTab:byte;  {=high(Tabelle)}
                   FUNCTION GetTabString(index:byte):pchar;
                 END;

TYPE PBoolOption=^TBoolOption;
     TBoolOption=OBJECT(TEnumOption)
                   CONSTRUCTOR init(app,key:pchar; Default:boolean);
                   PROCEDURE SetValue(v:boolean);
                   FUNCTION GetValue:boolean;
                 END;

TYPE PIntegerOption=^TIntegerOption;
     TIntegerOption=OBJECT(TAbstractOption)
                      CONSTRUCTOR init(app,key:pchar; Default:integer; min,max:integer);
                      FUNCTION GetPrivateProfileInt(Default:integer):integer;
                      PROCEDURE SetValue(neu:integer);
                      FUNCTION GetValue:integer;
                    PRIVATE
                      Value:integer;
                      MinValue,MaxValue:integer;
                    END;

TYPE PStringOption=^TStringOption;
     TStringOption=OBJECT(TAbstractOption)
                     CONSTRUCTOR init(app,key:pchar; Default:pchar; TheMaxChars:word);
                     PROCEDURE SetValue(neu:pchar);
                     FUNCTION GetValue:pchar;
                   PRIVATE
                     MaxChars:word;
                     Value:pchar;
                   END;

CONST INIFileName:pchar=nil;


TYPE POptionDialog=^TOptionDialog;
     POptionControl=^TOptionControl;
     TOptionControl=OBJECT
                     CONSTRUCTOR init(parent:POptionDialog);
                     PROCEDURE Setup;        virtual;
                     FUNCTION Test:boolean;  virtual;
                     PROCEDURE OK;           virtual;
                   END;
     TOptionDialog=OBJECT(TDialog)
                     CONSTRUCTOR init(AParent: PWindowsObject; AName:PChar; HT:THilfeThema);
                     DESTRUCTOR done;       virtual;
                     PROCEDURE SetupWindow; virtual;
                     PROCEDURE OK(VAR Msg:TMessage); virtual id_first+id_ok;
                     PROCEDURE IDHilfe(VAR Msg:TMessage);   virtual  id_first+998;
                   PRIVATE
                     Options:TDynArray;
                     HilfeThema:THilfeThema;
                     FUNCTION GetOption(nr:word):POptionControl;
                     PROCEDURE AddOption(o:POptionControl);
                   END;

TYPE TEnumOptionControl=OBJECT(TOptionControl)
                          CONSTRUCTOR init(parent:POptionDialog; id:word; Option:PEnumOption);
                          PROCEDURE Setup;        virtual;
                          PROCEDURE OK;           virtual;
                        PRIVATE
                          EnumOption:PEnumOption;
                          RadioButtons:array [0..42] of PRadioButton;
                        END;

     TIntegerOptionControl=OBJECT(TOptionControl)
                             CONSTRUCTOR init(parent:POptionDialog; id:word; Option:PIntegerOption);
                             PROCEDURE Setup;        virtual;
                             FUNCTION Test:boolean;  virtual;
                             PROCEDURE OK;           virtual;
                           PRIVATE
                             IntegerOption:PIntegerOption;
                             NumericEdit:PNumericEdit;
                           END;

     TBoolOptionControl=OBJECT(TOptionControl)
                          CONSTRUCTOR init(parent:POptionDialog; id:word; Option:PBoolOption);
                          PROCEDURE Setup;        virtual;
                          PROCEDURE OK;           virtual;
                        PRIVATE
                          BoolOption:PBoolOption;
                          CheckBox:PCheckBox;
                        END;

     TStringOptionControl=OBJECT(TOptionControl)
                            CONSTRUCTOR init(parent:POptionDialog; id:word; Option:PStringOption);
                            PROCEDURE Setup;     virtual;
                            PROCEDURE OK;        virtual;
                          PRIVATE
                            StringOption:PStringOption;
                            Edit:PEdit;
                          END;


IMPLEMENTATION
USES WinProcs, Strings, Objects, grund;

{************************* Abstract *************************}

CONSTRUCTOR TAbstractOption.init(app,key:pchar);
BEGIN
  ApplicationName:=app;
  KeyName:=key;
END;

FUNCTION TAbstractOption.GetPrivateProfileString(Default:PChar; ReturnedString:PChar; Size:Integer):integer;
BEGIN
  GetPrivateProfileString:=WinProcs.GetPrivateProfileString
    (ApplicationName, KeyName, Default, ReturnedString, Size, INIFileName);
END;

FUNCTION TAbstractOption.WritePrivateProfileString(s:PChar): Bool;
BEGIN
  WritePrivateProfileString:=WinProcs.WritePrivateProfileString(ApplicationName, KeyName, s, INIFileName);
END;

{*********************** Enum ******************************}

CONSTRUCTOR TEnumOption.init(app,key:pchar; Default:byte; VAR Tabelle:array of pchar);
VAR buffer:array [0..100] of char;
    b:byte;
BEGIN
  inherited init(app,key);
  if low(Tabelle)<>0 then runerror;
  MaxTab:=high(Tabelle);
  TabPtr:=pointer(@Tabelle);
  GetPrivateProfileString(GetTabString(Default), Buffer, high(Buffer));
  for b:=0 to MaxTab do if StrComp(GetTabString(b), Buffer)=0 then begin
    Value:=b;
    exit;
  end;
  SetValue(Default);  {ungueltiger String -> default in Datei schreiben}
END;

FUNCTION TEnumOption.GetTabString(index:byte):pchar;
BEGIN
  if index>maxtab then runerror;
  GetTabString:=TabPtr^[index];
END;

PROCEDURE TEnumOption.SetValue(v:byte);
BEGIN
  Value:=v;
  WritePrivateProfileString(GetTabString(v));
END;

FUNCTION TEnumOption.GetValue:byte;
BEGIN
  GetValue:=Value;
END;

{********************** Boolean ****************************}

CONSTRUCTOR TBoolOption.init(app,key:pchar; Default:boolean);
CONST BoolTabelle:Array [boolean] of pchar=('nein', 'ja');
BEGIN
  inherited init(app,key, byte(Default), BoolTabelle);
END;

PROCEDURE TBoolOption.SetValue(v:boolean);
BEGIN
  inherited SetValue(byte(v));
END;

FUNCTION TBoolOption.GetValue:boolean;
BEGIN
  GetValue:=boolean(inherited GetValue);
END;

{*********************************** Integer **************************}

CONSTRUCTOR TIntegerOption.init(app,key:pchar; Default:integer; min,max:integer);
VAR Buffer:integer;
BEGIN
  inherited init(app,key);
  Buffer:=GetPrivateProfileInt(Default);
  MinValue:=min;
  MaxValue:=max;
  if (Buffer>=min) and (Buffer<=max)
    then Value:=Buffer
    else Value:=Default;
END;

FUNCTION TIntegerOption.GetPrivateProfileInt(Default:integer):integer;
BEGIN
  GetPrivateProfileInt:=WinProcs.GetPrivateProfileInt(ApplicationName, KeyName, Default, INIFileName);
END;

PROCEDURE TIntegerOption.SetValue(neu:integer);
VAR Buffer:array [0..6] of char;
BEGIN
  if (neu<MinValue) or (neu>MaxValue) then runerror;
  Value:=neu;
  str(neu,Buffer);
  WritePrivateProfileString(Buffer);
END;

FUNCTION TIntegerOption.GetValue:integer;
BEGIN
  GetValue:=Value;
END;

{********************************* String *****************************}

CONSTRUCTOR TStringOption.init(app,key:pchar; Default:pchar; TheMaxChars:word);
VAR Buffer:pchar;
BEGIN
  inherited init(app,key);
  getmem(buffer, TheMaxChars+1);
  GetPrivateProfileString(Default, Buffer, MaxChars);
  Value:=Strings.StrNew(Buffer);
  freemem(buffer, TheMaxchars+1);
  Maxchars:=TheMaxChars;
END;

PROCEDURE TStringOption.SetValue(neu:pchar);
BEGIN
  if Value<>nil then Strings.StrDispose(Value);
  Value:=Strings.StrNew(neu);
  WritePrivateProfileString(Value);
END;

FUNCTION TStringOption.GetValue:pchar;
BEGIN
  GetValue:=Value;
END;

{********************************* OptionControl **************************}

CONSTRUCTOR TOptionControl.init(parent:POptionDialog);
BEGIN
  parent^.AddOption(@self);
END;

PROCEDURE TOptionControl.Setup;
BEGIN abstract; END;

FUNCTION TOptionControl.Test:boolean;
BEGIN Test:=true; END;

PROCEDURE TOptionControl.OK;
BEGIN abstract; END;

{********************************* OptionDialog *************************}

CONSTRUCTOR TOptionDialog.init(AParent: PWindowsObject; AName:PChar; HT:THilfeThema);
BEGIN
  Options.init;
  inherited init(AParent, AName);
  DisableTransfer;
  HilfeThema:=HT;
END;

DESTRUCTOR TOptionDialog.done;
BEGIN
  Options.done;
  inherited done;
END;

PROCEDURE TOptionDialog.SetupWindow;
VAR w:word;
BEGIN
  inherited SetupWindow;
  for w:=1 to Options.anzahl do GetOption(w)^.Setup;
END;

PROCEDURE TOptionDialog.OK(VAR Msg:TMessage);
VAR w:word;
BEGIN
  for w:=1 to Options.anzahl do if  not GetOption(w)^.Test then exit;
  for w:=1 to Options.anzahl do GetOption(w)^.OK;
  inherited ok(msg);
END;

PROCEDURE TOptionDialog.IDHilfe(VAR Msg:TMessage);
BEGIN
  Hilfe(HilfeThema);
END;

PROCEDURE TOptionDialog.AddOption(o:POptionControl);
BEGIN
  Options.append(o);
END;

FUNCTION TOptionDialog.GetOption(nr:word):POptionControl;
BEGIN
  if (nr<1) or (nr>Options.Anzahl) then runerror;
  GetOption:=Options.p^[nr];
END;

{*************************** EnumControl ****************************}

CONSTRUCTOR TEnumOptionControl.init(parent:POptionDialog; id:word; Option:PEnumOption);
VAR w:word;
BEGIN
  inherited init(parent);
  EnumOption:=Option;
  if option^.MaxTab>high(RadioButtons) then runerror;
  for w:=0 to option^.MaxTab do new(RadioButtons[w], InitResource(parent, id+w));
END;

PROCEDURE TEnumOptionControl.Setup;
VAR w:word;
    pos:word;
BEGIN
  pos:=EnumOption^.GetValue;
  for w:=0 to EnumOption^.MaxTab do RadioButtons[w]^.SetCheck(byte(pos=w));
END;

PROCEDURE TEnumOptionControl.OK;
VAR w:word;
    AnzahlTreffer:word;
BEGIN
  AnzahlTreffer:=0;
  for w:=0 to EnumOption^.MaxTab do if (RadioButtons[w]^.GetCheck=1) then begin
    EnumOption^.SetValue(w);
    inc(AnzahlTreffer);
  end;
  if AnzahlTreffer<>1 then runerror;
END;

{*************************************** IntegerControl *****************************}

CONSTRUCTOR TIntegerOptionControl.init(parent:POptionDialog; id:word; Option:PIntegerOption);
BEGIN
  inherited init(parent);
  IntegerOption:=Option;
  new(NumericEdit, InitResource(parent, id, Option^.MinValue, Option^.MaxValue, 6));
END;

PROCEDURE TIntegerOptionControl.Setup;
BEGIN
  NumericEdit^.SetValue(IntegerOption^.GetValue);
END;

FUNCTION TIntegerOptionControl.Test:boolean;
BEGIN
  Test:=NumericEdit^.CanClose;
END;

PROCEDURE TIntegerOptionControl.OK;
VAR Buffer:integer;
BEGIN
  NumericEdit^.GetValue(Buffer);
  IntegerOption^.SetValue(Buffer);
END;

{************************************* BoolOption ***********************************}

CONSTRUCTOR TBoolOptionControl.init(parent:POptionDialog; id:word; Option:PBoolOption);
BEGIN
  inherited init(parent);
  BoolOption:=Option;
  new(CheckBox, InitResource(parent, id));
END;

PROCEDURE TBoolOptionControl.Setup;
BEGIN
  CheckBox^.SetCheck(byte(BoolOption^.GetValue));
END;

PROCEDURE TBoolOptionControl.OK;
BEGIN
  BoolOption^.SetValue(boolean(CheckBox^.GetCheck));
END;

{*********************************** StringOption ***********************************}

CONSTRUCTOR TStringOptionControl.init(parent:POptionDialog; id:word; Option:PStringOption);
BEGIN
  inherited init(parent);
  StringOption:=Option;
  new(Edit, InitResource(parent, id, Option^.MaxChars+1));
END;

PROCEDURE TStringOptionControl.Setup;
BEGIN
  Edit^.SetText(StringOption^.GetValue);
END;

PROCEDURE TStringOptionControl.OK;
VAR bytes:word;
    temp:pchar;
BEGIN
  bytes:=Edit^.GetTextLen+1;
  bytes:=min(bytes, StringOption^.MaxChars+1);
  getmem(temp, bytes);
  Edit^.GetText(temp, bytes);
  StringOption^.SetValue(temp);
  freemem(temp, bytes);
END;


END.
