{Projekt: FAHRPLAN

 Autor: Stefan Bormann 94

 Inhalt: Ein abstraktes Sheetfenster, dass ein Vorfahre fr das das Netzsheet und
         das Sheet des Editorfensters implementiert. Dieses Objekt abstrahiert
         Mausbotschaften.
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Abst_Sht;

INTERFACE
USES oWindows, WinTypes;

TYPE TAbstractSheetCapture=(left,right,none);
TYPE TAbstractSheet=OBJECT(TWindow)
                      Capture:TAbstractSheetCapture;
                              {none      kein Capture, Fenster ist idle oder zwischen
                                         zwei Eingaben;
                               left      linke Taste einfach gedrckt, maus gecaptured;
                               right     rechte Taste einfach gedrckt, maus gecaptured}
                      MouseCursor:TPoint;     {enthlt die letzte festgestellte Mausposition
                               relativ zum Fensterursprung}
                      MouseInWindow:boolean; {ist true, wenn MouseCursor Koordinate im
                               Clientbereich des Fensters enthlt}
                      CONSTRUCTOR init(aparent:PWindow);
                    {zum berflssig machen des berschreibens}
                      FUNCTION GetClassName:pchar; virtual;
                      PROCEDURE getWindowclass(var awndclass:twndclass); virtual;
                    {zum berflssig machen des berschreibens}
                      PROCEDURE WMlButtonDown  (VAR Msg:TMessage); virtual wm_first+wm_lButtonDown;
                      PROCEDURE WMlButtonUp    (VAR Msg:TMessage); virtual wm_first+wm_lButtonUp;
                      PROCEDURE WMlButtonDblClk(VAR Msg:TMessage); virtual wm_first+wm_lButtonDblClk;
                      PROCEDURE WMrButtonDown  (VAR Msg:TMessage); virtual wm_first+wm_rButtonDown;
                      PROCEDURE WMrButtonUp    (VAR Msg:TMessage); virtual wm_first+wm_rButtonUp;
                      PROCEDURE WMrButtonDblClk(VAR Msg:TMessage); virtual wm_first+wm_rButtonDblClk;
                      PROCEDURE WMMouseMove    (VAR Msg:TMessage); virtual wm_first+wm_MouseMove;
                      PROCEDURE WMSetCursor    (VAR Msg:TMessage); virtual wm_first+wm_SetCursor;
                    {zum berschreiben}
                      PROCEDURE lButtonDown;      virtual;
                      PROCEDURE lButtonUp;        virtual;
                      PROCEDURE rButtonDown;      virtual;
                      PROCEDURE rButtonUp;        virtual;
                      PROCEDURE DoubleClick;      virtual;
                      PROCEDURE MouseMove;        virtual;
                      FUNCTION SetCursor:boolean; virtual;
                          {Rckgabewert: true:  Funktion hat Cursor gesetzt
                                         false: Cursor muss noch gesetzt werden}
                    PRIVATE
                      PROCEDURE CalcMouseCursor(x,y:integer);
                      PROCEDURE SetState(neu:TAbstractSheetCapture; x,y:integer);
                    END;


IMPLEMENTATION
USES WinProcs, objects;


CONSTRUCTOR TAbstractSheet.init(aparent:PWindow);
BEGIN
  inherited init(aparent, 'Sheet');
  Attr.Style := ws_Border or ws_Child or ws_Visible;
  Capture:=none;
  MouseInWindow:=false;
  MouseCursor.x:=-42; {macht das Sinn? Vieleicht:Falls jemand die werte benutzt erntet er Var out of Range}
  MouseCursor.y:=-42;
END;

FUNCTION TAbstractSheet.GetClassName:pchar;
BEGIN
  getclassname:='Sheet';
END;

PROCEDURE TAbstractSheet.getwindowclass(var awndclass:twndclass);
BEGIN
  inherited getwindowclass(awndclass);
  with awndclass do  style:=style or cs_dblclks or cs_Vredraw or cs_Hredraw;
END;


PROCEDURE TAbstractSheet.CalcMouseCursor(x,y:integer);
VAR ClientRect:TRect;
BEGIN
  MouseCursor.x:=x;
  MouseCursor.y:=y;
  GetClientRect(hWindow, ClientRect);
  MouseInWindow:=PtInRect(ClientRect, MouseCursor);
END;

PROCEDURE TAbstractSheet.SetState(neu:TAbstractSheetCapture; x,y:integer);
BEGIN
  case neu of
    left,right:SetCapture(hWindow);
    none:ReleaseCapture;
  end;
  Capture:=neu;
  CalcMouseCursor(x,y);
END;


PROCEDURE TAbstractSheet.WMlButtonDown(VAR Msg:TMessage);
BEGIN
  case Capture of
    none:begin
           SetState(left, integer(Msg.lParamLo), integer(Msg.lParamHi));
           lButtonDown;
         end;
    right:;
    left:; {kein runerror, weil Windows Botschaften verschlucken kann}
    else runerror;
  end;
  inherited WMlButtonDown(Msg);
END;

PROCEDURE TAbstractSheet.WMlButtonUp    (VAR Msg:TMessage);
BEGIN
  if Capture=left then begin
    SetState(none, integer(Msg.lParamLo), integer(Msg.lParamHi));
    lButtonUp;
  end;
END;

PROCEDURE TAbstractSheet.WMlButtonDblClk(VAR Msg:TMessage);
BEGIN
  if Capture=none then begin
    CalcMouseCursor(integer(Msg.lParamLo), integer(Msg.lParamHi));
    DoubleClick;
  end;
END;

PROCEDURE TAbstractSheet.WMrButtonDown(VAR Msg:TMessage);
BEGIN
  case Capture of
    none:begin
           SetState(right, integer(Msg.lParamLo), integer(Msg.lParamHi));
           rButtonDown;
         end;
    right:; {kein runerror, weil Windows Botschaften verschlucken kann}
    left:;
    else runerror;
  end;
END;

PROCEDURE TAbstractSheet.WMrButtonUp(VAR Msg:TMessage);
BEGIN
  if Capture=right then begin
    SetState(none, integer(Msg.lParamLo), integer(Msg.lParamHi));
    rButtonUp;
  end;
END;

PROCEDURE TAbstractSheet.WMrButtonDblClk(VAR Msg:TMessage);
BEGIN
  if Capture=none then begin
    CalcMouseCursor(integer(msg.lParamLo), integer(msg.lParamHi));
    DoubleClick;
  end;
END;

PROCEDURE TAbstractSheet.WMMouseMove(VAR Msg:TMessage);
BEGIN
  CalcMouseCursor(integer(msg.lParamLo), integer(msg.lParamHi));
  MouseMove;
END;

PROCEDURE TAbstractSheet.WMSetCursor(VAR Msg:TMessage);
VAR default:boolean;
    Punkt:TPoint;
BEGIN
  If Msg.lParamLo=HtClient then begin
    GetCursorPos(Punkt);
    ScreenToClient(hWindow, Punkt);
    CalcMouseCursor(Punkt.x, Punkt.y);
    default:=not self.SetCursor;
  end else default:=true;
  if default then DefWindowProc(Hwindow, Msg.Message, Msg.WParam, Msg.LParam);
END;


PROCEDURE TAbstractSheet.lButtonDown;
BEGIN  END;

PROCEDURE TAbstractSheet.lButtonUp;
BEGIN  END;

PROCEDURE TAbstractSheet.rButtonDown;
BEGIN  END;

PROCEDURE TAbstractSheet.rButtonUp;
BEGIN  END;

PROCEDURE TAbstractSheet.DoubleClick;
BEGIN  END;

PROCEDURE TAbstractSheet.MouseMove;
BEGIN  END;

FUNCTION TAbstractSheet.SetCursor:boolean;
BEGIN
  SetCursor:=false;
END;


END.
