{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: Das Objekt vom Typ TGraph fasst ein Array ber die Knoten und ein
         Array ber die Kanten zusammen.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT Graph;

INTERFACE
USES nodeedge, Knoten, heap, AbsCheck;

TYPE PGraph=^TGraph;
     TGraph=OBJECT
              KnotenArray:TKnotenArray;
              KantenArray:RecordArrayObj;
              CONSTRUCTOR init;
              DESTRUCTOR done;
              FUNCTION GraphenFaerbung(von,nach:word; Farbe:TGraphenFarbe):boolean;
              PROCEDURE FarbeLoeschen(Farbe:TGraphenFarbe);
              {FUNCTION BfNr2KnotenNr(bfnr:word):word;}
              FUNCTION KnotenDazu(wohin:RRelPunkt; nachbar:word):word;
              PROCEDURE KillKnoten(welchen:word);
              FUNCTION SuchKanteZwischenKnoten(node1,node2:PNode):PEdge;
              {PROCEDURE WriteAll;}
              PROCEDURE CheckGraph(VAR fehler:TFehlerArray);
            PRIVATE
              ZielKnoten:Pnode;
              NeueFarbe:TGraphenFarbe;
              FUNCTION FaerbRekurs(nextnode,oldnode:Pnode):boolean;
            END;


IMPLEMENTATION
USES Win_Allg, grund;


CONSTRUCTOR TGraph.init;
BEGIN
  KantenArray.init(sizeof(Redge));
  KnotenArray.init;
END;

DESTRUCTOR TGraph.done;
BEGIN
  KantenArray.done;
  KnotenArray.done;
END;

FUNCTION TGraph.FaerbRekurs(nextnode,oldnode:Pnode):boolean;
VAR w:word;
    n:Pnode;
    ep:Pedge;
BEGIN
  if nextnode=ZielKnoten then FaerbRekurs:=true   {Ende der neuen Linie gefunden}
  else with nextnode^ do begin
    for w:=1 to anzahl do begin
      n:=GetNode(w);  {neu zu testtende Richtung}
      if n=nil then runerror;    {schon wegen der Sicherheit}
      if (n<>oldnode) then begin {zurueckgehen wolln wir nich}
        ep:=GetEdge(w);
        if (ep^.Faerbung.f2=schwarz) and {noch nicht zweimal gefaerbt?}
           FaerbRekurs(n,nextnode) {irgendwo weiter hinten auf das Ziel getroffen}
        then begin                 {Faerben}
          with (ep^.Faerbung) do
            if f1=schwarz then f1:=NeueFarbe  {Erstfaerbung}
                          else f2:=NeueFarbe; {Zweitfaerbung}
          FaerbRekurs:=true;    {Weg als richtig markieren}
          exit;                 {verdammtnochmal, nicht weitersuchen!!!!!!!!?!}
        end;
      end;
    end;
    FaerbRekurs:=false;
  end;
END;

FUNCTION TGraph.GraphenFaerbung(von,nach:word; farbe:TGraphenFarbe):boolean;
BEGIN
  if (von=0) or (nach=0) or
     (von>KnotenArray.anzahl) or (nach>KnotenArray.anzahl) or
     (von=nach) then runerror;
  ZielKnoten:=KnotenArray.p^[nach];
  Neuefarbe:=farbe;
  GraphenFaerbung:=FaerbRekurs(KnotenArray.p^[von],nil);
END;

PROCEDURE TGraph.FarbeLoeschen(Farbe:TGraphenFarbe);
VAR w:word;
BEGIN
  for w:=1 to KantenArray.anzahl do with PEdge(KantenArray.p^[w])^.Faerbung do begin
    if f2=Farbe then f2:=schwarz
    else if f1=Farbe then begin
      f1:=f2;
      f2:=schwarz;
    end;
  end;
END;
{
FUNCTION TGraph.BfNr2KnotenNr(bfnr:word):word;
VAR w:word;
BEGIN
  for w:=1 to KnotenArray.anzahl do
    if Pnode(KnotenArray.p^[w])^.Bahnhof=bfnr then begin
      BfNr2KnotenNr:=w;
      exit;
    end;
  BfNr2KnotenNr:=0;
END;
}
{Rueckgabewert ist die Arrayposition, an der der neue Knoten eingefuegt wurde}
FUNCTION TGraph.KnotenDazu(wohin:RRelPunkt; nachbar:word):word;
VAR n:Pnode;
    e:Pedge;
    w:word;
BEGIN
{neuen Knoten erzeugen:}
  new(n,init(wohin));
  KnotenArray.append(n);
  KnotenDazu:=KnotenArray.anzahl;
{Kante erzeugen und bei beiden Knoten eintragen:}
  if (nachbar<>0) then begin
    e:=initedge(n,KnotenArray.p^[nachbar]);    {Neue Verbindungskante erzeugen}
    n^.append(e);                              {Kante beim neuen Knoten eintragen}
    KnotenArray.GetRec(nachbar)^.append(e);     {Kante beim Nachbarknoten eintragen}
    KantenArray.append(e);                     {Kante im Kantenarray eintragen}
  end;
END;

PROCEDURE TGraph.KillKnoten(welchen:word);
VAR n1,n2:Pnode;
    ep:Pedge;
    w:word;
BEGIN
  n1:=KnotenArray.p^[welchen];
  if n1^.anzahl<>1 then runerror;  {muss Blatt sein}
  n2:=n1^.GetNode(1);     {Nachbarknoten}
  ep:=n1^.GetEdge(1);     {Kante zum Nachbarknoten}
{Knoten lschen}
  KnotenArray.delete(welchen);
  dispose(n1,done);
{Kante zum Nachbarknoten lschen}
  w:=KantenArray.Position(ep);  {wo ist die Kante im Kantenarray}
  KantenArray.delete(w);        {Arrayposition eliminieren}
  dispose(ep);                  {Kante killen}
{Kante beim Nachbarknoten lschen}
  w:=n2^.Position(ep);          {wo ist die Kante im Array des Nachbarknotens}
  n2^.delete(w);                {KantenReferenz im Nachbarknoten eliminieren}
END;

FUNCTION TGraph.SuchKanteZwischenKnoten(node1,node2:PNode):PEdge;
VAR w:word;
    edge:PEdge;
BEGIN
  for w:=1 to KantenArray.anzahl do begin
    edge:=KantenArray.p^[w];
    if ((edge^.n1=node1) and (edge^.n2=node2)) or
       ((edge^.n1=node2) and (edge^.n2=node1)) then begin
      SuchKanteZwischenKnoten:=edge;
      exit;
    end;
  end;
  SuchKanteZwischenKnoten:=nil;
END;



{$R-,Q-}  {Ich will den Fehler auch sehen, kein runerror}
PROCEDURE TGraph.CheckGraph(VAR fehler:TFehlerArray);

 Function Zyklus(von, nach:PNode):boolean;
 Var w:word;
     temp:PNode;
     z:boolean;
 Begin
   if nach^.work=1 then Zyklus:=true else begin
     nach^.work:=1;
     for w:=1 to nach^.anzahl do begin
       temp:=nach^.GetNode(w);
       if temp<>von then begin
         z:=Zyklus(nach, temp);
         if z then begin
           Zyklus:=true;
           exit;
         end;
       end;
     end;
   end;
   Zyklus:=false;
 End;

VAR w:word;
    flag:boolean;
    scheisse:boolean;
BEGIN
  if KnotenArray.anzahl=0 then begin
    if KantenArray.anzahl<>0 then Fehler.Dazu(fatal, 'Netzgraph hat Kanten, aber keine Knoten!');
  end else if KnotenArray.anzahl<>KantenArray.anzahl+1 then begin
  {Anzahltest}
    Fehler.Dazu(fatal, 'Netzgraph ist kein Baum! Es gilt nicht Knotenzahl=Kantenzahl+1!');
  end else begin
  {Zyklustest}
    for w:=1 to KnotenArray.anzahl do KnotenArray.GetRec(w)^.work:=0;
    if Zyklus(nil, KnotenArray.GetRec(1)) then Fehler.Dazu(fatal, 'Netzgraph hat Zyklus!');
  {getrennter Graph}
    flag:=false;
    for w:=1 to KnotenArray.anzahl do begin
      scheisse:=(KnotenArray.GetRec(w)^.work=0);
      flag:=flag or scheisse;
    end;
    if flag then Fehler.Dazu(fatal, 'Graph ist gespalten!');
  end;
END;
{$R+,Q+}

{
PROCEDURE TGraph.WriteAll;
VAR datei:text;
    w,i:word;
BEGIN
  assign(datei,'d:\debug.txt');
  rewrite(datei);
  writeln(datei,'Knoten:');
  for w:=1 to KnotenArray.anzahl do begin
    writeln(datei,'Knoten Nr.:',w,':');
    with Pnode(KnotenArray.p^[w])^ do begin
      writeln(datei,'Name:',Bahnhof.Daten.Name);
      writeln(datei,'Ort :',Ort.x:1:3,'/',Ort.y:1:3);
      for i:=1 to anzahl do writeln(datei,'i=',i,'  e=',KantenArray.Position(GetEdge(i)));
    end;
  end;
  writeln(datei,'Kanten:');
  for w:=1 to KantenArray.anzahl do with Pedge(KantenArray.p^[w])^ do begin
    writeln(datei,'Kante Nr.',w:2,':');
    writeln(datei,KnotenArray.Position(n1),' <-> ',KnotenArray.Position(n2));
    writeln(datei,'Farbe:',GetGraphenFarbeName(Faerbung.f1),'/',GetGraphenFarbeName(Faerbung.f2));
  end;
  close(datei);
END;
}

END.

