{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt:
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT BfEdDlg;

{$R int_bfed}

INTERFACE
USES oWindows, AbsBfDat;

FUNCTION ExecuteBahnhofsEditor(parent:PWindowsObject; VAR Bahnhof:TBahnhof; MinGleisZahl:word):boolean;


IMPLEMENTATION
USES oDialogs, WinProcs, WinTypes, BfDef, win_allg, base_wnd, heap, grund, bwcc;

{************************** GleisEditor ********************************}

TYPE TGleisEditor=OBJECT(Tdialog)
                    Buffer:RGleisDaten;
                    PROCEDURE SetupWindow;               virtual;
                    PROCEDURE EndDlg(i:integer);         virtual;
                    PROCEDURE IDHilfe(VAR Msg:TMessage); virtual;
                  END;

PROCEDURE TGleisEditor.SetupWindow;
VAR bez:array [0..maxGleisBezeichnung] of char;
    lae:array [0..10] of char;
BEGIN
  String2CharArray(Buffer.Bezeichnung,bez);
  SetWindowText(GetDlgItem(Hwindow,110), bez);
  str(Buffer.NutzLaenge,lae);
  SetWindowText(GetDlgItem(Hwindow,111), lae);
END;

PROCEDURE TGleisEditor.EndDlg(i:integer);
VAR s:string[10];
    l:longint;
    k:integer;
BEGIN
  case i of
   1:with Buffer do begin
       Bezeichnung[0]:=char(GetWindowText(GetDlgItem(Hwindow,110), @Bezeichnung[1], sizeof(Bezeichnung)-1));
                 s[0]:=char(GetWindowText(GetDlgItem(Hwindow,111), @s[1],           sizeof(s)-1));
       {$R-}
       val(s,l,k);
       {$R+}
       if (k<>0) or (l<0) or (l>$FFFF) then begin
         messagebox(hwindow,'Die Nutzlnge mu ein ganzzahliger numerischer Wert (1..65535) sein!',
                            'Eingabefehler',mb_OK+mb_IconHand);
         exit;
       end;
       NutzLaenge:=l;
     end;
   2:;
   else runerror;
  end;
  TDialog.EndDlg(i);
END;

PROCEDURE TGleisEditor.IDHilfe(VAR Msg:TMessage);
BEGIN
  Hilfe(keineHilfe);
END;

{********************************* Bahnhofseditor ********************************}

CONST id_Name=103;
      id_Kuerzel=104;
      id_Eigner=105;
      id_Strecken=106;
      id_drei=114;
      id_vier=115;
      id_fuenf=116;
      id_Gleise=120;
      id_GleisDazu=121;
      id_GleisDel=122;
      id_GleisEdit=123;
      id_BitmapEdit=130;
      id_BitmapView=131;
      id_Info=140;

TYPE TBahnhofsEditor=OBJECT(TDialog)
                Bf:PBahnhof;
                StreckenEdit:PNumericEdit;
                GleiseListbox:PListBox;
                FarbenSchaltfeld:array [TReglerFarbenAnzahl] of PRadioButton;
                InfoEdit:PEdit;
                EditGleise:TRecordArray;
                MinGleisZahl:word;
                CONSTRUCTOR init(aparent:PWindowsObject; abf:PBahnhof; MGZ:word);
                DESTRUCTOR done; virtual;
                PROCEDURE SetupWindow; virtual;
                PROCEDURE OK         (VAR Msg:TMessage); virtual id_first+id_ok;
                PROCEDURE IDGleise   (VAR Msg:TMessage); virtual id_first+id_Gleise;
                PROCEDURE IDGleisDazu(VAR Msg:TMessage); virtual id_first+id_GleisDazu;
                PROCEDURE IDGleisDel (VAR Msg:TMessage); virtual id_first+id_GleisDel;
                PROCEDURE IDGleisEdit(VAR Msg:TMessage); virtual id_first+id_GleisEdit;
                PROCEDURE IDHilfe    (VAR Msg:TMessage); virtual id_first+998;

                PROCEDURE swt(id:word; const s:string);
                PROCEDURE UpdateGleise;
                PROCEDURE gwt(id:word; var s:string);
                FUNCTION GleisEditor(VAR Gleis:RGleisDaten):boolean;
              END;

CONSTRUCTOR TBahnhofsEditor.init(aparent:PWindowsObject; abf:PBahnhof; MGZ:word);
VAR f:TReglerfarbenAnzahl;
    w:word;
    glp:PGleisDaten;
BEGIN
  inherited init(aparent, 'BahnhofsEditor');
  MinGleisZahl:=MGZ;
  bf:=abf;
{Unterfenster-Schnittstellenobjekte initialisieren}
  new(StreckenEdit,  InitResource(@self, id_Strecken, 1, 99, 2));
  new(GleiseListbox, InitResource(@self, id_Gleise));
  for f:=low(f) to high(f) do new(FarbenSchaltfeld[f], InitResource(@self, id_drei-low(f)+f));
  new(InfoEdit, InitResource(@self, id_Info, MaxInt));
{Komplette Kopie der Gleisdaten in eigenen Speicher}
  EditGleise.init(sizeof(RGleisDaten));
  EditGleise.Erweiterung(bf^.AnzahlGleise);
  for w:=1 to bf^.AnzahlGleise do begin
    new(glp);
    glp^:=bf^.GetGleis(w)^;
    EditGleise.p^[w]:=glp;
  end;

  EndDlg(id_ok);
END;

DESTRUCTOR TBahnhofsEditor.done;
BEGIN
  inherited done;
  EditGleise.done;
END;

PROCEDURE TBahnhofsEditor.swt(id:word; const s:string);
VAR temp:string;
BEGIN
  temp:=s+#0;
  SetWindowText(GetDlgItem(hWindow, id), @temp[1]);
END;

PROCEDURE TBahnhofsEditor.UpdateGleise;
VAR w:word;
    s:string;
    flag:boolean;
BEGIN
  GleiseListbox^.ClearList;
  w:=EditGleise.Anzahl;
  flag:=w<>0;
  EnableWindow(GetDlgItem(hWindow, id_GleisEdit), flag);
  EnableWindow(GetDlgItem(hWindow, id_GleisDel), flag);
  for w:=1 to w do begin
    with PGleisDaten(EditGleise.p^[w])^ do begin
      s:=Bezeichnung;
      if NutzLaenge<>0 then s:=s+tab+'['+zahlstr(NutzLaenge,1)+'cm]';
      s:=s+#0;
    end;
    GleiseListbox^.AddString(@s[1]);
  end;
END;

PROCEDURE TBahnhofsEditor.SetupWindow;
VAR Info:pchar;
BEGIN
  inherited SetupWindow;
{allgemeine Daten}
  swt(id_Name,    bf^.Daten.Name);
  swt(id_Kuerzel, bf^.Daten.KurzName);
  swt(id_Eigner,  bf^.Daten.Eigner);
  StreckenEdit^.SetValue(bf^.Daten.Strecken);
  case bf^.Daten.ReglerFarben of
    3,4,5:FarbenSchaltfeld[bf^.Daten.ReglerFarben]^.SetCheck(1);
    else runerror;
  end;
{Gleise}
  UpdateGleise;
{Bitmap}
  {noch nich fertich...}
{Info}
  Info:=bf^.GetInfo;
  if Info<>nil then InfoEdit^.SetText(Info);
END;

PROCEDURE TBahnhofsEditor.gwt(id:word; VAR s:string);
BEGIN
  s[0]:=char(GetWindowText(GetDlgItem(hWindow, id), @s[1], high(s)));
END;

PROCEDURE TBahnhofsEditor.OK(VAR Msg:TMessage);
VAR i:integer;
    w:word;
    f:TReglerFarbenAnzahl;
    glp:PGleisDaten;
    temp:string[maxBahnhofsName];
    NeuInfo:pchar;
BEGIN
{Check, ob Daten sinnvoll sind}
  if not StreckenEdit^.CanClose then exit;
  w:=MinGleisZahl;
  i:=GleiseListBox^.GetCount;
  if (w=0) and (i<1) then begin
    BWCCmessagebox(hWindow, 'Der Bahnhof muss mindestens ein Gleis haben!', 'So gehts nich!', mb_ok+mb_IconHand);
    exit;
  end;
  if (w<>0) and (i<w) then begin
    BWCCmessagebox(hWindow, 'Der Bahnhof hat jetzt weniger Gleise, als im Fahrplan benutzt werden',
                            'So gehts nich!', mb_ok+mb_IconHand);
    exit;
  end;
  gwt(id_Name, temp);
  if SpaceWeg(temp)='' then begin
    BWCCmessagebox(hWindow, 'Der Bahnhof muss einen Namen haben!', 'So gehts auch nich!', mb_ok+mb_IconHand);
    exit;
  end;
{allgemeine Daten}
  bf^.Daten.Name:=temp;
  gwt(id_Kuerzel, bf^.Daten.Kurzname);
  bf^.KurzNameSicherstellen;
  gwt(id_Eigner,  bf^.Daten.Eigner);
  if not StreckenEdit^.GetValue(i) then runerror;
  bf^.Daten.Strecken:=i;
  i:=0;
  for f:=low(f) to high(f) do if FarbenSchaltfeld[f]^.GetCheck=1 then begin
    inc(i);
    bf^.Daten.ReglerFarben:=f;
  end;
  if i<>1 then runerror;
{Gleise}
  bf^.KillGleise;
  for i:=1 to EditGleise.anzahl
    do with PGleisDaten(EditGleise.p^[i])^
      do bf^.AppendGleis(Bezeichnung, Nutzlaenge);
{Bitmap}
  {spaeeeeeeter...}
{Info}
  if InfoEdit^.IsModified then begin
    i:=InfoEdit^.GetTextLen+1;
    GetMem(NeuInfo, i);
    InfoEdit^.GetText(NeuInfo, i);
    bf^.SetInfo(NeuInfo);
  end;
  EndDlg(id_ok);
END;


PROCEDURE TBahnhofsEditor.IDGleise(VAR Msg:TMessage);
BEGIN
  if Msg.LparamHi=lbn_DblClk then IDGleisEdit(Msg);
END;

PROCEDURE TBahnhofsEditor.IDGleisDazu(VAR Msg:TMessage);
VAR glp:PGleisDaten;
BEGIN
  new(glp);
  with glp^ do begin
    Bezeichnung:='';
    NutzLaenge:=0;
  end;
  if GleisEditor(glp^) then begin
    EditGleise.append(glp);
    UpdateGleise;
  end else begin
    dispose(glp);
  end;
END;

PROCEDURE TBahnhofsEditor.IDGleisDel(VAR Msg:TMessage);
VAR l:longint;
    glp:PGleisDaten;
BEGIN
  l:=GleiseListbox^.GetSelIndex;
  if l>=0 then begin
    glp:=EditGleise.p^[l+1];
    dispose(glp);
    EditGleise.Delete(l+1);
    UpdateGleise;
  end else MessageBeep(mb_IconStop);
END;

PROCEDURE TBahnhofsEditor.IDGleisEdit(VAR Msg:TMessage);
VAR glp:PGleisDaten;
    l:longint;
BEGIN
  l:=GleiseListbox^.GetSelIndex;
  if l>=0 then begin
    glp:=EditGleise.p^[l+1];
    if GleisEditor(glp^) then UpdateGleise;
  end else MessageBeep(mb_IconStop);
END;

PROCEDURE TBahnhofsEditor.IDHilfe(VAR Msg:TMessage);
BEGIN
  Hilfe(keineHilfe);
END;

FUNCTION TBahnhofsEditor.GleisEditor(VAR Gleis:RGleisDaten):boolean;
VAR dlg:TGleisEditor;
BEGIN
  dlg.Buffer:=Gleis;
  dlg.init(@self,'GleisEditor');
  if dlg.execute=1 then begin
    GleisEditor:=true;
    Gleis:=dlg.Buffer;
  end else GleisEditor:=false;
  dlg.done;
END;

{***************************** Exportierte Executefunktion *************************}

FUNCTION ExecuteBahnhofsEditor(parent:PWindowsObject; VAR Bahnhof:TBahnhof; MinGleisZahl:word):boolean;
VAR dlg:TBahnhofsEditor;
BEGIN
  dlg.init(parent, @Bahnhof, MinGleisZahl);
  ExecuteBahnhofsEditor:=dlg.execute=id_ok;
  dlg.done;
END;



END.
