{Projekt: FAHRPLAN

 Autor: Stefan Bormann 94

 Inhalt: Dieses Modul enthlt Diagnosealgorithmen fuer saemtliche Daten.
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Check;

INTERFACE
USES ZugArr, AbsCheck;

FUNCTION ErsterFehlerInZug(Zug:iZug; VAR s:string):boolean;
PROCEDURE CheckZug(Zug:iZug; Start:iZug; VAR fehler:TFehlerArray);
PROCEDURE CheckAll(VAR fehler:TFehlerArray);


IMPLEMENTATION
USES Daten, Strings, win_allg, grund, Ort_Zeit, WinProcs, NodeEdge, InsrtZug, RFarben;


FUNCTION ErsterFehlerInZug(Zug:iZug; VAR s:string):boolean;
VAR FehlerArray:TFehlerArray;
    fp:PDatenFehler;
BEGIN
  FehlerArray.init;
  CheckZug(Zug,1,FehlerArray);
  if FehlerArray.anzahl>0 then begin
    fp:=FehlerArray.p^[1];
    s:=fp^.Beschreibung;
    ErsterFehlerInZug:=true;
  end else begin
    ErsterFehlerInZug:=false;
  end;
  FehlerArray.done;
END;

{$R-,Q-}  {Ich will den Fehler auch sehen, kein runerror}
PROCEDURE CheckZug(Zug:iZug; Start:iZug; VAR fehler:TFehlerArray);
 Function OrtGleich(const o1,o2:ROrt):boolean;
 Begin
   OrtGleich:=(o1.Knoten=o2.Knoten) and (o1.Gleis=o2.Gleis);
 End;
VAR zp1,zp2:PZug;
    zdp1,zdp2,zdp3,zdp4:PZugDatum;
    w,az,ad:word;
    praefix:string[255];
    TempZug:iZug;
    flag1,flag2:boolean;
    s:string;
    node:PNode;
BEGIN
  if Zug=0 then zp1:=@EditierterZug
           else zp1:=FahrplanDaten.ZugArray^.GetZug(Zug);
  praefix:='Zug "'+copy(zp1^.name,1,MaxZugName)+'": ';
{Fehlerhafte Objektfelder}
{Reglerfarbe out of range}
  if (zp1^.Regler<minReglerFarbe) or (zp1^.Regler>maxReglerFarbe)
    then Fehler.Dazu(fatal, praefix+'Reglerfarbe out of range');
{Name='' oder berlnge}
  if (zp1^.Name='')
    then Fehler.Dazu(warning, 'Zug mit interner Nummer #'+zahlstr(zug,1)+' hat keinen Namen')
    else if (length(zp1^.Name)>MaxZugName)
           then Fehler.Dazu(error, Praefix+'Zugname hat berlaenge');
{Name mehrfach}
  for TempZug:=Start to FahrplanDaten.ZugArray^.GetAnzahl
    do if (TempZug<>Zug) and (FahrplanDaten.ZugArray^.GetZug(TempZug)^.name=zp1^.name)
         then Fehler.Dazu(warning, 'Zge mit internen Nummern #'+zahlstr(zug,1)+
                                   ' und #'+zahlstr(tempzug,1)+
                                   ' haben den selben Namen: "'+zp1^.name+'"');
{Keine Daten}
  if zp1^.GetAnzahl=0 then Fehler.Dazu(fatal, praefix+'Keine Daten vorhanden')
  else if zp1^.GetAnzahl=1 then Fehler.Dazu(fatal, praefix+'Nur ein Datum vorhanden')
  else begin
{Fehlerhafte Zeiten/Orte im Array}
    zdp1:=zp1^.GetRec(1);
    if zdp1^.AnZeit<>zdp1^.AbZeit
      then Fehler.Dazu(error, praefix+'An-/Abzeit im ersten Bahnhof ist nicht identisch, An='+
                                      zeit2hmin(zdp1^.AnZeit,true)+' Ab='+zeit2hmin(zdp1^.AbZeit,true));
    for w:=2 to zp1^.GetAnzahl do begin
      zdp2:=zp1^.GetRec(w);
      if zdp1^.AbZeit>=zdp2^.AnZeit
        then Fehler.Dazu(error, praefix+'Fahrzeit '+zahlstr(zdp1^.AnZeit-zdp2^.AbZeit,1)+
                                'min zwischen '+zahlstr(w-1,1)+'. und '+zahlstr(w,1)+'. Datum');
      if zdp2^.AbZeit<zdp2^.AnZeit
        then Fehler.Dazu(error, praefix+'Abfahrt vor Ankunft im '+zahlstr(w,1)+'. Datum');
      zdp1:=zdp2;
    end;
    for w:=1 to zp1^.GetAnzahl do begin
      zdp1:=zp1^.GetRec(w);
    {Ort ok?}
      if false {ortcheck} then Fehler.Dazu(error, praefix+'Ort im '+zahlstr(w,1)+'. Datum fehlerhaft!?');
      node:=zdp1^.Ort.Knoten;
      if byte(node^.Bahnhof.Daten.ReglerFarben)<ReglerFarbe2OrdnungsNummer(zp1^.Regler)
        then Fehler.Dazu(warning, zp1^.Name+' fhrt auf '+GetReglerFarbeName(zp1^.Regler)+
                                  ' durch '+node^.Bahnhof.Daten.Name+
                                  ', obwohl der Bahnhof nur '+
                                  zahlstr(node^.Bahnhof.Daten.ReglerFarben, 1)+
                                  ' Farben zulsst.');
    {Konflikt durch doppelte Benutzung von Gleisen/Strecken}
      for az:=start to FahrplanDaten.ZugArray^.Getanzahl do if not (az=Zug) then begin
        zp2:=FahrplanDaten.ZugArray^.GetZug(az);
        praefix:='Zge '+zp1^.Name+' und '+zp2^.Name;
        for ad:=1 to zp2^.GetAnzahl do begin
          zdp2:=zp2^.GetRec(ad);
          if OrtGleich(zdp1^.ort, zdp2^.ort) and
            (zdp1^.AnZeit<=zdp2^.AbZeit) and
            (zdp2^.AnZeit<=zdp1^.AbZeit)
          then Fehler.Dazu(warning, praefix+' berschneiden sich in '+Ort2String(zdp1^.ort));
          if {zdp3 und zdp4 definiert}
             (ad<>1) and (w<>1) and
             {Gleiche Strecke}
             ( ((zdp1^.ort.knoten=zdp2^.ort.knoten) and (zdp3^.ort.knoten=zdp4^.ort.knoten)) or
               ((zdp1^.ort.knoten=zdp4^.ort.knoten) and (zdp3^.ort.knoten=zdp2^.ort.knoten)) ) and
             {Zeitkonflikt}
             (zdp4^.AbZeit<=zdp1^.AnZeit) and (zdp3^.AbZeit<=zdp2^.AnZeit)
          then Fehler.Dazu(warning, praefix+' berschneiden sich auf Strecke zwischen '+
                                    Ort2String(zdp1^.ort)+' und '+Ort2String(zdp3^.ort));
          zdp4:=zdp2;
        end;
      end;
      zdp3:=zdp1;
    end;
  {Konflikt durch gleichzeitige Fahrt zweier Zge auf der gleichen Farbe}
    if not (zp1^.Regler=keine) then for az:=start to FahrplanDaten.ZugArray^.GetAnzahl do if not (az=Zug) then begin
      zp2:=FahrplanDaten.ZugArray^.GetZug(az);
      if  (zp1^.Regler=zp2^.Regler) and
         (zp1^.GetRec(1)^.AbZeit < zp2^.GetRec(zp2^.GetAnzahl)^.AnZeit) and
         (zp2^.GetRec(1)^.AbZeit < zp1^.GetRec(zp1^.GetAnzahl)^.AnZeit)
      then Fehler.Dazu(warning, 'Zge '+zp1^.Name+' und '+zp2^.Name+' fahren gleichzeitig aber haben gleiche Farbe.');
    end;
  end;
END;
{$R+,Q+}

PROCEDURE CheckAll(VAR fehler:TFehlerArray);
VAR z:iZug;
BEGIN
  for z:=1 to FahrplanDaten.ZugArray^.GetAnzahl do CheckZug(z, z+1, fehler);
  FahrplanDaten.NetzGraph^.CheckGraph(Fehler); {Zeile hinzugefuergt 29.9.95}
END;

END.
