{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 95

 Inhalt: Abstraktes Objekt, dass saemtliche Daten eines Fahrplans
         speichert.
         Die "Init_*"-Methoden sind virtual, damit im Fahrplan-
         programm erweiterte Unterobjekte benutzt werden koennen.
         Die *Veraendert-Methoden sind virtual, damit im Fahrplan-
         programm Aktionen durchgefuert werden koennen, die z.B.
         bestimmte Fenster neu zeichnen.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT DataObj;

INTERFACE
USES abslinar, graph, ZugArr;

TYPE PFahrplanDaten=^TFahrplanDaten;
     TFahrplanDaten=OBJECT
                      LinienArray:PSimpleLineArray;
                      NetzGraph  :PGraph;
                      ZugArray   :PZugArray;
                      CONSTRUCTOR init;
                      DESTRUCTOR done;  virtual;
                      PROCEDURE ReInit; virtual;
                      PROCEDURE InitObjects;
                      PROCEDURE DoneObjects;
                      PROCEDURE Init_LinienArray;  virtual;
                      PROCEDURE Init_NetzGraph;    virtual;
                      PROCEDURE Init_ZugArray;     virtual;
                      FUNCTION DateiLaden(dateiname:string):boolean;  virtual;
                      FUNCTION GetVeraendert:boolean;
                      PROCEDURE LinienVeraendert; virtual;
                      PROCEDURE NetzVeraendert;   virtual;
                      PROCEDURE ZuegeVeraendert;  virtual;
                      PROCEDURE ResetVeraendert;
                    PRIVATE
                      Veraendert:boolean;
                    END;


IMPLEMENTATION
USES Winprocs, WinTypes, BWCC, Strings,
     grund, win_allg,
     NodeEdge, FilePars, Ort_Zeit, Loadr0_2;


CONSTRUCTOR TFahrplanDaten.init;
BEGIN
  InitObjects;
END;

PROCEDURE TFahrplanDaten.InitObjects;
BEGIN
  Veraendert:=false;
  Init_NetzGraph;
  Init_LinienArray;
  Init_ZugArray;
END;

PROCEDURE TFahrplanDaten.Init_LinienArray;
BEGIN
  new(LinienArray, init);
END;

PROCEDURE TFahrplanDaten.Init_NetzGraph;
BEGIN
  new(NetzGraph, init);
END;

PROCEDURE TFahrplanDaten.Init_ZugArray;
BEGIN
  new(ZugArray, init);
END;

DESTRUCTOR TFahrplanDaten.done;
BEGIN
  DoneObjects;
END;

PROCEDURE TFahrplanDaten.DoneObjects;
BEGIN
  dispose(LinienArray,done);
  dispose(NetzGraph,done);
  dispose(ZugArray,done);
END;

PROCEDURE TFahrplanDaten.ReInit;
BEGIN
  DoneObjects;
  InitObjects;
END;

{*************************** Veraendert ***************************}

FUNCTION TFahrplanDaten.GetVeraendert:boolean;
BEGIN
  GetVeraendert:=Veraendert;
END;

PROCEDURE TFahrplanDaten.LinienVeraendert;
BEGIN
  Veraendert:=true;
END;

PROCEDURE TFahrplanDaten.NetzVeraendert;
BEGIN
  Veraendert:=true;
END;

PROCEDURE TFahrplanDaten.ZuegeVeraendert;
BEGIN
  Veraendert:=true;
END;

PROCEDURE TFahrplanDaten.ResetVeraendert;
BEGIN
  Veraendert:=false;
END;

{***************************** Laden ******************************}

TYPE MyParser=OBJECT(TFileParser)
                CONSTRUCTOR init(const Name:string; Dat:PFahrplanDaten);
                PROCEDURE Fehler(grund:string); virtual;
                PROCEDURE Ejecting;
                PROCEDURE Abort(grund:string);
              PRIVATE
                Daten:PFahrplanDaten;
              END;

CONSTRUCTOR MyParser.init(const Name:string; Dat:PFahrplanDaten);
BEGIN
  inherited init(Name);
  Daten:=Dat;
END;

PROCEDURE MyParser.Fehler(grund:string);
VAR puffer:array [0..1024] of char;
    ArgList:record p1:pchar; w:word; p2:pchar; end;
BEGIN
  ArgList.p1:=string2pchar(grund);
  ArgList.w:=ZeilenZaehler;
  ArgList.p2:=String2Pchar(Zeile);
  wvsprintf(puffer,'Fehlerbeschreibung:'+cr+'"%s"'+cr+'Zeile #%d:'+cr+'"%s"',ArgList);
  messagebox(0, puffer, 'Fehler beim Laden', mb_ok or mb_TaskModal);
END;

PROCEDURE MyParser.Ejecting;
BEGIN
  Schliessen;
  done;
  Daten^.ReInit;
END;

PROCEDURE MyParser.Abort(grund:string);
BEGIN
  Ejecting;
  messagebox(0, string2pchar(grund), 'Schwerer Fehler beim Laden', mb_ok or mb_TaskModal);
END;

{-------------------------------}

FUNCTION Loader0_1(VAR Parser:MyParser):boolean;  FAR;
BEGIN
  MessageBox(0, 'Dieses Dateiformat ist veraltet und kann nicht mehr von diesem '+
                'Programm gelesen werden.'+cr+
                'Um diese Datei in ein neuere Format zu berfhren bentigen Sie '+
                'FAHRPLAN.EXE der Version 0.3c, BFMANAG.DLL und die Bahnhofs-'+
                'Datenbank (BAHNHOF.LST), mit der Sie die PLN-Datei eingegeben haben.',
                'Wer zu spt kommt, den bestraft der Fahrplaneditor',
                mb_ok or mb_iconstop or mb_taskmodal);
  Loader0_1:=false;
END;

FUNCTION Loader0_2(VAR Parser:MyParser):boolean;  FAR;
VAR Tabelle:Array [1..4] of PAbschnitt;
BEGIN
  Tabelle[1]:=new(PKnotenAbschnitt0_2,init(@Parser, '[Knoten]', Parser.Daten));
  Tabelle[2]:=new(PKantenAbschnitt0_2,init(@Parser, '[Kanten]', Parser.Daten));
  Tabelle[3]:=new(PLinienAbschnitt0_2,init(@Parser, '[Linien]', Parser.Daten));
  Tabelle[4]:=new(PZugAbschnitt0_2,   init(@Parser, '[Zuege]',  Parser.Daten));
  Loader0_2:=Parser.DoParse(Tabelle);
END;

CONST DateiVersion:Array [1..2] of record
                                     Name:string[5];
                                     Loader:FUNCTION(VAR Parser:MyParser):boolean;
                                   end = ((Name:'V0.1'; Loader:Loader0_1),
                                          (Name:'V0.2'; Loader:Loader0_2));

FUNCTION TFahrplanDaten.DateiLaden(dateiname:string):boolean;
VAR Parser:MyParser;
VAR temp:string[42];
    w:word;
    altCursor:hCursor;
    diskCursor:hCursor;
BEGIN
{Initialisieren}
  DateiLaden:=false;

  diskCursor:=LoadCursor(hInstance, 'Diskette');
  altCursor:=SetCursor(diskCursor);

{Datei ffnen}
  Parser.init(dateiname, @self);
  if not Parser.Oeffnen then begin
    Parser.Abort('IO-Fehler '+zahlstr(Parser.IOresultCp,1)+cr+' beim ffnen der Datei');
    exit;
  end;
{Erste Zeile einlesen}
  if not Parser.LiesZeile then begin
    if Parser.IOresultCp=0 then  Parser.Abort('Keine Daten in Datei')
                           else  Parser.Abort('IO-Fehler '+zahlstr(Parser.IOresultCp,1)+cr+' beim Lesen der Datei');
    exit;
  end;
  splitstring(Parser.zeile,' ',Parser.zeile,temp);
  if (Parser.zeile<>'Fahrplan-Dateiformat') then begin
    Parser.Abort('Dateiformat-Identifikation fehlt');
    exit;
  end;
  w:=1;
  while (w<=high(DateiVersion)) and (DateiVersion[w].Name<>temp) do inc(w);
  if w>high(DateiVersion) then begin
    Parser.Abort('Unbekannte Version des Dateiformates');
    exit;
  end;
{Daten einlesen}
  if not DateiVersion[w].Loader(Parser) then begin
    Parser.Ejecting;
    exit;
  end;
{Datei schliessen}
  if not Parser.Schliessen then begin
    Parser.Abort('IO-Fehler '+zahlstr(Parser.IOresultCp,1)+cr+' beim Schlieen der Datei');
    exit;
  end;
{und Ende...}
  Parser.done;

  SetCursor(altCursor);
  DestroyCursor(diskCursor);

  DateiLaden:=true;
END;

END.
