UNIT Daten;

{$A+,B-,G+,I+,V-,X+,T+,P+}

INTERFACE
USES DataObj, oWindows, LineArr;

TYPE TEditorFahrplanDaten=OBJECT(TFahrplanDaten)
                            FUNCTION DateiSichern(dateiname:string):boolean;
                            PROCEDURE ReInit; virtual;
                            PROCEDURE Init_LinienArray; virtual;
                            FUNCTION GetLinienArray:PLineArray;
                            FUNCTION DateiLaden(dateiname:string):boolean;  virtual;
                            PROCEDURE LinienVeraendert; virtual;
                            PROCEDURE NetzVeraendert;   virtual;
                            PROCEDURE ZuegeVeraendert;  virtual;
                          END;

VAR FahrplanDaten:TEditorFahrplanDaten;

PROCEDURE Daten_init;
PROCEDURE Daten_done;
PROCEDURE Daten_ReInit;

IMPLEMENTATION
USES InsrtZug, WinTypes, WinProcs,
     NodeEdge, Win_Allg, Strings, Ort_Zeit, grund, ZugArr, RFarben, BfDef, netz;

PROCEDURE Daten_init;
BEGIN
  FahrplanDaten.init;
END;

PROCEDURE Daten_done;
BEGIN
  FahrplanDaten.done;
END;

PROCEDURE Daten_ReInit;
BEGIN
  FahrplanDaten.ReInit;
END;


FUNCTION TEditorFahrplanDaten.GetLinienArray:PLineArray;
BEGIN
  GetLinienArray:=pointer(LinienArray); {cast funktioniert, wegen Init_LinienArray!!!}
END;

PROCEDURE TEditorFahrplanDaten.Init_LinienArray;
BEGIN
  LinienArray:=new(PLineArray, init);
END;

PROCEDURE TEditorFahrplanDaten.ReInit;
BEGIN
  InsertZug_Reset;
  inherited ReInit;
END;


FUNCTION TEditorFahrplanDaten.DateiLaden(dateiname:string):boolean;
BEGIN
  inherited DateiLaden(dateiname);
  GetLinienArray^.EditorenNeueDaten;  {macht zwar einiges doppelt, mir ist aber nix besseres eingefallen}
END;


PROCEDURE TEditorFahrplanDaten.LinienVeraendert;
BEGIN
  inherited LinienVeraendert;
END;

PROCEDURE TEditorFahrplanDaten.NetzVeraendert;
BEGIN
  inherited NetzVeraendert;
  GetLinienArray^.EditorenNeueDaten;
  NetzFenster^.NeueDaten;
END;

PROCEDURE TEditorFahrplanDaten.ZuegeVeraendert;
BEGIN
  inherited ZuegeVeraendert;
  GetLinienArray^.EditorenNeuZeichnen;
END;

{*************************** Sichern ****************************}

VAR datei:text;
    zeile:string;
    ZeilenZaehler:word;
FUNCTION TEditorFahrplanDaten.DateiSichern(dateiname:string):boolean; {sichert V0.2}

 {Schreibt einen String in die Statuszeile des Fenster}
 Procedure Status(s:string);
 Begin

 End;

 Function Node2Index(node:PNode):word;
 Begin
   Node2Index:=FahrplanDaten.NetzGraph^.KnotenArray.Position(node);
 End;

 Procedure WriteEdge(Kante:Pedge);
 Begin
   writeln(datei, 'EDGE ', Node2Index(Kante^.n1), ' ', Node2Index(Kante^.n2), ' ');
 End;

 Procedure WriteNode(node:PNode);
 Var Arr:TPCharArray;
     w:word;
     NamePuffer:string[maxBahnhofsName];
     KurznamePuffer:string[maxKurzName];
     GleisBezeichnungPuffer:string[maxGleisBezeichnung];
 Begin
   NamePuffer:=node^.Bahnhof.Daten.Name;
   KurznamePuffer:=node^.Bahnhof.Daten.Kurzname;
   Ersetzen(' ', '_', NamePuffer);
   Ersetzen(' ', '_', KurznamePuffer);
   writeln(datei, 'BAHNHOF ', node^.ort.x:1:5, '/',
                              node^.ort.y:1:5, ' ',
                              NamePuffer, ' ',
                              KurzNamePuffer);
   if node^.Bahnhof.Daten.Eigner<>'' then writeln(datei, 'EIGNER '+node^.Bahnhof.Daten.Eigner);
   if node^.Bahnhof.Daten.Strecken<>0 then writeln(datei, 'STRECKEN ', node^.Bahnhof.Daten.Strecken);
   writeln(datei, 'REGLERFARBEN ', node^.Bahnhof.Daten.ReglerFarben);
   for w:=1 to node^.Bahnhof.AnzahlGleise do with node^.Bahnhof.GetGleis(w)^ do begin
     GleisBezeichnungPuffer:=Bezeichnung;
     Ersetzen(' ', '_', GleisBezeichnungPuffer);
     writeln(datei, 'GLEIS '+GleisBezeichnungPuffer+' ',Nutzlaenge);
   end;
   if (node^.Bahnhof.GetInfo<>nil) and (StrLen(node^.Bahnhof.GetInfo)>0) then begin
     Arr.init;
     Arr.ImportFromMultiLine(node^.Bahnhof.GetInfo);
     for w:=1 to Arr.anzahl do writeln(datei, 'INFO '+Pchar2String(Arr.p^[w]));
     Arr.done;
   end;
   writeln(datei);
 End;

 Function OrtDateiString(ort:ROrt):string;
 Begin
   OrtDateiString:=zahlstr(Node2Index(ort.Knoten),1)+','+zahlstr(ort.Gleis,1);
 End;

VAR w,nr:word;
    s:string;
    node:Pnode;
    zdp:PZugDatum;
    altCursor:hCursor;
    diskCursor:hCursor;
BEGIN
  DateiSichern:=false;

  diskCursor:=LoadCursor(hInstance, 'Diskette');
  altCursor:=SetCursor(diskCursor);

  Status('Datei ffnen');
  assign(datei,dateiname);
  rewrite(datei);
  writeln(datei,'Fahrplan-Dateiformat V0.2');
  writeln(datei);

  Status('Knoten sichern');
  writeln(datei,'[Knoten]');
  with FahrplanDaten.NetzGraph^.KnotenArray
    do for w:=1 to GetAnzahl
      do WriteNode(GetRec(w));

  Status('Kanten sichern');
  writeln(datei,'[Kanten]');
  with FahrplanDaten.NetzGraph^.KantenArray
    do for w:=1 to GetAnzahl
      do WriteEdge(GetRec(w));
  writeln(datei);

  Status('Linien sichern');
  writeln(datei,'[Linien]');
  with FahrplanDaten.LinienArray^ do begin
    for w:=1 to GetAnzahl do with GetLineData(w)^ do begin
      s:=Name;
      Ersetzen(' ','_',s);
      writeln(datei, 'LINE ', GetGraphenFarbeName(Farbe), ' ',
                              s, ' ',
                              Node2Index(anfang), ' ',
                              Node2Index(ende));
    end;
  end;
  writeln(datei);

  Status('Zge sichern');
  writeln(datei,'[Zuege]');
  with FahrplanDaten.ZugArray^ do begin
    for w:=1 to GetAnzahl do with GetZug(w)^ do begin
      s:=Name;
      Ersetzen(' ','_',s);
      writeln(datei, 'ZUG ', GetReglerFarbeName(Regler), ' ', s);
      zdp:=GetRec(1);
      writeln(datei, 'START ', OrtDateiString(zdp^.ort), ' ', zdp^.abZeit);
      for nr:=2 to GetAnzahl-1 do begin
        zdp:=GetRec(nr);
        writeln(datei, 'MITTE ', OrtDateiString(zdp^.ort), ' ', zdp^.anZeit, ' ', zdp^.abZeit);
      end;
      zdp:=GetRec(GetAnzahl);
      writeln(datei, 'ENDE ', OrtDateiString(zdp^.ort), ' ', zdp^.anZeit);
      writeln(datei);
    end;
  end;

  close(datei);
  ResetVeraendert;
  Status('ok');

  SetCursor(altCursor);
  DestroyCursor(diskCursor);

  DateiSichern:=true;
END;

END.
