{Projekt: alle Nutzer von BAHNHOF.DLL

 Autor: Stefan Bormann 95

 Inhalt: Kapselung der uBahnhof-Schnittstelle in einem Objekt
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT DB_obj;

INTERFACE
USES BfDef, WinTypes;

TYPE TBahnhofsDatenbank=OBJECT
        CONSTRUCTOR init;
        DESTRUCTOR done; virtual;
        FUNCTION IsOpen:boolean;

        FUNCTION OpenDirect(parent:hWnd; Dateiname:pchar):boolean;
        FUNCTION OpenDialog(parent:hWnd):boolean;
        FUNCTION CreateDialog(parent:hWnd):boolean;
        FUNCTION Close:boolean;
        FUNCTION GetFileName(Puffer:pchar; MaxChars:word):word;
        FUNCTION GetStatus:TDatenbankStatus;

        FUNCTION Aufzaehlung(AufzaehlProc:TAufzaehlProc):TBfError;
        FUNCTION BahnhofDazu:hBahnhof;
        FUNCTION BahnhofLoeschen(Bahnhof:hBahnhof):TBfError;

        FUNCTION BahnhofsAuswahlDialog(parent:hWnd; Titel:pchar):hBahnhof;
        PROCEDURE ExecuteStatusDialog(parent:hWnd);

        FUNCTION GetData(Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;
        FUNCTION SetData(Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;
        FUNCTION GetInfo(Bahnhof:hBahnhof; InfoPuffer:pchar; MaxChars:word):word;
        FUNCTION SetInfo(Bahnhof:hBahnhof; InfoPuffer:pchar):TBfError;
        FUNCTION Info2Window(Bahnhof:hBahnhof; Window:hWnd):TBfError;
        FUNCTION Window2Info(Bahnhof:hBahnhof; Window:hWnd):TBfError;

        FUNCTION GetGleisAnzahl(Bahnhof:hBahnhof):word;
        FUNCTION GetGleis(Bahnhof:hBahnhof; Gleis:hGleis; GleisPuffer:PGleisDaten):TBfError;
        FUNCTION GleisDazu(Bahnhof:hBahnhof; GleisPuffer:PGleisDaten):hGleis;
        FUNCTION GleiseLoeschen(Bahnhof:hBahnhof):TBfError;

        FUNCTION GetInfoLength(Bahnhof:hBahnhof):word;
      PRIVATE
        Handle:hDatenbank;
      END;


IMPLEMENTATION
USES uBahnhof, WinProcs;

CONSTRUCTOR TBahnhofsDatenbank.init;
BEGIN
  Handle:=0;
END;

DESTRUCTOR TBahnhofsDatenbank.done;
BEGIN
  if IsOpen then Close;
END;

FUNCTION TBahnhofsDatenbank.IsOpen:boolean;
BEGIN
  IsOpen:=Handle<>0;
END;


FUNCTION TBahnhofsDatenbank.OpenDirect(parent:hWnd; Dateiname:pchar):boolean;
BEGIN
  if IsOpen then runerror;
  Handle:=Bf_OpenDirect(parent, Dateiname);
  OpenDirect:=IsOpen;
END;

FUNCTION TBahnhofsDatenbank.OpenDialog(parent:hWnd):boolean;
BEGIN
  if IsOpen then runerror;
  Handle:=Bf_OpenDialog(parent);
  OpenDialog:=IsOpen;
END;

FUNCTION TBahnhofsDatenbank.CreateDialog(parent:hWnd):boolean;
BEGIN
  if IsOpen then runerror;
  Handle:=Bf_CreateDialog(parent);
  CreateDialog:=IsOpen;
END;

FUNCTION TBahnhofsDatenbank.Close:boolean;
BEGIN
  Close:=Bf_Close(Handle);
  Handle:=0;
END;

FUNCTION TBahnhofsDatenbank.GetFileName(Puffer:pchar; MaxChars:word):word;
BEGIN
  GetFileName:=Bf_GetFileName(Handle, Puffer, MaxChars);
END;

FUNCTION TBahnhofsDatenbank.GetStatus:TDatenbankStatus;
BEGIN
  GetStatus:=Bf_GetStatus(Handle);
END;


CONST TheProc:TAufzaehlProc=nil;
PROCEDURE Zwischenscheisse(Bahnhof:hBahnhof); export;
BEGIN
  TheProc(Bahnhof)
END;

FUNCTION TBahnhofsDatenbank.Aufzaehlung(AufzaehlProc:TAufzaehlProc):TBfError;
VAR proc:record case integer of
           0:(fp:TFarProc;);
           1:(ap:TAufzaehlProc;);
         end;
BEGIN
  TheProc:=AufzaehlProc;
  proc.fp:=MakeProcInstance(@Zwischenscheisse, hinstance);
  Aufzaehlung:=Bf_Aufzaehlung(Handle, proc.ap);
  FreeProcInstance(proc.fp);
END;

FUNCTION TBahnhofsDatenbank.BahnhofDazu:hBahnhof;
BEGIN
  BahnhofDazu:=Bf_BahnhofDazu(Handle);
END;

FUNCTION TBahnhofsDatenbank.BahnhofLoeschen(Bahnhof:hBahnhof):TBfError;
BEGIN
  BahnhofLoeschen:=Bf_BahnhofLoeschen(Handle, Bahnhof);
END;


FUNCTION TBahnhofsDatenbank.BahnhofsAuswahlDialog(parent:hWnd; Titel:pchar):hBahnhof;
BEGIN
  BahnhofsAuswahlDialog:=Bf_BahnhofsAuswahlDialog(Parent, Handle, Titel);
END;

PROCEDURE TBahnhofsDatenbank.ExecuteStatusDialog(parent:hWnd);
BEGIN
  Bf_ExecuteStatusDialog(Parent);
END;


FUNCTION TBahnhofsDatenbank.GetData(Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;
BEGIN
  GetData:=Bf_GetData(Handle, Bahnhof, DatenPuffer);
END;

FUNCTION TBahnhofsDatenbank.SetData(Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;
BEGIN
  SetData:=Bf_SetData(Handle, Bahnhof, DatenPuffer);
END;

FUNCTION TBahnhofsDatenbank.GetInfo(Bahnhof:hBahnhof; InfoPuffer:pchar; MaxChars:word):word;
BEGIN
  GetInfo:=Bf_GetInfo(Handle, Bahnhof, InfoPuffer, MaxChars);
END;

FUNCTION TBahnhofsDatenbank.SetInfo(Bahnhof:hBahnhof; InfoPuffer:pchar):TBfError;
BEGIN
  SetInfo:=Bf_SetInfo(Handle, Bahnhof, InfoPuffer);
END;

FUNCTION TBahnhofsDatenbank.Info2Window(Bahnhof:hBahnhof; Window:hWnd):TBfError;
BEGIN
  Info2Window:=Bf_Info2Window(Handle, Bahnhof, Window);
END;

FUNCTION TBahnhofsDatenbank.Window2Info(Bahnhof:hBahnhof; Window:hWnd):TBfError;
BEGIN
  Window2Info:=Bf_Window2Info(Handle, Bahnhof, Window);
END;


FUNCTION TBahnhofsDatenbank.GetGleisAnzahl(Bahnhof:hBahnhof):word;
BEGIN
  GetGleisAnzahl:=Bf_GetGleisAnzahl(Handle, Bahnhof);
END;

FUNCTION TBahnhofsDatenbank.GetGleis(Bahnhof:hBahnhof; Gleis:hGleis; GleisPuffer:PGleisDaten):TBfError;
BEGIN
  GetGleis:=Bf_GetGleis(Handle, Bahnhof, Gleis, GleisPuffer);
END;

FUNCTION TBahnhofsDatenbank.GleisDazu(Bahnhof:hBahnhof; GleisPuffer:PGleisDaten):hGleis;
BEGIN
  GleisDazu:=Bf_GleisDazu(Handle, Bahnhof, GleisPuffer);
END;

FUNCTION TBahnhofsDatenbank.GleiseLoeschen(Bahnhof:hBahnhof):TBfError;
BEGIN
  GleiseLoeschen:=Bf_GleiseLoeschen(Handle, Bahnhof);
END;


FUNCTION TBahnhofsDatenbank.GetInfoLength(Bahnhof:hBahnhof):word;
BEGIN
  GetInfoLength:=GetInfo(Bahnhof, nil, 0);
END;


END.
