{Projekt: FAHRPLAN (und andere)

 Autor: Stefan Bormann 94

 Inhalt: Drei Standartdialoge, deren berschriften vernderbar sind, um sie
         mglichst vielseitig verwenden zu knnen.
         Interner Vererbungsbaum:
                                          TAbstractDialog
                                           /           \
                                          /             \
                         TMehfachauswahlDialog       TListboxDialog
                                                           \
                                                            \
                                                       TEditListboxDialog
}

UNIT Dialoge;

{$R dialoge.res}

INTERFACE
USES oWindows, WinTypes, heap, win_allg;

{Fhrt ein modalen Dialog aus, der eine Listbox und drei Buttons (ok,cancel,help)
 enthlt}
FUNCTION MachListboxDialog(parent:PWindowsObject;       {Vaterfenster}
                           caption:pchar;               {Fensterberschrift}
                           VAR edit:word;               {Listbox Start-/Ergebnisindex}
                           VAR Eintraege:TPCharArray;   {Zeilen der Listbox}
                           Hilfe:THilfeThema):boolean;  {fr Hilfebutton}

{Fhrt einen modalen Dialog aus, der ein einzeiliges Editierfeld mit berschrift,
 eine Listbox mit berschrift und drei Buttons (ok,cancel,help) enthlt}
FUNCTION MachEditListboxDialog(parent:PWindowsObject;      {Vaterfenster}
                               caption:pchar;              {Fensterberschrift}
                               edittitel:pchar;            {Text ber Editierfeld}
                               VAR editstring:string;      {Editierfeld Start-/Ergebnisstring}
                               listboxtitel:pchar;         {Text ber Listbox}
                               VAR edit:word;              {Listbox Start-/Ergebnisindex}
                               VAR Eintraege:TPCharArray;  {Zeilen der Listbox}
                               Hilfe:THilfeThema):boolean; {fr Hilfebutton}

{Fhrt einen modalen Dialog aus, der eine Listbox mit Mehrfachauswahl und drei Buttons
 (ok,cancel,help) enthlt; Auerdem gibt es zwei Zusatzbuttons, mit denen alles an- oder
 abgewhlt werden kann. Die nicht ausgewaehlten Optionen werden im Array "Eintraege"
 mittels der virtuellen Methode "KillElement" gelscht}
FUNCTION MachMehrfachAuswahlDialog(parent:PWindowsObject;       {Vaterfenster}
                                   caption:pchar;               {Fensterberschrift}
                                   VAR Eintraege:TPCharArray;   {Zeilen der Listbox}
                                   Hilfe:THilfeThema):boolean;  {fr Hilfebutton}



IMPLEMENTATION
USES strings, oDialogs, WinProcs, BWCC, grund;

CONST id_edittitel   =101;
      id_listboxtitel=102;
      id_edit        =103;
      id_listbox     =104;
      id_alle        =105;
      id_keine       =106;

{******************************* Abstraktes Fenster **************************************}

TYPE TAbstractDialog=OBJECT(TDialog)
                       FensterName:pchar;
                       Arr:^TPCharArray;
                       HilfeThema:THilfeThema;
                       CONSTRUCTOR init(aparent:PWindowsObject; Recource:pchar; Titel:pchar;
                                        VAR Eintraege:TPcharArray; Hilfe:THilfeThema);
                       PROCEDURE SetupWindow; virtual;
                       PROCEDURE IDListbox(VAR Msg:TMessage); virtual  id_first+id_listbox;
                       PROCEDURE IDHilfe(VAR Msg:TMessage);   virtual  id_first+998;
                     END;

CONSTRUCTOR TAbstractDialog.init(aparent:PWindowsObject; Recource:pchar; Titel:pchar;
                                 VAR Eintraege:TPcharArray; Hilfe:THilfeThema);
BEGIN
  FensterName:=Titel;
  Arr:=@Eintraege;
  HilfeThema:=Hilfe;
  inherited init(aparent,recource);
END;

PROCEDURE TAbstractDialog.SetupWindow;
VAR w:word;
BEGIN
  inherited SetupWindow;
  SetWindowText(hWindow,FensterName);
  for w:=1 to Arr^.anzahl do SendDlgItemMsg(id_listbox, lb_AddString, 0, longint(Arr^.p^[w]));
END;

PROCEDURE TAbstractDialog.IDListbox(VAR Msg:TMessage);
BEGIN
  if Msg.LparamHi=lbn_DblClk then ok(msg);
END;

PROCEDURE TAbstractDialog.IDHilfe(VAR Msg:TMessage);
BEGIN
  Hilfe(HilfeThema);
END;

{******************************* Listbox **************************************}

TYPE TListboxDialog=OBJECT(TAbstractDialog)
                      Edit:word;
                      PROCEDURE SetupWindow; virtual;
                      PROCEDURE OK(VAR Msg:TMessage);        virtual  id_first+id_ok;
                    END;

PROCEDURE TListboxDialog.SetupWindow;
VAR w:word;
BEGIN
  inherited SetupWindow;
  if edit>Arr^.anzahl then runerror;
  if edit<>0 then SendDlgItemMsg(id_listbox, lb_setcursel, edit-1, 0);
END;

PROCEDURE TListboxDialog.OK(VAR Msg:TMessage);
VAR l:longint;
BEGIN
  l:=SendDlgItemMessage(Hwindow, id_listbox, lb_GetCurSel, 0, 0);
  if (l=lb_err) then begin
    BWCCmessagebox(hwindow, 'Erstmal etwas in der Listbox auswhlen!!!', 'Sekunde!', mb_ok+mb_iconstop);
    exit;
  end;
  inc(l);
  if (l<1) or (l>Arr^.anzahl) then runerror;
  Edit:=loword(l);
  inherited ok(msg);
END;

FUNCTION MachListboxDialog(parent:PWindowsObject;
                           caption:pchar;
                           VAR edit:word;
                           VAR Eintraege:TPCharArray;
                           Hilfe:THilfeThema):boolean;
VAR dlg:TListboxDialog;
    ok:boolean;
BEGIN
  dlg.init(parent,'listbox',caption,Eintraege,Hilfe);
  dlg.edit:=edit;
  ok:=(dlg.execute=id_ok);
  if ok then edit:=dlg.edit;
  MachListboxDialog:=ok;
  dlg.done;
END;

{**************************** Edit + Listbox ************************************}

TYPE TEditListboxDialog=OBJECT(TListboxDialog)
                          listboxtitel:pchar;
                          edittitel:pchar;
                          editstring:string;
                          PROCEDURE SetupWindow; virtual;
                          PROCEDURE OK(VAR Msg:TMessage); virtual  id_first+id_ok;
                        END;

PROCEDURE TEditListboxDialog.SetupWindow;
BEGIN
  inherited SetupWindow;
  SetWindowText(GetDlgItem(hwindow,id_listboxtitel),listboxtitel);
  SetWindowText(GetDlgItem(hwindow,id_edittitel),edittitel);
  SetWindowText(GetDlgItem(hwindow,id_edit),string2pchar(editstring));
END;

PROCEDURE TEditListboxDialog.OK(VAR Msg:TMessage);
BEGIN
  EditString[0]:=char(lo(GetWindowText(GetDlgItem(Hwindow,id_edit),@EditString[1],sizeof(EditString)-2)));
  EditString:=spaceweg(EditString);
  if EditString='' then begin
    BWCCmessagebox(hwindow, 'Einen Namen sollte das Kind schon haben', 'Mooooment', mb_ok+mb_iconstop);
    exit;
  end;
  inherited OK(msg);
END;

FUNCTION MachEditListboxDialog(parent:PWindowsObject;
                               caption:pchar;
                               edittitel:pchar;
                               VAR editstring:string;
                               listboxtitel:pchar;
                               VAR edit:word;
                               VAR Eintraege:TPCharArray;
                               Hilfe:THilfeThema):boolean;
VAR dlg:TEditListboxDialog;
    ok:boolean;
BEGIN
  dlg.init(parent,'edit_listbox',caption,Eintraege,Hilfe);
  dlg.edittitel:=edittitel;
  dlg.editstring:=editstring;
  dlg.listboxtitel:=listboxtitel;
  dlg.edit:=edit;
  ok:=(dlg.execute=id_ok);
  if ok then begin
    edit:=dlg.edit;
    editstring:=dlg.editstring;
  end;
  MachEditListboxDialog:=ok;
  dlg.done;
END;

{******************************* Mehrfachauswahl **************************************}


TYPE TMehrfachAuswahlDialog=OBJECT(TAbstractDialog)
                              PROCEDURE IDalle (VAR msg:TMessage); virtual id_first+id_alle;
                              PROCEDURE IDkeine(VAR Msg:TMessage); virtual id_first+id_keine;
                              PROCEDURE SetupWindow; virtual;
                              PROCEDURE OK(VAR msg:TMessage); virtual id_first+id_ok;
                            END;

PROCEDURE TMehrfachAuswahlDialog.IDalle(VAR msg:TMessage);
BEGIN
  SendDlgItemMsg(id_listbox, lb_SetSel, 1, -1);
END;

PROCEDURE TMehrfachAuswahlDialog.IDkeine(VAR msg:TMessage);
BEGIN
  SendDlgItemMsg(id_listbox, lb_SetSel, 0, -1);
END;

PROCEDURE TMehrfachAuswahlDialog.SetupWindow;
BEGIN
  inherited SetupWindow;
END;

PROCEDURE TMehrfachAuswahlDialog.OK(VAR msg:TMessage);
TYPE AInteger=Array [1..1000] of integer;
VAR temparr:^AInteger; {Array der Indizes der angewhlten Zeilen}
    anz:longint;       {Anzahl der angewaehlten Zeilen}
    x,                 {Schleifenindex in TempArr}
    y:word;            {Schleifenindex in Arr}
    StringAusListbox:array [0..256] of char;
                       {Puffer fuer String, der mit lb_getstring geholt wird}
    ArrAnzahl:word;    {Kopie von Arr^.Anzahl}
BEGIN
  ArrAnzahl:=Arr^.Anzahl;
{Anzahl der Auswahlen holen, wenn =0 Fehlermeldung, sonst Puffer machen, Indizes holen}
  anz:=SendDlgItemMsg(id_listbox, lb_GetSelCount, 0, 0);
  if anz<1 then begin
    BWCCmessagebox(hwindow, 'Sie muessen vorher einige Zeilen auswhlen', 'So geits nich...', mb_ok+mb_IconHand);
    exit;
  end;
  if anz>ArrAnzahl then runerror;
  getmem(temparr,anz*sizeof(integer));
  SendDlgItemMsg(id_listbox, lb_GetSelItems, anz, longint(temparr));
{Integer im Array Abbilden:  Index in Listbox -> Index im Stringarray}
  for x:=1 to Anz do begin
    SendDlgItemMsg(id_listbox, lb_GetText, TempArr^[x], longint(@StringAusListbox[0]));
    y:=1;
    while (y<=ArrAnzahl) and (StrComp(StringAusListbox,Arr^.p^[y])<>0) do inc(y);
    if y>ArrAnzahl then runerror;
    TempArr^[x]:=y;
  end;
{Nicht angewaehlte Strings aus Arr loeschen}
  for y:=1 to ArrAnzahl do begin
    x:=1;
    while (x<=Anz) and (TempArr^[x]<>y) do inc(x);
    if x>Anz then Arr^.KillElement(y);
  end;
  inherited ok(msg);
END;


FUNCTION MachMehrfachAuswahlDialog(parent:PWindowsObject;
                                   caption:pchar;
                                   VAR Eintraege:TPCharArray;
                                   Hilfe:THilfeThema):boolean;
VAR dlg:TMehrfachAuswahlDialog;
    ok:boolean;
BEGIN
  dlg.init(parent,'ListBox_Mehrfach',caption,Eintraege,Hilfe);
  ok:=(dlg.execute=id_ok);
  MachMehrfachAuswahlDialog:=ok;
  dlg.done;
END;

END.
