{Projekt: FAHRPLAN

 Autor: Stefan Bormann 94

 Inhalt: Dieses Modul nimmt die Mausbotschaften des Fahrplansheets auf und
         erledigt das Editieren einzelner Knotenpunkte des Fahrplans und das
         anwaehlen einzelner Knotenpunkte
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT DragZug;

INTERFACE
USES Edit_Sht;

PROCEDURE DragZug_lMouseDown(window:PEditSheet; C:RFahrplanCursor);
PROCEDURE DragZug_lMouseUp(window:PEditSheet);
PROCEDURE DragZug_rMouseDown(window:PEditSheet; C:RFahrplanCursor);
PROCEDURE DragZug_MouseMove(window:PEditSheet; C:RFahrplanCursor);
FUNCTION DragZug_Idle:boolean;

PROCEDURE DragZug_KillCursor;

TYPE TTrefferArt=(nix,Ankunft,Abfahrt,Aufenthalt,Fahrt);

TYPE TDragZug_Cursor=record
                       zug:word;
                       Datum:word;
                       TrefferArt:TTrefferArt;
                       Fenster:PEditSheet;
                     end;

VAR DragZug_Cursor:TDragZug_Cursor;



IMPLEMENTATION
USES ZugArr, Daten, Fp_Allg, Check, Ort_Zeit, Optionen,
     WinProcs, WinTypes, BWCC, Win_Allg;

CONST DragAndDrop:boolean=false;

VAR Backup:record
             primary:RZugDatum;   {Angewaehlter Datensatz, kopiert in lButtonDown}
             secondary:RZugDatum; {zweiter Datensatz, wird nur bei *Fahrt* benutzt}
           end;
    CursorZeitVersatz:integer; {MausZeit-DatenZeit beim lButtonDown}
    Minimum,Maximum:TZeit;

VAR MausZeiger:record
                 LinksRechts:hCursor;
                 ObenUnten:hCursor;
                 Arrow:hCursor;
               end;

FUNCTION DragZug_Idle:boolean;
BEGIN
  DragZug_Idle:=not DragAndDrop;
END;

 Function GetTheZDP(Differenz:Integer):PZugDatum;
 Begin
   GetTheZDP:=FahrplanDaten.ZugArray^.GetZDP(DragZug_Cursor.Zug, DragZug_Cursor.Datum+Differenz);
 End;

 Procedure MachStatusZeile;
 Var s:string;
     zp:PZug;
     zdp,zdp2:PZugDatum;

  Function Fahrzeit(a,b:word):string;
  Begin
    Fahrzeit:='; Fahrzeit='+Zeit2hmin(zp^.GetRec(b)^.AnZeit-zp^.GetRec(a)^.AbZeit, false);
  End;

  Function AufenthaltsDauer:string;
  Begin
    AufenthaltsDauer:='; Aufenthalt='+Zeit2hmin(zdp^.AbZeit-zdp^.AnZeit, false);
  End;

 Begin
   with DragZug_Cursor do begin
     if TrefferArt<>nix then begin
       zp:=FahrplanDaten.ZugArray^.GetZug(Zug);
       s:=zp^.name;
       zdp:=zp^.GetRec(Datum);
     end;
     case TrefferArt of
       nix       :s:='nichts angewhlt...';
       Ankunft   :s:='Ankunft von '+s+' um '+Zeit2hmin(zdp^.AnZeit,true)+Fahrzeit(Datum-1,Datum)+AufenthaltsDauer;
       Abfahrt   :s:='Abfahrt von '+s+' um '+Zeit2hmin(zdp^.AbZeit,true)+AufenthaltsDauer+Fahrzeit(Datum,Datum+1);
       Aufenthalt:s:='Aufenthalt von '+s+' in '+Ort2String(zdp^.ort)+AufenthaltsDauer;
       Fahrt     :begin
                    s:='Fahrt von '+s+' von '+Ort2String(zdp^.ort)+' nach ';
                    zdp:=zp^.GetRec(Datum+1);
                    s:=s+Ort2String(zdp^.ort)+Fahrzeit(Datum,Datum+1);
                  end;
       else runerror;
     end;
   end;
   StatusZeile(s);
 End;

 Procedure InvalidateCursor;
 Var zp:PZug;
     zdp:PZugDatum;
     fpc1,fpc2:RFahrplanCursor;
 Begin
   if (DragZug_Cursor.TrefferArt=nix) or (DragZug_Cursor.Fenster=nil) then exit;
   zp:=FahrplanDaten.ZugArray^.GetZug(DragZug_Cursor.Zug);
   zdp:=zp^.GetRec(DragZug_Cursor.Datum);
{senkrecht malen}
   if DragZug_Cursor.TrefferArt in [Ankunft,Abfahrt,Aufenthalt] then begin
     fpc1.ort:=zdp^.ort;
     fpc2.ort:=zdp^.ort;
     fpc1.zeit:=zdp^.anZeit;
     fpc2.zeit:=zdp^.abZeit;
     DragZug_Cursor.Fenster^.UserInvalidate(fpc1,fpc2,true);
   end;
{Aufenthalt fertig}
   if DragZug_Cursor.TrefferArt=Aufenthalt then exit;
(*
{Ankunft/Abfahrt am Anfang/Ende des Zuges fertig}
   case DragZug_Cursor.TrefferArt of
     Ankunft:if DragZug_Cursor.Datum=zp^.anzahl then exit;
     Abfahrt:if DragZug_Cursor.Datum=1 then exit;
   end; {halb sichtbares wird in "UserInvalidate2" ignoriert}
*)
{diagonal malen}
   fpc1.ort:=zdp^.ort;
   case DragZug_Cursor.TrefferArt of
     Ankunft:begin
               fpc1.zeit:=zdp^.anZeit;
               zdp:=zp^.GetRec(DragZug_Cursor.Datum-1);
               fpc2.ort:=zdp^.ort;
               fpc2.zeit:=zdp^.abZeit;
             end;
     Abfahrt,Fahrt:begin
                     fpc1.zeit:=zdp^.abZeit;
                     zdp:=zp^.GetRec(DragZug_Cursor.Datum+1);
                     fpc2.ort:=zdp^.ort;
                     fpc2.zeit:=zdp^.anZeit;
                   end;
     else runerror;
   end;
   DragZug_Cursor.Fenster^.UserInvalidate(fpc1,fpc2,true);
 End;

VAR MouseMove_CursorZeit:TZeit;
    MouseMove_DeltaT:word;
    Schleife_ueber_Zuege,Schleife_ueber_Zugdaten:word;

FUNCTION PlaceCursor(window:PEditSheet; C:RFahrplanCursor):boolean;

 Function Test(Zeit:TZeit; Art:TTrefferArt):boolean;
 Var delta:word;
     Ergebnis:boolean;
 Begin
   delta:=abs(zeit-MouseMove_CursorZeit);
   Ergebnis:=delta<MouseMove_DeltaT;
   Test:=Ergebnis;
   if Ergebnis then begin
     Test:=true;
     MouseMove_DeltaT:=delta;
     DragZug_Cursor.Zug  :=Schleife_ueber_Zuege;
     DragZug_Cursor.Datum:=Schleife_ueber_Zugdaten;
     DragZug_Cursor.TrefferArt:=Art;
   end;
 End;

VAR zdp, alt_zdp:PZugDatum;
CONST MaxAbstand=8;
BEGIN
{Erst alten Cursor, wenn vorhanden, uebermalen}
  DragZug_KillCursor;
{neue Cursorposition bestimmen}
  PlaceCursor:=false;
  MouseMove_CursorZeit:=C.Zeit;
  MouseMove_DeltaT:=$FFFF;
  DragZug_Cursor.TrefferArt:=nix;
  for Schleife_ueber_Zuege:=1 to FahrplanDaten.ZugArray^.GetAnzahl
  do WITH FahrplanDaten.ZugArray^.GetZug(Schleife_ueber_Zuege)^ DO BEGIN
    if C.Ort.Gleis=0 then begin
      alt_zdp:=GetRec(1);
      for Schleife_ueber_Zugdaten:=1 to GetAnzahl-1 do begin
        zdp:=GetRec(Schleife_ueber_Zugdaten+1);
        if c.ort.knoten=c.zweitknoten then runerror;
        if zdp=alt_zdp then runerror;
        if ((alt_zdp^.ort.knoten=c.ort.knoten) or (alt_zdp^.ort.knoten=c.ZweitKnoten)) and
           ((    zdp^.ort.knoten=c.ort.knoten) or (    zdp^.ort.knoten=c.ZweitKnoten)) {zwischen Bahnhfen}
            then Test((zdp^.Anzeit+alt_zdp^.Abzeit) div 2, Fahrt);
        alt_zdp:=zdp;
      end;
    end else for Schleife_ueber_Zugdaten:=1 to GetAnzahl do begin
      zdp:=GetRec(Schleife_ueber_Zugdaten);
      if (zdp^.ort.Knoten=C.ort.Knoten) and (zdp^.ort.Gleis=C.ort.Gleis) then begin
        if (Schleife_ueber_Zugdaten<>GetAnzahl)
         then Test(zdp^.AbZeit+3, Abfahrt);
        if {(Schleife_ueber_Zugdaten<>1) and (Schleife_ueber_Zugdaten<>anzahl)} true
         then Test((zdp^.AbZeit+zdp^.AnZeit) div 2, Aufenthalt);
        if (Schleife_ueber_Zugdaten<>1)
         then Test(zdp^.AnZeit-3, Ankunft);
      end;
    end;
  END; {with FahrplanDaten.ZugArray^.getzug(...)}
{fertig, neuen Cursor ggf. hinmalen}
  if MouseMove_DeltaT>MaxAbstand then begin
    DragZug_Cursor.TrefferArt:=nix;
    PlaceCursor:=false;
  end else begin
    PlaceCursor:=true;
    DragZug_Cursor.Fenster:=window;
    InvalidateCursor;
  end;
  MachStatusZeile;
END;


PROCEDURE DragZug_MouseMove(window:PEditSheet; C:RFahrplanCursor);
VAR DatenVeraendert:boolean;
    zdp,zdp2:PZugDatum;
    temp:TZeit;
BEGIN
  DatenVeraendert:=false;
  dec(c.zeit,CursorZeitVersatz);
  if DragAndDrop then if (c.Zeit<Minimum) then begin
    StatusZeile('zu frh!!!!!!!!!!');
  end else if (c.Zeit>Maximum) then begin
    StatusZeile('zu spt');
  end else begin
    InvalidateCursor;
    zdp:=GetTheZDP(0);
    case DragZug_Cursor.TrefferArt of
      nix:runerror;
      Ankunft   :begin
                   zdp^.AnZeit:=c.Zeit;
                   DatenVeraendert:=true;
                 end;
      Abfahrt   :begin
                   zdp^.AbZeit:=c.Zeit;
                   DatenVeraendert:=true;
                 end;
      Fahrt     :begin
                   zdp2:=GetTheZDP(+1);
                   temp:=zdp2^.AnZeit-zdp^.AbZeit;  {Fahrzeit}
                   zdp ^.AbZeit:=c.Zeit;      {neue Abfahrtszeit}
                   zdp2^.AnZeit:=c.Zeit+temp; {neue Ankunftszeit}
                   DatenVeraendert:=true;
                 end;
      Aufenthalt:begin
                   DatenVeraendert:=(c.ort.knoten=backup.primary.ort.knoten) and (c.ort.gleis<>0);
                   if DatenVeraendert and (zdp^.ort.gleis<>c.ort.gleis) then begin
                     zdp^.ort.gleis:=c.ort.gleis;
                     window^.NeuZeichnen;
                   end;
                 end;
      else runerror;
    end;
    if DragZug_Cursor.Datum=1 then zdp^.AnZeit:=zdp^.AbZeit;
    temp:=FahrplanDaten.ZugArray^.GetZug(DragZug_Cursor.Zug)^.GetAnzahl;
    if (DragZug_Cursor.Datum=temp) then zdp^.AbZeit:=zdp^.AnZeit
    else if ((DragZug_Cursor.TrefferArt=Fahrt) and (DragZug_Cursor.Datum=temp-1)) then zdp2^.AbZeit:=zdp2^.AnZeit;
  end;
  if DatenVeraendert then begin
    MachStatusZeile;
    InvalidateCursor;
  end;
END;


PROCEDURE DragZug_lMouseDown(window:PEditSheet; C:RFahrplanCursor);
VAR zdp,zdp2:PZugDatum;
    Zeit:TZeit;
BEGIN
  DragAndDrop:=PlaceCursor(window, C);
  if DragAndDrop then begin
    zdp:=GetTheZDP(0);
    Backup.primary:=zdp^;
    case DragZug_Cursor.TrefferArt of
      Ankunft,Abfahrt,Fahrt:SetCursor(MausZeiger.ObenUnten);
      Aufenthalt:SetCursor(MausZeiger.LinksRechts);
      nix:runerror;
      else runerror;
    end;
    with DragZug_Cursor do case TrefferArt of
      Ankunft   :begin
                   Minimum:=GetTheZDP(-1)^.AbZeit+1; {Fahrt in 1min}
                   if datum=FahrplanDaten.ZugArray^.GetZug(zug)^.GetAnzahl
                     then Maximum:=MaxZeit
                     else Maximum:=zdp^.AbZeit; {Aufenthalt=0min}
                   CursorZeitVersatz:=c.Zeit-zdp^.AnZeit;
                 end;
      Abfahrt   :begin
                   if datum=1
                     then Minimum:=MinZeit
                     else Minimum:=zdp^.AnZeit; {Aufenthalt=0min}
                   Maximum:=GetTheZDP(+1)^.AnZeit-1; {Fahrt in 1min}
                   CursorZeitVersatz:=c.Zeit-zdp^.AbZeit;
                 end;
      Aufenthalt:begin
                   {egal, wird nicht gespeichert}
                   Minimum:=MinZeit;
                   Maximum:=MaxZeit;
                   CursorZeitVersatz:=c.Zeit-zdp^.AnZeit;
                 end;
      Fahrt     :begin
                   zdp2:=GetTheZDP(+1);
                   Backup.Secondary:=zdp2^;
                   Zeit:=(zdp2^.AnZeit-zdp^.AbZeit);
                   if datum=1
                     then Minimum:=MinZeit
                     else Minimum:=zdp^.AnZeit;      {Aufenthalt=0min am Start}
                   if datum+1=FahrplanDaten.ZugArray^.GetZug(zug)^.GetAnzahl
                     then Maximum:=MaxZeit
                     else Maximum:=zdp2^.AbZeit-Zeit; {Aufenthalt=0min am Ziel}
                   CursorZeitVersatz:=c.Zeit-zdp^.AbZeit;
                 end;
    end;
  end;
END;

PROCEDURE DragZug_lMouseUp(window:PEditSheet);
VAR fehler:string;
BEGIN
  if DragAndDrop then begin
    SetCursor(MausZeiger.Arrow);
    DragAndDrop:=false;
    if AutoCheck.GetValue and ErsterFehlerInZug(DragZug_Cursor.Zug, Fehler) then begin
      if bwccmessagebox(window^.hWindow,
                        String2pchar(Fehler),
                        'Daten inkonsistent! Trotzdem nehmen?',
                        mb_OKCancel
                       )=id_Cancel then begin
        GetTheZDP(0)^:=Backup.primary;
        if DragZug_Cursor.TrefferArt=Fahrt then GetTheZDP(1)^:=Backup.secondary;
        FahrplanDaten.GetLinienArray^.EditorenNeuZeichnen;
      end else FahrplanDaten.ZuegeVeraendert
    end else FahrplanDaten.ZuegeVeraendert;
  end;
END;

PROCEDURE DragZug_rMouseDown(window:PEditSheet; C:RFahrplanCursor);
BEGIN
  if not PlaceCursor(window, C) then MessageBeep(mb_IconHand);
END;


PROCEDURE DragZug_KillCursor;  {wird beim Schliessen von Fahrplaneditorsheets aufgerufen}
BEGIN
  InvalidateCursor;
  DragZug_Cursor.TrefferArt:=nix;
  DragZug_Cursor.Fenster:=nil;
END;

BEGIN
  DragZug_Cursor.TrefferArt:=nix;
  DragZug_Cursor.Fenster:=nil;
  with MausZeiger do begin
    LinksRechts:=LoadCursor(0,idc_sizewe);
    ObenUnten  :=LoadCursor(0,idc_sizens);
    Arrow      :=LoadCursor(0,idc_arrow);
  end;
END.