UNIT Edit_Sht;

{$A+,B-,G+,I+,V-,X+,T+,P+}
{$R-,S-,Q-}

INTERFACE
USES oWindows, oDialogs, WinTypes,
     ZugArr, Spalten, Ort_Zeit, NodeEdge, Abst_Sht, zeit_y;

TYPE RFahrplanCursor=RECORD  {logische Mausposition}
                       Ort:ROrt;          {Position im Graph}
                       ZweitKnoten:PNode; {Zweiter Knoten, zwischen denen Gleis=0 ist}
                       Zeit:TZeit;        {Zeitpunkt im Fahrplan}
                     END;

TYPE PEditSheet=^TEditSheet;
     TEditSheet=OBJECT(TAbstractSheet)
                  SpaltenArray:TSpaltenArray;   {Array ber alle senkrechten Klickpositionen}
                  CONSTRUCTOR init(aparent:PWindow; GF:TGraphenFarbe; TheUmrechner:PUmrechner);
                  DESTRUCTOR done;       virtual;
                  PROCEDURE SetupWindow; virtual;
                  PROCEDURE NeuZeichnen;
                  FUNCTION GetStundenAufSeite:word;
                  PROCEDURE UserInvalidate(CONST p1,p2:RFahrplanCursor; HG_loeschen:boolean);
                  PROCEDURE WMClose(VAR msg:TMessage); virtual wm_first+wm_close;
                PRIVATE
                  Umrechner:PUmrechner;
                  AusschnittZeichnen:boolean; {wird von UserInvalidate gesetzt und von Paint zurueckgesetzt}
                  GraphenFarbe:TGraphenFarbe; {Um entscheiden zu koennen, wann ein Zug gezeichnet wird}
                  ZeitIntervall:record von,bis:TZeit; end; {bei AusschnittZeichnen=true}
                  FUNCTION SetCursor:boolean;   virtual;
                  PROCEDURE MouseMove;          virtual;
                  PROCEDURE lButtonDown;        virtual;
                  PROCEDURE lButtonUp;          virtual;
                  PROCEDURE rButtonDown;        virtual;

                  PROCEDURE PaintZug(DC:HDC; Zug:TZug; thick:boolean; Zahlen,Namen:boolean);
                  PROCEDURE Paint(PaintDC:HDC; VAR PaintInfo:TPaintStruct); virtual;

                  PROCEDURE CursorPosAusrechnen(VAR Cursor:RFahrplanCursor);
                  FUNCTION Ort2X(Ort:ROrt):integer;
                  FUNCTION Knoten2leftX(Knoten:PNode):integer;
                  FUNCTION Knoten2rightX(Knoten:PNode):integer;
                END;


IMPLEMENTATION
USES WinProcs, Win_Allg, Grund, Strings, ProgExit, heap,
     Daten, InsrtZug, DragZug, RFarben;

CONST ort2x_fehler=-1;

VAR ZeitSchrift:hFont;
    NameSchrift:hFont;

CONSTRUCTOR TEditSheet.init(aparent:PWindow; gf:TGraphenFarbe; TheUmrechner:PUmrechner);
BEGIN
  inherited init(aparent);
  SpaltenArray.init;
  GraphenFarbe:=gf;
  AusschnittZeichnen:=false;
  Umrechner:=TheUmrechner;
END;

DESTRUCTOR TEditSheet.done;
BEGIN
  DragZug_KillCursor;
  inherited done;
  SpaltenArray.done;
END;

PROCEDURE TEditSheet.SetupWindow;
BEGIN
  inherited Setupwindow;
  Neuzeichnen; {um den zoom auszurechnen}
END;

PROCEDURE TEditSheet.WMClose(VAR Msg:TMessage);
BEGIN
  inherited WMClose(msg);
END;


FUNCTION TEditSheet.Ort2X(ort:ROrt):integer;
VAR i:iSpalten;
BEGIN
  i:=SpaltenArray.Ort2Spalte(ort);
  if i=0 then Ort2X:=ort2x_fehler
         else Ort2X:=SpaltenArray.GetX(i);
END;

FUNCTION TEditSheet.Knoten2leftX(Knoten:PNode):integer;
VAR Ort:ROrt;
BEGIN
  Ort.Knoten:=Knoten;
  Ort.Gleis:=1;
  Knoten2leftX:=Ort2x(Ort);
END;

FUNCTION TEditSheet.Knoten2rightX(Knoten:PNode):integer;
VAR w:word;
    i:iSpalten;
    Ort:ROrt;
    Spalte:PSpalte;
BEGIN
  Ort.Knoten:=Knoten;
  Ort.Gleis:=1;
  with SpaltenArray do begin
    i:=Ort2Spalte(ort);
    while (anzahl>i) and (GetKnoten(i+1)=Knoten) do inc(i);
    if GetGleis(i)=0 then Knoten2RightX:=GetX(i-1)
                     else Knoten2rightX:=GetX(i);
  end;
END;

PROCEDURE TEditSheet.CursorPosAusrechnen(VAR Cursor:RFahrplanCursor);
VAR xvorher,neu:integer;
    geraten:iSpalten;
    ClientRect:TRect;
CONST abweich=2;
BEGIN
  if SpaltenArray.anzahl<2 then runerror;
  if MouseInWindow then begin
    GetClientRect(hWindow, ClientRect);
    with SpaltenArray do begin
      geraten:=MouseCursor.x div ClientRect.right * anzahl;
      if geraten>anzahl then runerror;
      if geraten=0 then geraten:=1;
      xvorher:=GetX(geraten);
      if MouseCursor.X>xvorher+abweich then begin
        while (geraten<anzahl) and (MouseCursor.X>((GetX(geraten+1)+xvorher) div 2)) do begin
          inc(geraten);
          xvorher:=GetX(geraten);
        end;
      end else if MouseCursor.X<xvorher-abweich then begin
        while (geraten>1) and (MouseCursor.X<((GetX(geraten-1)+xvorher) div 2)) do begin
          dec(geraten);
          xvorher:=GetX(geraten);
        end;
      end;
      Cursor.ort.Knoten:=GetKnoten(geraten);
      Cursor.ort.Gleis:=GetGleis(geraten);
      if GetGleis(geraten)=0 then Cursor.ZweitKnoten:=GetKnoten(geraten+1); {+1, weil hier
          klar ist, das der primaere (in TOrt gespeicherte) Knoten links angezeigt werden}
      Cursor.Zeit:=Umrechner^.Y2Zeit(Mousecursor.Y);
    end; {with spaltenarray}
  end else begin
    Cursor.ort.Knoten:=nil;
    Cursor.ort.Gleis:=0;
    Cursor.Zeit:=keineZeit;
  end;
END;

{*********************************** Window-Messages **************************************}

PROCEDURE TEditSheet.lButtonDown;
VAR Cursor:RFahrplanCursor;
BEGIN
  CursorPosAusrechnen(Cursor);
  if InsertZug_Idle then begin
    DragZug_lMouseDown(@self,Cursor);
  end else begin
    InsertZug_MouseDown(@self,Cursor);
  end;
END;

PROCEDURE TEditSheet.lButtonUp;
BEGIN
  if InsertZug_Idle then begin
    DragZug_lMouseUp(@self);
  end else begin
    InsertZug_MouseUp(@self);
  end;
END;

FUNCTION TEditSheet.SetCursor:boolean;
VAR Cursor:RFahrplanCursor;
    selbermachen:boolean;
BEGIN
  selbermachen:= (not InsertZug_Idle) and (Capture=none);
  if SelberMachen then begin
    CursorPosAusrechnen(Cursor);
    InsertZug_MouseMove(@self,Cursor);
  end;
  SetCursor:=SelberMachen;
END;

PROCEDURE TEditSheet.MouseMove;
VAR Cursor:RFahrplanCursor;
BEGIN
  CursorPosAusrechnen(Cursor);
  If Capture=Left then begin
    if InsertZug_Idle then DragZug_MouseMove(@self,Cursor)
                      else InsertZug_MouseMove(@self,Cursor);
  end;
END;

PROCEDURE TEditSheet.rButtonDown;
VAR Cursor:RFahrplanCursor;
BEGIN
  if InsertZug_Idle then begin
    CursorPosAusrechnen(Cursor);
    DragZug_rMouseDown(@self, Cursor);
  end;
END;

{***************************}

FUNCTION TEditSheet.GetStundenAufSeite:word;
BEGIN
  GetStundenAufSeite:=(Umrechner^.y2zeit(attr.h)-Umrechner^.y2zeit(0)) div 60
END;

PROCEDURE TEditSheet.NeuZeichnen;
BEGIN
  Umrechner^.SetZoom;
  InvalidateRect(hWindow,nil,true);
END;

PROCEDURE TEditSheet.PaintZug(DC:HDC; Zug:TZug; thick:boolean; Zahlen,Namen:boolean);
VAR w:word;                {Schleife ber Zugdaten}
    ZeitString:string[10]; {Puffer fuer TextOut}
    AltFont:hFont;         {zum restaurieren}
    NeuDaten,AltDaten:record
                        Datum:RZugDatum;
                        x,leftX,rightX:integer;
                        anY,abY:integer;
                      end;
    dx,dy:integer;         {Erster Teil der Schleife: dy/dx ist Steigung einer Fahrtlinie
                            Zweiter Teil            : Breite, Hoehe des Zugnamens}
    temp:integer;
    x1,y1,x2,y2:integer;   {Positionen der Zeiten}
    TextExtend:longint;
BEGIN
{thick=true heit, dass der Zug gerade eingegeben wird, und deshalb als dickerer
 Strich hervorgehoben wird}
  if thick then ReglerFarbeSelectThick(dc,Zug.Regler)
           else ReglerFarbeSelectSolid(dc,Zug.Regler);
{kleine Schrift fr Minuten einschalten}
  AltFont:=SelectObject(dc,ZeitSchrift);
{Zug existiert nicht? Kann bei gerade eingegebenem Zug passieren}
  if Zug.GetAnzahl=0 then exit;
{Zeichenschleife}
  for w:=1 to Zug.GetAnzahl do begin
    with NeuDaten do begin
      Datum:=Zug.GetRec(w)^;
      x:=Ort2X(Datum.ort);
      if x<>Ort2X_fehler then begin
        if Datum.AnZeit<>KeineZeit then any:=Umrechner^.Zeit2Y(Datum.AnZeit);
        if Datum.AbZeit<>KeineZeit then aby:=Umrechner^.Zeit2Y(Datum.AbZeit);
        if Namen or Zahlen then begin
          leftX:=Knoten2leftX(Datum.ort.knoten);
          rightX:=Knoten2rightX(Datum.ort.knoten);
        end;
      end;
    end; {with}
    if w=1 then begin
      if (NeuDaten.x<>ort2x_fehler) and (NeuDaten.Datum.AnZeit<>KeineZeit) then begin
        MoveTo(dc,NeuDaten.x,NeuDaten.any);
        LineTo(dc,NeuDaten.x,NeuDaten.aby);
        if NeuDaten.any<>NeuDaten.aby then runerror;
      end;
    end {w=1} else {w<>1} begin
      if NeuDaten.x=ort2x_fehler then begin
        if AltDaten.x<>ort2x_fehler then begin
          {abgehender Pfeil}
        end;
      end else begin
        if AltDaten.x=ort2x_fehler then begin
          {ankommender Pfeil}
          MoveTo(dc,NeuDaten.x,NeuDaten.any);
        end else begin
          if Zahlen or Namen then begin
            dx:=NeuDaten.x-AltDaten.x;
            dy:=NeuDaten.any-AltDaten.aby;
            {Abfahrtszeit}
            str(AltDaten.Datum.AbZeit mod 60, ZeitString);
            if dx>0 then begin
              x1:=AltDaten.rightX+2;
              temp:=x1+14;
              SetTextAlign(dc, ta_left or ta_top);
            end else begin
              x1:=AltDaten.leftX;
              temp:=x1-14;
              SetTextAlign(dc, ta_right or ta_top);
            end;
            y1:=AltDaten.aby+ (temp-AltDaten.x)*dy div dx;
            if Zahlen then TextOut(dc,x1,y1, @ZeitString[1],length(ZeitString));
            {Ankunftszeit}
            str(NeuDaten.Datum.AnZeit mod 60, ZeitString);
            if dx>0 then begin
              x2:=NeuDaten.leftX;
              temp:=x2-14;
              SetTextAlign(dc, ta_right or ta_bottom);
            end else begin
              x2:=NeuDaten.rightX+2;
              temp:=x2+14;
              SetTextAlign(dc, ta_left or ta_bottom);
            end;
            y2:=NeuDaten.any+ (temp-NeuDaten.x)*dy div dx;
            if (Zahlen) and ((NeuDaten.Datum.AnZeit<>NeuDaten.Datum.AbZeit) or (Zug.GetAnzahl=w))
              then TextOut(dc,x2,y2, @ZeitString[1],length(ZeitString))
              else with NeuDaten do Rectangle(dc, x-1,any-1, x+2,any+2); {Punkt bei Durchfahrt}
          end; {if Zahlen or Namen}
          {diagonale Fahrtenlinie}
          LineTo(dc,NeuDaten.x,NeuDaten.any);
          {Name des Zuges}
           if Namen then begin
            TextExtend:=GetTextExtent(dc,@Zug.name[1],length(Zug.Name));
            dx:=integer(loword(TextExtend));
            dy:=integer(hiword(TextExtend));
            x1:=((x1+x2) div 2) - (dx div 2);
            y1:=((y1+y2) div 2) - (dy div 2);
            Rectangle(dc, x1-2, y1-1, x1+dx+1, y1+dy+1);
            SetTextAlign(dc, ta_top or ta_left);
            TextOut(dc, x1, y1, @Zug.name[1], length(Zug.Name));
          end; {if namen}
        end; {altdaten.x<>ort2x_fehler}
        LineTo(dc,NeuDaten.x,NeuDaten.aby);  {senkrechte Ortslinie Linie}
      end;
    end;  {w<>1}

    AltDaten:=NeuDaten;
  end;  {for}
{freigeben, alte Zustnde restaurieren}
  SelectObject(dc,AltFont);
  SetTextAlign(dc,ta_left or ta_top);
END;

PROCEDURE TEditSheet.Paint(PaintDC:HDC; VAR PaintInfo:TPaintStruct);
 Procedure Line(dc:HDC; x1,y1,x2,y2:word);
 Begin
   moveto(DC,x1,y1);
   lineto(DC,x2,y2);
 End;
VAR i:word;
    fuck:integer;
    altBf:word;
    zdp:PZugDatum;
    altPen:HPen;
    Zeit:TZeit;
    Punkt:TPoint;
    flag1,flag2:boolean;
    zp:PZug;
    lpen, laltpen:hpen;
BEGIN
  if SpaltenArray.anzahl<2 then runerror;
  altBf:=0;
  with attr do begin
{Senkrechte Linien}
    with SpaltenArray do for i:=1 to anzahl do begin
      fuck:=GetX(i);
      if not (GetGleis(i)=0) then Line(PaintDC, fuck, 1, fuck, h-3);
    end;
{Waagerechte Linien}
    i:=(Umrechner^.GetFensterObenZeit+62) div 60;
    lpen:=createpen(ps_dot,1,0);
    laltpen:=selectobject(paintdc, lpen);
    repeat
      fuck:=Umrechner^.Zeit2Y(i*60);
      line(PaintDC, 1, fuck, w-3, fuck);
      inc(i);
    until (fuck-63>h) or (i=24);
    SelectObject(paintdc, laltpen);
    DeleteObject(lpen);
  end;

  altPen:=ReglerFarbeSelectSolid(PaintDC,keine);
  if not AusSchnittZeichnen then with ZeitIntervall do begin
    von:=Umrechner^.GetFensterObenZeit;
    bis:=von+attr.h;
  end;
  if InsertZug_Idle then begin
{Keine Zugeinfuegung im Gange}
    flag1:=DragZug_Idle;
    for i:=1 to FahrplanDaten.ZugArray^.GetAnzahl do begin
      flag2:=flag1 or (DragZug_Cursor.Zug=i);
      PaintZug(PaintDC,FahrplanDaten.ZugArray^.GetZug(i)^,false, flag2, flag2);
    end;
  end else begin
{momentane Eingabe}
    PaintZug(PaintDC,EditierterZug,true,true,true);
{Daten, Daten, Daten...}
    flag1:=InsertZug_Idle or not AusschnittZeichnen;
    for i:=1 to FahrplanDaten.ZugArray^.GetAnzahl do begin
      zp:=FahrplanDaten.ZugArray^.GetZug(i);
      if (zp^.GetRec         (1)^.AbZeit<ZeitIntervall.bis) and
         (zp^.GetRec(zp^.GetAnzahl)^.AnZeit>ZeitIntervall.von)
         then PaintZug(PaintDC,zp^,false, flag1, flag1);
    end;
  end;

  SelectObject(PaintDC,altPen);

{Cursor malen}
  if DragZug_Cursor.Fenster=@self then begin
    zdp:=FahrplanDaten.ZugArray^.GetZug(DragZug_Cursor.Zug)^.GetRec(DragZug_Cursor.Datum);
    case DragZug_Cursor.TrefferArt of
      nix:;
      Ankunft      :Zeit:=zdp^.AnZeit;
      Abfahrt,Fahrt:Zeit:=zdp^.AbZeit;
      Aufenthalt   :Zeit:=(zdp^.AnZeit+zdp^.AbZeit) div 2;
      else runerror;
    end;
    with Punkt do begin
      x:=Ort2X(zdp^.ort);
      y:=Umrechner^.Zeit2Y(Zeit);
      if DragZug_Cursor.TrefferArt=Fahrt then begin
        zdp:=FahrplanDaten.ZugArray^.GetZug(DragZug_Cursor.Zug)^.GetRec(DragZug_Cursor.Datum+1);
        x:=(x+Ort2X(zdp^.ort)) div 2;  {ist leider nicht in der Mitte :-(}
        y:=(y+Umrechner^.Zeit2Y(zdp^.AnZeit)) div 2;
      end;
      Rectangle(PaintDC, x-3, y-3 ,x+4, y+4);
    end;
  end;

  AusschnittZeichnen:=false;
  ZeitIntervall.von:=60*12-1;
  ZeitIntervall.bis:=1;
END;

PROCEDURE TEditSheet.UserInvalidate(CONST p1,p2:RFahrplanCursor; HG_loeschen:boolean);
VAR Rechteck:TRechteck;
    Point1,Point2:TPoint;
    Fehler1,Fehler2:boolean;
BEGIN
  AusschnittZeichnen:=true;

  Point1.x:=ort2x(p1.ort);
  Fehler1:=(Point1.x=ort2x_fehler);
  Point1.y:=Umrechner^.zeit2y(p1.zeit);

  Point2.x:=ort2x(p2.ort);
  Fehler2:=(Point2.x=ort2x_fehler);
  Point2.y:=Umrechner^.zeit2y(p2.zeit);
(*
  if Fehler1 and Fehler2 then messagebox(hwindow, 'edit_sht.pas #458', 'hoppla', mb_ok); {tritt auf, deshalb kein runerror}

  Dieser Fehler liess sich erzeugen, wie folgt:
  - Programmstart
  - Debug-Standart
  - Hauptstrecke vergroessern (maximum?)
  - Ne 52?? verschieben (Fehler mit cancel beantworten)
  - beenden
*)
  {Fehler1 or Fehler2 tritt z.B. auf, wenn beim Einfuegen von Zuegen der Startbf einer
   Fahrt nicht im angeklickten Fenster ist}
  if Fehler1 then Rechteck.init(Point2) else begin
    Rechteck.init(Point1);
    if not Fehler2 then Rechteck.AddPoint(Point2);
  end;

  Rechteck.Vergroessern(4,10); {y mehr, damit Zeiten mitgeloescht werden}
  with ZeitIntervall do with Rechteck.Rechteck do begin
    if von>top    then von:=top;
    if bis<bottom then bis:=bottom;
  end;

  InvalidateRect(Hwindow, @Rechteck.Rechteck, HG_loeschen);
END;


PROCEDURE Edit_Sht_Init;
VAR LogFont:TLogFont;
BEGIN
{Schrift fuer Beschriftung der x-Achse}
  fillchar(LogFont,sizeof(LogFont),0);
  with LogFont do begin
    lfHeight:=14;
    lfWidth:=0;
    lfEscapement:=0;
    lfOrientation:=0;
    lfWeight:=400;
    lfItalic:=0;
    lfUnderline:=0;
    lfStrikeOut:=0;
    lfCharSet:=ANSI_CHARSET; {?}
    lfOutPrecision:={OUT_TT_ONLY_PRECIS}0;
    lfClipPrecision:=CLIP_DEFAULT_PRECIS;
    lfQuality:=DEFAULT_QUALITY;
    lfPitchAndFamily:={TMPF_TRUETYPE or }FF_DONTCARE;
    strcopy(lfFaceName,'Arial');
  end;
  ZeitSchrift:=CreateFontIndirect(LogFont);
  NameSchrift:=ZeitSchrift;
END;

PROCEDURE Edit_Sht_Done; FAR;
BEGIN
  DeleteObject(ZeitSchrift);
END;

BEGIN
  RegisterExitProc(Edit_Sht_Done);
  Edit_Sht_Init;
END.
