{Projekt: FAHRPLAN

 Autor: Stefan Bormann 94

 Inhalt: Dieses Modul beinhaltet ein Fensterobjekt des Fensters, das die Liste der
         Fehler, die vom Modul Check gefunden wurden anzeigt.
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Err_List;

INTERFACE
USES oWindows, AbsCheck, mdi;

PROCEDURE StartFehlerListenFenster(parent: PNewMDIWindow; const FehlerArray:TFehlerArray);
{bergebenes Array wird kopiert!!}


IMPLEMENTATION
USES Win_Allg, oDialogs, WinDos, grund, Strings, WinProcs, WinTypes,
     MDIchild;

CONST id_ListBox=101;
      id_LeseStatic=102;

TYPE PFenster=^TFenster;
     TFenster=OBJECT(TFahrplanMDIChild)
                Eintraege:TPcharArray;
                AnzahlStatic:PStatic;
                LeseStatic:PStatic;
                ListBox:PListBox;
                CONSTRUCTOR init(aparent:PNewMDIWindow; const FehlerArray:TFehlerArray);
                DESTRUCTOR done;             virtual;
                FUNCTION GetClassName:pchar; virtual;
                PROCEDURE GetWindowClass(VAR class:TWndClass); virtual;
                PROCEDURE SetupWindow;       virtual;
                PROCEDURE IDListBox(VAR Msg:TMessage); virtual id_first+id_ListBox;
                PROCEDURE Size(x,y:integer); virtual;
              END;

CONSTRUCTOR TFenster.init(aparent:PNewMDIWindow; const FehlerArray:TFehlerArray);
VAR w:word;
    arten:array [TFehlerSchwere] of word;
    s:string;
    zh,zm,zs,zhs:word;
BEGIN
  GetTime(zh,zm,zs,zhs);
  s:='Fehlerliste von '+zahlstr(zh,1)+':'+zweistellig(zm)+{':'+zweistellig(zs)+}#0;
  inherited init(aparent, @s[1]);
  fillchar(arten,sizeof(arten),0);
  Eintraege.init;
  Eintraege.Erweiterung(FehlerArray.anzahl);   (***)
  for w:=1 to FehlerArray.anzahl do begin
    with FehlerArray.GetRec(w)^ do begin;
      case Schwere of
        warning       :s:='Warnung:  ';
        abscheck.error:s:='Fehler:  ';
        fatal         :s:='SCHWERER FEHLER:  ';
      end;
      s:=s+Beschreibung+#0;
      Eintraege.p^[w]:=Strings.StrNew(@s[1]);           (***)
      inc(arten[schwere]);
    end;
  end;
  s:=zahlstr(arten[warning],1)+' Warnungen;  '
    +zahlstr(arten[abscheck.error],1)  +' Fehler;  '
    +zahlstr(arten[fatal],1)  +' schwere Fehler:'+#0;
  new(AnzahlStatic, init(@self, -1,            @s[1], 10,10,10,10, length(s)-1));
  new(LeseStatic,   init(@self, id_LeseStatic, nil,   10,30,10,10, 256));
  new(ListBox,      init(@self, id_ListBox,           10,50,10,10));
  with ListBox^.attr do style:=style and not lbs_sort;
END;

DESTRUCTOR TFenster.Done;
BEGIN
  inherited done;
  Eintraege.done;
END;

FUNCTION TFenster.GetClassName:pchar;
BEGIN
  GetClassName:='FehlerListe';
END;

PROCEDURE TFenster.GetWindowClass(VAR class:TWndClass);
BEGIN
  inherited GetWindowClass(class);
  with class do style:=style and not cs_NoClose;
END;

PROCEDURE TFenster.SetupWindow;
VAR w:word;
BEGIN
  inherited SetupWindow;
  for w:=1 to Eintraege.anzahl do begin
    SendMessage(ListBox^.hWindow, lb_addstring, 0, longint(Eintraege.p^[w]));
  end;
END;

PROCEDURE TFenster.IDListBox(VAR Msg:TMessage);
BEGIN
  if Msg.LparamHi=lbn_SelChange then LeseStatic^.SetCaption(Eintraege.p^[ListBox^.GetSelIndex+1]);
END;

PROCEDURE TFenster.Size(x,y:integer);
CONST Xabstand=4;
      Yabstand=3;
      LeseHoehe=67;
VAR Breite:integer;
BEGIN
  Breite:=x-2*Xabstand;
  MoveWindow(AnzahlStatic^.hWindow, Xabstand, Yabstand,             Breite, 20, true);
  MoveWindow(Listbox^.hWindow,      Xabstand, Yabstand+30,          Breite, y-2*Yabstand-LeseHoehe-40, true);
  MoveWindow(LeseStatic^.hWindow,   Xabstand, y-Yabstand-LeseHoehe, Breite, LeseHoehe, true);
END;


PROCEDURE StartFehlerListenFenster(parent: PNewMDIWindow; const FehlerArray:TFehlerArray);
BEGIN
  Application^.MakeWindow(new(PFenster, init(parent, FehlerArray)));
END;

END.
