{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: TFarbBalken ist ein Unterfenster, dass neben dem Sheet und den
         Scrollbalken im Editorfenster eingeblendet werden kann.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT FarbBalk;

INTERFACE
USES oWindows, WinTypes, WinProcs, heap, grund,
     Optionen, ZugArr, zeit_y;

CONST wm_UserResize=wm_user+3;

TYPE PFarbBalken=^TFarbBalken;
     TFarbBalken=OBJECT(TWindow)
                   CONSTRUCTOR init(aparent:PWindowsObject; TheUmrechner:PUmrechner);
                   DESTRUCTOR done;  virtual;
                   PROCEDURE NeuZeichnen;
                   PROCEDURE UpdateVisibleness;
                   FUNCTION GetWidth:integer;
                   PROCEDURE Paint(PaintDC:hDC; VAR PaintInfo:TPaintStruct);  virtual;
                 PRIVATE
                   Umrechner:PUmrechner;
                   Saeulen:array [TReglerFarbe] of PDynArray;
                   PROCEDURE MachArrays;
                   PROCEDURE FuellArraysMitZeiten;
                   PROCEDURE Zeiten2Balken;
                 END;


IMPLEMENTATION
USES ort_zeit, daten, rFarben;

{******************************* interner Kram ****************************}

TYPE AZug=Array [1..$7FFE] of iZug;
     TZugMenge=OBJECT
                 MaximumAnzahl:word;  {size of array}
                 Anzahl:word;         {count of used places}
                 p:^AZug;
                 CONSTRUCTOR init(anz:word);
                 DESTRUCTOR done;
                 PROCEDURE Add(z:iZug);
                 FUNCTION Search(z:iZug):boolean;
                 PROCEDURE Del(z:iZug);
                 FUNCTION GetEinzigenZug:iZug;
               PRIVATE
                 FUNCTION GetPosition(z:iZug):word;
               END;

CONSTRUCTOR TZugMenge.init(anz:word);
BEGIN
  getmem(p, anz*sizeof(iZug));
  MaximumAnzahl:=anz;
  anzahl:=0;
END;

DESTRUCTOR TZugMenge.done;
BEGIN
  freemem(p, MaximumAnzahl*sizeof(iZug));
END;

PROCEDURE TZugMenge.Add(z:iZug);
BEGIN
  if Anzahl=MaximumAnzahl then runerror;
  inc(Anzahl);
  p^[Anzahl]:=z;
END;

FUNCTION TZugmenge.Search(z:iZug):boolean;
BEGIN
  Search:=GetPosition(z)<>0;
END;

PROCEDURE TZugMenge.Del(z:iZug);
VAR w:word;
BEGIN
  w:=GetPosition(z);
  if w=0 then runerror;
  dec(Anzahl);
  for w:=w to Anzahl do p^[w]:=p^[w+1];
END;

FUNCTION TZugMenge.GetPosition(z:iZug):word;
VAR w:word;
BEGIN
  for w:=1 to Anzahl do if p^[w]=z then begin
    GetPosition:=w;
    exit;
  end;
  GetPosition:=0;
END;

FUNCTION TZugMenge.GetEinzigenZug:iZug;
BEGIN
  if anzahl<>1 then runerror;
  GetEinzigenZug:=p^[1];
END;

{********************************** Fenster *******************************}

CONST Balkenbreite=8;
      dickbreite=6;
      duennbreite=4;

CONSTRUCTOR TFarbBalken.init(aparent:PWindowsObject; TheUmrechner:PUmrechner);
VAR F:TReglerFarbe;
BEGIN
  inherited init(aparent, 'FarbBalken');
  Attr.Style := ws_Border or ws_Child or ws_Visible;
  for f:=MinReglerFarbe to MaxReglerFarbe do Saeulen[f]:=nil;
  Umrechner:=TheUmrechner;
END;

DESTRUCTOR TFarbBalken.done;
VAR f:TReglerFarbe;
BEGIN
  inherited done;
  for f:=MinReglerFarbe to MaxReglerFarbe
    do if Saeulen[f]<>nil
      then dispose(Saeulen[f],done);
END;


PROCEDURE TFarbBalken.UpdateVisibleness;
BEGIN
  if FarbBalkenZeigen.GetValue then show(sw_show)
                               else show(sw_hide);
END;

FUNCTION TFarbBalken.GetWidth:integer;
VAR width:word;
    f:TReglerFarbe;
BEGIN
  width:=0;
  for f:=MinReglerFarbe to MaxReglerFarbe do if Saeulen[f]<>nil then inc(width, BalkenBreite);
  GetWidth:=Width;
END;


TYPE RZugZeit=RECORD
               zeit:TZeit;  {-1:record soll geloescht werden}
               Zug:integer; {positiv:zeit ist abzeit;
                             negativ:zeit ist anzeit;
                             null:folgendes Interval ist Zuglos
                             -1:Konflikt (nach Transformation)}
             END;
{
TYPE RBalken=RECORD
               zeit:TZeit;
               status:(kein_Zug, innerhalb, ausserhalb, Konflikt);
             END;
}
{****************** NeuZeichnen+private Hilfsfunktionen ******************}

PROCEDURE TFarbBalken.MachArrays;
VAR w:word;
    f:TReglerFarbe;
    anz:array [TReglerFarbe] of word;
BEGIN
  for f:=MinReglerFarbe to MaxReglerFarbe do anz[f]:=0;
{Farbennutung zaehlen}
  with FahrplanDaten.ZugArray^
    do for w:=1 to GetAnzahl
      do inc(anz[GetZug(w)^.Regler]);
{Benoetigte Array in "Saeulen" erstellen}
  for f:=MinReglerFarbe to MaxReglerFarbe do if (anz[f]>0) then begin
    if Saeulen[f]=nil then new(Saeulen[f], init)
                      else Saeulen[f]^.Free;
    Saeulen[f]^.Erweiterung(anz[f]*2);
  end else begin
    if Saeulen[f]<>nil then begin
      dispose(Saeulen[f], done);
      Saeulen[f]:=nil;
    end;
  end;
END;

 Function ZeitVergleich(ra,rb:pointer):SignTyp;  Far;
 Var temp:SignTyp;
 Begin
   Temp:=LongIntVergleich(RZugZeit(ra).zeit,RZugZeit(rb).zeit);
   if Temp=0 then Temp:=LongIntVergleich(RZugZeit(rb).Zug,RZugZeit(ra).Zug);
   ZeitVergleich:=Temp;
 End;

PROCEDURE TFarbBalken.FuellArraysMitZeiten;
VAR w:word;
    f:TReglerFarbe;
    pos:array [TReglerFarbe] of word;
BEGIN
  for f:=MinReglerFarbe to MaxReglerFarbe do pos[f]:=0;
{Arrays fuellen}
  with FahrplanDaten.ZugArray^
    do for w:=1 to GetAnzahl
      do with GetZug(w)^
  do begin
    f:=Regler;
    inc(pos[f]);
    with RZugZeit(Saeulen[f]^.p^[pos[f]]) do begin
      Zug:=w;
      Zeit:=GetRec(1)^.AbZeit;
    end;
    inc(pos[f]);
    with RZugZeit(Saeulen[f]^.p^[pos[f]]) do begin
      Zug:=-w;
      Zeit:=GetRec(GetAnzahl)^.AnZeit;
    end;
  end;
{Nach Zeiten sortieren}
  for f:=MinReglerFarbe to MaxReglerFarbe
    do if Saeulen[f]<>nil
      then Saeulen[f]^.Trivial_Sort(ZeitVergleich);
END;
{  with Saeulen[blau]^ do for w:=1 to anzahl do with RZugZeit(p^[w])
    do StrDump_AutoPutString('zug='+zahlstr(zug,4)+'     zeit='+zahlstr(zeit,4));  }

 Function FilterFunc(p:pointer):boolean;  Far;
 Begin
   FilterFunc:=RZugZeit(p).zeit<>-1;
 End;

PROCEDURE TFarbBalken.Zeiten2Balken;
{TYPE RCaster=record case integer of
              1:(zz:RZugZeit;);
              2:(ba:RBalken;);
              3:(p:pointer;);
             end;}
VAR w:word;
    f:TReglerFarbe;
    open:TZugMenge;
BEGIN
  open.init(FahrplanDaten.ZugArray^.GetAnzahl);
  for f:=MinReglerFarbe to MaxReglerFarbe
    do if Saeulen[f]<>nil then  with Saeulen[f]^
  do begin
    w:=0;
    while (w<anzahl) do begin
      inc(w);
      with RZugZeit(p^[w]) do begin
        if (zug>0) then begin
          open.add(zug);
          case open.anzahl of
            1:;
            2:zug:=-1;
            else zeit:=-1;       {loeschen}
          end;
        end else begin
          open.del(-zug);
          case open.anzahl of
            0:zug:=0;
            1:zug:=open.GetEinzigenZug;
            else zeit:=-1;
          end;
        end;{if positiv}
      end; {with}
    end;{while}
    if open.anzahl<>0 then runerror;
    Filter(FilterFunc);
  end;{for,if,with,if}
  open.done;
END;

PROCEDURE TFarbBalken.NeuZeichnen;
BEGIN
{  StrDump_AutoPutString('TFarbBalken.NeuZeichnen');}
  MachArrays;
  FuellArraysMitZeiten;
  Zeiten2Balken;
  invalidaterect(hWindow, nil, true);
END;

{********************************** Paint ******************************}

PROCEDURE TFarbBalken.Paint(PaintDC:hDC; VAR PaintInfo:TPaintStruct);
VAR w:word;
    new,last:RZugZeit;
    f:TReglerFarbe;
    altbrush,ab2:hBrush;
    altpen,ap2:hPen;
    Xstart:integer;
    Schrafur:hBrush;
    lb:TLogBrush;
BEGIN
  if attr.w=GetWidth+2 then begin
    lb.lbstyle:=bs_hatched;
    lb.lbcolor:=0;
    lb.lbhatch:=hs_bdiagonal;
    Schrafur:=CreateBrushIndirect(lb);
    Xstart:=(BalkenBreite-DickBreite) div 2;
    for f:=MinReglerFarbe to MaxReglerFarbe do if Saeulen[f]<>nil then with Saeulen[f]^ do begin
      altbrush:=ReglerFarbeSelectBrush(PaintDC, f);
      altpen:=ReglerFarbeSelectSolid(PaintDC, f);
      last:=RZugZeit(p^[1]);
      for w:=2 to anzahl do begin
        new:=RZugZeit(p^[w]);
        case last.zug of
           0:;
          -1:begin
               ap2:=SelectObject(PaintDC, GetStockObject(black_pen));
               ab2:=SelectObject(PaintDC, Schrafur);
               rectangle(PaintDC, Xstart, Umrechner^.zeit2y(last.zeit), Xstart+DickBreite, Umrechner^.zeit2y(new.zeit));
               SelectObject(PaintDC, ap2);
               SelectObject(PaintDC, ab2);
             end;
          else begin
            rectangle(PaintDC, Xstart, Umrechner^.zeit2y(last.zeit), Xstart+DickBreite, Umrechner^.zeit2y(new.zeit));
          end;
        end;
        last:=new;
      end;
      SelectObject(PaintDC, altbrush);
      SelectObject(PaintDC, altpen);
      inc(Xstart,BalkenBreite);
    end;
    DeleteObject(Schrafur);
  end else PostMessage(parent^.hWindow, wm_UserResize, 0, 0);
END;

END.
