{Projekt: Allgemein verwendbares Modul.

 Autor: Stefan Bormann 95

 Inhalt: "TAbschnitt" und "TFileParser" bilden ein System, aus dem
         sich leicht File-Parser ableiten lassen, die Dateien
         folgenden Schemas lesen:

         [abschnitt1]
         zeile1
         zeile2
         zeile3
         [abschnitt2]
         zeile4
         zeile5

         Fuer jeden Abschnitt muss ein Objekt aus "TAbschnitt"
         abgeleitet werden, dass mindestens die "line"-
         Methode ueberschreibt.
         Im Nachfahren von "TFileParser" muss die Methode
         "Fehler" ueberschrieben werden, um die Fehlertexte
         anzeigen zu koennen.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT FilePars;

INTERFACE

TYPE PAbschnitt=^TAbschnitt;
     PFileParser=^TFileParser;
     {"init" merkt sich den die Daten aus der Kommandozeile;
      "start" wird aufgerufen, bevor die erste Zeile des
              Abschnitts gelesen wird;
      "line"  wird fuer jede nicht leere Zeile im Abschnitt
              einmal aufgerufen;
      "stop"  wird aufgerufen, wenn der Abschnitt zu ende ist,
              weil die Datei zu ende ist oder eine neuer
              Abschnitt begonnen wird;
      "start", "line" und "stop" muessen true zurueckgeben,
      wenn sie Erfolg hatten. Wenn sie false zurueckgeben,
      wird das Laden abgebrochen.}
     TAbschnitt=OBJECT
                  ueberschrift:string[42];
                  Parser:PFileParser;
                  CONSTRUCTOR init(aParser:PFileParser; titel:string);
                  FUNCTION start:boolean;               virtual;
                  FUNCTION line(Zeile:string):boolean;  virtual;
                  FUNCTION stop:boolean;                virtual;
                END;

     TAbschnittArray=Array [1..8000] of PAbschnitt;

     TFileParser=OBJECT
                   Zeile:string;       {zuletzt gelesene Zeile}
                   DateiName:string;
                   IOresultCp:integer;
                   ZeilenZaehler:word;
                   CONSTRUCTOR init(Name:string);
                   FUNCTION Oeffnen:boolean;    virtual;
                   FUNCTION LiesZeile:boolean;  virtual;
                   FUNCTION DoParse(const Tabelle:Array of PAbschnitt):boolean;
                   FUNCTION Schliessen:boolean; virtual;
                   PROCEDURE Fehler(s:string);  virtual;   {abstrakt!}
                   DESTRUCTOR done;             virtual;
                 PRIVATE
                   Datei:text;
                 END;



IMPLEMENTATION
USES objects, grund;

{******************************** Abschnitt *********************************}

CONSTRUCTOR TAbschnitt.init(aParser:PFileParser; titel:string);
BEGIN
  Parser:=aParser;
  ueberschrift:=titel;
END;

FUNCTION TAbschnitt.start:boolean;
BEGIN
  start:=true;
END;

FUNCTION TAbschnitt.line(Zeile:string):boolean;
BEGIN  abstract;  END;

FUNCTION TAbschnitt.stop:boolean;
BEGIN
  stop:=true;
END;


{********************************** Parser **********************************}

CONSTRUCTOR TFileParser.init(Name:string);
BEGIN
  Dateiname:=name;
  IOresultCp:=0;
  ZeilenZaehler:=0;
END;

FUNCTION TFileParser.Oeffnen:boolean;
BEGIN
  assign(datei,dateiname);
{$I-}
  reset(datei);
  IOresultCp:=IOresult;
{$I+}
  Oeffnen:=IOresultCp=0;
END;

FUNCTION TFileParser.LiesZeile:boolean;
VAR temp:string;
BEGIN
  LiesZeile:=false;
  repeat
     if eof(datei) then exit;
     inc(ZeilenZaehler);
{$I-}
     readln(datei,zeile);
     IOresultCp:=IOresult;
     if IOresultCp<>0 then exit;
{$I+}
     temp:=spaceweg(zeile);
  until (temp<>'') and (temp[1]<>'#') and (temp[1]<>';');
  LiesZeile:=true;
END;

FUNCTION TFileParser.DoParse(const Tabelle:Array of PAbschnitt):boolean;
VAR ZeileGelesen:boolean;
    Abschnitt:PAbschnitt;
    TabIndex:word;
BEGIN
  DoParse:=false;
  if not LiesZeile then begin
    Fehler('Keine Daten in Datei');
    exit;
  end;
  if (Zeile<>Tabelle[low(Tabelle)]^.ueberschrift) then begin
    Fehler('Dateianfang fehlerhaft;'+cr+'"'+Tabelle[low(Tabelle)]^.Ueberschrift+'" erwartet!');
    exit;
  end;
{Schleife ueber die Abschnitte}
  for TabIndex:=low(Tabelle) to high(Tabelle) do begin
    Abschnitt:=Tabelle[TabIndex];
{Abschnitt initialisieren}
    if not Abschnitt^.start then exit;
{Schleife ueber die Zeilen im Abschnitt}
    ZeileGelesen:=LiesZeile;
    while (ZeileGelesen) and ((TabIndex=high(Tabelle)) or (Zeile<>Tabelle[TabIndex+1]^.Ueberschrift)) do begin
      if not Abschnitt^.Line(Zeile) then exit;
      ZeileGelesen:=LiesZeile;
    end;
{Abschnitt beenden}
    if not ZeileGelesen and (TabIndex<>high(Tabelle)) then begin
      Fehler('Unerwartetes Ende der Datei;'+cr+'"'+Abschnitt^.Ueberschrift+'" erwartet!');
      exit;
    end;
    if not Abschnitt^.stop then exit;
{nochn Abschnitt?}
  end;
  DoParse:=true;
END;

FUNCTION TFileParser.Schliessen:boolean;
BEGIN
{$I-}
  close(datei);
  IOresultCp:=IOresult;
{$I+}
  Schliessen:=IOresultCp=0;
END;

PROCEDURE TFileParser.Fehler(s:string);
BEGIN
  abstract;
END;

DESTRUCTOR TFileParser.done;
BEGIN
END;






END.
