{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: Die Prozedur "StartDruckProgramm" tut folgendes:
         1. Sicherung der Daten in eine temporaere Datei
         2. Aufruf eines externen Programms, wie im
            Druckoptionen-Dialog definiert.

         Die Prozedur "DruckO
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT FpDruck;

INTERFACE

PROCEDURE StartDruckProgramm;


IMPLEMENTATION
USES fp_allg, Optionen, WinProcs, WinTypes, Daten, win_allg, strings;

PROCEDURE StartDruckProgramm;
VAR Dateiname:array [0..256] of char;
    res:word;
    s:string;
    w:word;
    ok:boolean;
BEGIN
  StatusZeile('schreibe tempraere Datei...');
  GetTempFileName(#0, 'PLN', 0, Dateiname);
  if not FahrplanDaten.DateiSichern(strpas(Dateiname)) then begin
    StatusZeile('Das Schreiben der temporren Fahrplandatei ist fehlgeschlagen');
    Messagebox(0, 'Das Schreiben des Fahrplans in eine temporre Datei ist fehlgeschlagen',
                  'Fehler beim Aufruf des Druckprogramms!',
                  mb_OK or mb_taskmodal);
    exit;
  end;
  StatusZeile('rufe Druckprogramm auf...');

  s:=strpas(DruckKommando.GetValue);
  repeat
    w:=pos('%s', s);
    if w=0 then w:=pos('%S', s);
    ok:= (w=0);
    if not ok then begin
      delete(s, w, 2);
      insert(strpas(Dateiname), s, w);
    end;
  until ok;
  strpcopy(Dateiname, s);

  res:=WinExec(Dateiname, sw_ShowNormal);
  if res>32 then StatusZeile('Druckprogramm wurde erfolgreich gestartet.') else begin
    StatusZeile('Fehler bei Aufruf des Druckprogramms!');
    Messagebox(0, GetWinExecFehlerString(res),
                  'Fehler bei Aufruf des Druckprogramms!',
                  mb_ok or mb_taskmodal);
  end;
END;

END.
