UNIT Fp_edit;
{$A+,B-,G+,I+,V-,X+,W+,N+}

INTERFACE
USES oWindows, WinTypes, heap, oDialogs, Win_Allg,
     nodeedge, Fp_Allg, ZugArr, Strecke, Ort_Zeit, AbsLinAr,
     MDIchild, Edit_Sht, Spalten, ScrollBar, FarbBalk, zeit_y;


CONST cm_zugabbrechen=302;
      wm_UserVertical=wm_user+1;
      wm_UserHorizontal=wm_user+2;

TYPE PEditorFenster=^TEditorFenster;
     TEditorFenster=OBJECT(TFahrplanMDIchild)
                        LineData:PLineData;  {Zeiger auf die Liniedaten von TSimpleLine}
                        CONSTRUCTOR init(aLineData:PLineData);
                        FUNCTION LoadBearbeitenMenu:hMenu;  virtual;
                        PROCEDURE NeueDaten;
                        PROCEDURE NeuZeichnen;
                        FUNCTION AnzahlBahnhoefe:word;

                        PROCEDURE CMZugStarten(VAR Msg:TMessage);     virtual cm_first+cm_zugstarten;
                        PROCEDURE CMZugAbbrechen(VAR Msg:TMessage);   virtual cm_first+cm_zugabbrechen;
                        PROCEDURE CMZugFertig(VAR Msg:TMessage);      virtual cm_first+cm_zugfertig;
                        {PROCEDURE CMdibacken(VAR Msg:TMessage);       virtual cm_first+cm_debuggen;}
                        PROCEDURE WMUserVertical(VAR Msg:TMessage);   virtual wm_first+wm_UserVertical;
                        PROCEDURE WMUserHorizontal(VAR Msg:TMessage); virtual wm_first+wm_UserHorizontal;
                        PROCEDURE WMUserResize(VAR Msg:TMessage);     virtual wm_first+wm_UserResize;
                    PRIVATE
                        Umrechner:TUmrechner;
                        Sheet:PEditSheet;
                        Vertical:PVerticalScrollBar;
                        Horizontal:PHorizontalScrollBar;
                        FarbBalken:PFarbBalken;
                        HintergrundFarbe:TColorRef;
                        SchriftFarbe:TColorRef;
                        PROCEDURE SetupWindow;  virtual;
                        FUNCTION GetClassName:pchar;  virtual;
                        FUNCTION GetIcon:hIcon;   virtual;
                        DESTRUCTOR done;  virtual;

                        PROCEDURE SpaltenAusrechnen;

                        PROCEDURE DoReSize;
                        PROCEDURE Size(x,y:integer); virtual;
                        PROCEDURE Paint(PaintDc:hDC; VAR PaintInfo:TPaintStruct); virtual;
                    END;


IMPLEMENTATION
USES WinProcs, Strings, win31,
     grund, InsrtZug, Dialoge, ProgExit, RFarben, GraphCol, mdi, Optionen;

CONST obenfrei=29;
      linksfrei=19;
      sbBreite=18;
      abstGleis=15;

VAR DuenneSchrift:hFont;

CONSTRUCTOR TEditorFenster.init(aLineData:PLineData);
VAR s:string;
    LogFont:TLogFont;
    w,fuck:word;
TYPE aRGB=array [0..3] of byte;
BEGIN
  LineData:=aLineData;
{geerbtes Fenster initialisieren}
  s:='Fahrplan - '+LineData^.name+#0;
  inherited init(PNewMDIwindow(Application^.MainWindow), @s[1]);  {au weia, watn casting...}
  attr.style:=attr.style+ws_iconic+ws_clipchildren;
{Unterfenster im Clientbereich initialisieren}
  new(Vertical, init(@self, 100, 100, 100, 100, wm_UserVertical));
  with Vertical^ do begin
    Gesammt:=24;
    Seite:=4;
    Position:=0;
  end;
  new(Horizontal, init(@self, 100, 100, 100, 100, wm_UserHorizontal));
  with Horizontal^ do begin
    Gesammt:=10;
    Seite:=4;
    Position:=0;
  end;
  new(Sheet, init(@self, LineData^.Farbe, @Umrechner));
  new(FarbBalken, init(@self, @Umrechner));
{Schner farbiger Hintergrund...}
  HintergrundFarbe:=getgraphenfarbecolorref(LineData^.Farbe);
  Hintergrund:=GetGraphenFarbeBrush(LineData^.Farbe);
  if rgb2GrayScale(HintergrundFarbe)<0.3 then SchriftFarbe:=$FFFFFF
                                         else SchriftFarbe:=0;
  Umrechner.init;
END;

FUNCTION TEditorFenster.LoadBearbeitenMenu:hMenu;
BEGIN
  LoadBearbeitenMenu:=LoadMenu(hInstance, 'EditorFenster');
END;

CONST ClassNameString:Array [0..8+MaxReglerFarbeName] of char='Editor_';
FUNCTION TEditorFenster.GetClassName:pchar;
VAR temp:string[12];
BEGIN
  temp:=GetGraphenFarbeName(LineData^.Farbe)+#0;
  StrCopy(@ClassNameString[7],@temp[1]);
  GetClassName:=ClassNameString;
END;

FUNCTION TEditorFenster.GetIcon:hIcon;
BEGIN
  GetIcon:=loadicon(hinstance,'Fahrplan');
END;

PROCEDURE TEditorFenster.SetupWindow;
BEGIN
  inherited SetupWindow;
  FarbBalken^.UpdateVisibleness;
END;

DESTRUCTOR TEditorFenster.done;
BEGIN
  inherited done;
  LineData^.StreckenArray.done;
END;

FUNCTION TEditorFenster.AnzahlBahnhoefe:word;
BEGIN
  AnzahlBahnhoefe:=LineData^.StreckenArray.GetAnzahl;
END;

PROCEDURE TEditorFenster.CMZugStarten(VAR Msg:TMessage);
VAR ReglerFarbe:TReglerFarbe;
    ZugName:string;
    edit:word;
    Eintraege:TPcharArray;
CONST ZugCounter:word=0;
BEGIN
  inc(ZugCounter);
  ZugName:='Zug #'+zahlstr(ZugCounter,1);
  Eintraege.init;
  for ReglerFarbe:=minReglerFarbe to maxReglerFarbe do begin
    Eintraege.appendstring(GetReglerFarbeName(ReglerFarbe));
  end;
  edit:=1; {default: keine Farbe}
  if MachEditListboxDialog(@self, 'Zug starten',
                           'Zugname:', ZugName,
                           'Reglerfarbe', edit,
                           Eintraege, KeineHilfe) then begin
    ReglerFarbe:=minReglerFarbe;
    while edit>1 do begin
      inc(ReglerFarbe);
      dec(edit);
    end;
    InsertZug_Start(ReglerFarbe,ZugName);
  end;
  Eintraege.done;  {war mal eingeklammert. warum???}
END;

PROCEDURE TEditorFenster.CMZugAbbrechen(VAR Msg:TMessage);
BEGIN
  InsertZug_Reset;
END;

PROCEDURE TEditorFenster.CMZugFertig(VAR Msg:TMessage);
BEGIN
  InsertZug_Accept(Sheet);
END;

PROCEDURE TEditorFenster.Size(x,y:integer);
VAR fbBreite:integer;
    SheetBreite:integer;
BEGIN
  if FarbBalkenZeigen.GetValue then begin
    fbBreite:=FarbBalken^.GetWidth+2;
    MoveWindow(FarbBalken^.hWindow, x-fbBreite-3-1,      obenfrei,     fbBreite,    y-obenfrei-sbBreite-3+1, true);
  end else fbBreite:=0;
  SheetBreite:=x-fbBreite-sbBreite-linksfrei-3+1;
  MoveWindow(Vertical^.Hwindow,   x-fbBreite-sbBreite-3, obenfrei,     sbBreite,    y-obenfrei-sbBreite-3+1, true);
  MoveWindow(Horizontal^.hWindow, linksfrei,             y-sbBreite-3, SheetBreite, sbBreite    ,            true);
  MoveWindow(Sheet^.Hwindow,      linksfrei,             obenfrei,     SheetBreite, y-obenfrei-sbBreite-3+1, true);
  Vertical^.SetSeite(Sheet^.GetStundenAufSeite);
  SpaltenAusrechnen;
END;

PROCEDURE TEditorFenster.WMUserVertical(VAR Msg:TMessage);
BEGIN
  Neuzeichnen;
END;

PROCEDURE TEditorFenster.WMUserHorizontal(VAR Msg:TMessage);
BEGIN
  Sheet^.SpaltenArray.SetOffset(Horizontal^.Position);
  Neuzeichnen;
END;

PROCEDURE TEditorFenster.WMUserResize(VAR Msg:TMessage);
BEGIN
  DoResize;
END;


PROCEDURE TEditorFenster.SpaltenAusrechnen;
BEGIN
  if (LineData^.StreckenArray.GetAnzahl<2) or IsIconic(hWindow) then begin
    Sheet^.SpaltenArray.Free;
    exit;
  end;

  Strecke2Spalten(LineData^.StreckenArray, Sheet^.SpaltenArray, 0,Sheet^.attr.w, abstGleis);
  Sheet^.SpaltenArray.SetOffset(0);

  with Horizontal^ do begin
    Gesammt:=Sheet^.SpaltenArray.GetGesammtBreite;
    Seite:=Sheet^.attr.w;
    SetPosition(0);
  end;
END;


PROCEDURE TEditorFenster.Neuzeichnen;
VAR FensterObenZeit:TZeit;
BEGIN
  {StrDump_AutoPutstring('EditorFenster.NeuZeichnen');}
  FensterObenZeit:=Vertical^.Position*60;
  InvalidateRect(hWindow,nil,true);
  Umrechner.SetFensterObenZeit(FensterObenZeit);
  Sheet^.NeuZeichnen;
  FarbBalken^.NeuZeichnen;
(*
  Vertical^.SetSeite(Sheet^.GetStundenAufSeite);  {fuer Zeitzoom Buttonlaenge neu ermitteln}
gekillt, weil das dialogfenster neuedaten aufruft, der ruft size auf und size macht es!
*)
END;

PROCEDURE TEditorFenster.DoResize;
VAR rect:TRect;
BEGIN
  GetClientRect(hWindow, rect);
  size(rect.right, rect.bottom);
END;

PROCEDURE TEditorFenster.NeueDaten;
BEGIN
  FarbBalken^.UpdateVisibleness;
  with LineData^ do StreckenArray.Aufbauen(anfang,ende,Farbe);
  DoResize;
  NeuZeichnen;
END;

PROCEDURE TEditorFenster.Paint(Paintdc:hDC; VAR PaintInfo:TPaintStruct);
 Procedure Line(dc:HDC; x1,y1,x2,y2:integer);
 Begin
   moveto(DC,x1,y1);
   lineto(DC,x2,y2);
 End;
VAR Pixel:integer;
    altKnoten:PNode;
    Stunde:word;
    i:iSpalten;
    s:string[3];
    altFont:hFont;
    Zustand:(oberhalb, drinnen, unterhalb);
    ClientRect:TRect;
    Name:string[3];
BEGIN
  GetClientRect(hWindow, ClientRect);
  altKnoten:=nil;
  SetBKColor(PaintDc,HintergrundFarbe);
  SetTextColor(PaintDc,SchriftFarbe);
{Senkrechte Linien und Bahnhofsbeschriftung}
  altFont:=SelectObject(Paintdc,DuenneSchrift);
  with Sheet^.SpaltenArray do for i:=1 to anzahl do begin
    Pixel:=Getx(i)+linksfrei+1;
    Name:=GetName(i);
    TextOut(PaintDC, Pixel-length(Name)*4, obenfrei div 2 -2, @Name[1], length(Name));
    if altKnoten<>GetKnoten(i) then begin
      altKnoten:=GetKnoten(i);
      with altKnoten^.Bahnhof.Daten do
        TextOut(paintDC, Pixel-4, -1, @KurzName[1], length(KurzName));
    end;
    Line(PaintDC, Pixel, obenfrei-4, Pixel, obenfrei);
  end;
  SelectObject(Paintdc,altFont);
{Waagerechte Linien und Stundenbeschriftung}

  Zustand:=oberhalb;
  for Stunde:=0 to 23 do begin
    Pixel:=Umrechner.Zeit2Y(Stunde*60)+ObenFrei+1;
    case Zustand of
      oberhalb :if Pixel>ObenFrei then Zustand:=Drinnen;
      drinnen  :if Pixel>ClientRect.bottom then Zustand:=Unterhalb;
      unterhalb:;
      else runerror;
    end;
    if Zustand=drinnen then begin
      str(Stunde:2, s);
      TextOut(PaintDC, 0, Pixel-8, @s[1], 2);
      line(PaintDC, linksfrei-4, Pixel, linksfrei, Pixel);
    end;
  end;
END;

PROCEDURE Fp_Edit_Init;
VAR LogFont:TLogFont;
BEGIN
{Schrift fuer Beschriftung der x-Achse}
  DuenneSchrift:= GetStockObject(ANSI_VAR_FONT);
  GetObject(DuenneSchrift,Sizeof(TLogFont), @LogFont);
  LogFont.lfWeight := 500;
  DuenneSchrift:=CreateFontIndirect(LogFont);
END;

PROCEDURE Fp_Edit_Done; FAR;
BEGIN
  DeleteObject(DuenneSchrift);
END;

BEGIN
  RegisterExitProc(Fp_Edit_Done);
  Fp_Edit_Init;
END.
