{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: Abstrakter Parameterparser und abgeleiteter Typ fuer Benutzung im Fahrplanprogramm
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT Fp_Param;

INTERFACE

CONST Schalterzeichen:char='/';

PROCEDURE Param_Init;


IMPLEMENTATION
USES Optionen, hauptfen, win_allg, Strings, Objects, oDialogs, WinTypes, oWindows, WinProcs;


TYPE SChar=set of char;
     TParamFehler=(Param_FalscherSchalter, Param_ZuWenig, Param_ZuViele, Param_EinzelnerSlash);
     TParam=OBJECT
              CONSTRUCTOR init(erlaubt:SChar; min,max:word);
              FUNCTION Schalter(Zeichen:char; s:string):boolean; virtual;
              FUNCTION Parameter(nr:word; s:string):boolean;     virtual;
              FUNCTION FehlerStr(code:TParamFehler):string;      virtual;
              PROCEDURE StandardHilfe(code:TParamFehler);        virtual;
              PROCEDURE HilfeAnzeigen(HilfeText:string);         virtual;
            END;


CONSTRUCTOR TParam.init(erlaubt:SChar; min,max:word);
VAR s:string;
    c:char;
    w:word;
    pc:word;
BEGIN
  pc:=0;
  for w:=1 to paramcount do begin
    s:=paramstr(w);
    if s[1]=Schalterzeichen then begin
      case length(s) of
        0:runerror;
        1:begin
            StandardHilfe(Param_EinzelnerSlash);
            exit;
          end;
        else begin
            c:=upcase(s[2]);
            if c in erlaubt then begin
              if not Schalter(c, copy(s, 3,length(s)-2)) then exit;
            end else begin
              StandardHilfe(Param_FalscherSchalter);
              exit;
            end;
          end;
      end;
    end else begin
      inc(pc);
      if pc>max then begin
        StandardHilfe(Param_ZuViele);
        exit;
      end;
      if not Parameter(pc, s) then exit;
    end;
  end;
  if pc<min then StandardHilfe(Param_ZuWenig);
END;

FUNCTION TParam.FehlerStr(code:TParamFehler):string;
CONST fs:Array[TParamFehler] of pchar=
         ('Sie haben einen unbekannten Schalter benutzt',
          'Anzahl der Parameter (nicht Schalter) ist zu klein',
          'Anzahl der Parameter (nicht Schalter) ist zu gross',
          'Sie haben einen einzelnen Slash "/" angegeben, der Slash darf aber nur als '+
                  'Praefix fuer einen Schalter benutzt werden');
BEGIN
  FehlerStr:=StrPas(fs[code]);
END;

PROCEDURE TParam.StandardHilfe(code:TParamFehler);
BEGIN
  HilfeAnzeigen(FehlerStr(code));
END;

PROCEDURE TParam.HilfeAnzeigen(HilfeText:string);
BEGIN abstract; END;

FUNCTION TParam.Schalter(Zeichen:char; s:string):boolean;
BEGIN abstract; END;

FUNCTION TParam.Parameter(nr:word; s:string):boolean;
BEGIN abstract; END;




TYPE TFpParam=OBJECT(TParam)
                Laden:string;
                FUNCTION Schalter(Zeichen:char; s:string):boolean; virtual;
                FUNCTION Parameter(nr:word; s:string):boolean;     virtual;
                PROCEDURE HilfeAnzeigen(HilfeText:string);          virtual;
              END;

FUNCTION TFpParam.Schalter(Zeichen:char; s:string):boolean;
BEGIN
  Schalter:=true;
  case Zeichen of
    'D':begin
          DefaultDatenbank.SetValue(String2Pchar(s));
        end;
    else runerror;
  end;
END;

CONST ParamFahrplanLaden:string[100]='';

FUNCTION TFpParam.Parameter(nr:word; s:string):boolean;
BEGIN
  Parameter:=true;
  if nr<>1 then runerror;
  ParamFahrplanLaden:=s;
END;

  TYPE TParamFenster=OBJECT(TDialog)
                       txt:pchar;
                       PROCEDURE SetupWindow;               virtual;
                       PROCEDURE IDHilfe(VAR Msg:TMessage); virtual id_first+998;
                     END;

  PROCEDURE TParamFenster.SetupWindow;
  BEGIN
    inherited SetupWindow;
    SetWindowText(GetDlgItem(hWindow, 110), txt);
  END;

  PROCEDURE TParamFenster.IDHilfe(VAR Msg:TMessage);
  BEGIN
    Hilfe(keineHilfe);
  END;

PROCEDURE TFpParam.HilfeAnzeigen(HilfeText:string);
VAR dlg:TParamFenster;
BEGIN
  dlg.txt:=String2Pchar(HilfeText);
  dlg.init(Application^.MainWindow, 'ParamFehler');
  dlg.execute;
  dlg.done;
  PostQuitMessage(0);
END;


PROCEDURE Param_Init;
VAR Param:TFpParam;
BEGIN
  Param.init(['D'], 0, 1);
  if ParamFahrplanLaden<>'' then PostMessage(Application^.MainWindow^.hWindow,
                                             wm_UserParamLaden,
                                             0, longint(@ParamFahrplanLaden));
END;


END.
