{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: TKnotenArray ist ein Array ueber Knoten vom Typ TNode
         TKantenArraay ist ein Array ueber Kanten vom Typ TEdge
         Die beiden Objekte sind im wesetentlichen dazu da, die
         Typensicherheit beim Zugriff auf das Array zu wahren,
         indem die Methoden von TDynArray auf Typisierte
         versionen 1:1 abgebildet werden.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT GraphArr;

INTERFACE
USES heap, nodeedge;

TYPE iNode=word;  {Index im Array}

TYPE PKnotenArray=^TKnotenArray;
     TKnotenArray=OBJECT
                    CONSTRUCTOR init;
                    DESTRUCTOR done; virtual;
                    FUNCTION NaechsterOrt(wozu:RRelPunkt):word;
                    PROCEDURE VerschiebKnoten(WohinDamit:RRelPunkt; welcher:word);
                    FUNCTION GetRec(bf:iNode):PNode; {Achtung! Wird fast nirgendwo benutzt,
                                                      Meisstens ungeheimer Direktzugriff}
                    FUNCTION GetAnzahl:word;
                    PROCEDURE Append(n:PNode);
                    PROCEDURE Delete(nr:word);
                    FUNCTION Position(n:PNode):word;
                  PRIVATE
                    Arr:TDynArray;
                    PROCEDURE Free;  virtual;
                  END;

TYPE PKantenArray=^TKantenArray;
     TKantenArray=OBJECT
                    CONSTRUCTOR init;
                    DESTRUCTOR done; virtual;
                    FUNCTION GetRec(w:word):PEdge;
                    FUNCTION GetAnzahl:word;
                    PROCEDURE Append(e:PEdge);
                    PROCEDURE Delete(nr:word);
                    FUNCTION Position(e:PEdge):word;
                  PRIVATE
                    Arr:TRecordArray;
                    PROCEDURE Free;  virtual;
                  END;

IMPLEMENTATION

CONSTRUCTOR TKnotenArray.init;
BEGIN
  Arr.init;
END;

DESTRUCTOR  TKnotenArray.done;
BEGIN
  Free;
  Arr.done;
END;

PROCEDURE TKnotenArray.Free;
VAR w:word;
BEGIN
  for w:=1 to arr.anzahl do Dispose(pnode(Arr.p^[w]), done);
  Arr.Free;
END;

FUNCTION TKnotenArray.NaechsterOrt(wozu:RRelPunkt):word;
VAR wert,min:real;
    w:word;
BEGIN
  min:=42;
  NaechsterOrt:=0;
  for w:=1 to arr.anzahl do begin
    with Pnode(arr.p^[w])^ do wert:=sqrt(sqr(wozu.x-ort.x)+sqr(wozu.y-ort.y));
    if (wert<min) and (wert<0.1) then begin
      NaechsterOrt:=w;
      min:=wert;
    end;
  end;
END;

PROCEDURE TKnotenArray.VerschiebKnoten(WohinDamit:RRelPunkt; welcher:word);
BEGIN
  Pnode(arr.p^[welcher])^.ort:=WohinDamit;
END;

FUNCTION TKnotenArray.GetRec(bf:iNode):PNode;
BEGIN
  if bf<1 then begin
    runerror;
  end;
  if bf>arr.anzahl then begin
    runerror;
  end;
  GetRec:=arr.p^[bf];
END;

FUNCTION TKnotenArray.GetAnzahl:word;
BEGIN
  GetAnzahl:=Arr.Anzahl;
END;

PROCEDURE TKnotenArray.Append(n:PNode);
BEGIN
  Arr.Append(n);
END;

PROCEDURE TKnotenArray.Delete(nr:word);
BEGIN
  Arr.Delete(nr);
END;

FUNCTION TKnotenArray.Position(n:PNode):word;
BEGIN
  Position:=Arr.Position(n);
END;

{**************************** KantenArray **********************}

CONSTRUCTOR TKantenArray.init;
BEGIN
  Arr.init(sizeof(REdge));
END;

PROCEDURE TKantenArray.Free;
BEGIN
  Arr.Free;
END;

DESTRUCTOR TKantenArray.done;
BEGIN
  Free;
  Arr.done;
END;

FUNCTION TKantenArray.GetRec(w:word):PEdge;
BEGIN
  if (w<1) or (w>Arr.anzahl) then runerror;
  GetRec:=Arr.p^[w];
END;

FUNCTION TKantenArray.GetAnzahl:word;
BEGIN
  GetAnzahl:=Arr.Anzahl;
END;

PROCEDURE TKantenArray.Append(e:PEdge);
BEGIN
  Arr.Append(e);
END;

PROCEDURE TKantenArray.Delete(nr:word);
BEGIN
  Arr.Delete(nr);
END;

FUNCTION TKantenArray.Position(e:PEdge):word;
BEGIN
  Position:=Arr.Position(e);
END;


END.
