{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 95

 Inhalt: Tabelle der Graphen-Farben (=Linienfarben)
         mit Funktionen, die Namen, Farbe, Brush, durchgezogene
         und gestrichelte Linien passend zu einer Farbe liefern.

 Referenzen: Der Typ TGraphenFarbe wird aus NodeEdge importiert,
             die Funktionen werden im wesentlichen in den
             Algorithmen, die den Netzgraph zeichnen bentigt.
}

UNIT GraphCol;

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

INTERFACE
USES NodeEdge, WinTypes;

FUNCTION GetGraphenFarbeBrush(f:TGraphenFarbe):HBrush;
FUNCTION GraphenFarbeSelectSolid(dc:HDC; f:TGraphenFarbe):THandle;
FUNCTION GraphenFarbeSelectDash (dc:HDC; f:TGraphenFarbe):THandle;


IMPLEMENTATION
USES ProgExit, WinProcs;

CONST farben:array [TGraphenFarbe] of record
                                        pen_solid,pen_dash:HPen;
                                        brush:HBrush;
                                      end =
                          ((pen_solid:0; pen_dash:0; brush:0),
                           (pen_solid:0; pen_dash:0; brush:0),
                           (pen_solid:0; pen_dash:0; brush:0),
                           (pen_solid:0; pen_dash:0; brush:0),
                           (pen_solid:0; pen_dash:0; brush:0),
                           (pen_solid:0; pen_dash:0; brush:0),
                           (pen_solid:0; pen_dash:0; brush:0));

FUNCTION GetGraphenFarbeBrush(f:TGraphenFarbe):HBrush;
BEGIN
  GetGraphenFarbeBrush:=Farben[f].Brush;
END;

FUNCTION GraphenFarbeSelectSolid(dc:HDC; f:TGraphenFarbe):THandle;
BEGIN
  GraphenFarbeSelectSolid:=selectobject(dc,farben[f].pen_solid);
END;

FUNCTION GraphenFarbeSelectDash (dc:HDC; f:TGraphenFarbe):THandle;
BEGIN
  GraphenFarbeSelectDash :=selectobject(dc,farben[f].pen_dash);
END;


PROCEDURE KillPens; FAR;
VAR f:TGraphenFarbe;
BEGIN
  for f:=schwarz to maxGraphenFarbe do begin
    deleteobject(farben[f].pen_solid);
    deleteobject(farben[f].pen_dash);
    deleteobject(farben[f].brush);
  end;
END;

VAR f:TGraphenFarbe;
    cr:TColorRef;
BEGIN
  RegisterExitproc(KillPens);
  for f:=schwarz to maxGraphenFarbe do with farben[f] do begin
    cr:=GetGraphenFarbeColorRef(f);
    pen_solid:=createpen(ps_solid,1,cr);
    pen_dash :=createpen(ps_dot,1,cr);
    brush    :=CreateSolidBrush(cr);
  end;
END.
