{$A+,B-,F-,G+,I+,V-,X+}
{$D+,L+,R+,S+}

UNIT HauptFen;

INTERFACE
USES WinProcs, WinTypes, oWindows, CommDlg, Strings, BWCC, oDialogs,
     Daten, netz, BfShell, Fp_Allg, Fp_Edit, ZugList, fpdruck,
     Win_Allg, grund, Deb_Win, mdi, MyComDlg, AbsCheck, Check, Err_List, DragZug,
     Optionen, ShellApi, Win31, ZugVersc;

CONST AppName='FahrPlan';
      cm_BahnhofsEditor=138;
      wm_UserParamLaden=wm_User+2;

     cm_neu=101;
     cm_fileopen=102;
     cm_filesave=103;
     cm_filesaveas=104;
     cm_drucken=110;
     cm_db_open=151;
     cm_db_close=152;
     cm_db_status=153;
     cm_DatenCheck=120;
     cm_debugstandart=42;
     cm_about=999;
     cm_ZugListe=701;
     cm_ZuegeVerschieben=702;
     cm_HilfeInhalt=901;
     cm_AllgOpt=401;
     cm_FpEdOpt=402;
     cm_DruckOpt=403;

TYPE PFenster=^TFenster;
     TFenster=OBJECT(TnewMDIWindow)
                CONSTRUCTOR init;
              PRIVATE
                dateiname: string;
                dateinamegueltig:boolean;
                DESTRUCTOR done; virtual;
                PROCEDURE SetupWindow; virtual;
                FUNCTION GetClassName:pchar; virtual;
                PROCEDURE getWindowclass(var awndclass:twndclass); virtual;
                FUNCTION canclose:boolean;  virtual;
                FUNCTION GetMenueBeschreibung(cm:word):pchar;  virtual;

                PROCEDURE CMneu             (VAR Msg:TMessage);  virtual cm_first+cm_neu;
                PROCEDURE CMFileOpen        (VAR Msg:TMessage);  virtual cm_first+cm_fileopen;
                PROCEDURE CMFileSave        (VAR Msg:TMessage);  virtual cm_first+cm_filesave;
                PROCEDURE CMFileSaveAs      (VAR Msg:TMessage);  virtual cm_first+cm_filesaveas;
                PROCEDURE CMDrucken         (VAR Msg:TMessage);  virtual cm_first+cm_drucken;
                PROCEDURE CMdb_open         (VAR Msg:TMessage);  virtual cm_first+cm_db_open;
                PROCEDURE CMdb_close        (VAR Msg:TMessage);  virtual cm_first+cm_db_close;
                PROCEDURE CMdb_status       (VAR Msg:TMessage);  virtual cm_first+cm_db_status;
                PROCEDURE CMDatenCheck      (VAR Msg:TMessage);  virtual cm_first+cm_DatenCheck;
                PROCEDURE CMDebugStandart   (VAR Msg:TMessage);  virtual cm_first+cm_debugstandart;
                PROCEDURE CMabout           (VAR Msg:TMessage);  virtual cm_first+cm_about;
                PROCEDURE CMZugListe        (VAR Msg:TMessage);  virtual cm_first+cm_ZugListe;
                PROCEDURE CMZuegeVerschieben(VAR Msg:TMessage);  virtual cm_first+cm_ZuegeVerschieben;
                PROCEDURE CMAllgOpt         (VAR Msg:TMessage);  virtual cm_first+cm_AllgOpt;
                PROCEDURE CMFpEdOpt         (VAR Msg:TMessage);  virtual cm_first+cm_FpEdOpt;
                PROCEDURE CMDruckOpt        (VAR Msg:TMessage);  virtual cm_first+cm_DruckOpt;
                PROCEDURE CMBreakpoint      (VAR Msg:TMessage);  virtual cm_first+cm_Debuggen;
                PROCEDURE CMHilfeInhalt     (VAR Msg:TMessage);  virtual cm_first+cm_HilfeInhalt;
                PROCEDURE WMUserStatus      (VAR Msg:TMessage);  virtual wm_first+wm_UserStatus;
                PROCEDURE WMUserParamLaden  (VAR Msg:TMessage);  virtual wm_first+wm_UserParamLaden;
                PROCEDURE WMDropFile        (VAR Msg:TMessage);  virtual wm_first+wm_DropFiles;
                FUNCTION Sichern:boolean;
                FUNCTION SichernAls:boolean;
                FUNCTION Schliessen:boolean;
                PROCEDURE NeueDaten;
                PROCEDURE ShowDateiname;
                PROCEDURE UpdateDatenbankStatusDisplay;

                PROCEDURE WMSysCommand(VAR Msg:TMessage);  virtual wm_first+wm_syscommand;
              END;


IMPLEMENTATION
USES xdiTools, base_wnd;

CONSTRUCTOR TFenster.init;
VAR s:string;
CONST maxrec=7 {$ifdef debug} +2 {$endif};
      ButtArr:Array [1..maxrec] of RZeilenButtonDef=(
{$ifdef debug}
          (resource_n:'but_debug_n';    resource_g:'but_debug_g';    cm:cm_debugstandart),
          (resource_n:nil;              resource_g:nil;              cm:0),
{$endif}
          (resource_n:'but_bf_n';       resource_g:'but_bf_g';       cm:cm_bfdazu),
          (resource_n:nil;              resource_g:nil;              cm:0),
          (resource_n:'but_zugstart_n'; resource_g:'but_zugstart_g'; cm:cm_zugstarten),
          (resource_n:'but_zugstop_n';  resource_g:'but_zugstop_g';  cm:cm_zugfertig),
          (resource_n:'but_zugliste_n'; resource_g:'but_zugliste_g'; cm:cm_zugliste),
          (resource_n:nil;              resource_g:nil;              cm:0),
          (resource_n:'but_hilfe_n';    resource_g:'but_hilfe_g';    cm:cm_hilfeinhalt) );
      ButtonZeileDef:RButtonZeileDef=(ArrPtr:pointer(@ButtArr); Anzahl:maxrec);
BEGIN
  inherited init('Fahrplan-Editor', LoadMenu(hInstance, AppName), ButtonZeileDef);
  s:='Fahrplan-Editor '+VersionString+'  von Stefan Bormann `95'+#0;
  StatusZeile^.SetDefaultText(@s[1]);
  StatusZeile^.SetHelpText(nil);
  ChildMenuPos:=4;
  DateinameGueltig:=false;
  new(NetzFenster,init(@self));
END;

FUNCTION TFenster.GetClassName:pchar;
BEGIN
  getclassname:=AppName;
END;

PROCEDURE TFenster.getwindowclass(var awndclass:twndclass);
BEGIN
  inherited getwindowclass(awndclass);
  with awndclass do begin
    hicon:=loadicon(hinstance,AppName);
  end;
END;

DESTRUCTOR TFenster.done;
BEGIN
  inherited done;
END;

PROCEDURE TFenster.SetupWindow;
BEGIN
  TMDIWindow.SetupWindow;
{  AppendMenu(GetSystemMenu(Hwindow,false), mf_unchecked+mf_enabled+mf_string, cm_BahnhofsEditor, 'Bahnhofeditior');}
  DragAcceptFiles(hWindow, true);
  UpdateDatenbankStatusDisplay;
  ButtonZeile^.SetPosition(ButtonZeilePosition.GetValue);
  StatusZeile^.SetSichtbar(StatusZeileDa.GetValue);
END;

FUNCTION TFenster.CanClose:boolean;
BEGIN
  CanClose:=Schliessen;
END;

FUNCTION TFenster.GetMenueBeschreibung(cm:word):pchar;
VAR p:pchar;
BEGIN
  case cm of
    cm_neu             :p:='Erzeugen eines ganz neuen Fahrplans';
    cm_fileopen        :p:='Laden eines alten Fahrplans von Platte';
    cm_filesave        :p:='Sichern des Fahrplans in alte Datei';
    cm_filesaveas      :p:='Sichern des Fahrplans in neu auszuwhlende Datei';
    cm_drucken         :p:='Aufruf des externen Druckprogramms von Crni';
    cm_db_open         :p:='ffnen einer Bahnhofs-Datenbank, um Bahnhfe ins Netz einfgen zu knnen';
    cm_db_close        :p:='Schlieen der Bahnhofs-Datenbank';
    cm_db_status       :p:='Info ber internen Zustand der BAHNHOF.DLL (=Bahnhofsdatenbank-Modul)';
    cm_DatenCheck      :p:='berprfen der Datenintegritt des geladenen Fahrplans';
    cm_about           :p:='Informationen ber Programmstatus und Author';
    24340              :p:='und tschss...';
    cm_bfdazu          :p:='Neuen Bahnhof bei Markierung ins Netz einfgen';
    cm_bfloeschen      :p:='Markierten Bahnhof lschen';
    cm_bfinfo          :p:='Infofenster mit Informationen ber markierten Bahnhof';
    cm_liniedazu       :p:='Neue Fahrplanlinie defieren (Anfangs-/Endpunkt eines Editorfensters)';
    cm_linieloeschen   :p:='Markierte Linie lschen';
    cm_linieinfo       :p:='Infofenster mit Informationen ber markierte Linie';
    cm_linieumdrehen   :p:='Reihenfolge der Bahnhfe auf einer Linie umdrehen';
    cm_zugstarten      :p:='Zug zum Fahrplan dazufgen';
    cm_zugfertig       :p:='Eingabe des neuen Zuges beenden, in Fahrplan bernehmen';
    cm_zugabbrechen    :p:='Eingabe des neuen Zuges abbrechen, nicht in Fahrplan bernehmen';
    cm_ZugListe        :p:='Fenster mit Liste aller Zge ffnen';
    cm_ZuegeVerschieben:p:='Zge komplett zeitlich verschieben';
    cm_FpEdOpt         :p:='Optionen fr Editorfenster ndern';
    cm_AllgOpt         :p:='Allgemeine Optionen ndern';
    cm_DruckOpt        :p:='Optionen fr Aufruf von Crnis Druckprogramms ndern';
    cm_debugstandart   :p:='Diesen Menpunkt einfach NICHT BEACHTEN!!!!!';
    cm_Debuggen        :p:='Diesen Menpunkt erst recht NICHT BEACHTEN!!!!!';
    cm_HilfeInhalt     :p:='ffnet die Windows-Hilfe und zeigt den Hilfeindex des Fahrplanprogramms an '+
                           '(sollte es zumindest...)';
    else p:=inherited GetMenueBeschreibung(cm);
  end;
  GetMenueBeschreibung:=p;
END;

{************************ Men-Antworten Dateimen ****************************}

PROCEDURE TFenster.CMneu(VAR Msg:Tmessage);
BEGIN
  DateinameGueltig:=not schliessen and DateinameGueltig;
  ShowDateiname;
END;

PROCEDURE TFenster.CMFileOpen(var Msg: TMessage);
VAR dlg:TLoadCommDlg;
BEGIN
  If not Schliessen then exit;
  DateinameGueltig:=false;
  dlg.init(hwindow, 'Fahrplan Laden');
  with dlg.Daten do begin
    lpstrDefExt   := 'pln';
    lpstrFilter   := 'Fahrplan-Dateien'+#0+'*.pln'+#0;
  end;
  dateiname:='';
  if dlg.execute(dateiname) then begin
    DateinameGueltig:=FahrplanDaten.DateiLaden(Dateiname);
    NeueDaten;
    ShowDateiname;
  end;
  dlg.done;
END;

PROCEDURE TFenster.WMUserParamLaden(VAR Msg:TMessage);
TYPE pstring=^string;
BEGIN
  Dateiname:=pstring(msg.lParam)^;
  DateinameGueltig:=FahrplanDaten.DateiLaden(Dateiname);
  ShowDateiname;
END;

PROCEDURE TFenster.WMDropFile(VAR Msg:TMessage);
BEGIN
  case DragQueryFile(msg.wParam, $FFFF, nil, 0) of
    0:;
    1:begin
        if Schliessen then begin
          Dateiname[0]:=char(DragQueryFile(msg.wParam, 0, @Dateiname[1], high(Dateiname)));
          DateinameGueltig:=FahrplanDaten.DateiLaden(Dateiname);
        end;
      end;
    else begin
        MessageBox(hWindow, 'Sie wollten mehrere Dateien in den Fahrplaneditor versenken, '+
                            'der Fahrplaneditor kann aber nur einen Fahrplan zu einem Zeitpunkt verkraften!!!',
                            'Drag and Drop', mb_OK);
      end;
  end;
  DragFinish(msg.wParam);
END;

FUNCTION TFenster.SichernAls:boolean;
VAR dlg:TSaveCommDlg;
BEGIN
  dlg.init(hwindow, 'Fahrplan Sichern');
  with dlg.daten do begin
    lpstrDefExt   := 'pln';
    lpstrFilter   := 'Fahrplan-Dateien'+#0+'*.pln'+#0;
  end;
  if not DateinameGueltig then Dateiname:='';
  SichernAls:=dlg.execute(dateiname) and FahrplanDaten.DateiSichern(Dateiname);
END;

PROCEDURE TFenster.CMFileSave(VAR Msg:TMessage);
BEGIN
  DateinameGueltig:=Sichern;
  ShowDateiname;
END;

PROCEDURE TFenster.CMFileSaveAs(VAR Msg:TMessage);
BEGIN
  DateinameGueltig:=SichernAls;
  ShowDateiname;
END;

PROCEDURE TFenster.CMDebugStandart(VAR Msg:TMessage);
BEGIN
  if not schliessen then exit;
  DateiName:='f:\muelling.pln';
  DateiNameGueltig:=FahrplanDaten.DateiLaden(DateiName);
  neuedaten;
  ShowDateiname;
END;

FUNCTION TFenster.Schliessen:boolean;
VAR schl:boolean;
BEGIN
  if FahrplanDaten.GetVeraendert then begin
    messagebeep(0);
    case messagebox(hwindow,'Sie haben noch ungesicherte Daten im Speicher! Sollen die vorher noch gesichert werden?',
                            'Achtung!', mb_YesNoCancel) of
      id_yes   :Schl:=Sichern;
      id_no    :Schl:=true;
      id_cancel:Schl:=false;
      else runerror;
    end;
  end else Schl:=true;
  if schl then begin
    Daten_ReInit;
    NeueDaten;
  end;
  Schliessen:=schl;
END;

FUNCTION TFenster.Sichern:boolean;
VAR ok:boolean;
BEGIN
  if DateinameGueltig then Sichern:=FahrplanDaten.DateiSichern(Dateiname)
                      else Sichern:=SichernAls;
END;

PROCEDURE TFenster.NeueDaten;
BEGIN
  NetzFenster^.NeueDaten;
END;

PROCEDURE TFenster.CMDatenCheck(VAR Msg:TMessage);
VAR FehlerArray:TFehlerArray;
    Cursor:hCursor;
BEGIN
  FehlerArray.init;
  Cursor:=SetCursor(LoadCursor(0, idc_wait));
  CheckAll(FehlerArray);
  SetCursor(Cursor);
  if FehlerArray.Anzahl=0
    then BWCCMessagebox(hWindow, 'Alle Daten fr gut befunden! :-)', 'Fehlersuche beendet', mb_ok)
    else StartFehlerListenFenster(@self,FehlerArray);
  FehlerArray.done;
END;

{********************************** Optionen **********************************}

PROCEDURE TFenster.CMFpEdOpt(VAR Msg:TMessage);
BEGIN
  ExecuteEditorOptionen(@self);
END;

PROCEDURE TFenster.CMAllgOpt(VAR Msg:TMessage);
BEGIN
  ExecuteAllgOptionen(@self);
END;

PROCEDURE TFenster.CMDruckOpt(VAR Msg:TMessage);
BEGIN
  ExecuteDruckOptionen(@self);
END;

{********************************** Drucken ***********************************}

PROCEDURE TFenster.CMDrucken(VAR Msg:TMessage);
BEGIN
  StartDruckProgramm;
END;

{******************************** Datenbank ***********************************}

PROCEDURE TFenster.CMdb_open(VAR Msg:TMessage);
BEGIN
  if Datenbank.IsOpen then Datenbank.Close;
  Datenbank.OpenDialog(hWindow);
  UpdateDatenbankStatusDisplay;
END;

PROCEDURE TFenster.CMdb_close(VAR Msg:TMessage);
BEGIN
  Datenbank.Close;
  UpdateDatenbankStatusDisplay;
END;

PROCEDURE TFenster.UpdateDatenbankStatusDisplay;
VAR wie:word;
BEGIN
  if Datenbank.IsOpen then wie:=mf_enabled
                      else wie:=mf_grayed;
  EnableMenuItem(GetMenu(hWindow), cm_db_close, wie);
  NetzFenster^.UpdateDatenbankStatic;
END;

PROCEDURE TFenster.CMdb_status(VAR Msg:TMessage);
BEGIN
  Datenbank.ExecuteStatusDialog(hWindow);
END;

{************************** Sonstige Men-Antworten ***************************}

  PROCEDURE SetupAbout(h:Hwnd); far;
  VAR s:string[20];
      p:pchar;
  BEGIN
    SetWindowText(GetDlgItem(h,101), VersionString);
    s:=zahlstr(memavail shr 10,1)+' kB frei'+#0;
    SetWindowText(GetDlgItem(h,103), @s[1]);
    with PFenster(Application^.MainWindow)^ do   {gefaerlich}
      if DateinameGueltig then p:=string2pchar(Dateiname)
                          else p:='-- keine --';
    SetWindowText(GetDlgItem(h,104), p);
  END;

PROCEDURE TFenster.CMabout(VAR Msg:TMessage);
BEGIN
  StatusZeile^.SetHelpText(nil);
  ExecuteSetupDialog(@self, 'about', SetupAbout);
END;

PROCEDURE TFenster.CMZugListe(VAR Msg:TMessage);
BEGIN
  DragZug_KillCursor;
  ExecuteZugListeDialog(@self);
END;

PROCEDURE TFenster.CMZuegeVerschieben(VAR Msg:TMessage);
BEGIN
  DragZug_KillCursor;
  ExecuteZuegeVerschieben(@self);
END;

PROCEDURE TFenster.CMBreakpoint(VAR Msg:TMessage);
BEGIN END;

PROCEDURE TFenster.CMHilfeInhalt(VAR Msg:TMessage);
BEGIN
  Hilfe(keineHilfe);
END;

PROCEDURE TFenster.WMSysCommand(VAR Msg:TMessage);
BEGIN
  if msg.wParam = cm_BahnhofsEditor then begin
    StartBfEdit(0);
  end else inherited WMSysCommand(msg);
END;

PROCEDURE TFenster.WMUserStatus(VAR Msg:TMessage);
BEGIN
  StatusZeile^.SetHelpText(pchar(Msg.lParam));
  UpdateWindow(StatusZeile^.hWindow);
END;

PROCEDURE TFenster.ShowDateiname;
VAR s:string;
BEGIN
  s:='Fahrplan-Editor';
  if DateinameGueltig then s:=s+' <'+Dateiname+'>';
  s:=s+#0;
  SetCaption(@s[1]);
END;


END.
