UNIT InsrtZug;

{$A+,B-,G+,I+,V-,X+,T+,P+}

INTERFACE
USES WinTypes,
     Ort_Zeit, NodeEdge, RFarben, ZugArr, edit_sht;

VAR EditierterZug:TZug;
{Puffer, in dem der gerade eingegebene Zug gepuffert wird, bis er fertig ist.
 Wird exportiert, damit alle EditSheets direkten Zugriff zum Zeichnen haben}


PROCEDURE InsertZug_Start(R:TReglerFarbe; N:string);
PROCEDURE InsertZug_Reset;
PROCEDURE InsertZug_Accept(window:PEditSheet);

PROCEDURE InsertZug_MouseDown(window:PEditSheet; fc:RFahrplanCursor);
PROCEDURE InsertZug_MouseMove(window:PEditSheet; fc:RFahrplanCursor);
PROCEDURE InsertZug_MouseUp(window:PEditSheet);

FUNCTION InsertZug_Idle:boolean;  {gibt false, wenn keine Eingabe am Laufen ist}

IMPLEMENTATION
USES ProgExit, WinProcs, Daten, BWCC, oWindows, grund, Fp_Allg, Optionen, Check, Win_Allg;


TYPE TEditStatus=(nix, start, startA, ziel, zielA, weiter, weiterA);
VAR Status:TEditStatus;
    MausZeiger:record
                 TotenKopf, arrow, start, weiter, ziel:HCursor;
               end;
    Cursor, altCursor:RFahrplanCursor;


PROCEDURE Cancel;
BEGIN
  MessageBeep(mb_IconHand);
  InsertZug_Reset;
END;

PROCEDURE Panic;
BEGIN
  Cancel;
  StatusZeile('EditZug: Panic');
END;

PROCEDURE KillAufenthaltAmEnde;
BEGIN
  with EditierterZug.GetRec(EditierterZug.GetAnzahl)^ do abZeit:=anZeit;
END;

{******************************* Cursor ***********************************}

FUNCTION Cursor2String:string;
BEGIN
  Cursor2String:=Ort2String(Cursor.Ort)+' um '+Zeit2hmin(Cursor.Zeit, true);
END;

FUNCTION CursorGueltig:boolean;
BEGIN
  CursorGueltig:=(Cursor.Ort.Knoten<>nil) and
                 (Cursor.Ort.Gleis<>0) and
                 RangeCheckZeit(Cursor.Zeit);
END;

FUNCTION ZielGueltig:boolean;
VAR alt:PZugDatum;
BEGIN
  if CursorGueltig then begin
    alt:=EditierterZug.GetRec(EditierterZug.GetAnzahl-1);
    ZielGueltig:=(FahrplanDaten.NetzGraph^.SuchKanteZwischenKnoten(Cursor.Ort.Knoten, alt^.ort.Knoten)<>nil) and
                 (Cursor.Zeit>alt^.abZeit);
  end else ZielGueltig:=false;
END;

FUNCTION WeiterGueltig:boolean;
VAR alt:PZugDatum;
BEGIN
  if CursorGueltig then begin
    alt:=EditierterZug.GetRec(EditierterZug.GetAnzahl);
    WeiterGueltig:=(Cursor.ort.Knoten=alt^.ort.Knoten) and
                   (Cursor.ort.Gleis=alt^.ort.Gleis) and
                   (Cursor.Zeit>=alt^.anZeit);
  end else WeiterGueltig:=false;
END;

PROCEDURE StoreCursor(fc:RFahrplanCursor);
 Procedure divmul(Var Zeit:TZeit; Kill:TZeit);
 Begin
   Zeit:=round(Zeit/kill) *kill;
 End;
BEGIN
  Cursor:=fc;
  case ZeitRaster.GetValue of
    Raster_Eins :;
    Raster_Zwei :divmul(Cursor.Zeit,2);
    Raster_Fuenf:divmul(Cursor.Zeit,5);
    Raster_Zehn :divmul(Cursor.Zeit,10);
    else runerror;
  end;
END;

{********************************** Interface **************************************}

FUNCTION InsertZug_Idle:boolean;
BEGIN
  InsertZug_Idle:=Status=nix;
END;

PROCEDURE InsertZug_Start(R:TReglerFarbe; N:string);
BEGIN
  InsertZug_Reset;
  Status:=start;
  EditierterZug.Regler:=r;
  EditierterZug.Name:=n;
END;

PROCEDURE InsertZug_Reset;
BEGIN
  Status:=nix;
  EditierterZug.free;
  FahrplanDaten.GetLinienArray^.EditorenNeuZeichnen;
END;

PROCEDURE InsertZug_Accept(window:PEditSheet);
VAR Fehler:string;
BEGIN
  case Status of
    nix:BWCCmessagebox(window^.hWindow, 'Sie haben doch gar keinen Zug in der Mache!?!', 'Eingabefehler!', mb_ok);
    start:BWCCmessagebox(window^.hWindow, 'Erst Zug zuende malen!', 'Eingabefehler', mb_ok);
    startA,weiterA,zielA:runerror;
    weiter,ziel:if (EditierterZug.GetAnzahl<2)
                  then BWCCmessagebox(window^.hWindow, 'Erst Zug zuende malen!', 'Eingabefehler', mb_ok)
                  else if not AutoCheck.GetValue or
                          not ErsterFehlerInZug(0, Fehler) or
                          (bwccmessagebox(window^.hWindow, String2pchar(Fehler),
                                          'Daten inkonsistent! Trotzdem nehmen?', mb_okcancel
                                         )=id_OK)
                         then begin
                           KillAufenthaltAmEnde;
                           FahrplanDaten.ZugArray^.MoveZug(EditierterZug);
                           FahrplanDaten.ZuegeVeraendert;
                         end;
    else runerror;
  end;
  Status:=nix;
  EditierterZug.free;
END;

PROCEDURE InsertZug_MouseDown(window:PEditSheet; fc:RFahrplanCursor);
BEGIN
  StoreCursor(fc);
  case Status of
    nix:exit;
    start :begin
             Status:=startA;
             EditierterZug.DoAppend(cursor.ort,cursor.zeit,cursor.zeit);
           end;
    weiter:begin
             Status:=weiterA;
           end;
    ziel  :begin
             Status:=zielA;
             EditierterZug.DoAppend(cursor.ort,cursor.zeit,cursor.zeit);
           end;
    startA,zielA,weiterA:runerror;
    else runerror;
  end;
  altCursor.ort.Knoten:=nil;
  InsertZug_MouseMove(window, Cursor);
END;

PROCEDURE InsertZug_MouseMove(window:PEditSheet; fc:RFahrplanCursor);
VAR zdp:PZugDatum;
    MausPosOK:boolean;
    StartPunkt:RFahrplanCursor;
BEGIN
  StoreCursor(fc);
  MausPosOK:=true;

  case Status of
   startA :begin
             StatusZeile('Start: '+Cursor2string);
             if EditierterZug.GetAnzahl<>1 then runerror;
             zdp:=EditierterZug.GetRec(1);
             with zdp^ do begin
               ort:=Cursor.ort;
               anZeit:=Cursor.Zeit;
               abZeit:=Cursor.Zeit;
             end;
             MausPosOK:=CursorGueltig;
           end;
   weiterA:begin
             zdp:=EditierterZug.GetRec(EditierterZug.GetAnzahl);
             zdp^.abZeit:=Cursor.Zeit;
             MausPosOK:=false;
             if CursorGueltig
               then if WeiterGueltig
                 then begin
                   if Cursor.Zeit=zdp^.anZeit
                     then StatusZeile('Durchfahrt in '+Cursor2String)
                     else StatusZeile('Aufenthalt '+Zeit2hmin(Cursor.Zeit-zdp^.anZeit, false)+' in '+Cursor2String);
                   MausPosOK:=true;
                 end else StatusZeile('Zug kann nur von gleichem Gleis zu spterer Zeit weiterfahren!!! (Bldmann)')
               else StatusZeile('Eingabe ungltig (wo hlst du eigentlich die Maus hin???)');
             StartPunkt.Ort:=zdp^.Ort;
             StartPunkt.Zeit:=zdp^.anZeit;
           end;
   zielA  :begin
if EditierterZug.GetAnzahl=0 then runerror(42);
             zdp:=EditierterZug.GetRec(EditierterZug.GetAnzahl);
             zdp^.Ort:=Cursor.Ort;
             zdp^.anZeit:=Cursor.Zeit;
             zdp^.abZeit:=Cursor.Zeit;
             if EditierterZug.GetAnzahl<2 then runerror;
             zdp:=EditierterZug.GetRec(EditierterZug.GetAnzahl-1);
             MausPosOK:=false;
             if CursorGueltig
               then if ZielGueltig
                 then begin
                   StatusZeile('Fahrzeit: '+Zeit2hmin(Cursor.Zeit-zdp^.abZeit, false)+
                               ';  Ziel: '+Cursor2String);
                   MausPosOK:=true;
                 end else StatusZeile('Zug mu in benachbartem Bahnhof zu spterer Zeit ankommen!!!')
               else StatusZeile('Eingabe ungltig (was machst du da eigentlich???)');
             StartPunkt.Ort:=zdp^.Ort;
             StartPunkt.Zeit:=zdp^.abZeit;
           end;
   start,ziel,weiter:StatusZeile(Cursor2String);
   nix:;
   else runerror;
  end;

  if MausPosOK then case Status of
    nix           :SetCursor(MausZeiger.arrow);
    start, startA :SetCursor(MausZeiger.start);
    weiter,weiterA:SetCursor(MausZeiger.weiter);
    ziel,  zielA  :SetCursor(MausZeiger.ziel);
    else runerror;
  end else SetCursor(MausZeiger.totenkopf);

  if Status in [weiterA,zielA] then begin
    if altCursor.ort.knoten<>nil then window^.UserInvalidate(StartPunkt, altCursor, true);
    if MausPosOK then begin
      window^.UserInvalidate(StartPunkt, Cursor, false);
      altCursor:=Cursor;
    end else altCursor.ort.knoten:=nil;
  end;
END;

PROCEDURE InsertZug_MouseUp(window:PEditSheet);

 Function Nochmal(f:PWindowsObject; s:string):boolean;
 Begin
   s:=s+' ('+Cursor2String+')'+#0;
   Nochmal:=(MessageBox(f^.hWindow,
                        @s[1],
                        'Letzten Klick wiederholen!!?',
                        mb_RetryCancel
                       )=id_Retry);
 End;

BEGIN
  case Status of
    nix:;
    start,ziel,weiter:; {woanders gedrueckt, hier losgelassen ist ok}
    startA :BEGIN
              if CursorGueltig then begin
                StatusZeile('Start in '+Cursor2String);
                Status:=ziel;
                FahrplanDaten.GetLinienArray^.EditorenNeuZeichnen;
              end else if Nochmal(window, 'Ungltige Startposition') then begin
                Status:=Start;
                with EditierterZug do begin
                  if GetAnzahl<>1 then runerror;
                  Free;
                end;
                window^.NeuZeichnen;
              end else Cancel;
            END;
    zielA  :BEGIN
              if ZielGueltig then begin
                StatusZeile('Ankunft in '+Cursor2String);
                Status:=weiter;
                FahrplanDaten.GetLinienArray^.EditorenNeuZeichnen;
              end else if Nochmal(window, 'Ungltige Zielposition') then begin
                Status:=Ziel;
                with EditierterZug do begin
                  dispose(GetRec(GetAnzahl));
                  Delete(GetAnzahl);
                end;
                window^.NeuZeichnen;
              end else Cancel;
            END;
    weiterA:BEGIN
              if WeiterGueltig then begin
                StatusZeile('Weiterfahrt von '+Cursor2String);
                Status:=Ziel;
                FahrplanDaten.GetLinienArray^.EditorenNeuZeichnen;
              end else if Nochmal(window, 'Ungltige Startposition fr Weiterfahrt') then begin
                Status:=Weiter;
                KillAufenthaltAmEnde;
                window^.NeuZeichnen;
              end else Cancel;
            END;
    else runerror;
  end;
END;

{********************************* init/done **********************************}

PROCEDURE InsertZug_done; FAR;
BEGIN
  EditierterZug.done;
  with MausZeiger do begin
    DestroyCursor(start);
    DestroyCursor(ziel);
    DestroyCursor(weiter);
    DestroyCursor(totenkopf);
  end;
END;

BEGIN
  RegisterExitProc(InsertZug_done);
  EditierterZug.init(keine,'noname');
  Status:=nix;
  with MausZeiger do begin
    arrow    :=LoadCursor(0,idc_Arrow);
    start    :=LoadCursor(Hinstance,'start');
    ziel     :=LoadCursor(Hinstance,'ziel');
    weiter   :=LoadCursor(Hinstance,'weiter');
    totenkopf:=LoadCursor(Hinstance,'totenkopf');
    if (arrow=0) or (start=0) or (ziel=0) or (weiter=0) or (totenkopf=0) then runerror;
  end;
END.
