UNIT LineArr;

{$A+,B-,G+,I+,V-,X+,W+}
{$D+,L+,R+,S+}

INTERFACE
USES heap, nodeedge, fp_edit, AbsLinAr;


TYPE PLine=^TLine;
     TLine=OBJECT(TSimpleLine)
             CONSTRUCTOR init(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe);
             DESTRUCTOR done; virtual;
             FUNCTION GetEditor:PEditorFenster;
             PROCEDURE Umdrehen;
           private
             Editor:PEditorFenster;
           END;

{Array ueber EditorFenster}
TYPE PLineArray=^TLineArray;
     TLineArray=OBJECT(TSimpleLineArray)
                  FUNCTION InitLine(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe):PSimpleLine; virtual;
                  FUNCTION GetEditor(nr:word):PEditorFenster;
                  FUNCTION GetLine(nr:word):PLine;
                  PROCEDURE EditorenNeuZeichnen;
                  PROCEDURE EditorenNeueDaten;
                END;


IMPLEMENTATION
USES oWindows, WinTypes;

{************************************ Line ***********************************}

CONSTRUCTOR TLine.init(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe);
BEGIN
  inherited init(anfang, ende, name, farbe);
  new(Editor, init(@LineData));
  Application^.MakeWindow(Editor);
END;

DESTRUCTOR TLine.done;
BEGIN
  inherited done;
  dispose(Editor, done);
END;

FUNCTION TLine.GetEditor:PEditorFenster;
BEGIN
  GetEditor:=Editor;
END;

PROCEDURE TLine.Umdrehen;
VAR p:pointer;
BEGIN
  with LineData do begin
    p:=anfang;
    anfang:=ende;
    ende:=p;
  end;
  Editor^.NeueDaten;
END;

{******************************** LinienArray ********************************}

FUNCTION TLineArray.InitLine(anfang,ende:Pnode; const name:string; Farbe:TGraphenFarbe):PSimpleLine;
VAR Line:PLine;
BEGIN
  InitLine:=new(PLine, init(anfang, ende, name, farbe));
END;

FUNCTION TLineArray.GetLine(nr:word):PLine;
BEGIN
  GetLine:=TheArray.p^[nr];
END;

FUNCTION TLineArray.GetEditor(nr:word):PEditorFenster;
BEGIN
  GetEditor:=GetLine(nr)^.GetEditor;
END;

PROCEDURE TLineArray.EditorenNeuZeichnen;
VAR i:word;
BEGIN
  for i:=1 to TheArray.anzahl do GetEditor(i)^.NeuZeichnen;
END;

PROCEDURE TLineArray.EditorenNeueDaten;
VAR i:word;
BEGIN
  for i:=1 to TheArray.anzahl do GetEditor(i)^.NeueDaten;
END;


END.
