{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 94

 Inhalt: Der Loader fuer das PLN-Dateiformat der Version 0.2
         (siehe datform.txt)
         Achtung! Es ist aussichtslos dieses Modul zuverstehen,
         wenn man nicht die Unit "FilePars" verstanden hat!!!

 Referenzen: Dieses Modul wird von der Lademethode des Objekts
             "TFahrplanDaten" in der Unit "DataObj" benutzt.
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Loadr0_2;

INTERFACE
USES FilePars, NodeEdge, DataObj, win_allg, zugarr;


TYPE TPLNAbschnitt=OBJECT(TAbschnitt)
                     CONSTRUCTOR init(aParser:PFileParser; titel:string; Dat:PFahrplanDaten);
                   PRIVATE
                     Daten:PFahrplanDaten;
                   END;

TYPE PKnotenAbschnitt0_2=^TKnotenAbschnitt0_2;
     TKnotenAbschnitt0_2=OBJECT(TPLNAbschnitt)
                           erster:boolean;
                           FUNCTION Start:boolean;              virtual;
                           FUNCTION Line(Zeile:string):boolean; virtual;
                           FUNCTION Stop:boolean;               virtual;
                         PRIVATE
                           Knoten:PNode;
                           ZeilenPuffer:TPCharArray;
                           FUNCTION KnotenEnde:boolean;
                         END;

TYPE PKantenAbschnitt0_2=^TKantenAbschnitt0_2;
     TKantenAbschnitt0_2=OBJECT(TPLNAbschnitt)
                           FUNCTION Line(Zeile:string):boolean; virtual;
                           FUNCTION Stop:boolean;               virtual;
                         END;

TYPE PLinienAbschnitt0_2=^TLinienAbschnitt0_2;
     TLinienAbschnitt0_2=OBJECT(TPLNAbschnitt)
                           FUNCTION Line(Zeile:string):boolean; virtual;
                         END;

TYPE PZugAbschnitt0_2=^TZugAbschnitt0_2;
     TZugAbschnitt0_2=OBJECT(TPLNAbschnitt)
                        status:(nach_zug, nach_start, nach_stop);
                        Zug:TZug;
                        FUNCTION Start:boolean;              virtual;
                        FUNCTION Line(Zeile:string):boolean; virtual;
                        FUNCTION Stop:boolean;               virtual;
                        PROCEDURE ErwartetMeldung;
                      END;


IMPLEMENTATION
USES Ort_Zeit, grund, Strings, AbsCheck;

CONSTRUCTOR TPLNAbschnitt.init(aParser:PFileParser; titel:string; Dat:PFahrplanDaten);
BEGIN
  Daten:=Dat;
  inherited init(aParser, titel);
END;

FUNCTION TKnotenAbschnitt0_2.start:boolean;
BEGIN
  erster:=true;
  start:=inherited start;
  ZeilenPuffer.init;
  Knoten:=nil;
END;

FUNCTION TKnotenAbschnitt0_2.Line(Zeile:string):boolean;
                                              {KnotenNr}
 Function String2RelPunkt(s1:string; Var ort:RRelPunkt):boolean;
 Var s2:string;
     k:integer;
 Begin
   String2RelPunkt:=false;
   if s1='' then begin  Parser^.Fehler('Alle Parameter fehlen'); exit;  end;
   splitstring(s1,'/',s1,s2);
   val(s1,ort.x,k);
   if k<>0 then begin  Parser^.Fehler('Num. Format in x-Koordinate falsch'); exit  end;
   val(s2,ort.y,k);
   if k<>0 then begin  Parser^.Fehler('Num. Format in y-Koordinate falsch'); exit  end;
   String2RelPunkt:=true;
 End;

VAR temp:string;
    i,k:integer;
    RelPunkt:RRelPunkt;
BEGIN
  Line:=false;
  SplitString(zeile,' ',temp,zeile);
  if temp='BAHNHOF' then begin
    if not erster and not KnotenEnde then exit;
    SplitString(zeile, ' ', temp, zeile);
    if not String2RelPunkt(temp, RelPunkt) then exit;
    SplitString(zeile, ' ', temp, zeile);
    if temp='' then begin Parser^.Fehler('Bahnhof hat keinen Namen!'); exit; end;
    new(Knoten, init(RelPunkt));
    Daten^.NetzGraph^.KnotenArray.Append(Knoten);
    ZeilenPuffer.Free;
    with Knoten^.Bahnhof do begin
      Ersetzen('_', ' ', temp);
      Ersetzen('_', ' ', zeile);
      Daten.Name:=temp;
      Daten.KurzName:=zeile;
      KurznameSicherstellen;
    end;
    erster:=false;
  end else if erster then begin
    Parser^.Fehler('Erste Zeile in Knotenabschnitt muss "BAHNHOF"-Zeile sein!');
    exit;
  end else if temp='EIGNER' then begin
    Ersetzen('_', ' ', zeile);
    Knoten^.Bahnhof.Daten.Eigner:=Zeile;
  end else if temp='STRECKEN' then begin
    val(Zeile, Knoten^.Bahnhof.Daten.Strecken, k);
    if k<>0 then begin Parser^.Fehler('Numerisches Format der Streckenanzahl falsch!'); exit; end;
  end else if temp='REGLERFARBEN' then begin
    val(Zeile, i, k);
    if k<>0 then begin Parser^.Fehler('Numerisches Format der Reglerfarbenanzahl falsch!'); exit; end;
    if (i<3) or (i>5) then begin Parser^.Fehler('Reglerfarbenanzahl ist nicht zwischen 3 und 5!'); exit; end;
    Knoten^.Bahnhof.Daten.ReglerFarben:=i;
  end else if temp='INFO' then begin
    ZeilenPuffer.Append(strnew(string2pchar(zeile)));
  end else if temp='GLEIS' then begin
    if SplitString(zeile, ' ', zeile, temp) then begin
      val(temp, i, k);
      if k<>0 then begin Parser^.Fehler('Numerisches Format der Nutzlnge ist fehlerhaft!'); exit; end;
      if (i<0) then begin Parser^.Fehler('Negative Gleislnge ist Schwachsinn!'); exit; end;
    end else i:=0;
    Ersetzen('_', ' ', zeile);
    Knoten^.Bahnhof.AppendGleis(zeile, i);
  end;
  Line:=true;
END;

FUNCTION TKnotenAbschnitt0_2.KnotenEnde:boolean;
BEGIN
  KnotenEnde:=false;
  if ZeilenPuffer.anzahl>0 then Knoten^.Bahnhof.SetInfo(ZeilenPuffer.ExportToMultiLine);
  if Knoten^.Bahnhof.AnzahlGleise=0 then begin
    Parser^.Fehler('Bahnhof hat keine Gleise!');
    exit;
  end;
  KnotenEnde:=true;
END;

FUNCTION TKnotenAbschnitt0_2.Stop:boolean;
BEGIN
  Stop:=(erster or KnotenEnde) and inherited Stop ;
  ZeilenPuffer.done;
END;

{---------------------------------------------------------}

FUNCTION TKantenAbschnitt0_2.Line(Zeile:string):boolean;
VAR temp:string;
    k1,k2,i1,i2:integer;
    n1,n2:PNode;
    edge:PEdge;
BEGIN
  Line:=false;
  SplitString(zeile, ' ', temp, zeile);
  SplitString(zeile, ' ', temp, zeile);
  if temp=''  then begin Parser^.Fehler('Erster Knoten fehlt in Kantendefinition!');  exit; end;
  if zeile='' then begin Parser^.Fehler('Zweiter Knoten fehlt in Kantendefinition!'); exit; end;
  val(temp,  i1, k1);
  val(zeile, i2, k2);
  if (k1<>0) or (k2<>0) then begin Parser^.Fehler('Numerisches Format der Knotennummer fehlerhaft!'); exit; end;
  k1:=Daten^.NetzGraph^.KnotenArray.GetAnzahl;
  if (i1=0) or (i2=0) or (i1>k1) or (i2>k1) then begin
    Parser^.Fehler('Knotennummer in Kantendefinition auerhalb des gltigen Wertebereichs!');
    exit;
  end;
  n1:=Daten^.NetzGraph^.KnotenArray.GetRec(i1);
  n2:=Daten^.NetzGraph^.KnotenArray.GetRec(i2);
  edge:=InitEdge(n1,n2);
  n1^.Append(edge);
  n2^.Append(edge);
  with Daten^.NetzGraph^ do KantenArray.Append(edge);
  Line:=true;
END;

FUNCTION TKantenAbschnitt0_2.Stop:boolean;
VAR ok:boolean;
    Zeilen:TFehlerArray;
BEGIN
  Zeilen.init;
  Daten^.NetzGraph^.CheckGraph(Zeilen);
  if Zeilen.anzahl>0 then Parser^.Fehler(Zeilen.GetRec(1)^.Beschreibung);
  Stop:=inherited Stop and (Zeilen.anzahl=0);
  Zeilen.done;
END;

{---------------------------------------------------------}

FUNCTION TLinienAbschnitt0_2.Line(Zeile:string):boolean;
VAR temp:string;
    f:TGraphenFarbe;
    name:string[100];
    anfang,ende:word;
    k:integer;
Begin
  Line:=false;
  SplitString(zeile,' ',temp,zeile);
  if temp<>'LINE' then begin  Parser^.Fehler('`LINE` erwartet!'); exit;  end;
  SplitString(zeile,' ',temp,zeile);
  f:=Schwarz;
  while (f<>maxGraphenFarbe) and (GetGraphenFarbeName(f)<>temp) do f:=succ(f);
  if GetGraphenFarbeName(f)<>temp then begin  Parser^.Fehler('unbekannte Linien-Farbe'); exit;  end;
  SplitString(zeile,' ',name,zeile);
  Ersetzen('_',' ',name);
  SplitString(zeile,' ',temp,zeile);
  val(temp,anfang,k);
  if k<>0 then begin  Parser^.Fehler('Num. Format von Anfangsbf. falsch'); exit;  end;
  val(zeile,ende,k);
  if k<>0 then begin  Parser^.Fehler('Num. Format von Endebf. falsch'); exit;  end;
  if (anfang=0) or (ende=0) then begin  Parser^.Fehler('Bahnhof nicht in Netzgraph'); exit;  end;
  if (anfang=ende) then begin  Parser^.Fehler('Anfangs- und Endebahnhof gleich'); exit;  end;
  if not Daten^.NetzGraph^.GraphenFaerbung(Anfang,Ende,F) then begin
    Parser^.Fehler('Graphenfrbung nicht erfolgreich');
    exit;
  end else Daten^.LinienArray^.LinieDazu(Daten^.NetzGraph^.KnotenArray.GetRec(Anfang),
                                         Daten^.NetzGraph^.KnotenArray.GetRec(Ende),
                                         Name, F);
  Line:=true;
END;

{---------------------------------------------------------}

PROCEDURE TZugAbschnitt0_2.ErwartetMeldung;
BEGIN
  case status of
    nach_zug  :Parser^.Fehler('START-Zeile erwartet');
    nach_start:Parser^.Fehler('MITTE- oder STOP-Zeile erwartet');
    nach_stop :Parser^.Fehler('ZUG-Zeile oder Ende des Abschnitts erwartet');
    else runerror;
  end;
END;

FUNCTION TZugAbschnitt0_2.Start:boolean;
BEGIN
  status:=nach_stop;
  start:=inherited start;
END;

FUNCTION TZugAbschnitt0_2.Line(Zeile:string):boolean;

 Function ParseOrt(VAR s:string; VAR ort:ROrt):boolean;
 Var BfString,GleisString:string[5];
     w:word;
     k:integer;
 Begin
   ParseOrt:=false;
   SplitString(s, ',', BfString,GleisString);
 {Bahnhof}
   val(BfString,w,k);
   if k<>0 then begin
     Parser^.Fehler('Bahnhofsnr. hat ungltiges num. Format');
     exit;
   end;
   if (w=0) then begin
     Parser^.Fehler('Bahnhof nicht in Fahrplan');
     exit;
   end;
   Ort.Knoten:=Daten^.NetzGraph^.KnotenArray.GetRec(w);
 {Gleis}
   val(GleisString,w,k);
   if k<>0 then begin
     Parser^.Fehler('Gleisnr. hat ungltiges num. Format');
     exit;
   end;
   if (Ort.Knoten^.Bahnhof.AnzahlGleise<w) then begin
     Parser^.Fehler('Ungltige Gleisnummer');
     exit;
   end;
   Ort.Gleis:=w;
   ParseOrt:=true;
 End;

 Function ParseZeit(VAR s:string; VAR Zeit:TZeit):boolean;
 Var k:integer;
 Begin
   val(s,Zeit,k);
   ParseZeit:=(k=0) and (Zeit<=maxZeit) and (Zeit>=minZeit);
 End;

VAR Eins,Zwei:string[100];
    f:TReglerFarbe;
    Ort:ROrt;
    anZeit,abZeit:TZeit;
BEGIN
  Line:=false;
  SplitString(Zeile, ' ', Eins,Zeile);
  SplitString(Zeile, ' ', Zwei,Zeile);
  if Eins='ZUG' then begin
    if Status<>nach_Stop then begin
      ErwartetMeldung;
      exit;
    end;
    f:=minReglerFarbe;
    while (f<maxReglerFarbe) and (GetReglerFarbeName(f)<>Zwei) do inc(f);
    if GetReglerFarbeName(f)=Zwei then begin
      Ersetzen('_',' ',zeile); {Bugfix, Zeile eingefgt 10.11.94}
      Zug.init(f,Zeile);
      Status:=nach_zug;
    end else begin
      Parser^.Fehler('unbekannte Reglerfarbe "'+zwei+'"');
      exit;
    end;
    Status:=Nach_Zug;
  end else if Eins='START' then begin
    if Status<>nach_zug then begin
      ErwartetMeldung;
      exit;
    end;
    if not ParseOrt(Zwei,Ort) then exit;
    if not ParseZeit(Zeile,abZeit) then exit;
    Zug.DoAppend(Ort,abZeit,abZeit);
    Status:=Nach_Start;
  end else if Eins='MITTE' then begin
    if Status<>nach_start then begin
      ErwartetMeldung;
      exit;
    end;
    if not ParseOrt(Zwei,Ort) then exit;
    SplitString(Zeile,' ',eins,zwei);
    if not ParseZeit(eins,anZeit) then exit;
    if not ParseZeit(zwei,abZeit) then exit;
    Zug.DoAppend(Ort,anZeit,abZeit);
  end else if Eins='ENDE' then begin
    if Status<>nach_start then begin
      ErwartetMeldung;
      exit;
    end;
    if not ParseOrt(Zwei,Ort) then exit;
    if not ParseZeit(Zeile,anZeit) then exit;
    Zug.DoAppend(Ort,anZeit,anZeit);
    Daten^.ZugArray^.MoveZug(Zug);
    Status:=Nach_Stop;
  end else begin
    Parser^.Fehler('unbekanntes Schlsselwort in [Zuege]');
    exit;
  end;
  Line:=true;
END;

FUNCTION TZugAbschnitt0_2.Stop:boolean;
VAR fehler:boolean;
BEGIN
  fehler:=status<>nach_stop;
  if fehler then Parser^.Fehler('Unerwartetes Ende des [Zuege]-Abschnitts');
  Stop:=inherited Stop and not fehler;
END;

END.
