UNIT Netz;

{$A+,B-,G+,I+,V-,X+,W+}
{$D+,L+,R+,S+}

INTERFACE
USES Wintypes, WinProcs, oWindows, oDialogs,
     nodeedge, Netz_Sht, Win_Allg, MDIchild, fp_allg, mdi;

CONST cm_bfloeschen=202;
      cm_bfinfo=203;
      cm_liniedazu=205;
      cm_linieloeschen=206;
      cm_linieinfo=207;
      cm_linieumdrehen=209;

TYPE PNetzFenster=^TNetzFenster;
     TNetzFenster=OBJECT(TFahrplanMDIchild)
                    CONSTRUCTOR init(aparent:PNewMDIwindow);
                    DESTRUCTOR done; virtual;
                    FUNCTION GetClassName:pchar; virtual;
                    PROCEDURE NeueDaten;
                    PROCEDURE UpdateDatenbankStatic;
                    FUNCTION LoadBearbeitenMenu:hMenu;        virtual;
                  PRIVATE
                    neuLinieName:string;     {fr deflinie}
                    neuLinieFarbe:TGraphenFarbe;      {"}
                    Sheet:PNetzSheet;
                    ListBox:PListBox;
                    DatenbankStatic:PStatic;
                    PROCEDURE ListBoxFuellen;

                    PROCEDURE CMbfdazu(VAR Msg:TMessage);        virtual cm_first+cm_bfdazu;
                    PROCEDURE CMbfloeschen(VAR Msg:TMessage);    virtual cm_first+cm_bfloeschen;
                    PROCEDURE CMnodeinfo(VAR Msg:TMessage);      virtual cm_first+cm_bfinfo;
                    PROCEDURE CMdeflinie(VAR Msg:TMessage);      virtual cm_first+cm_liniedazu;
                    PROCEDURE CMlinieloeschen(VAR Msg:TMessage); virtual cm_first+cm_linieloeschen;
                    PROCEDURE CMlinieinfo(VAR Msg:TMessage);     virtual cm_first+cm_linieinfo;
                    PROCEDURE CMlinieumdrehen(VAR Msg:TMessage); virtual cm_first+cm_linieumdrehen;
                    PROCEDURE IDListBox(VAR Msg:TMessage);       virtual id_first+19;

                    PROCEDURE Size(x,y:integer); virtual;
                    PROCEDURE WMUserDefLine(VAR Msg:TMessage); virtual wm_user+wm_userDefLine;
                  END;

VAR NetzFenster:PNetzFenster; {global gemacht 2.10.95, damit daten.pas Zugriff hat, um NeueDaten aufzurufen}

IMPLEMENTATION
USES grund, Deb_Win, BWCC, Strings,
     info_bf, Daten, Info_Lin, deflinie, ZugArr, BfDef;

CONST LinieZaehler:word=1; {fr Nummerierung der Linien}
      id_ListBox=19;
      id_DatenbankStatic=20;

CONSTRUCTOR TNetzFenster.init(aparent:PNewMDIWindow);
VAR LogBrush:TLogBrush;
BEGIN
  inherited init(aparent, 'Streckennetz');
  attr.style:=ws_popup+ws_clipchildren;
  new(DatenbankStatic, init(@self, id_DatenbankStatic, nil, 1,1,1,1, 100));
  with DatenbankStatic^.attr do style:=style or ws_border;
  new(Sheet, init(@self));
  new(ListBox, init(@self, id_ListBox, 1,1,1,1));
  with ListBox^.attr do style:=style-lbs_Sort+lbs_useTabstops;
  Hintergrund:=GetStockObject(ltGray_brush);
END;

DESTRUCTOR TNetzFenster.done;
BEGIN
  inherited done;
END;

FUNCTION TNetzFenster.GetClassName:pchar;
BEGIN
  getclassname:='NetzFenster';
END;

PROCEDURE TNetzFenster.NeueDaten;
BEGIN
  Sheet^.NeuZeichnen;
  ListBoxFuellen;
END;

PROCEDURE TNetzFenster.UpdateDatenbankStatic;
VAR Puffer:array [0..100] of char;
BEGIN
  if Datenbank.IsOpen then begin
    StrCopy(Puffer, ' Datenbank: ');
    Datenbank.GetFileName(StrEnd(Puffer), high(Puffer));
  end else StrCopy(Puffer, ' -- keine Bahnhofsdatenbank geffnet --');
  DatenbankStatic^.SetText(Puffer);
END;

PROCEDURE TNetzFenster.Size(x,y:integer);
VAR ListboxHoehe:word;
    StaticHoehe:word;

 Function Window2TextHeight(h:hWnd):word;
 Var TextMetrics:TTextMetric;
     dc:HDC;
 Begin
   dc:=getdc(h);
   GetTextMetrics(dc,TextMetrics);
   releasedc(h,dc);
   Window2TextHeight:=TextMetrics.tmHeight;
 End;

BEGIN
  StaticHoehe:=Window2TextHeight(DatenbankStatic^.hWindow)+3;
  ListboxHoehe:=Window2TextHeight(Listbox^.hWindow)*3+2;
  MoveWindow(DatenbankStatic^.hwindow, 3, 3,                x-6, StaticHoehe,                    true);
  MoveWindow(Sheet^.hwindow,           3, StaticHoehe+6,    x-6, y-StaticHoehe-ListboxHoehe-4*3, true);
  MoveWindow(listbox^.hwindow,         3, y-ListboxHoehe-3, x-6, ListBoxHoehe,                   true);
END;

FUNCTION TNetzFenster.LoadBearbeitenMenu:hMenu;
BEGIN
  LoadBearbeitenMenu:=LoadMenu(hInstance, 'NetzFenster');
END;

{********************************* Bahnhfe ***********************************}

PROCEDURE TNetzFenster.CMbfdazu(VAR Msg:TMessage);
VAR ZuSetzenderBf:hBahnhof;
    node:PNode;
    anz:word;
    s:string;
    erster:boolean;
    DatenPuffer:RBahnhofsDaten;
BEGIN
  if not Datenbank.IsOpen then begin
    MessageBox(hWindow, 'Sie mssen erst eine Bahnhofs-Datenbank ffnen, befor Sie '+
                        'Bahnhfe in das Netz einfgen knnen!', 'Fehler',
                        mb_ok or mb_IconStop);
    exit;
  end;

  ZuSetzenderBf:=0;
  erster:=(FahrplanDaten.NetzGraph^.KnotenArray.GetAnzahl=0);
  if (erster or (Sheet^.BfMarkiert<>0)) then begin
    if not erster then begin
      node:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(Sheet^.BfMarkiert);
      with node^.Bahnhof.Daten do begin
        s:=Name;
        anz:=Strecken;
      end;
    end;
    if erster or (anz>node^.anzahl) then begin
      ZuSetzenderBf:=Datenbank.BahnhofsAuswahlDialog(hwindow, 'Neuer Bahnhof');
      if (ZuSetzenderBf<>0){ and (BWCCmessagebox(hWindow,
                                                'Ein Bahnhof mit dem selben Namen ist schon an '+
                                                'einer anderen Stelle im Netz eingebaut worden!',
                                                'Fehler!', mb_OkCancel+mb_IconQuestion
                                               )=id_ok)}
      then begin
        Sheet^.SetzBahnhof(ZuSetzenderBf);
        DatenBank.GetData(ZuSetzenderBf, @DatenPuffer);
        StatusZeile('Klicken Sie an die Stelle, wo "'+DatenPuffer.Name+'" eingefgt werden soll');
      end;
    end else begin
      s:=s+' hat nicht genug Strecken, um den neuen Bahnhof anzufgen'+#0;
      BWCCmessagebox(hWindow, @s[1], 'Fehler!', mb_ok);
    end;
  end else BWCCmessagebox(Hwindow, 'Sie mssen erst einen Bahnhof markieren,'+cr+
                                   'zu dem der neue Bahnhof direkte Verbindung haben soll',
                                   'Fehler!', mb_ok);
END;

 Function BahnhofInFahrplanBenutzt(node:PNode):boolean;
 Var zug:iZug;
     datum:word;
     zdp:PZugDatum;
     zp:PZug;
 Begin
   BahnhofInFahrplanBenutzt:=true;
   for Zug:=1 to FahrplanDaten.ZugArray^.GetAnzahl do begin
     zp:=FahrplanDaten.ZugArray^.GetZug(Zug);
     for datum:=1 to zp^.GetAnzahl do begin
       zdp:=zp^.GetRec(datum);
       if zdp^.Ort.Knoten=Node then exit;
     end;
   end;
   BahnhofInFahrplanBenutzt:=false;
 End;

PROCEDURE TNetzFenster.CMbfloeschen(VAR Msg:TMessage);
VAR np:Pnode;
    f:TGraphenFarbe;
    anz:word;
    ep:PEdge;
BEGIN
  if Sheet^.BfMarkiert=0 then messagebox(hwindow,'Markieren Sie erstmal den zu lschenden Bahnhof','Idiot!',mb_OK)
  else begin
    Sheet^.AbortEdit;
    np:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(Sheet^.BfMarkiert);
    anz:=0;
    ep:=np^.GetEdge(1);
    for f:=low(ep^.Faerbung) to high(ep^.Faerbung) do if ep^.Faerbung[f] then inc(anz);
    if np^.anzahl<>1 then messagebox(Hwindow,'Es knnen nur Endbahnhfe gelscht werden.','nun aber mal langsam',mb_OK)
    else if (anz>0)
      then BWCCmessagebox(hwindow, 'Es knnen keine Bahnhfe gelscht werden, '+
                                   'die an einer registrierten Strecke liegen!',
                                   'Bahnhof lschen', mb_ok)
    else if BahnhofInFahrplanBenutzt(np)
      then BWCCmessagebox(hWindow, 'Es knnen keine Bahnhfe gelscht werden, '+
                                   'durch die Zge verkehren!',
                                   'Bahnhof lschen', mb_ok)
    else begin
      np:=np^.GetNode(1);  {Nachbarknoten merken, um ihn dann markieren zu koennen}
      FahrplanDaten.NetzGraph^.KillKnoten(Sheet^.BfMarkiert);
      Sheet^.BfMarkiert:=FahrplanDaten.NetzGraph^.KnotenArray.Position(np);
      FahrplanDaten.NetzVeraendert;
    end;
  end;
END;

PROCEDURE TNetzFenster.CMnodeinfo(VAR Msg:TMessage);
BEGIN
  Sheet^.NodeInfo;
END;

{******************************* Linien ********************************}

PROCEDURE TNetzFenster.ListBoxFuellen;
VAR w:word;
    s:string;
BEGIN
  ListBox^.ClearList;
  for w:=1 to FahrplanDaten.LinienArray^.GetAnzahl do with FahrplanDaten.LinienArray^.GetLineData(w)^ do begin
    s:=name+' '+tab+GetGraphenFarbeName(Farbe)+#0;
    ListBox^.AddString(pointer(@s[1]));
  end;
END;

PROCEDURE TNetzFenster.IDListBox(VAR Msg:TMessage);
BEGIN
  case Msg.LparamHi of
    lbn_DblClk   :CMLinieInfo(Msg);
    lbn_SelChange:;
  end;
END;

PROCEDURE TNetzFenster.CMLinieInfo(VAR Msg:TMessage);
VAR l:longint;
BEGIN
  l:=ListBox^.GetSelIndex;
  if l<0 then messagebox(hwindow, 'Erst eine Linie auswhlen!', 'Fehler', mb_ok)
         else with FahrplanDaten.GetLinienArray^ do if (GetAnzahl>0) then Info_Linie(GetLine(l+1));
END;

PROCEDURE TNetzFenster.CMdeflinie(VAR Msg:TMessage);
VAR name:string[142];
    moeglich:SGraphenFarbe;
    w:word;
BEGIN
  if (FahrplanDaten.NetzGraph^.KnotenArray.GetAnzahl<2)
  then messagebox(hwindow,'malen Sie erstmal ein Streckennetz...','ruhiger werden!',mb_OK)
  else begin
    neuLinieName:='Linie #'+zahlstr(LinieZaehler,1);
    moeglich:=AlleGraphenFarben-[schwarz];
    for w:=1 to FahrplanDaten.LinienArray^.GetAnzahl do moeglich:=moeglich-[FahrplanDaten.LinienArray^.GetLineData(w)^.Farbe];
    if moeglich=[]
      then messagebox(hwindow, 'Es steht keine Farbe mehr zur Verfuegung', 'Fehler!', mb_ok)
      else if DefLinieDlg(@self, moeglich, neuLinieFarbe, neuLinieName)
             then Sheet^.StartLine;
  end;
END;

PROCEDURE TNetzFenster.WMUserDefLine(VAR Msg:TMessage);
VAR Anfang,Ende:word;
BEGIN
  Anfang:=Msg.wParam;
  Ende:=Msg.lParam;
  if (Anfang=Ende) then
    MessageBox(Hwindow,'Anfangs- und Zielbahnhof mssen unterschiedlich sein!!!','Linienende',mb_OK)
  else if FahrplanDaten.NetzGraph^.GraphenFaerbung(Anfang,Ende,neuLinieFarbe) then begin
    FahrplanDaten.LinienArray^.LinieDazu(FahrplanDaten.NetzGraph^.KnotenArray.GetRec(Anfang),
                          FahrplanDaten.NetzGraph^.KnotenArray.GetRec(Ende),
                          neuLinieName,
                          neuLinieFarbe);
    inc(LinieZaehler);
    FahrplanDaten.NetzVeraendert;
  end else messagebox(Hwindow,'Graph kann nicht gefrbt werden,'+cr+
                              'warscheinlich gibt es keine vollstndig ungefrbte Verbindung'+cr+
                              'zwischen dem gewhlten Anfangs- und Endbahnhof',
                              'neue Linie - Fehler',mb_OK);
END;

PROCEDURE TNetzFenster.CMlinieloeschen(VAR Msg:TMessage);
VAR l:longint;
BEGIN
  l:=ListBox^.GetSelIndex;
  if l<0 then messagebox(hwindow, 'Erst eine Linie auswhlen!', 'Linie lschen?', mb_ok)
  else begin
    FahrplanDaten.NetzGraph^.FarbeLoeschen(FahrplanDaten.LinienArray^.GetLineData(l+1)^.Farbe);
    FahrplanDaten.LinienArray^.LinieLoeschen(l+1);
    FahrplanDaten.NetzVeraendert;
  end;
END;

PROCEDURE TNetzFenster.CMlinieumdrehen(VAR Msg:TMessage);
VAR l:longint;
BEGIN
  l:=ListBox^.GetSelIndex;
  if l<0 then messagebox(hwindow, 'Erst eine Linie auswhlen!', 'Linie umdrehen?', mb_ok)
         else FahrplanDaten.GetLinienArray^.GetLine(l+1)^.Umdrehen;
END;

END.
