UNIT Netz_Sht;

{$A+,B-,G+,I+,V-,X+,W-}
{$D+,L+,R+,S+}

INTERFACE
USES Wintypes, WinProcs, oWindows,
     nodeedge, Abst_Sht, BfDef;

TYPE PNetzSheet=^TNetzSheet;
     TNetzSheet=OBJECT(TAbstractSheet)
                    BfMarkiert:word;
                    CONSTRUCTOR init(aparent:PWindow);
                    PROCEDURE NodeInfo;    {wie dblclk, wird vom Men aktiviert}
                    PROCEDURE SetzBahnhof(welchen:word);
                    PROCEDURE AbortEdit;
                    PROCEDURE StartLine;
                    PROCEDURE NeuZeichnen;
                  PRIVATE
                    Modus:(normal,
                           setzen,     {Einsetzen eines zusetzlichen Bahnhofs}
                           DragAndDrop,{Verschieben eines Bahnhofs}
                           Anfang,     {Startpunkt einer neu zu definierenden Linie}
                           Ende        {Endpunkt     "    "  "        "         "  }
                          );
                    cursor:record
                             arrow,
                             bfsetzen:HCursor;
                             Pfeile:HCursor;
                             Anfang,Ende:HCursor;
                           end;
                    ZuSetzenderBf:hBahnhof;   {Index in BfManag}
                    AnfangBf:word;        {Index in NetzGraph^}
                    MoveDelta:RRelPunkt;  {Differenz zwischen verschiebender Maus
                                           und verschobenem Bahnhof}
                    SavedPos:RRelPunkt;
                    MarkierBrush:Hbrush;
                    DESTRUCTOR done; virtual;

                    PROCEDURE MouseMove;           virtual;
                    FUNCTION SetCursor:boolean;    virtual;
                    PROCEDURE lButtonDown;         virtual;
                    PROCEDURE lButtonUp;           virtual;
                    PROCEDURE DoubleClick;         virtual;
                    PROCEDURE rButtonDown;         virtual;

                    PROCEDURE DanebenGeklickt(wobei:pchar);

                    PROCEDURE RelPunkt2Pixel(Rel:RRelPunkt; VAR Pixel:TPoint);
                    PROCEDURE MausPos2RelPunkt(mx,my:integer; VAR RelPunkt:RRelPunkt);

                    PROCEDURE PaintKnoten(dc:HDC; br,hoe,markiert:word);
                    PROCEDURE PaintKanten(dc:HDC; br,hoe:word);
                    PROCEDURE Paint(PaintDC: HDC; var PaintInfo:TPaintStruct); virtual;
                    PROCEDURE BahnhofNeuzeichnen(node:PNode; Auch:PRelPunkt);
                  END;


CONST wm_UserDefLine=1;

IMPLEMENTATION
USES grund, bwcc, win_allg,
     info_bf, daten, fp_allg, graph, db_obj, AbsBfDat, GraphCol;

CONST RechteckHoehe:word=10;
      RechteckBreite:word=10;
      MarkierFarbe=$000000FF;

CONSTRUCTOR TNetzSheet.init(aparent:PWindow);
BEGIN
  inherited init(aparent);
  Modus:=normal;
  ZuSetzenderBf:=0;
  BfMarkiert:=0;
  AnfangBf:=0;
  with cursor do begin
    arrow   :=LoadCursor(0,idc_Arrow);
    bfsetzen:=LoadCursor(Hinstance,'setzen');
    Pfeile  :=LoadCursor(Hinstance,'verschieben');
    anfang  :=LoadCursor(Hinstance,'startlinie');
    ende    :=LoadCursor(Hinstance,'endelinie');
  end;
  MarkierBrush:=createsolidbrush(MarkierFarbe);
END;

DESTRUCTOR TNetzSheet.done;
BEGIN
  inherited done;
  with cursor do begin
    DestroyCursor(bfsetzen);
    DestroyCursor(Pfeile);
    DestroyCursor(anfang);
    DestroyCursor(ende);
  end;
  DeleteObject(MarkierBrush);
END;

FUNCTION TNetzSheet.SetCursor:boolean;
BEGIN
  SetCursor:=true;
  case Modus of
    normal     :WinProcs.SetCursor(Cursor.arrow);
    setzen     :WinProcs.SetCursor(Cursor.BfSetzen);
    anfang     :WinProcs.SetCursor(Cursor.anfang);
    ende       :WinProcs.SetCursor(Cursor.ende);
    DragAndDrop:runerror;
    else runerror;
  end;
END;

PROCEDURE TNetzSheet.MouseMove;
VAR wohin:RRelPunkt;
BEGIN
  if (Modus=DragAndDrop) and MouseInWindow then begin
    if BfMarkiert=0 then runerror;
    MausPos2RelPunkt(MouseCursor.x,MouseCursor.y, Wohin);
    Wohin.x:=Wohin.x-MoveDelta.x;
    Wohin.y:=Wohin.y-MoveDelta.y;
    BahnhofNeuZeichnen(FahrplanDaten.NetzGraph^.KnotenArray.GetRec(BfMarkiert), @Wohin);
    FahrplanDaten.NetzGraph^.KnotenArray.VerschiebKnoten(Wohin, BfMarkiert);
  end;
END;

PROCEDURE TNetzSheet.Danebengeklickt(wobei:pchar);
BEGIN
  BWCCmessagebox(Hwindow,'Danebengeklickt!!!'+cr+'Ziel doch mal richtig!',wobei,mb_OK);
END;


PROCEDURE TNetzSheet.SetzBahnhof(welchen:word);
BEGIN
  Modus:=setzen;
  ZuSetzenderBf:=welchen;
END;

PROCEDURE TNetzSheet.AbortEdit;
BEGIN
  Modus:=normal;
END;

PROCEDURE TNetzSheet.StartLine;
BEGIN
  Modus:=anfang;
END;


FUNCTION CopyBahnhofFromDatabase(VAR Datenbank:TBahnhofsDatenbank;
                                 Bahnhof:hBahnhof;
                                 VAR Buffer:TBahnhof):boolean;
VAR w:word;
    Gleis:RGleisDaten;
    NeuInfo:pchar;
BEGIN
  CopyBahnhofFromDatabase:=false;

  Buffer.Free;

  if (Datenbank.GetData(Bahnhof, @Buffer.Daten)<>keinFehler) then exit;

  w:=Datenbank.GetInfoLength(Bahnhof);
  if w<>0 then begin
    GetMem(NeuInfo, w+1);
    Datenbank.GetInfo(Bahnhof, NeuInfo, w);
    Buffer.SetInfo(NeuInfo);
  end;

  w:=Datenbank.GetGleisAnzahl(Bahnhof);
  if w=0 then exit;

  for w:=1 to w do begin
    if (Datenbank.GetGleis(Bahnhof, w, @Gleis)<>keinFehler) then exit;
    Buffer.AppendGleis(Gleis.Bezeichnung, Gleis.NutzLaenge);
  end;

  CopyBahnhofFromDatabase:=true;
END;

PROCEDURE TNetzSheet.lButtonDown;
VAR w:word;
    wohin:RRelPunkt;
    node:PNode;
BEGIN
  MausPos2RelPunkt(MouseCursor.x, MouseCursor.y, Wohin);
  case Modus of
    normal:     begin
                  rButtonDown;
                  if (BfMarkiert<>0) then begin
                    Modus:=DragAndDrop;
                    {FahrplanDaten.Veraendert:=true; warum nur? Eingeklammert 2.10.95}
                    node:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(BfMarkiert);
                    MoveDelta.x:=Wohin.x-node^.Ort.x;
                    MoveDelta.y:=Wohin.y-node^.Ort.y;
                    SavedPos:=node^.Ort;
                    WinProcs.SetCursor(Cursor.Pfeile);
                  end;
                end;
    Anfang     :begin
                  AnfangBf:=FahrplanDaten.NetzGraph^.KnotenArray.NaechsterOrt(wohin);
                  if AnfangBf=0 then begin
                    Modus:=normal;
                    DanebenGeklickt('Linienanfang');
                  end else begin
                    Modus:=Ende;
                    node:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(AnfangBf);
                    StatusZeile('Linienstart in "'+node^.Bahnhof.Daten.Name+'"');
                  end;
                end;
    Ende       :begin
                  w:=FahrplanDaten.NetzGraph^.KnotenArray.NaechsterOrt(wohin);
                  if (w=0) then DanebenGeklickt('Lienienende') else begin
                    node:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(w);
                    StatusZeile('Linienende in "'+node^.Bahnhof.Daten.name+'"');
                    SendMessage(parent^.hwindow,wm_user+wm_UserDefLine,AnfangBf,w);
                  end;
                  Modus:=normal;
                end;
    setzen:     begin {bei erstem Knoten keine Kante erzeugen}
                  if FahrplanDaten.NetzGraph^.KnotenArray.GetAnzahl=0 then BfMarkiert:=0;
                  BfMarkiert:=FahrplanDaten.NetzGraph^.KnotenDazu(Wohin, BfMarkiert);
                  if BfMarkiert=0 then begin
                    StatusZeile('');  {war vorher ca. "klicken Sie, wo er hin soll"}
                    BWCCmessagebox(hWindow, 'Der Bahnhof lie sich nicht ins Netz einfgen.',
                                            'Interner Fehler!', mb_OK+mb_IconHand);
                  end else begin
                    FahrplanDaten.NetzVeraendert;
                    node:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(BfMarkiert);
                    CopyBahnhofFromDatabase(Datenbank, ZuSetzenderBf, node^.Bahnhof);
                    StatusZeile('Bahnhof "'+Node^.Bahnhof.Daten.Name+'" gesetzt');
                  end;
                  Modus:=normal;
                  NeuZeichnen;
                end;
    DragAndDrop:runerror;
    else runerror;
  end;
END;

PROCEDURE TNetzSheet.lButtonUp;
VAR node:PNode;
    ok:boolean;
    Point:TPoint;
    Rechteck:TRechteck;
BEGIN
  if (Modus=DragAndDrop) then begin
    Modus:=normal;
    WinProcs.SetCursor(Cursor.Arrow);
    node:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(BfMarkiert);
    if MouseInWindow then begin
      RelPunkt2Pixel(node^.Ort, Point);
      GetClientRect(hWindow, Rechteck.Rechteck);
      Rechteck.Vergroessern(-RechteckBreite div 2, -RechteckHoehe div 2);
      ok:=PtInRect(Rechteck.Rechteck, Point);
    end;
    if not MouseInWindow or not ok then  node^.Ort:=SavedPos;
    NeuZeichnen;
  end;
END;

PROCEDURE TNetzSheet.rButtonDown;
VAR node:PNode;
    w:word;
    Wohin:RRelPunkt;
BEGIN
  MausPos2RelPunkt(MouseCursor.x, MouseCursor.y, Wohin);
  w:=FahrplanDaten.NetzGraph^.KnotenArray.NaechsterOrt(wohin);
  if w<>BfMarkiert then begin
    NeuZeichnen;
    BfMarkiert:=w;
  end;
  if BfMarkiert=0 then begin
    StatusZeile('Kein Bahnhof angewhlt');
  end else begin
    node:=FahrplanDaten.NetzGraph^.KnotenArray.GetRec(BfMarkiert);
    StatusZeile('Bahnhof "'+Node^.Bahnhof.Daten.Name+'" angeklickt');
  end;
END;

PROCEDURE TNetzSheet.DoubleClick;
BEGIN
  nodeinfo;
END;

PROCEDURE TNetzSheet.nodeinfo;
BEGIN
  if BfMarkiert<>0 then DoBfInfo(@self,FahrplanDaten.NetzGraph^.KnotenArray.GetRec(BfMarkiert));
END;

PROCEDURE TNetzSheet.MausPos2RelPunkt(mx,my:integer; VAR RelPunkt:RRelPunkt);
BEGIN
  RelPunkt.x:=mx/attr.w;
  RelPunkt.y:=my/attr.h;
END;

PROCEDURE TNetzSheet.RelPunkt2Pixel(Rel:RRelPunkt; VAR Pixel:TPoint);
BEGIN
  Pixel.x:=round(Rel.x*attr.w);  {Achtung! diese Umrechnung ist nochmal genauso}
  Pixel.y:=round(Rel.y*attr.h);  {in GRAPH.PAS implementiert!}
END;

PROCEDURE TNetzSheet.NeuZeichnen;
BEGIN
  invalidaterect(Hwindow,nil,true);
END;

PROCEDURE TNetzSheet.BahnhofNeuzeichnen(node:PNode; Auch:PRelPunkt);
VAR Rechteck:TRechteck;
    Punkt:TPoint;
    w:word;
BEGIN
  RelPunkt2Pixel(node^.Ort, Punkt);
  Rechteck.init(Punkt);
  if Auch<>nil then begin
    RelPunkt2Pixel(Auch^,Punkt);
    Rechteck.AddPoint(Punkt);
  end;
  for w:=1 to node^.anzahl do begin
    RelPunkt2Pixel(node^.GetNode(w)^.Ort, Punkt);
    Rechteck.AddPoint(Punkt);
  end;
  Rechteck.Vergroessern(RechteckBreite div 2 +1, RechteckHoehe  div 2 +1);
  InvalidateRect(hWindow, @Rechteck.Rechteck, true);
END;

PROCEDURE TNetzSheet.PaintKnoten(dc:HDC; br,hoe,markiert:word);
VAR w:word;
    x,y:integer;
    s:string[5];
    altbrush:Hbrush;
    altbk:TColorRef;
    altalign:word;
    rx,ry:integer;
    TextExtent:TPoint;
BEGIN
  SetTextAlign(dc, ta_center or ta_top);
  for w:=1 to FahrplanDaten.NetzGraph^.KnotenArray.GetAnzahl
      do with pnode(FahrplanDaten.NetzGraph^.KnotenArray.GetRec(w))^ do begin
    if w=markiert then begin
      altbrush:=selectobject(dc,MarkierBrush);
      altbk:=SetBKColor(dc,MarkierFarbe);
    end;
    s:=Bahnhof.Daten.kurzname;
    longint(TextExtent):=GetTextExtent(dc, @s[1], length(s));
    RechteckBreite:=max(Textextent.x+4, RechteckBreite);
    RechteckHoehe :=max(Textextent.y+4, RechteckHoehe);
    rx:=RechteckBreite div 2;
    ry:=RechteckHoehe  div 2;
    x:=round(ort.x*br);
    y:=round(ort.y*hoe);
    rectangle(dc,x-rx,y-ry,x+rx+1,y+ry);
    textout(dc,x,y-ry+2,@s[1],length(s));
    if w=markiert then begin
      selectobject(dc,altbrush);
      SetBKColor(dc,altbk);
    end;
  end;
END;

PROCEDURE TNetzSheet.PaintKanten(dc:HDC; br,hoe:word);
 Procedure Linie(dc:HDC; n1,n2:Pnode; br,hoe:word);
 Var rp:RRelPunkt;
 Begin
   rp:=n1^.Ort;
   moveto(dc, round(rp.x*br), round(rp.y*hoe));
   rp:=n2^.Ort;
   lineto(dc, round(rp.x*br), round(rp.y*hoe));
 End;
VAR w:word;
    altpen:THandle;
    altbk:TColorRef;
    f,f1,f2:TGraphenFarbe;
    anz:word;
BEGIN
  for w:=1 to FahrplanDaten.NetzGraph^.KantenArray.GetAnzahl
      do with Pedge(FahrplanDaten.NetzGraph^.KantenArray.GetRec(w))^ do begin
    anz:=0;
    f1:=schwarz;
    for f:=low(Faerbung) to high(Faerbung) do if Faerbung[f] then begin
      inc(anz);
      if anz=1 then f1:=f;
      if anz=2 then f2:=f;
    end;
    if anz>2 then f1:=schwarz;
    case anz of
      2:begin
          altbk:=setbkcolor(dc,GetGraphenFarbeColorRef(f1));
          altpen:=GraphenFarbeSelectDash(dc, f2);
          Linie(dc, n1,n2, br,hoe);
          setbkcolor(dc,altbk);
        end;
      else begin
          altpen:=GraphenFarbeSelectSolid(dc, f1);
          Linie(dc, n1,n2, br,hoe);
        end;
    end;
    selectobject(dc,altpen); {zurueckstellen}
  end;
END;

PROCEDURE TNetzSheet.Paint(PaintDC: HDC; var PaintInfo:TPaintStruct);
BEGIN
  inherited paint(PaintDC,PaintInfo);
  with attr do begin
    PaintKanten(PaintDC,w,h);
    PaintKnoten(PaintDC,w,h,BfMarkiert);
  end;
END;


END.
