{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 94

 Inhalt: Redge  Record, das die Datenfelder einer Kante im Graphen RGraph enthlt
         Tnode  Objekt, das ein dynamisches Array der benachbarten Kanten und die
                Datenfelder eines Knoten in RGraph enthlt

 Referenzen: Alle Module, die irgendwie direkt oder indirekt mit dem Netzgraph
             zu tun haben importieren NodeEdge
}

UNIT NodeEdge;

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$D+,L+,R+,S+}

INTERFACE
USES heap, AbsBfDat, WinTypes;

TYPE TGraphenFarbe=(schwarz,rot,gruen,blau,tuerkis,gelb,braun);
     SGraphenFarbe=set of TGraphenFarbe;
     {TGraphenFarbe ist die Linien-Farbe der Striche im Netz}

FUNCTION GetGraphenFarbeName(f:TGraphenFarbe):string;
{GetGraphenFarbeName liefert einen String, der die Farbe identifiziert}
FUNCTION GetGraphenFarbeColorRef(f:TGraphenFarbe):TColorRef;
{GetGraphenFarbeColorRef liefert die rgb-Werte der Farbe}

{\\}
TYPE  RFaerbung=array [rot..braun] of boolean;
{//}
     {RFaerbung speichert die (max 2) Linien-Farben, die ein Strich im Netz hat}

CONST maxGraphenFarbe=braun;
      AlleGraphenFarben=[schwarz,rot,gruen,blau,tuerkis,gelb,braun];

TYPE RRelPunkt=RECORD x,y:single; END;  {0..1}
     PRelPunkt=^RRelPunkt;
     {RRelPunkt gibt die relative Position eines Knotens (=Bahnhofs) im
      Netzfenster an. Relativ deshalb, weil die Koordinaten unabhngig von der
      aktuellen Gre des Fensters in Pixeln sein sollen, um die Darstellung
      des Netzgraphen bei Grennderungen des Netzfensters zoomen zu knnen.}

TYPE Pnode=^Tnode;
     Pedge=^Redge;
     Redge=RECORD
             n1,n2:Pnode;        {Knoten, die von der Kante verbunden werden}
             Faerbung:RFaerbung; {Farbe(n) der Kante}
           END;
     Tnode=OBJECT(DynArrayObj)   {dyn. Array ber die Nachbarkanten}
             Bahnhof:TBahnhof;   {Objekt, da den Bahnhof komplett definiert (AbsBfDat)}
             Ort:RRelPunkt;      {Position im Netzfenster [0,1]}
             work:word;          {allgemeine Arbeitsvariable}
             CONSTRUCTOR init(wohin:RRelPunkt);
             FUNCTION GetNode(nr:word):Pnode; {gibt nr-ten Nachbarknoten}
             FUNCTION GetEdge(nr:word):Pedge; {gibt nr-te Nachbarkante}
             FUNCTION HatKnotenDieseFarbe(Farbe:TGraphenFarbe):boolean;
           END;

(*
CONST KeineFaerbung:RFaerbung=(f1:schwarz;f2:schwarz);
{schwarze durchgezogene Linie}
*)

FUNCTION initedge(n1,n2:Pnode):Pedge;


IMPLEMENTATION

CONST FarbenTabelle:Array [TGraphenFarbe] of record name:string[42]; cr:TColorRef; end
      =((name:'schwarz'; cr:0),
        (name:'rot';     cr:$000000FF),
        (name:'grn';    cr:$0000FF00),
        (name:'blau';    cr:$00FF0000),
        (name:'trkis';  cr:$00FFFF00),
        (name:'gelb';    cr:$0000FFFF),
        (name:'braun';   cr:$0000408F));

FUNCTION GetGraphenFarbeName(f:TGraphenFarbe):string;
BEGIN
  GetGraphenFarbeName:=FarbenTabelle[f].name;
END;

FUNCTION GetGraphenFarbeColorRef(f:TGraphenFarbe):TColorRef;
BEGIN
  GetGraphenFarbeColorRef:=FarbenTabelle[f].cr;
END;

{******************************** Knoten *********************************}

CONSTRUCTOR Tnode.init(wohin:RRelPunkt);
BEGIN
  inherited init;
  Ort:=wohin;
  Bahnhof.init;
  work:=0;
END;

FUNCTION Tnode.GetNode(nr:word):Pnode;
VAR n1c,n2c:Pnode;
BEGIN
  if (nr=0) or (nr>anzahl) then runerror;
{Knotenreferenzen aus Kante in lokale Variablen kopieren}
  with Pedge(p^[nr])^ do begin
    n1c:=n1;
    n2c:=n2;
  end;
{Sicherheit is geil}
  if (n1c=nil) or (n2c=nil) or (n1c=n2c) then runerror;
{der eine oder der andere oder Fehler}
  if n1c=@self then GetNode:=n2c
               else if n2c=@self then GetNode:=n1c
                                 else runerror;
END;

FUNCTION Tnode.GetEdge(nr:word):Pedge;
BEGIN
  if (nr=0) or (nr>anzahl)
    then runerror;
  GetEdge:=p^[nr];
END;

FUNCTION TNode.HatKnotenDieseFarbe(Farbe:TGraphenFarbe):boolean;
VAR w:word;
BEGIN
  HatKnotenDieseFarbe:=true;
  for w:=1 to anzahl do with getedge(w)^ do  if Faerbung[Farbe] then exit;
  HatKnotenDieseFarbe:=false;
END;

{************************************ Kante ***************************}

FUNCTION initedge(n1,n2:Pnode):Pedge;
VAR e:Pedge;
    f:TGraphenFarbe;
BEGIN
  new(e);
  e^.n1:=n1;
  e^.n2:=n2;
  for f:=low(e^.Faerbung) to high(e^.Faerbung) do e^.Faerbung[f]:=false;
  initedge:=e;
END;

END.
